/*    */ package org.jboss.ejb.txtimer;
/*    */ 
/*    */ import java.lang.reflect.Method;
/*    */ import java.util.Set;
/*    */ import javax.ejb.TimedObject;
/*    */ import javax.ejb.Timer;
/*    */ import org.jboss.ejb.Container;
/*    */ import org.jboss.invocation.Invocation;
/*    */ import org.jboss.invocation.InvocationKey;
/*    */ import org.jboss.invocation.InvocationType;
/*    */ import org.jboss.invocation.PayloadKey;
/*    */ import org.jboss.metadata.ApplicationMetaData;
/*    */ import org.jboss.metadata.AssemblyDescriptorMetaData;
/*    */ import org.jboss.metadata.BeanMetaData;
/*    */ import org.jboss.metadata.SecurityIdentityMetaData;
/*    */ import org.jboss.security.RunAs;
/*    */ import org.jboss.security.RunAsIdentity;
/*    */ 
/*    */ public class TimedObjectInvokerImpl
/*    */   implements TimedObjectInvoker
/*    */ {
/*    */   private Container container;
/*    */   private TimedObjectId timedObjectId;
/*    */   private Method method;
/* 57 */   boolean pushedRunAs = false;
/*    */ 
/*    */   public TimedObjectInvokerImpl(TimedObjectId timedObjectId, Container container)
/*    */   {
/*    */     try
/*    */     {
/* 63 */       this.container = container;
/* 64 */       this.timedObjectId = timedObjectId;
/* 65 */       this.method = TimedObject.class.getMethod("ejbTimeout", new Class[] { Timer.class });
/*    */     }
/*    */     catch (NoSuchMethodException ignore)
/*    */     {
/*    */     }
/*    */   }
/*    */ 
/*    */   public void callTimeout(Timer timer)
/*    */     throws Exception
/*    */   {
/* 81 */     ClassLoader callerClassLoader = SecurityActions.getContextClassLoader();
/* 82 */     SecurityActions.setContextClassLoader(this.container.getClassLoader());
/* 83 */     this.container.pushENC();
/*    */     try
/*    */     {
/* 86 */       Invocation inv = new Invocation(this.timedObjectId.getInstancePk(), this.method, new Object[] { timer }, null, null, null);
/* 87 */       inv.setValue(InvocationKey.INVOKER_PROXY_BINDING, null, PayloadKey.AS_IS);
/* 88 */       inv.setType(InvocationType.LOCAL);
/*    */ 
/* 90 */       BeanMetaData bmd = this.container.getBeanMetaData();
/* 91 */       SecurityIdentityMetaData ejbTimeoutIdentity = bmd.isEntity() ? null : bmd.getEjbTimeoutIdentity();
/* 92 */       if ((ejbTimeoutIdentity != null) && (!ejbTimeoutIdentity.getUseCallerIdentity()))
/*    */       {
/* 94 */         ApplicationMetaData applicationMetaData = bmd.getApplicationMetaData();
/* 95 */         AssemblyDescriptorMetaData assemblyDescriptor = applicationMetaData.getAssemblyDescriptor();
/* 96 */         String roleName = ejbTimeoutIdentity.getRunAsRoleName();
/* 97 */         String principalName = ejbTimeoutIdentity.getRunAsPrincipalName();
/*    */ 
/* 99 */         Set extraRoleNames = assemblyDescriptor.getSecurityRoleNamesByPrincipal(principalName);
/* 100 */         RunAs runAsIdentity = new RunAsIdentity(roleName, principalName, extraRoleNames);
/* 101 */         SecurityActions.pushRunAsIdentity(runAsIdentity);
/* 102 */         this.pushedRunAs = true;
/*    */       }
/* 104 */       this.container.invoke(inv);
/*    */     }
/*    */     finally
/*    */     {
/* 108 */       this.container.popENC();
/* 109 */       if (this.pushedRunAs)
/* 110 */         SecurityActions.popRunAsIdentity();
/* 111 */       SecurityActions.setContextClassLoader(callerClassLoader);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.txtimer.TimedObjectInvokerImpl
 * JD-Core Version:    0.6.0
 */