/*     */ package org.jboss.ejb.txtimer;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.mx.util.ObjectNameFactory;
/*     */ 
/*     */ public class TimedObjectId
/*     */   implements Serializable
/*     */ {
/*     */   private ObjectName containerId;
/*     */   private Object instancePk;
/*     */   private int hashCode;
/*     */ 
/*     */   public TimedObjectId(ObjectName containerId, Object instancePk)
/*     */   {
/*  57 */     if (containerId == null) {
/*  58 */       throw new IllegalArgumentException("containerId cannot be null");
/*     */     }
/*  60 */     this.containerId = containerId;
/*  61 */     this.instancePk = instancePk;
/*     */   }
/*     */ 
/*     */   public TimedObjectId(ObjectName timedObjectId)
/*     */   {
/*  71 */     this(timedObjectId, null);
/*     */   }
/*     */ 
/*     */   public ObjectName getContainerId()
/*     */   {
/*  76 */     return this.containerId;
/*     */   }
/*     */ 
/*     */   public Object getInstancePk()
/*     */   {
/*  81 */     return this.instancePk;
/*     */   }
/*     */ 
/*     */   public static TimedObjectId parse(String externalForm)
/*     */   {
/*  90 */     if ((!externalForm.startsWith("[")) || (!externalForm.endsWith("]"))) {
/*  91 */       throw new IllegalArgumentException("Square brackets expected arround: " + externalForm);
/*     */     }
/*     */ 
/*  94 */     String inStr = externalForm.substring(1, externalForm.length() - 1);
/*     */ 
/*  96 */     if (!inStr.startsWith("target="))
/*  97 */       throw new IllegalArgumentException("Cannot parse: " + externalForm);
/*  98 */     String jmxStr = inStr.substring(7);
/*     */ 
/* 100 */     String pkStr = null;
/* 101 */     int pkIndex = jmxStr.indexOf(",pk=");
/* 102 */     if (pkIndex > 0)
/*     */     {
/* 104 */       pkStr = jmxStr.substring(pkIndex + 4);
/* 105 */       jmxStr = jmxStr.substring(0, pkIndex);
/*     */     }
/*     */ 
/* 108 */     ObjectName contatinerId = ObjectNameFactory.create(jmxStr);
/* 109 */     return new TimedObjectId(contatinerId, pkStr);
/*     */   }
/*     */ 
/*     */   public String toExternalForm()
/*     */   {
/* 118 */     String pkStr = this.instancePk != null ? ",pk=" + this.instancePk : "";
/* 119 */     return "[target=" + this.containerId + pkStr + "]";
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 124 */     if (this.hashCode == 0)
/* 125 */       this.hashCode = toString().hashCode();
/* 126 */     return this.hashCode;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 131 */     if (obj == this) return true;
/* 132 */     if ((obj instanceof TimedObjectId))
/*     */     {
/* 134 */       TimedObjectId other = (TimedObjectId)obj;
/* 135 */       if (this.containerId.equals(other.containerId))
/* 136 */         return other.instancePk == null ? true : this.instancePk != null ? this.instancePk.equals(other.instancePk) : false;
/*     */     }
/* 138 */     return false;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 143 */     return toExternalForm();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.txtimer.TimedObjectId
 * JD-Core Version:    0.6.0
 */