/*     */ package org.jboss.ejb.plugins.inflow;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.concurrent.atomic.AtomicBoolean;
/*     */ import java.util.concurrent.atomic.AtomicInteger;
/*     */ import javax.ejb.EJBMetaData;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.resource.spi.ActivationSpec;
/*     */ import javax.resource.spi.UnavailableException;
/*     */ import javax.resource.spi.endpoint.MessageEndpoint;
/*     */ import javax.resource.spi.endpoint.MessageEndpointFactory;
/*     */ import javax.transaction.xa.XAResource;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EJBProxyFactory;
/*     */ import org.jboss.ejb.MessageDrivenContainer;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.InvocationType;
/*     */ import org.jboss.invocation.InvokerInterceptor;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.InvokerProxyBindingMetaData;
/*     */ import org.jboss.metadata.MessageDrivenMetaData;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationMetaData;
/*     */ import org.jboss.mx.util.JMXExceptionDecoder;
/*     */ import org.jboss.proxy.GenericProxyFactory;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.util.Strings;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class JBossMessageEndpointFactory extends ServiceMBeanSupport
/*     */   implements EJBProxyFactory, MessageEndpointFactory, JBossMessageEndpointFactoryMBean
/*     */ {
/*  70 */   protected boolean trace = this.log.isTraceEnabled();
/*     */   protected MessageDrivenContainer container;
/*     */   protected MessageDrivenMetaData metaData;
/*     */   protected String invokerBinding;
/*     */   protected InvokerProxyBindingMetaData invokerMetaData;
/*  85 */   protected HashMap<String, org.jboss.metadata.ActivationConfigPropertyMetaData> properties = new HashMap();
/*     */ 
/*  88 */   protected GenericProxyFactory proxyFactory = new GenericProxyFactory();
/*     */   protected Class<?> messagingTypeClass;
/*     */   protected String resourceAdapterName;
/*     */   protected ObjectName resourceAdapterObjectName;
/*     */   protected ActivationSpec activationSpec;
/*     */   protected ArrayList<Class<?>> interceptors;
/*     */   protected Class<?>[] interfaces;
/* 109 */   protected AtomicInteger nextProxyId = new AtomicInteger(0);
/*     */ 
/* 112 */   protected AtomicBoolean deliveryActive = new AtomicBoolean(true);
/*     */ 
/* 115 */   protected String[] createActivationSpecSig = { Class.class.getName(), Collection.class.getName() };
/*     */ 
/* 122 */   protected String[] activationSig = { MessageEndpointFactory.class.getName(), ActivationSpec.class.getName() };
/*     */ 
/*     */   public MessageDrivenContainer getContainer()
/*     */   {
/* 135 */     return this.container;
/*     */   }
/*     */ 
/*     */   public String getConfig()
/*     */   {
/* 140 */     return toString();
/*     */   }
/*     */ 
/*     */   public MessageEndpoint createEndpoint(XAResource resource) throws UnavailableException
/*     */   {
/* 145 */     this.trace = this.log.isTraceEnabled();
/*     */ 
/* 147 */     if ((getState() != 3) && (getState() != 2)) {
/* 148 */       throw new UnavailableException("The container is not started");
/*     */     }
/* 150 */     HashMap context = new HashMap();
/* 151 */     context.put("MessageEndpoint.Factory", this);
/* 152 */     context.put("MessageEndpoint.XAResource", resource);
/*     */ 
/* 154 */     String ejbName = this.container.getBeanMetaData().getContainerObjectNameJndiName();
/*     */ 
/* 156 */     if (this.trace) {
/* 157 */       this.log.trace("createEndpoint " + this + " xaResource=" + resource);
/*     */     }
/* 159 */     MessageEndpoint endpoint = (MessageEndpoint)this.proxyFactory.createProxy(ejbName + "@" + this.nextProxyId.incrementAndGet(), this.container.getServiceName(), InvokerInterceptor.getLocal(), null, null, this.interceptors, this.container.getClassLoader(), this.interfaces, context);
/*     */ 
/* 172 */     if (this.trace) {
/* 173 */       this.log.trace("Created endpoint " + endpoint + " from " + this);
/*     */     }
/* 175 */     return endpoint;
/*     */   }
/*     */ 
/*     */   public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException
/*     */   {
/* 180 */     boolean result = false;
/* 181 */     int transType = this.metaData.getMethodTransactionType(method.getName(), method.getParameterTypes(), InvocationType.LOCAL);
/* 182 */     if (transType == 1)
/* 183 */       result = true;
/* 184 */     if (this.trace)
/* 185 */       this.log.trace("isDeliveryTransacted " + this.container.getBeanMetaData().getContainerObjectNameJndiName() + " method=" + method + " result=" + result);
/* 186 */     return result;
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 192 */     this.metaData = ((MessageDrivenMetaData)this.container.getBeanMetaData());
/*     */ 
/* 194 */     resolveMessageListener();
/*     */ 
/* 196 */     resolveResourceAdapter();
/*     */ 
/* 198 */     createActivationSpec();
/*     */ 
/* 200 */     setupProxyParameters();
/*     */ 
/* 202 */     activate();
/*     */   }
/*     */ 
/*     */   protected void stopService()
/*     */     throws Exception
/*     */   {
/* 208 */     deactivate();
/*     */   }
/*     */ 
/*     */   public boolean isIdentical(Container container, Invocation mi)
/*     */   {
/* 213 */     throw new Error("Not valid for MessageDriven beans");
/*     */   }
/*     */ 
/*     */   public Object getEJBHome()
/*     */   {
/* 218 */     throw new Error("Not valid for MessageDriven beans");
/*     */   }
/*     */ 
/*     */   public EJBMetaData getEJBMetaData()
/*     */   {
/* 223 */     throw new Error("Not valid for MessageDriven beans");
/*     */   }
/*     */ 
/*     */   public Collection getEntityCollection(Collection collection)
/*     */   {
/* 228 */     throw new Error("Not valid for MessageDriven beans");
/*     */   }
/*     */ 
/*     */   public Object getEntityEJBObject(Object id)
/*     */   {
/* 233 */     throw new Error("Not valid for MessageDriven beans");
/*     */   }
/*     */ 
/*     */   public Object getStatefulSessionEJBObject(Object id)
/*     */   {
/* 238 */     throw new Error("Not valid for MessageDriven beans");
/*     */   }
/*     */ 
/*     */   public Object getStatelessSessionEJBObject()
/*     */   {
/* 243 */     throw new Error("Not valid for MessageDriven beans");
/*     */   }
/*     */ 
/*     */   public void setInvokerBinding(String binding)
/*     */   {
/* 248 */     this.invokerBinding = binding;
/*     */   }
/*     */ 
/*     */   public void setInvokerMetaData(InvokerProxyBindingMetaData imd)
/*     */   {
/* 253 */     this.invokerMetaData = imd;
/*     */   }
/*     */ 
/*     */   public void setContainer(Container container)
/*     */   {
/* 263 */     this.container = ((MessageDrivenContainer)container);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 271 */     StringBuffer buffer = new StringBuffer(100);
/* 272 */     buffer.append(super.toString());
/* 273 */     buffer.append("{ resourceAdapter=").append(this.resourceAdapterObjectName);
/* 274 */     buffer.append(", messagingType=").append(this.messagingTypeClass.getName());
/* 275 */     buffer.append(", ejbName=").append(this.container.getBeanMetaData().getContainerObjectNameJndiName());
/* 276 */     buffer.append(", activationConfig=").append(this.properties.values());
/* 277 */     buffer.append(", activationSpec=").append(this.activationSpec);
/* 278 */     buffer.append("}");
/* 279 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   protected void resolveMessageListener()
/*     */     throws DeploymentException
/*     */   {
/* 289 */     String messagingType = this.metaData.getMessagingType();
/*     */     try
/*     */     {
/* 292 */       this.messagingTypeClass = GetTCLAction.getContextClassLoader().loadClass(messagingType);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 296 */       DeploymentException.rethrowAsDeploymentException("Could not load messaging-type class " + messagingType, e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected String resolveResourceAdapterName()
/*     */     throws DeploymentException
/*     */   {
/* 308 */     return this.metaData.getResourceAdapterName();
/*     */   }
/*     */ 
/*     */   protected void resolveResourceAdapter()
/*     */     throws DeploymentException
/*     */   {
/* 318 */     this.resourceAdapterName = resolveResourceAdapterName();
/*     */     try
/*     */     {
/* 321 */       this.resourceAdapterObjectName = new ObjectName("jboss.jca:service=RARDeployment,name='" + this.resourceAdapterName + "'");
/* 322 */       int state = ((Integer)this.server.getAttribute(this.resourceAdapterObjectName, "State")).intValue();
/* 323 */       if (state != 3)
/* 324 */         throw new DeploymentException("The resource adapter is not started " + this.resourceAdapterName);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 328 */       DeploymentException.rethrowAsDeploymentException("Cannot locate resource adapter deployment " + this.resourceAdapterName, e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void setupProxyParameters()
/*     */     throws DeploymentException
/*     */   {
/* 340 */     this.interfaces = new Class[] { MessageEndpoint.class, this.messagingTypeClass };
/*     */ 
/* 343 */     this.interceptors = new ArrayList();
/* 344 */     Element proxyConfig = this.invokerMetaData.getProxyFactoryConfig();
/* 345 */     Element endpointInterceptors = MetaData.getOptionalChild(proxyConfig, "endpoint-interceptors", null);
/* 346 */     if (endpointInterceptors == null) {
/* 347 */       throw new DeploymentException("No endpoint interceptors found");
/*     */     }
/*     */ 
/* 350 */     NodeList children = endpointInterceptors.getElementsByTagName("interceptor");
/* 351 */     for (int i = 0; i < children.getLength(); i++)
/*     */     {
/* 353 */       Node currentChild = children.item(i);
/* 354 */       if (currentChild.getNodeType() != 1)
/*     */         continue;
/* 356 */       Element interceptor = (Element)children.item(i);
/* 357 */       String className = MetaData.getElementContent(interceptor);
/*     */       try
/*     */       {
/* 360 */         Class clazz = this.container.getClassLoader().loadClass(className);
/* 361 */         this.interceptors.add(clazz);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 365 */         DeploymentException.rethrowAsDeploymentException("Error loading interceptor class " + className, t);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void augmentActivationConfigProperties()
/*     */     throws DeploymentException
/*     */   {
/* 380 */     Element proxyConfig = this.invokerMetaData.getProxyFactoryConfig();
/* 381 */     Element activationConfig = MetaData.getOptionalChild(proxyConfig, "activation-config");
/* 382 */     if (activationConfig != null)
/*     */     {
/* 384 */       Iterator iterator = MetaData.getChildrenByTagName(activationConfig, "activation-config-property");
/* 385 */       while (iterator.hasNext())
/*     */       {
/* 387 */         Element xml = (Element)iterator.next();
/* 388 */         org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData md = new org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData();
/* 389 */         org.jboss.metadata.ActivationConfigPropertyMetaData metaData = new org.jboss.metadata.ActivationConfigPropertyMetaData(md);
/* 390 */         String name = MetaData.getElementContent(MetaData.getUniqueChild(xml, "activation-config-property-name"));
/* 391 */         String value = MetaData.getElementContent(MetaData.getUniqueChild(xml, "activation-config-property-value"));
/* 392 */         if ((name == null) || (name.trim().length() == 0))
/* 393 */           throw new DeploymentException("activation-config-property doesn't have a name");
/* 394 */         if (!Strings.isValidJavaIdentifier(name))
/* 395 */           throw new DeploymentException("activation-config-property '" + name + "' is not a valid java identifier");
/* 396 */         md.setName(name);
/* 397 */         md.setValue(value);
/* 398 */         if (!this.properties.containsKey(metaData.getName())) {
/* 399 */           this.properties.put(metaData.getName(), metaData);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 404 */     String link = this.metaData.getDestinationLink();
/* 405 */     if (link != null)
/*     */     {
/* 407 */       link = link.trim();
/* 408 */       if (link.length() > 0)
/*     */       {
/* 410 */         if (this.properties.containsKey("destination")) {
/* 411 */           this.log.warn("Ignoring message-destination-link '" + link + "' when the destination " + "is already in the activation-config.");
/*     */         }
/*     */         else
/*     */         {
/* 415 */           MessageDestinationMetaData destinationMetaData = this.container.getMessageDestination(link);
/* 416 */           if (destinationMetaData == null)
/* 417 */             throw new DeploymentException("Unresolved message-destination-link '" + link + "' no message-destination in ejb-jar.xml");
/* 418 */           String jndiName = destinationMetaData.getJndiName();
/* 419 */           if (jndiName == null)
/* 420 */             throw new DeploymentException("The message-destination '" + link + "' has no jndi-name in jboss.xml");
/* 421 */           org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData acpmd = new org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData();
/*     */ 
/* 423 */           acpmd.setActivationConfigPropertyName("destination");
/* 424 */           acpmd.setValue(jndiName);
/* 425 */           org.jboss.metadata.ActivationConfigPropertyMetaData wrapper = new org.jboss.metadata.ActivationConfigPropertyMetaData(acpmd);
/* 426 */           this.properties.put("destination", wrapper);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void createActivationSpec()
/*     */     throws DeploymentException
/*     */   {
/* 439 */     this.properties = new HashMap(this.metaData.getActivationConfigProperties());
/* 440 */     augmentActivationConfigProperties();
/*     */ 
/* 442 */     Object[] params = { this.messagingTypeClass, this.properties.values() };
/*     */     try
/*     */     {
/* 449 */       this.activationSpec = ((ActivationSpec)this.server.invoke(this.resourceAdapterObjectName, "createActivationSpec", params, this.createActivationSpecSig));
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 453 */       t = JMXExceptionDecoder.decode(t);
/* 454 */       DeploymentException.rethrowAsDeploymentException("Unable to create activation spec ra=" + this.resourceAdapterObjectName + " messaging-type=" + this.messagingTypeClass.getName() + " properties=" + this.metaData.getActivationConfigProperties(), t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void startDelivery()
/*     */     throws Exception
/*     */   {
/* 461 */     if (getState() != 3) {
/* 462 */       throw new IllegalStateException("The MDB is not started");
/*     */     }
/* 464 */     if (this.deliveryActive.getAndSet(true))
/* 465 */       return;
/* 466 */     activate();
/*     */   }
/*     */ 
/*     */   public void stopDelivery() throws Exception
/*     */   {
/* 471 */     stopDelivery(false);
/*     */   }
/*     */ 
/*     */   public void stopDelivery(boolean asynch) throws Exception
/*     */   {
/* 476 */     if (getState() != 3) {
/* 477 */       throw new IllegalStateException("The MDB is not started");
/*     */     }
/* 479 */     if (!this.deliveryActive.getAndSet(false)) {
/* 480 */       return;
/*     */     }
/* 482 */     if (asynch)
/*     */     {
/* 484 */       new Thread("StopDelivery: " + getServiceName())
/*     */       {
/*     */         public void run()
/*     */         {
/* 488 */           JBossMessageEndpointFactory.this.deactivate();
/*     */         }
/*     */       }
/* 484 */       .start();
/*     */     }
/*     */     else
/*     */     {
/* 494 */       deactivate();
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean getDeliveryActive()
/*     */   {
/* 500 */     return this.deliveryActive.get();
/*     */   }
/*     */ 
/*     */   public void setDeliveryActive(boolean active)
/*     */   {
/* 505 */     this.deliveryActive.set(active);
/*     */   }
/*     */ 
/*     */   protected void activate()
/*     */     throws DeploymentException
/*     */   {
/* 515 */     if (!this.deliveryActive.get())
/*     */     {
/* 517 */       this.log.info("Delivery is disabled: " + getServiceName());
/* 518 */       return;
/*     */     }
/*     */ 
/* 521 */     Object[] params = { this, this.activationSpec };
/*     */     try
/*     */     {
/* 524 */       this.server.invoke(this.resourceAdapterObjectName, "endpointActivation", params, this.activationSig);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 528 */       t = JMXExceptionDecoder.decode(t);
/* 529 */       DeploymentException.rethrowAsDeploymentException("Endpoint activation failed ra=" + this.resourceAdapterObjectName + " activationSpec=" + this.activationSpec, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void deactivate()
/*     */   {
/* 539 */     Object[] params = { this, this.activationSpec };
/*     */     try
/*     */     {
/* 542 */       this.server.invoke(this.resourceAdapterObjectName, "endpointDeactivation", params, this.activationSig);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 546 */       t = JMXExceptionDecoder.decode(t);
/* 547 */       this.log.warn("Endpoint activation failed ra=" + this.resourceAdapterObjectName + " activationSpec=" + this.activationSpec, t);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.inflow.JBossMessageEndpointFactory
 * JD-Core Version:    0.6.0
 */