/*     */ package org.jboss.ejb.plugins.cmp.jdbc2.schema;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.transaction.RollbackException;
/*     */ import javax.transaction.Synchronization;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMRFieldBridge2;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;
/*     */ import org.jboss.tm.TransactionLocal;
/*     */ 
/*     */ public class Schema
/*     */ {
/*     */   private EntityTable[] entityTables;
/*     */   private RelationTable[] relationTables;
/*     */   private TransactionLocal localViews;
/*     */ 
/*     */   public Schema()
/*     */   {
/*  47 */     this.localViews = new TransactionLocal()
/*     */     {
/*     */       protected Object initialValue()
/*     */       {
/*  51 */         Transaction tx = getTransaction();
/*     */ 
/*  53 */         if (tx == null)
/*     */         {
/*  55 */           throw new IllegalStateException("An operation requires an active transaction!");
/*     */         }
/*     */ 
/*  58 */         Schema.Views views = new Schema.Views(Schema.this, tx);
/*  59 */         Synchronization sync = new Schema.SchemaSynchronization(Schema.this, views);
/*     */         try
/*     */         {
/*  63 */           tx.registerSynchronization(sync);
/*     */         }
/*     */         catch (RollbackException e)
/*     */         {
/*  67 */           throw new EJBException("Transaction already marked to roll back: " + e.getMessage(), e);
/*     */         }
/*     */         catch (SystemException e)
/*     */         {
/*  71 */           e.printStackTrace();
/*  72 */           throw new IllegalStateException("Failed to register transaction synchronization: " + e.getMessage());
/*     */         }
/*     */ 
/*  75 */         return views;
/*     */       }
/*     */     };
/*     */   }
/*     */ 
/*     */   public EntityTable createEntityTable(JDBCEntityMetaData metadata, JDBCEntityBridge2 entity) throws DeploymentException {
/*  82 */     if (this.entityTables == null)
/*     */     {
/*  84 */       this.entityTables = new EntityTable[1];
/*     */     }
/*     */     else
/*     */     {
/*  88 */       EntityTable[] tmp = this.entityTables;
/*  89 */       this.entityTables = new EntityTable[tmp.length + 1];
/*  90 */       System.arraycopy(tmp, 0, this.entityTables, 0, tmp.length);
/*     */     }
/*     */ 
/*  93 */     EntityTable table = new EntityTable(metadata, entity, this, this.entityTables.length - 1);
/*  94 */     this.entityTables[(this.entityTables.length - 1)] = table;
/*  95 */     return table;
/*     */   }
/*     */ 
/*     */   public RelationTable createRelationTable(JDBCCMRFieldBridge2 leftField, JDBCCMRFieldBridge2 rightField)
/*     */     throws DeploymentException
/*     */   {
/* 101 */     if (this.relationTables == null)
/*     */     {
/* 103 */       this.relationTables = new RelationTable[1];
/*     */     }
/*     */     else
/*     */     {
/* 107 */       RelationTable[] tmp = this.relationTables;
/* 108 */       this.relationTables = new RelationTable[tmp.length + 1];
/* 109 */       System.arraycopy(tmp, 0, this.relationTables, 0, tmp.length);
/*     */     }
/*     */ 
/* 112 */     RelationTable table = new RelationTable(leftField, rightField, this, this.relationTables.length - 1);
/* 113 */     this.relationTables[(this.relationTables.length - 1)] = table;
/* 114 */     return table;
/*     */   }
/*     */ 
/*     */   public Table.View getView(EntityTable table)
/*     */   {
/* 119 */     Views views = (Views)this.localViews.get();
/* 120 */     Table.View view = views.entityViews[table.getTableId()];
/* 121 */     if (view == null)
/*     */     {
/* 123 */       view = table.createView(views.tx);
/* 124 */       views.entityViews[table.getTableId()] = view;
/*     */     }
/* 126 */     return view;
/*     */   }
/*     */ 
/*     */   public Table.View getView(RelationTable table)
/*     */   {
/* 131 */     Views views = (Views)this.localViews.get();
/* 132 */     Table.View view = views.relationViews[table.getTableId()];
/* 133 */     if (view == null)
/*     */     {
/* 135 */       view = table.createView(views.tx);
/* 136 */       views.relationViews[table.getTableId()] = view;
/*     */     }
/* 138 */     return view;
/*     */   }
/*     */ 
/*     */   public void flush()
/*     */   {
/* 143 */     Views views = (Views)this.localViews.get();
/*     */ 
/* 145 */     Table.View[] relationViews = views.relationViews;
/* 146 */     if (relationViews != null)
/*     */     {
/* 148 */       for (int i = 0; i < relationViews.length; i++)
/*     */       {
/* 150 */         Table.View view = relationViews[i];
/* 151 */         if (view == null)
/*     */           continue;
/*     */         try
/*     */         {
/* 155 */           view.flushDeleted(views);
/*     */         }
/*     */         catch (SQLException e)
/*     */         {
/* 159 */           throw new EJBException("Failed to delete many-to-many relationships: " + e.getMessage(), e);
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 165 */     Table.View[] entityViews = views.entityViews;
/* 166 */     for (int i = 0; i < entityViews.length; i++)
/*     */     {
/* 168 */       Table.View view = entityViews[i];
/* 169 */       if (view == null)
/*     */         continue;
/*     */       try
/*     */       {
/* 173 */         view.flushDeleted(views);
/*     */       }
/*     */       catch (SQLException e)
/*     */       {
/* 177 */         throw new EJBException("Failed to delete instances: " + e.getMessage(), e);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 182 */     for (int i = 0; i < entityViews.length; i++)
/*     */     {
/* 184 */       Table.View view = entityViews[i];
/* 185 */       if (view == null)
/*     */         continue;
/*     */       try
/*     */       {
/* 189 */         view.flushCreated(views);
/*     */       }
/*     */       catch (SQLException e)
/*     */       {
/* 193 */         throw new EJBException("Failed to create instances: " + e.getMessage(), e);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 198 */     for (int i = 0; i < entityViews.length; i++)
/*     */     {
/* 200 */       Table.View view = entityViews[i];
/* 201 */       if (view == null)
/*     */         continue;
/*     */       try
/*     */       {
/* 205 */         view.flushUpdated();
/*     */       }
/*     */       catch (SQLException e)
/*     */       {
/* 209 */         throw new EJBException("Failed to update instances: " + e.getMessage(), e);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 214 */     if (relationViews != null)
/*     */     {
/* 216 */       for (int i = 0; i < relationViews.length; i++)
/*     */       {
/* 218 */         Table.View view = relationViews[i];
/* 219 */         if (view == null)
/*     */           continue;
/*     */         try
/*     */         {
/* 223 */           view.flushCreated(views);
/*     */         }
/*     */         catch (SQLException e)
/*     */         {
/* 227 */           throw new EJBException("Failed to create many-to-many relationships: " + e.getMessage(), e);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private class SchemaSynchronization
/*     */     implements Synchronization
/*     */   {
/*     */     private final Schema.Views views;
/*     */ 
/*     */     public SchemaSynchronization(Schema.Views views)
/*     */     {
/* 256 */       this.views = views;
/*     */     }
/*     */ 
/*     */     public void beforeCompletion()
/*     */     {
/* 261 */       Schema.this.flush();
/*     */ 
/* 263 */       for (int i = 0; i < this.views.entityViews.length; i++)
/*     */       {
/* 265 */         Table.View view = this.views.entityViews[i];
/* 266 */         if (view == null)
/*     */           continue;
/* 268 */         view.beforeCompletion();
/*     */       }
/*     */     }
/*     */ 
/*     */     public void afterCompletion(int status)
/*     */     {
/* 275 */       if ((status == 1) || (status == 4) || (status == 9))
/*     */       {
/* 279 */         for (int i = 0; i < this.views.entityViews.length; i++)
/*     */         {
/* 281 */           Table.View view = this.views.entityViews[i];
/* 282 */           if (view == null)
/*     */             continue;
/* 284 */           view.rolledback();
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 290 */         for (int i = 0; i < this.views.entityViews.length; i++)
/*     */         {
/* 292 */           Table.View view = this.views.entityViews[i];
/* 293 */           if (view == null)
/*     */             continue;
/* 295 */           view.committed();
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public class Views
/*     */   {
/*     */     public final Transaction tx;
/*     */     public final Table.View[] entityViews;
/*     */     public final Table.View[] relationViews;
/*     */ 
/*     */     public Views(Transaction tx)
/*     */     {
/* 244 */       this.tx = tx;
/* 245 */       this.entityViews = new Table.View[Schema.this.entityTables.length];
/* 246 */       this.relationViews = (Schema.this.relationTables == null ? null : new Table.View[Schema.this.relationTables.length]);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc2.schema.Schema
 * JD-Core Version:    0.6.0
 */