/*     */ package org.jboss.ejb.plugins.cmp.jdbc2;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import javax.ejb.DuplicateKeyException;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractCMRFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMRFieldBridge2.FieldState;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.schema.Cache.CacheLoader;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.schema.EntityTable.ForeignKeyConstraint;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.schema.EntityTable.Row;
/*     */ 
/*     */ public class PersistentContext
/*     */ {
/*     */   private final EntityTable.Row row;
/*     */   private final JDBCCMRFieldBridge2.FieldState[] cmrStates;
/*     */ 
/*     */   public PersistentContext(JDBCEntityBridge2 entity, EntityTable.Row row)
/*     */   {
/*  44 */     this.row = row;
/*     */ 
/*  46 */     JDBCAbstractCMRFieldBridge[] cmrFields = entity.getCMRFields();
/*  47 */     if (cmrFields != null)
/*     */     {
/*  49 */       this.cmrStates = new JDBCCMRFieldBridge2.FieldState[cmrFields.length];
/*     */     }
/*     */     else
/*     */     {
/*  53 */       this.cmrStates = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getFieldValue(int rowIndex)
/*     */   {
/*  59 */     return this.row.getFieldValue(rowIndex);
/*     */   }
/*     */ 
/*     */   public void setFieldValue(int rowIndex, Object value)
/*     */   {
/*  64 */     this.row.setFieldValue(rowIndex, value);
/*     */   }
/*     */ 
/*     */   public void setPk(Object pk) throws DuplicateKeyException
/*     */   {
/*  69 */     if (pk == null)
/*     */     {
/*  71 */       throw new IllegalArgumentException("Primary key is null!");
/*     */     }
/*     */ 
/*  74 */     this.row.insert(pk);
/*     */   }
/*     */ 
/*     */   public boolean isDirty()
/*     */   {
/*  79 */     return this.row.isDirty();
/*     */   }
/*     */ 
/*     */   public void setDirty()
/*     */   {
/*  84 */     this.row.setDirty();
/*     */   }
/*     */ 
/*     */   public void setDirtyRelations()
/*     */   {
/*  89 */     this.row.setDirtyRelations();
/*     */   }
/*     */ 
/*     */   public void remove()
/*     */   {
/*  94 */     this.row.delete();
/*     */   }
/*     */ 
/*     */   public JDBCCMRFieldBridge2.FieldState getCMRState(int cmrIndex)
/*     */   {
/*  99 */     return this.cmrStates[cmrIndex];
/*     */   }
/*     */ 
/*     */   public void setCMRState(int cmrIndex, JDBCCMRFieldBridge2.FieldState state)
/*     */   {
/* 104 */     this.cmrStates[cmrIndex] = state;
/*     */   }
/*     */ 
/*     */   public void loadCachedRelations(int cmrIndex, Cache.CacheLoader loader)
/*     */   {
/* 109 */     this.row.loadCachedRelations(cmrIndex, loader);
/*     */   }
/*     */ 
/*     */   public void cacheRelations(int cmrIndex, Cache.CacheLoader loader)
/*     */   {
/* 114 */     this.row.cacheRelations(cmrIndex, loader);
/*     */   }
/*     */ 
/*     */   public void flush() throws SQLException, DuplicateKeyException
/*     */   {
/* 119 */     this.row.flush();
/*     */   }
/*     */ 
/*     */   public void nullForeignKey(EntityTable.ForeignKeyConstraint constraint)
/*     */   {
/* 124 */     this.row.nullForeignKey(constraint);
/*     */   }
/*     */ 
/*     */   public void nonNullForeignKey(EntityTable.ForeignKeyConstraint constraint)
/*     */   {
/* 129 */     this.row.nonNullForeignKey(constraint);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc2.PersistentContext
 * JD-Core Version:    0.6.0
 */