/*     */ package org.jboss.ejb.plugins.cmp.jdbc2;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.ejb.FinderException;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.plugins.cmp.bridge.EntityBridgeInvocationHandler;
/*     */ import org.jboss.ejb.plugins.cmp.bridge.EntityBridgeInvocationHandler.FieldGetInvoker;
/*     */ import org.jboss.ejb.plugins.cmp.bridge.EntityBridgeInvocationHandler.FieldSetInvoker;
/*     */ import org.jboss.ejb.plugins.cmp.bridge.FieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.EJBSelectBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.schema.Schema;
/*     */ import org.jboss.proxy.compiler.InvocationHandler;
/*     */ import org.jboss.proxy.compiler.Proxy;
/*     */ 
/*     */ public class InstanceFactory
/*     */ {
/*     */   private final Class beanClass;
/*     */   private final Constructor beanProxyConstructor;
/*     */   private final Map fieldMap;
/*     */   private final Map selectorMap;
/*     */ 
/*     */   public InstanceFactory(JDBCStoreManager2 manager, JDBCEntityBridge2 entity)
/*     */     throws Exception
/*     */   {
/*  61 */     EntityContainer theContainer = manager.getContainer();
/*  62 */     this.beanClass = theContainer.getBeanClass();
/*  63 */     this.fieldMap = createFieldMap(entity);
/*  64 */     this.selectorMap = createSelectorMap(entity, manager.getQueryFactory());
/*     */ 
/*  66 */     EntityBridgeInvocationHandler handler = new EntityBridgeInvocationHandler(this.fieldMap, this.selectorMap, this.beanClass);
/*  67 */     Class[] classes = { this.beanClass };
/*  68 */     ClassLoader classLoader = this.beanClass.getClassLoader();
/*     */ 
/*  70 */     Object o = Proxy.newProxyInstance(classLoader, classes, handler);
/*     */ 
/*  73 */     this.beanProxyConstructor = o.getClass().getConstructor(new Class[] { InvocationHandler.class });
/*     */ 
/*  76 */     newInstance();
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*  81 */     Proxy.forgetProxyForClass(this.beanClass);
/*     */   }
/*     */ 
/*     */   public Object newInstance() throws Exception
/*     */   {
/*  86 */     EntityBridgeInvocationHandler handler = new EntityBridgeInvocationHandler(this.fieldMap, this.selectorMap, this.beanClass);
/*  87 */     return this.beanProxyConstructor.newInstance(new Object[] { handler });
/*     */   }
/*     */ 
/*     */   private static Map getAbstractAccessors(Class beanClass)
/*     */   {
/*  92 */     Method[] methods = beanClass.getMethods();
/*  93 */     Map abstractAccessors = new HashMap(methods.length);
/*     */ 
/*  95 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/*  97 */       if (!Modifier.isAbstract(methods[i].getModifiers()))
/*     */         continue;
/*  99 */       String methodName = methods[i].getName();
/* 100 */       if ((!methodName.startsWith("get")) && (!methodName.startsWith("set")))
/*     */         continue;
/* 102 */       abstractAccessors.put(methodName, methods[i]);
/*     */     }
/*     */ 
/* 106 */     return abstractAccessors;
/*     */   }
/*     */ 
/*     */   private static Map createFieldMap(JDBCEntityBridge2 entityBridge) throws DeploymentException
/*     */   {
/* 111 */     Map abstractAccessors = getAbstractAccessors(entityBridge.getMetaData().getEntityClass());
/*     */ 
/* 113 */     List fields = entityBridge.getFields();
/* 114 */     Map map = new HashMap(fields.size() * 2);
/* 115 */     for (int i = 0; i < fields.size(); i++)
/*     */     {
/* 117 */       FieldBridge field = (FieldBridge)fields.get(i);
/*     */ 
/* 120 */       String fieldName = field.getFieldName();
/* 121 */       String fieldBaseName = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
/* 122 */       String getterName = "get" + fieldBaseName;
/* 123 */       String setterName = "set" + fieldBaseName;
/*     */ 
/* 126 */       Method getterMethod = (Method)abstractAccessors.get(getterName);
/* 127 */       Method setterMethod = (Method)abstractAccessors.get(setterName);
/*     */ 
/* 130 */       if ((getterMethod != null) && (setterMethod == null))
/*     */       {
/* 132 */         throw new DeploymentException("Getter was found but, no setter was found for field: " + fieldName);
/*     */       }
/* 134 */       if ((getterMethod == null) && (setterMethod != null))
/*     */       {
/* 136 */         throw new DeploymentException("Setter was found but, no getter was found for field: " + fieldName);
/*     */       }
/* 138 */       if ((getterMethod == null) || (setterMethod == null)) {
/*     */         continue;
/*     */       }
/* 141 */       map.put(getterMethod.getName(), new EntityBridgeInvocationHandler.FieldGetInvoker(field));
/* 142 */       map.put(setterMethod.getName(), new EntityBridgeInvocationHandler.FieldSetInvoker(field));
/*     */ 
/* 145 */       abstractAccessors.remove(getterName);
/* 146 */       abstractAccessors.remove(setterName);
/*     */     }
/*     */ 
/* 149 */     return Collections.unmodifiableMap(map);
/*     */   }
/*     */ 
/*     */   private static Map createSelectorMap(JDBCEntityBridge2 entityBridge, QueryFactory queryFactory)
/*     */     throws DeploymentException
/*     */   {
/* 155 */     Collection queries = entityBridge.getMetaData().getQueries();
/* 156 */     Map selectorsByMethod = new HashMap(queries.size());
/* 157 */     Iterator definedFinders = queries.iterator();
/* 158 */     while (definedFinders.hasNext())
/*     */     {
/* 160 */       JDBCQueryMetaData metadata = (JDBCQueryMetaData)definedFinders.next();
/* 161 */       if (metadata.getMethod().getName().startsWith("ejbSelect"))
/*     */       {
/*     */         try
/*     */         {
/* 165 */           QueryCommand queryCommand = queryFactory.getQueryCommand(metadata.getMethod());
/* 166 */           Schema schema = ((JDBCStoreManager2)entityBridge.getManager()).getSchema();
/* 167 */           EJBSelectBridge ejbSelectBridge = new EJBSelectBridge(entityBridge.getContainer(), schema, metadata, queryCommand);
/* 168 */           selectorsByMethod.put(metadata.getMethod(), ejbSelectBridge);
/*     */         }
/*     */         catch (FinderException e)
/*     */         {
/* 172 */           throw new DeploymentException(e.getMessage());
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 177 */     return selectorsByMethod;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc2.InstanceFactory
 * JD-Core Version:    0.6.0
 */