/*     */ package org.jboss.ejb.plugins.cmp.jdbc2;
/*     */ 
/*     */ import javax.ejb.FinderException;
/*     */ import javax.ejb.ObjectNotFoundException;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.GenericEntityObjectFactory;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCEntityPersistenceStore;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCTypeFactory;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.QueryParameter;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCFunctionMappingMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCTypeMappingMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMPFieldBridge2;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.schema.EntityTable;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.schema.Schema;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class FindByPrimaryKeyCommand extends AbstractQueryCommand
/*     */ {
/*     */   public FindByPrimaryKeyCommand(JDBCEntityBridge2 entity)
/*     */     throws DeploymentException
/*     */   {
/*  49 */     this.entity = entity;
/*     */ 
/*  51 */     JDBCCMPFieldBridge2[] fields = (JDBCCMPFieldBridge2[])(JDBCCMPFieldBridge2[])entity.getTableFields();
/*  52 */     String selectColumns = fields[0].getColumnName();
/*  53 */     for (int i = 1; i < fields.length; i++)
/*     */     {
/*  55 */       selectColumns = selectColumns + ", " + fields[i].getColumnName();
/*     */     }
/*     */ 
/*  58 */     JDBCCMPFieldBridge2[] pkFields = (JDBCCMPFieldBridge2[])(JDBCCMPFieldBridge2[])entity.getPrimaryKeyFields();
/*  59 */     String whereColumns = pkFields[0].getColumnName() + "=?";
/*  60 */     for (int i = 1; i < pkFields.length; i++)
/*     */     {
/*  62 */       whereColumns = whereColumns + " and " + pkFields[i].getColumnName() + "=?";
/*     */     }
/*     */ 
/*  65 */     if (entity.getMetaData().hasRowLocking())
/*     */     {
/*  67 */       JDBCEntityPersistenceStore manager = entity.getManager();
/*  68 */       JDBCTypeFactory typeFactory = manager.getJDBCTypeFactory();
/*  69 */       JDBCTypeMappingMetaData typeMapping = typeFactory.getTypeMapping();
/*  70 */       JDBCFunctionMappingMetaData rowLockingTemplate = typeMapping.getRowLockingTemplate();
/*     */ 
/*  72 */       if (rowLockingTemplate == null)
/*     */       {
/*  74 */         throw new DeploymentException("Row locking template is not defined for mapping: " + typeMapping.getName());
/*     */       }
/*     */ 
/*  77 */       this.sql = rowLockingTemplate.getFunctionSql(new Object[] { selectColumns, entity.getQualifiedTableName(), whereColumns, null }, new StringBuffer()).toString();
/*     */     }
/*     */     else
/*     */     {
/*  83 */       this.sql = "select ";
/*  84 */       this.sql += selectColumns;
/*  85 */       this.sql = (this.sql + " from " + entity.getQualifiedTableName() + " where ");
/*  86 */       this.sql += whereColumns;
/*     */     }
/*     */ 
/*  89 */     this.log = Logger.getLogger(getClass().getName() + "." + entity.getEntityName() + "#findByPrimaryKey");
/*     */ 
/*  91 */     this.log.debug("sql: " + this.sql);
/*     */ 
/*  93 */     setParameters(QueryParameter.createPrimaryKeyParameters(0, entity));
/*  94 */     setEntityReader(entity, false);
/*     */   }
/*     */ 
/*     */   public Object fetchOne(Schema schema, GenericEntityObjectFactory factory, Object[] args) throws FinderException
/*     */   {
/*  99 */     Object pk = args[0];
/* 100 */     if (pk == null)
/*     */     {
/* 102 */       throw new IllegalArgumentException("Null argument for findByPrimaryKey");
/*     */     }
/*     */ 
/* 106 */     boolean cached = this.entity.getTable().hasRow(pk);
/*     */     Object instance;
/* 107 */     if (!cached)
/*     */     {
/* 109 */       Object instance = super.executeFetchOne(args, factory);
/* 110 */       if (instance == null)
/*     */       {
/* 112 */         throw new ObjectNotFoundException("Instance not find: entity=" + this.entity.getEntityName() + ", pk=" + pk);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 117 */       instance = factory.getEntityEJBObject(pk);
/*     */     }
/*     */ 
/* 120 */     return instance;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc2.FindByPrimaryKeyCommand
 * JD-Core Version:    0.6.0
 */