/*     */ package org.jboss.ejb.plugins.cmp.jdbc2;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.StringTokenizer;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.plugins.cmp.ejbql.Catalog;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCEntityPersistenceStore;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.QueryParameter;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCDeclaredQueryMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMPFieldBridge2;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class DeclaredSQLQueryCommand extends AbstractQueryCommand
/*     */ {
/*     */   private JDBCCMPFieldBridge2 selectedField;
/*     */ 
/*     */   public DeclaredSQLQueryCommand(JDBCEntityBridge2 entity, JDBCDeclaredQueryMetaData metadata)
/*     */     throws DeploymentException
/*     */   {
/*  48 */     initResultReader(entity, metadata);
/*     */ 
/*  50 */     this.sql = buildSQL(metadata);
/*  51 */     this.sql = parseParameters(this.sql, metadata);
/*     */ 
/*  53 */     setResultType(metadata.getMethod().getReturnType());
/*     */ 
/*  55 */     this.log = Logger.getLogger(getClass().getName() + "." + entity.getEntityName() + "#" + metadata.getMethod().getName());
/*     */ 
/*  57 */     this.log.debug("sql: " + this.sql);
/*     */   }
/*     */ 
/*     */   private void initResultReader(JDBCEntityBridge2 entity, JDBCDeclaredQueryMetaData metadata)
/*     */     throws DeploymentException
/*     */   {
/*  63 */     String entityName = metadata.getEJBName();
/*  64 */     if (entityName != null)
/*     */     {
/*  66 */       Catalog catalog = entity.getManager().getCatalog();
/*  67 */       JDBCEntityBridge2 otherEntity = (JDBCEntityBridge2)catalog.getEntityByEJBName(entityName);
/*  68 */       if (otherEntity == null)
/*     */       {
/*  70 */         throw new DeploymentException("Unknown entity: " + entityName);
/*     */       }
/*  72 */       this.entity = otherEntity;
/*     */     }
/*     */     else
/*     */     {
/*  76 */       this.entity = entity;
/*     */     }
/*     */ 
/*  79 */     String fieldName = metadata.getFieldName();
/*  80 */     if (fieldName == null)
/*     */     {
/*  82 */       setEntityReader(this.entity, metadata.isSelectDistinct());
/*     */     }
/*     */     else
/*     */     {
/*  86 */       this.selectedField = ((JDBCCMPFieldBridge2)entity.getFieldByName(fieldName));
/*  87 */       if (this.selectedField == null)
/*     */       {
/*  89 */         throw new DeploymentException("Unknown cmp field: " + fieldName);
/*     */       }
/*     */ 
/*  92 */       setFieldReader(this.selectedField);
/*     */     }
/*     */   }
/*     */ 
/*     */   private String buildSQL(JDBCDeclaredQueryMetaData metadata)
/*     */   {
/*  98 */     StringBuffer sql = new StringBuffer(300);
/*     */ 
/* 100 */     sql.append("SELECT ");
/* 101 */     if (metadata.isSelectDistinct())
/*     */     {
/* 103 */       sql.append("DISTINCT ");
/*     */     }
/*     */ 
/* 106 */     String alias = metadata.getAlias();
/* 107 */     String from = metadata.getFrom();
/*     */     String selectList;
/*     */     String table;
/*     */     String selectList;
/* 110 */     if (metadata.getFieldName() == null)
/*     */     {
/* 113 */       String table = this.entity.getQualifiedTableName();
/*     */ 
/* 117 */       String tableAlias = getTableAlias(alias, from, this.entity.getTableName());
/* 118 */       selectList = SQLUtil.getColumnNamesClause(this.entity.getPrimaryKeyFields(), tableAlias, new StringBuffer(35)).toString();
/*     */     }
/*     */     else
/*     */     {
/* 125 */       JDBCStoreManager2 manager = (JDBCStoreManager2)this.selectedField.getManager();
/* 126 */       table = manager.getEntityBridge().getQualifiedTableName();
/* 127 */       selectList = SQLUtil.getColumnNamesClause(this.selectedField, getTableAlias(alias, from, manager.getEntityBridge().getTableName()), new StringBuffer()).toString();
/*     */     }
/*     */ 
/* 131 */     sql.append(selectList);
/* 132 */     String additionalColumns = metadata.getAdditionalColumns();
/* 133 */     if (additionalColumns != null)
/*     */     {
/* 135 */       sql.append(additionalColumns);
/*     */     }
/* 137 */     sql.append(" FROM ").append(table);
/* 138 */     if (alias != null)
/*     */     {
/* 140 */       sql.append(' ').append(alias);
/*     */     }
/* 142 */     if (from != null)
/*     */     {
/* 144 */       sql.append(' ').append(from);
/*     */     }
/*     */ 
/* 147 */     String where = metadata.getWhere();
/* 148 */     if ((where != null) && (where.trim().length() > 0))
/*     */     {
/* 150 */       sql.append(" WHERE ").append(where);
/*     */     }
/*     */ 
/* 153 */     String order = metadata.getOrder();
/* 154 */     if ((order != null) && (order.trim().length() > 0))
/*     */     {
/* 156 */       sql.append(" ORDER BY ").append(order);
/*     */     }
/*     */ 
/* 159 */     String other = metadata.getOther();
/* 160 */     if ((other != null) && (other.trim().length() > 0))
/*     */     {
/* 162 */       sql.append(' ').append(other);
/*     */     }
/* 164 */     return sql.toString();
/*     */   }
/*     */ 
/*     */   private static String getTableAlias(String alias, String from, String table)
/*     */   {
/*     */     String tableAlias;
/*     */     String tableAlias;
/* 170 */     if (alias != null)
/*     */     {
/* 172 */       tableAlias = alias;
/*     */     }
/*     */     else
/*     */     {
/*     */       String tableAlias;
/* 174 */       if (from != null)
/*     */       {
/* 176 */         tableAlias = table;
/*     */       }
/*     */       else
/*     */       {
/* 180 */         tableAlias = "";
/*     */       }
/*     */     }
/* 182 */     return tableAlias;
/*     */   }
/*     */ 
/*     */   protected String parseParameters(String sql, JDBCDeclaredQueryMetaData metadata)
/*     */     throws DeploymentException
/*     */   {
/* 197 */     StringBuffer sqlBuf = new StringBuffer();
/* 198 */     ArrayList params = new ArrayList();
/*     */ 
/* 201 */     if (sql != null)
/*     */     {
/* 203 */       sql = sql.trim();
/*     */ 
/* 205 */       StringTokenizer tokens = new StringTokenizer(sql, "{}", true);
/* 206 */       while (tokens.hasMoreTokens())
/*     */       {
/* 208 */         String token = tokens.nextToken();
/* 209 */         if (token.equals("{"))
/*     */         {
/* 211 */           token = tokens.nextToken();
/* 212 */           if (Character.isDigit(token.charAt(0)))
/*     */           {
/* 214 */             QueryParameter parameter = new QueryParameter(this.entity.getManager(), metadata.getMethod(), token);
/*     */ 
/* 218 */             sqlBuf.append("?");
/* 219 */             params.add(parameter);
/*     */ 
/* 221 */             if (!tokens.nextToken().equals("}"))
/*     */             {
/* 223 */               throw new DeploymentException("Invalid parameter - missing closing '}' : " + sql);
/*     */             }
/*     */ 
/*     */           }
/*     */           else
/*     */           {
/* 230 */             sqlBuf.append("{").append(token);
/*     */           }
/*     */ 
/*     */         }
/*     */         else
/*     */         {
/* 236 */           sqlBuf.append(token);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 241 */     setParameters(params);
/*     */ 
/* 243 */     return sqlBuf.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc2.DeclaredSQLQueryCommand
 * JD-Core Version:    0.6.0
 */