/*    */ package org.jboss.ejb.plugins.cmp.jdbc2;
/*    */ 
/*    */ import java.lang.reflect.Method;
/*    */ import java.sql.SQLException;
/*    */ import javax.ejb.CreateException;
/*    */ import javax.ejb.DuplicateKeyException;
/*    */ import org.jboss.deployment.DeploymentException;
/*    */ import org.jboss.ejb.EntityEnterpriseContext;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;
/*    */ 
/*    */ public class ApplicationPkCreateCommand
/*    */   implements CreateCommand
/*    */ {
/*    */   private JDBCEntityBridge2 entityBridge;
/*    */ 
/*    */   public void init(JDBCStoreManager2 manager)
/*    */     throws DeploymentException
/*    */   {
/* 44 */     this.entityBridge = ((JDBCEntityBridge2)manager.getEntityBridge());
/*    */   }
/*    */ 
/*    */   public Object execute(Method m, Object[] args, EntityEnterpriseContext ctx)
/*    */     throws CreateException
/*    */   {
/* 50 */     PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
/*    */     Object pk;
/* 51 */     if (ctx.getId() == null)
/*    */     {
/* 53 */       Object pk = this.entityBridge.extractPrimaryKeyFromInstance(ctx);
/*    */ 
/* 55 */       if (pk == null)
/*    */       {
/* 57 */         throw new CreateException("Primary key for created instance is null.");
/*    */       }
/*    */ 
/* 60 */       pctx.setPk(pk);
/*    */     }
/*    */     else
/*    */     {
/*    */       try
/*    */       {
/* 67 */         pctx.flush();
/*    */       }
/*    */       catch (SQLException e)
/*    */       {
/* 71 */         if ("23000".equals(e.getSQLState()))
/*    */         {
/* 73 */           throw new DuplicateKeyException("Unique key violation or invalid foreign key value: pk=" + ctx.getId());
/*    */         }
/*    */ 
/* 77 */         throw new CreateException("Failed to create instance: pk=" + ctx.getId() + ", state=" + e.getSQLState() + ", msg=" + e.getMessage());
/*    */       }
/*    */ 
/* 82 */       pk = ctx.getId();
/*    */     }
/* 84 */     return pk;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc2.ApplicationPkCreateCommand
 * JD-Core Version:    0.6.0
 */