/*     */ package org.jboss.ejb.plugins.cmp.jdbc.metadata;
/*     */ 
/*     */ import java.net.URL;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.XmlFileLoader;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public final class JDBCXmlFileLoader
/*     */ {
/*     */   private final Container container;
/*     */   private final Logger log;
/*     */ 
/*     */   public JDBCXmlFileLoader(Container con, Logger log)
/*     */   {
/*  53 */     this.container = con;
/*  54 */     this.log = log;
/*     */   }
/*     */ 
/*     */   public JDBCApplicationMetaData load()
/*     */     throws DeploymentException
/*     */   {
/*  63 */     JDBCApplicationMetaData jamd = new JDBCApplicationMetaData(this.container.getBeanMetaData().getApplicationMetaData(), this.container.getClassLoader());
/*     */ 
/*  69 */     URL stdJDBCUrl = this.container.getClassLoader().getResource("standardjbosscmp-jdbc.xml");
/*  70 */     if (stdJDBCUrl == null) {
/*  71 */       throw new DeploymentException("No standardjbosscmp-jdbc.xml found");
/*     */     }
/*     */ 
/*  74 */     boolean debug = this.log.isDebugEnabled();
/*  75 */     if (debug)
/*  76 */       this.log.debug("Loading standardjbosscmp-jdbc.xml : " + stdJDBCUrl.toString());
/*  77 */     Element stdJDBCElement = XmlFileLoader.getDocument(stdJDBCUrl, true).getDocumentElement();
/*     */ 
/*  80 */     jamd = new JDBCApplicationMetaData(stdJDBCElement, jamd);
/*     */ 
/*  83 */     URL jdbcUrl = null;
/*  84 */     VirtualFile dd = this.container.getDeploymentUnit().getMetaDataFile("jbosscmp-jdbc.xml");
/*  85 */     if (dd != null)
/*     */     {
/*     */       try
/*     */       {
/*  89 */         jdbcUrl = dd.toURL();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*  93 */         throw new IllegalStateException("Failed to create URL for " + dd.getPathName(), e);
/*     */       }
/*     */     }
/*     */ 
/*  97 */     if (jdbcUrl != null)
/*     */     {
/*  99 */       if (debug)
/* 100 */         this.log.debug(jdbcUrl.toString() + " found. Overriding defaults");
/* 101 */       Element jdbcElement = XmlFileLoader.getDocument(jdbcUrl, true).getDocumentElement();
/* 102 */       jamd = new JDBCApplicationMetaData(jdbcElement, jamd);
/*     */     }
/*     */ 
/* 105 */     return jamd;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCXmlFileLoader
 * JD-Core Version:    0.6.0
 */