/*     */ package org.jboss.ejb.plugins.cmp.jdbc.metadata;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import javax.sql.DataSource;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.jboss.metadata.RelationMetaData;
/*     */ import org.jboss.metadata.RelationshipRoleMetaData;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public final class JDBCRelationMetaData
/*     */ {
/*     */   private static final int TABLE = 1;
/*     */   private static final int FOREIGN_KEY = 2;
/*     */   private final String relationName;
/*     */   private final JDBCRelationshipRoleMetaData left;
/*     */   private final JDBCRelationshipRoleMetaData right;
/*     */   private final int mappingStyle;
/*     */   private final String dataSourceName;
/*     */   private final String datasourceMappingName;
/*     */   private transient DataSource dataSource;
/*     */   private final JDBCTypeMappingMetaData datasourceMapping;
/*     */   private final String tableName;
/*     */   private boolean tableCreated;
/*     */   private boolean tableDropped;
/*     */   private final boolean createTable;
/*     */   private final boolean removeTable;
/*     */   private final boolean alterTable;
/*     */   private final ArrayList tablePostCreateCmd;
/*     */   private final boolean rowLocking;
/*     */   private final boolean primaryKeyConstraint;
/*     */   private final boolean readOnly;
/*     */   private final int readTimeOut;
/*     */ 
/*     */   public JDBCRelationMetaData(JDBCApplicationMetaData jdbcApplication, RelationMetaData relationMetaData)
/*     */     throws DeploymentException
/*     */   {
/* 129 */     RelationshipRoleMetaData leftRole = relationMetaData.getLeftRelationshipRole();
/* 130 */     RelationshipRoleMetaData rightRole = relationMetaData.getRightRelationshipRole();
/*     */ 
/* 133 */     if ((leftRole.isMultiplicityMany()) && (rightRole.isMultiplicityMany()))
/*     */     {
/* 135 */       this.mappingStyle = 1;
/*     */     }
/*     */     else
/*     */     {
/* 139 */       this.mappingStyle = 2;
/*     */     }
/*     */ 
/* 142 */     this.dataSourceName = null;
/* 143 */     this.datasourceMappingName = null;
/* 144 */     this.datasourceMapping = null;
/* 145 */     this.createTable = false;
/* 146 */     this.removeTable = false;
/* 147 */     this.alterTable = false;
/* 148 */     this.rowLocking = false;
/* 149 */     this.primaryKeyConstraint = false;
/* 150 */     this.readOnly = false;
/* 151 */     this.readTimeOut = -1;
/*     */ 
/* 153 */     this.left = new JDBCRelationshipRoleMetaData(this, jdbcApplication, leftRole);
/*     */ 
/* 155 */     this.right = new JDBCRelationshipRoleMetaData(this, jdbcApplication, rightRole);
/* 156 */     this.left.init(this.right);
/* 157 */     this.right.init(this.left);
/*     */ 
/* 159 */     this.relationName = getNonNullRelationName(this.left, this.right, relationMetaData.getRelationName());
/*     */ 
/* 161 */     if (this.mappingStyle == 1)
/*     */     {
/* 163 */       this.tableName = createDefaultTableName();
/* 164 */       this.tablePostCreateCmd = getDefaultTablePostCreateCmd();
/*     */     }
/*     */     else
/*     */     {
/* 168 */       this.tableName = null;
/* 169 */       this.tablePostCreateCmd = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public JDBCRelationMetaData(JDBCApplicationMetaData jdbcApplication, Element element, JDBCRelationMetaData defaultValues)
/*     */     throws DeploymentException
/*     */   {
/* 191 */     this.mappingStyle = loadMappingStyle(element, defaultValues);
/*     */ 
/* 194 */     String readOnlyString = MetaData.getOptionalChildContent(element, "read-only");
/* 195 */     if (readOnlyString != null)
/*     */     {
/* 197 */       this.readOnly = Boolean.valueOf(readOnlyString).booleanValue();
/*     */     }
/*     */     else
/*     */     {
/* 201 */       this.readOnly = defaultValues.isReadOnly();
/*     */     }
/*     */ 
/* 205 */     String readTimeOutString = MetaData.getOptionalChildContent(element, "read-time-out");
/* 206 */     if (readTimeOutString != null)
/*     */     {
/*     */       try
/*     */       {
/* 210 */         this.readTimeOut = Integer.parseInt(readTimeOutString);
/*     */       }
/*     */       catch (NumberFormatException e)
/*     */       {
/* 214 */         throw new DeploymentException("Invalid number format in read-time-out '" + readTimeOutString + "': " + e);
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 220 */       this.readTimeOut = defaultValues.getReadTimeOut();
/*     */     }
/*     */ 
/* 227 */     Element mappingElement = getMappingElement(element);
/*     */ 
/* 230 */     String dataSourceNameString = MetaData.getOptionalChildContent(mappingElement, "datasource");
/* 231 */     if (dataSourceNameString != null)
/* 232 */       this.dataSourceName = dataSourceNameString;
/*     */     else {
/* 234 */       this.dataSourceName = defaultValues.getDataSourceName();
/*     */     }
/*     */ 
/* 238 */     String datasourceMappingString = MetaData.getOptionalChildContent(mappingElement, "datasource-mapping");
/* 239 */     if (datasourceMappingString != null)
/*     */     {
/* 241 */       this.datasourceMappingName = datasourceMappingString;
/* 242 */       this.datasourceMapping = jdbcApplication.getTypeMappingByName(datasourceMappingString);
/* 243 */       if (this.datasourceMapping == null)
/*     */       {
/* 245 */         throw new DeploymentException("Error in jbosscmp-jdbc.xml : datasource-mapping " + datasourceMappingString + " not found");
/*     */       }
/*     */ 
/*     */     }
/* 249 */     else if ((defaultValues.datasourceMappingName != null) && (defaultValues.getTypeMapping() != null))
/*     */     {
/* 251 */       this.datasourceMappingName = null;
/* 252 */       this.datasourceMapping = defaultValues.getTypeMapping();
/*     */     }
/*     */     else
/*     */     {
/* 256 */       this.datasourceMappingName = null;
/* 257 */       this.datasourceMapping = JDBCEntityMetaData.obtainTypeMappingFromLibrary(this.dataSourceName);
/*     */     }
/*     */ 
/* 261 */     String tableNameString = MetaData.getOptionalChildContent(mappingElement, "table-name");
/* 262 */     if (tableNameString == null)
/*     */     {
/* 264 */       tableNameString = defaultValues.getDefaultTableName();
/* 265 */       if (tableNameString == null)
/*     */       {
/* 270 */         tableNameString = defaultValues.createDefaultTableName();
/*     */       }
/*     */     }
/* 273 */     this.tableName = tableNameString;
/*     */ 
/* 276 */     String createString = MetaData.getOptionalChildContent(mappingElement, "create-table");
/* 277 */     if (createString != null)
/*     */     {
/* 279 */       this.createTable = Boolean.valueOf(createString).booleanValue();
/*     */     }
/*     */     else
/*     */     {
/* 283 */       this.createTable = defaultValues.getCreateTable();
/*     */     }
/*     */ 
/* 287 */     String removeString = MetaData.getOptionalChildContent(mappingElement, "remove-table");
/* 288 */     if (removeString != null)
/*     */     {
/* 290 */       this.removeTable = Boolean.valueOf(removeString).booleanValue();
/*     */     }
/*     */     else
/*     */     {
/* 294 */       this.removeTable = defaultValues.getRemoveTable();
/*     */     }
/*     */ 
/* 298 */     Element posttc = MetaData.getOptionalChild(mappingElement, "post-table-create");
/* 299 */     if (posttc != null)
/*     */     {
/* 301 */       Iterator it = MetaData.getChildrenByTagName(posttc, "sql-statement");
/* 302 */       this.tablePostCreateCmd = new ArrayList();
/* 303 */       while (it.hasNext())
/*     */       {
/* 305 */         Element etmp = (Element)it.next();
/* 306 */         this.tablePostCreateCmd.add(MetaData.getElementContent(etmp));
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 311 */       this.tablePostCreateCmd = defaultValues.getDefaultTablePostCreateCmd();
/*     */     }
/*     */ 
/* 315 */     String alterString = MetaData.getOptionalChildContent(mappingElement, "alter-table");
/* 316 */     if (alterString != null)
/*     */     {
/* 318 */       this.alterTable = Boolean.valueOf(alterString).booleanValue();
/*     */     }
/*     */     else
/*     */     {
/* 322 */       this.alterTable = defaultValues.getAlterTable();
/*     */     }
/*     */ 
/* 326 */     String sForUpString = MetaData.getOptionalChildContent(mappingElement, "row-locking");
/* 327 */     if (sForUpString != null)
/*     */     {
/* 329 */       this.rowLocking = ((!isReadOnly()) && (Boolean.valueOf(sForUpString).booleanValue()));
/*     */     }
/*     */     else
/*     */     {
/* 333 */       this.rowLocking = defaultValues.hasRowLocking();
/*     */     }
/*     */ 
/* 337 */     String pkString = MetaData.getOptionalChildContent(mappingElement, "pk-constraint");
/* 338 */     if (pkString != null)
/*     */     {
/* 340 */       this.primaryKeyConstraint = Boolean.valueOf(pkString).booleanValue();
/*     */     }
/*     */     else
/*     */     {
/* 344 */       this.primaryKeyConstraint = defaultValues.hasPrimaryKeyConstraint();
/*     */     }
/*     */ 
/* 350 */     JDBCRelationshipRoleMetaData defaultLeft = defaultValues.getLeftRelationshipRole();
/* 351 */     JDBCRelationshipRoleMetaData defaultRight = defaultValues.getRightRelationshipRole();
/*     */ 
/* 353 */     if (!MetaData.getChildrenByTagName(element, "ejb-relationship-role").hasNext())
/*     */     {
/* 357 */       this.left = new JDBCRelationshipRoleMetaData(this, jdbcApplication, element, defaultLeft);
/*     */ 
/* 359 */       this.right = new JDBCRelationshipRoleMetaData(this, jdbcApplication, element, defaultRight);
/*     */ 
/* 361 */       this.left.init(this.right);
/* 362 */       this.right.init(this.left);
/*     */     }
/*     */     else
/*     */     {
/* 366 */       Element leftElement = getEJBRelationshipRoleElement(element, defaultLeft);
/* 367 */       this.left = new JDBCRelationshipRoleMetaData(this, jdbcApplication, leftElement, defaultLeft);
/*     */ 
/* 369 */       Element rightElement = getEJBRelationshipRoleElement(element, defaultRight);
/* 370 */       this.right = new JDBCRelationshipRoleMetaData(this, jdbcApplication, rightElement, defaultRight);
/*     */ 
/* 372 */       this.left.init(this.right, leftElement);
/* 373 */       this.right.init(this.left, rightElement);
/*     */     }
/*     */ 
/* 376 */     this.relationName = getNonNullRelationName(this.left, this.right, defaultValues.getRelationName());
/*     */ 
/* 379 */     if ((isForeignKeyMappingStyle()) && (this.left.getKeyFields().isEmpty()) && (this.right.getKeyFields().isEmpty()))
/*     */     {
/* 381 */       throw new DeploymentException("Atleast one role of a foreign-key mapped relationship must have key fields (or <primkey-field> is missing from ejb-jar.xml): ejb-relation-name=" + this.relationName);
/*     */     }
/*     */ 
/* 387 */     if ((isTableMappingStyle()) && ((this.left.getKeyFields().isEmpty()) || (this.right.getKeyFields().isEmpty())))
/*     */     {
/* 389 */       throw new DeploymentException("Both roles of a relation-table mapped relationship must have key fields: ejb-relation-name=" + this.relationName);
/*     */     }
/*     */   }
/*     */ 
/*     */   private int loadMappingStyle(Element element, JDBCRelationMetaData defaultValues)
/*     */     throws DeploymentException
/*     */   {
/* 398 */     if ("defaults".equals(element.getTagName()))
/*     */     {
/* 401 */       String perferredRelationMapping = MetaData.getOptionalChildContent(element, "preferred-relation-mapping");
/*     */ 
/* 403 */       if (("relation-table".equals(perferredRelationMapping)) || (defaultValues.isManyToMany()))
/*     */       {
/* 405 */         return 1;
/*     */       }
/*     */ 
/* 409 */       return 2;
/*     */     }
/*     */ 
/* 414 */     if (MetaData.getOptionalChild(element, "relation-table-mapping") != null)
/*     */     {
/* 416 */       return 1;
/*     */     }
/*     */ 
/* 420 */     if (MetaData.getOptionalChild(element, "foreign-key-mapping") != null)
/*     */     {
/* 422 */       if (defaultValues.isManyToMany())
/*     */       {
/* 424 */         throw new DeploymentException("Foreign key mapping-style is not allowed for many-to-many relationsips.");
/*     */       }
/*     */ 
/* 427 */       return 2;
/*     */     }
/*     */ 
/* 431 */     return defaultValues.mappingStyle;
/*     */   }
/*     */ 
/*     */   private static Element getMappingElement(Element element)
/*     */     throws DeploymentException
/*     */   {
/* 438 */     if ("defaults".equals(element.getTagName()))
/*     */     {
/* 440 */       return element;
/*     */     }
/*     */ 
/* 444 */     Element tableMappingElement = MetaData.getOptionalChild(element, "relation-table-mapping");
/* 445 */     if (tableMappingElement != null)
/*     */     {
/* 447 */       return tableMappingElement;
/*     */     }
/*     */ 
/* 451 */     Element foreignKeyMappingElement = MetaData.getOptionalChild(element, "foreign-key-mapping");
/* 452 */     if (foreignKeyMappingElement != null)
/*     */     {
/* 454 */       return foreignKeyMappingElement;
/*     */     }
/* 456 */     return null;
/*     */   }
/*     */ 
/*     */   private static Element getEJBRelationshipRoleElement(Element element, JDBCRelationshipRoleMetaData defaultRole)
/*     */     throws DeploymentException
/*     */   {
/* 463 */     String roleName = defaultRole.getRelationshipRoleName();
/*     */ 
/* 465 */     if (roleName == null) {
/* 466 */       throw new DeploymentException("No ejb-relationship-role-name element found");
/*     */     }
/* 468 */     Iterator iter = MetaData.getChildrenByTagName(element, "ejb-relationship-role");
/* 469 */     if (!iter.hasNext())
/*     */     {
/* 471 */       throw new DeploymentException("No ejb-relationship-role elements found");
/*     */     }
/*     */ 
/* 474 */     Element roleElement = null;
/* 475 */     for (int i = 0; iter.hasNext(); i++)
/*     */     {
/* 478 */       if (i > 1)
/*     */       {
/* 480 */         throw new DeploymentException("Expected only 2 ejb-relationship-role but found more then 2");
/*     */       }
/*     */ 
/* 483 */       Element tempElement = (Element)iter.next();
/* 484 */       if (!roleName.equals(MetaData.getUniqueChildContent(tempElement, "ejb-relationship-role-name")))
/*     */         continue;
/* 486 */       roleElement = tempElement;
/*     */     }
/*     */ 
/* 490 */     if (roleElement == null)
/*     */     {
/* 492 */       throw new DeploymentException("An ejb-relationship-role element was not found for role '" + roleName + "'");
/*     */     }
/*     */ 
/* 495 */     return roleElement;
/*     */   }
/*     */ 
/*     */   public String getRelationName()
/*     */   {
/* 506 */     return this.relationName;
/*     */   }
/*     */ 
/*     */   public JDBCRelationshipRoleMetaData getLeftRelationshipRole()
/*     */   {
/* 518 */     return this.left;
/*     */   }
/*     */ 
/*     */   public JDBCRelationshipRoleMetaData getRightRelationshipRole()
/*     */   {
/* 530 */     return this.right;
/*     */   }
/*     */ 
/*     */   public JDBCRelationshipRoleMetaData getOtherRelationshipRole(JDBCRelationshipRoleMetaData role)
/*     */   {
/* 543 */     if (this.left == role)
/*     */     {
/* 545 */       return this.right;
/*     */     }
/* 547 */     if (this.right == role)
/*     */     {
/* 549 */       return this.left;
/*     */     }
/*     */ 
/* 553 */     throw new IllegalArgumentException("Specified role is not the left or right role. role=" + role);
/*     */   }
/*     */ 
/*     */   public boolean isTableMappingStyle()
/*     */   {
/* 564 */     return this.mappingStyle == 1;
/*     */   }
/*     */ 
/*     */   public boolean isForeignKeyMappingStyle()
/*     */   {
/* 574 */     return this.mappingStyle == 2;
/*     */   }
/*     */ 
/*     */   private String getDataSourceName()
/*     */   {
/* 584 */     return this.dataSourceName;
/*     */   }
/*     */ 
/*     */   public JDBCTypeMappingMetaData getTypeMapping()
/*     */     throws DeploymentException
/*     */   {
/* 594 */     if (this.datasourceMapping == null)
/*     */     {
/* 596 */       throw new DeploymentException("type-mapping is not initialized: " + this.dataSourceName + " was not deployed or type-mapping was not configured.");
/*     */     }
/*     */ 
/* 600 */     return this.datasourceMapping;
/*     */   }
/*     */ 
/*     */   public String getDefaultTableName()
/*     */   {
/* 610 */     return this.tableName;
/*     */   }
/*     */ 
/*     */   public ArrayList getDefaultTablePostCreateCmd()
/*     */   {
/* 621 */     return this.tablePostCreateCmd;
/*     */   }
/*     */ 
/*     */   public boolean isTableCreated()
/*     */   {
/* 634 */     return this.tableCreated;
/*     */   }
/*     */ 
/*     */   public void setTableCreated()
/*     */   {
/* 639 */     this.tableCreated = true;
/*     */   }
/*     */ 
/*     */   public void setTableDropped()
/*     */   {
/* 647 */     this.tableDropped = true;
/*     */   }
/*     */ 
/*     */   public boolean isTableDropped()
/*     */   {
/* 652 */     return this.tableDropped;
/*     */   }
/*     */ 
/*     */   public boolean getCreateTable()
/*     */   {
/* 663 */     return this.createTable;
/*     */   }
/*     */ 
/*     */   public boolean getRemoveTable()
/*     */   {
/* 674 */     return this.removeTable;
/*     */   }
/*     */ 
/*     */   public boolean getAlterTable()
/*     */   {
/* 682 */     return this.alterTable;
/*     */   }
/*     */ 
/*     */   public boolean hasPrimaryKeyConstraint()
/*     */   {
/* 694 */     return this.primaryKeyConstraint;
/*     */   }
/*     */ 
/*     */   public boolean isReadOnly()
/*     */   {
/* 702 */     return this.readOnly;
/*     */   }
/*     */ 
/*     */   public int getReadTimeOut()
/*     */   {
/* 710 */     return this.readTimeOut;
/*     */   }
/*     */ 
/*     */   public boolean hasRowLocking()
/*     */   {
/* 718 */     return this.rowLocking;
/*     */   }
/*     */ 
/*     */   private String createDefaultTableName()
/*     */   {
/* 723 */     String defaultTableName = this.left.getEntity().getName();
/* 724 */     if (this.left.getCMRFieldName() != null)
/*     */     {
/* 726 */       defaultTableName = defaultTableName + "_" + this.left.getCMRFieldName();
/*     */     }
/* 728 */     defaultTableName = defaultTableName + "_" + this.right.getEntity().getName();
/* 729 */     if (this.right.getCMRFieldName() != null)
/*     */     {
/* 731 */       defaultTableName = defaultTableName + "_" + this.right.getCMRFieldName();
/*     */     }
/* 733 */     return defaultTableName;
/*     */   }
/*     */ 
/*     */   private boolean isManyToMany()
/*     */   {
/* 738 */     return (this.left.isMultiplicityMany()) && (this.right.isMultiplicityMany());
/*     */   }
/*     */ 
/*     */   public synchronized DataSource getDataSource()
/*     */   {
/* 743 */     if (this.dataSource == null)
/*     */     {
/*     */       try
/*     */       {
/* 747 */         InitialContext context = new InitialContext();
/* 748 */         this.dataSource = ((DataSource)context.lookup(this.dataSourceName));
/*     */       }
/*     */       catch (NamingException e)
/*     */       {
/* 752 */         throw new EJBException("Data source for relationship named " + this.relationName + " not found " + this.dataSourceName);
/*     */       }
/*     */     }
/*     */ 
/* 756 */     return this.dataSource;
/*     */   }
/*     */ 
/*     */   private String getNonNullRelationName(JDBCRelationshipRoleMetaData left, JDBCRelationshipRoleMetaData right, String relationName)
/*     */   {
/* 764 */     if (relationName == null)
/*     */     {
/* 767 */       relationName = left.getEntity().getName() + (!left.isNavigable() ? "" : new StringBuilder().append("_").append(left.getCMRFieldName()).toString()) + "-" + right.getEntity().getName() + (!right.isNavigable() ? "" : new StringBuilder().append("_").append(right.getCMRFieldName()).toString());
/*     */     }
/*     */ 
/* 773 */     return relationName;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationMetaData
 * JD-Core Version:    0.6.0
 */