/*     */ package org.jboss.ejb.plugins.cmp.jdbc.metadata;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCQueryManager;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.jboss.metadata.QueryMetaData;
/*     */ import org.jboss.util.Classes;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class JDBCQueryMetaDataFactory
/*     */ {
/*  50 */   private static final Logger log = Logger.getLogger(JDBCQueryMetaDataFactory.class);
/*     */   private JDBCEntityMetaData entity;
/*     */ 
/*     */   public JDBCQueryMetaDataFactory(JDBCEntityMetaData entity)
/*     */   {
/*  56 */     this.entity = entity;
/*     */   }
/*     */ 
/*     */   public Map createJDBCQueryMetaData(QueryMetaData queryData)
/*     */     throws DeploymentException
/*     */   {
/*  63 */     Method[] methods = getQueryMethods(queryData);
/*  64 */     Map queries = new HashMap(methods.length);
/*  65 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/*  67 */       queries.put(methods[i], new JDBCQlQueryMetaData(queryData, methods[i], this.entity.getQLCompiler(), false));
/*     */     }
/*     */ 
/*  72 */     return queries;
/*     */   }
/*     */ 
/*     */   public Map createJDBCQueryMetaData(Element queryElement, Map defaultValues, JDBCReadAheadMetaData readAhead)
/*     */     throws DeploymentException
/*     */   {
/*  81 */     Method[] methods = getQueryMethods(queryElement);
/*     */ 
/*  84 */     Element readAheadElement = MetaData.getOptionalChild(queryElement, "read-ahead");
/*     */ 
/*  86 */     if (readAheadElement != null)
/*     */     {
/*  88 */       readAhead = new JDBCReadAheadMetaData(readAheadElement, readAhead);
/*     */     }
/*     */ 
/*  91 */     Map queries = new HashMap(methods.length);
/*  92 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/*  94 */       JDBCQueryMetaData defaultValue = (JDBCQueryMetaData)defaultValues.get(methods[i]);
/*     */ 
/*  97 */       if ((defaultValue == null) && (!this.entity.isCMP1x()) && (!methods[i].getName().equals("findByPrimaryKey")))
/*     */       {
/* 100 */         log.warn("The query method is not defined in ejb-jar.xml: " + methods[i]);
/*     */       }
/*     */ 
/* 103 */       JDBCQueryMetaData jdbcQueryData = createJDBCQueryMetaData(defaultValue, queryElement, methods[i], readAhead);
/*     */ 
/* 110 */       queries.put(methods[i], jdbcQueryData);
/*     */     }
/* 112 */     return queries;
/*     */   }
/*     */ 
/*     */   public static JDBCQueryMetaData createJDBCQueryMetaData(JDBCQueryMetaData jdbcQueryMetaData, JDBCReadAheadMetaData readAhead, Class qlCompiler)
/*     */     throws DeploymentException
/*     */   {
/* 122 */     if ((jdbcQueryMetaData instanceof JDBCRawSqlQueryMetaData))
/*     */     {
/* 124 */       return new JDBCRawSqlQueryMetaData(jdbcQueryMetaData.getMethod(), qlCompiler, false);
/*     */     }
/*     */ 
/* 128 */     if ((jdbcQueryMetaData instanceof JDBCJBossQLQueryMetaData))
/*     */     {
/* 130 */       return new JDBCJBossQLQueryMetaData((JDBCJBossQLQueryMetaData)jdbcQueryMetaData, readAhead, qlCompiler, false);
/*     */     }
/*     */ 
/* 137 */     if ((jdbcQueryMetaData instanceof JDBCDynamicQLQueryMetaData))
/*     */     {
/* 139 */       return new JDBCDynamicQLQueryMetaData((JDBCDynamicQLQueryMetaData)jdbcQueryMetaData, readAhead, qlCompiler, false);
/*     */     }
/*     */ 
/* 146 */     if ((jdbcQueryMetaData instanceof JDBCDeclaredQueryMetaData))
/*     */     {
/* 148 */       return new JDBCDeclaredQueryMetaData((JDBCDeclaredQueryMetaData)jdbcQueryMetaData, readAhead, qlCompiler, false);
/*     */     }
/*     */ 
/* 155 */     if ((jdbcQueryMetaData instanceof JDBCQlQueryMetaData))
/*     */     {
/* 157 */       return new JDBCQlQueryMetaData((JDBCQlQueryMetaData)jdbcQueryMetaData, readAhead, qlCompiler, false);
/*     */     }
/*     */ 
/* 163 */     throw new DeploymentException("Error in query specification for method " + jdbcQueryMetaData.getMethod().getName());
/*     */   }
/*     */ 
/*     */   private JDBCQueryMetaData createJDBCQueryMetaData(JDBCQueryMetaData jdbcQueryMetaData, Element queryElement, Method method, JDBCReadAheadMetaData readAhead)
/*     */     throws DeploymentException
/*     */   {
/* 176 */     Class qlCompiler = JDBCQueryManager.getQLCompiler(queryElement, this.entity);
/* 177 */     boolean isResultTypeMappingLocal = jdbcQueryMetaData == null ? false : jdbcQueryMetaData.isResultTypeMappingLocal();
/*     */ 
/* 180 */     boolean lazyResultSetLoading = (Collection.class.isAssignableFrom(method.getReturnType())) && (MetaData.getOptionalChildBooleanContent(queryElement, "lazy-resultset-loading"));
/*     */ 
/* 184 */     Element rawSql = MetaData.getOptionalChild(queryElement, "raw-sql");
/* 185 */     if (rawSql != null)
/*     */     {
/* 187 */       return new JDBCRawSqlQueryMetaData(method, qlCompiler, lazyResultSetLoading);
/*     */     }
/*     */ 
/* 191 */     Element jbossQL = MetaData.getOptionalChild(queryElement, "jboss-ql");
/*     */ 
/* 193 */     if (jbossQL != null)
/*     */     {
/* 195 */       return new JDBCJBossQLQueryMetaData(isResultTypeMappingLocal, jbossQL, method, readAhead, qlCompiler, lazyResultSetLoading);
/*     */     }
/*     */ 
/* 206 */     Element dynamicQL = MetaData.getOptionalChild(queryElement, "dynamic-ql");
/* 207 */     if (dynamicQL != null)
/*     */     {
/* 209 */       return new JDBCDynamicQLQueryMetaData(isResultTypeMappingLocal, method, readAhead, qlCompiler, lazyResultSetLoading);
/*     */     }
/*     */ 
/* 213 */     Element delcaredSql = MetaData.getOptionalChild(queryElement, "declared-sql");
/* 214 */     if (delcaredSql != null)
/*     */     {
/* 216 */       return new JDBCDeclaredQueryMetaData(isResultTypeMappingLocal, delcaredSql, method, readAhead, qlCompiler, lazyResultSetLoading);
/*     */     }
/*     */ 
/* 227 */     if ((jdbcQueryMetaData instanceof JDBCQlQueryMetaData))
/*     */     {
/* 229 */       return new JDBCQlQueryMetaData((JDBCQlQueryMetaData)jdbcQueryMetaData, method, readAhead);
/*     */     }
/*     */ 
/* 236 */     throw new DeploymentException("Error in query specification for method " + method.getName());
/*     */   }
/*     */ 
/*     */   private Method[] getQueryMethods(Element queryElement)
/*     */     throws DeploymentException
/*     */   {
/* 243 */     Element queryMethod = MetaData.getUniqueChild(queryElement, "query-method");
/*     */ 
/* 246 */     String methodName = MetaData.getUniqueChildContent(queryMethod, "method-name");
/*     */ 
/* 250 */     ArrayList methodParams = new ArrayList();
/* 251 */     Element methodParamsElement = MetaData.getUniqueChild(queryMethod, "method-params");
/*     */ 
/* 253 */     Iterator iterator = MetaData.getChildrenByTagName(methodParamsElement, "method-param");
/*     */ 
/* 255 */     while (iterator.hasNext())
/*     */     {
/* 257 */       methodParams.add(MetaData.getElementContent((Element)iterator.next()));
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 262 */       Class[] parameters = Classes.convertToJavaClasses(methodParams.iterator(), this.entity.getClassLoader());
/*     */ 
/* 264 */       return getQueryMethods(methodName, parameters);
/*     */     }
/*     */     catch (ClassNotFoundException cnfe) {
/*     */     }
/* 268 */     throw new DeploymentException(cnfe.getMessage());
/*     */   }
/*     */ 
/*     */   private Method[] getQueryMethods(QueryMetaData queryData)
/*     */     throws DeploymentException
/*     */   {
/* 276 */     String methodName = queryData.getMethodName();
/*     */     try
/*     */     {
/* 280 */       Class[] parameters = Classes.convertToJavaClasses(queryData.getMethodParams(), this.entity.getClassLoader());
/*     */ 
/* 282 */       return getQueryMethods(methodName, parameters);
/*     */     }
/*     */     catch (ClassNotFoundException cnfe) {
/*     */     }
/* 286 */     throw new DeploymentException(cnfe.getMessage());
/*     */   }
/*     */ 
/*     */   private Method[] getQueryMethods(String methodName, Class[] parameters)
/*     */     throws DeploymentException
/*     */   {
/* 295 */     ArrayList methods = new ArrayList(2);
/* 296 */     if (methodName.startsWith("ejbSelect"))
/*     */     {
/* 299 */       Method method = getQueryMethod(methodName, parameters, this.entity.getEntityClass());
/* 300 */       if (method != null)
/*     */       {
/* 302 */         methods.add(method);
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 308 */       Class homeClass = this.entity.getHomeClass();
/* 309 */       if (homeClass != null)
/*     */       {
/* 311 */         Method method = getQueryMethod(methodName, parameters, homeClass);
/* 312 */         if (method != null)
/*     */         {
/* 314 */           methods.add(method);
/*     */         }
/*     */       }
/*     */ 
/* 318 */       Class localHomeClass = this.entity.getLocalHomeClass();
/* 319 */       if (localHomeClass != null)
/*     */       {
/* 321 */         Method method = getQueryMethod(methodName, parameters, localHomeClass);
/* 322 */         if (method != null)
/*     */         {
/* 324 */           methods.add(method);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 329 */     if (methods.size() == 0)
/*     */     {
/* 331 */       StringBuffer sb = new StringBuffer(300);
/* 332 */       sb.append("Query method not found: ").append(methodName).append('(');
/*     */ 
/* 334 */       for (int i = 0; i < parameters.length; i++)
/*     */       {
/* 336 */         if (i > 0)
/*     */         {
/* 338 */           sb.append(',');
/*     */         }
/* 340 */         sb.append(parameters[i].getName());
/*     */       }
/* 342 */       sb.append(')');
/* 343 */       throw new DeploymentException(sb.toString());
/*     */     }
/* 345 */     return (Method[])(Method[])methods.toArray(new Method[methods.size()]);
/*     */   }
/*     */ 
/*     */   private static Method getQueryMethod(String queryName, Class[] parameters, Class clazz)
/*     */   {
/*     */     try
/*     */     {
/* 355 */       Method method = clazz.getMethod(queryName, parameters);
/*     */ 
/* 359 */       if (Modifier.isAbstract(method.getModifiers()))
/*     */       {
/* 361 */         return method;
/*     */       }
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*     */     }
/*     */ 
/* 368 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaDataFactory
 * JD-Core Version:    0.6.0
 */