/*     */ package org.jboss.ejb.plugins.cmp.jdbc.metadata;
/*     */ 
/*     */ import java.util.Date;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public final class JDBCOptimisticLockingMetaData
/*     */ {
/*  38 */   public static final Integer FIELD_GROUP_STRATEGY = new Integer(1);
/*  39 */   public static final Integer MODIFIED_STRATEGY = new Integer(2);
/*  40 */   public static final Integer READ_STRATEGY = new Integer(4);
/*  41 */   public static final Integer VERSION_COLUMN_STRATEGY = new Integer(8);
/*  42 */   public static final Integer TIMESTAMP_COLUMN_STRATEGY = new Integer(16);
/*  43 */   public static final Integer KEYGENERATOR_COLUMN_STRATEGY = new Integer(32);
/*     */   private final Integer lockingStrategy;
/*     */   private final String groupName;
/*     */   private final JDBCCMPFieldMetaData lockingField;
/*     */   private final String keyGeneratorFactory;
/*     */   private final Logger log;
/*     */ 
/*     */   public JDBCOptimisticLockingMetaData(JDBCEntityMetaData entityMetaData, Element element)
/*     */     throws DeploymentException
/*     */   {
/*  70 */     this.log = Logger.getLogger(entityMetaData.getName());
/*     */     Element strategyEl;
/*  73 */     if ((strategyEl = MetaData.getOptionalChild(element, "group-name")) != null)
/*     */     {
/*  75 */       this.lockingStrategy = FIELD_GROUP_STRATEGY;
/*  76 */       this.groupName = MetaData.getElementContent(strategyEl);
/*  77 */       this.lockingField = null;
/*  78 */       this.keyGeneratorFactory = null;
/*     */ 
/*  80 */       this.log.debug("optimistic locking: group=" + this.groupName);
/*     */     }
/*  82 */     else if ((strategyEl = MetaData.getOptionalChild(element, "modified-strategy")) != null)
/*     */     {
/*  84 */       this.lockingStrategy = MODIFIED_STRATEGY;
/*  85 */       this.groupName = null;
/*  86 */       this.lockingField = null;
/*  87 */       this.keyGeneratorFactory = null;
/*     */ 
/*  89 */       this.log.debug("optimistic locking: modified strategy");
/*     */     }
/*  91 */     else if ((strategyEl = MetaData.getOptionalChild(element, "read-strategy")) != null)
/*     */     {
/*  93 */       this.lockingStrategy = READ_STRATEGY;
/*  94 */       this.groupName = null;
/*  95 */       this.lockingField = null;
/*  96 */       this.keyGeneratorFactory = null;
/*     */ 
/*  98 */       this.log.debug("optimistic locking: read strategy");
/*     */     }
/* 100 */     else if ((strategyEl = MetaData.getOptionalChild(element, "version-column")) != null)
/*     */     {
/* 102 */       String fieldType = MetaData.getOptionalChildContent(element, "field-type");
/* 103 */       if (fieldType != null) {
/* 104 */         throw new DeploymentException("field-type is not allowed for version column. It is implicitly set to java.lang.Long.");
/*     */       }
/*     */ 
/* 108 */       this.lockingStrategy = VERSION_COLUMN_STRATEGY;
/* 109 */       this.lockingField = constructLockingField(entityMetaData, element);
/* 110 */       this.groupName = null;
/* 111 */       this.keyGeneratorFactory = null;
/*     */ 
/* 113 */       this.log.debug("optimistic locking: version-column=" + this.lockingField.getFieldName());
/*     */     }
/* 115 */     else if ((strategyEl = MetaData.getOptionalChild(element, "timestamp-column")) != null)
/*     */     {
/* 117 */       String fieldType = MetaData.getOptionalChildContent(element, "field-type");
/* 118 */       if (fieldType != null) {
/* 119 */         throw new DeploymentException("field-type is not allowed for timestamp column. It is implicitly set to java.util.Date.");
/*     */       }
/*     */ 
/* 123 */       this.lockingStrategy = TIMESTAMP_COLUMN_STRATEGY;
/* 124 */       this.lockingField = constructLockingField(entityMetaData, element);
/* 125 */       this.groupName = null;
/* 126 */       this.keyGeneratorFactory = null;
/*     */ 
/* 128 */       this.log.debug("optimistic locking: timestamp-column=" + this.lockingField.getFieldName());
/*     */     }
/* 130 */     else if ((this.keyGeneratorFactory = MetaData.getOptionalChildContent(element, "key-generator-factory")) != null)
/*     */     {
/* 133 */       this.lockingStrategy = KEYGENERATOR_COLUMN_STRATEGY;
/* 134 */       this.lockingField = constructLockingField(entityMetaData, element);
/* 135 */       this.groupName = null;
/*     */ 
/* 137 */       this.log.debug("optimistic locking: key-generator-factory=" + this.keyGeneratorFactory);
/*     */     }
/*     */     else
/*     */     {
/* 141 */       throw new DeploymentException("Unexpected error: entity " + entityMetaData.getName() + " has unkown/incorrect optimistic locking configuration.");
/*     */     }
/*     */   }
/*     */ 
/*     */   public Integer getLockingStrategy()
/*     */   {
/* 150 */     return this.lockingStrategy;
/*     */   }
/*     */ 
/*     */   public String getGroupName()
/*     */   {
/* 155 */     return this.groupName;
/*     */   }
/*     */ 
/*     */   public JDBCCMPFieldMetaData getLockingField()
/*     */   {
/* 160 */     return this.lockingField;
/*     */   }
/*     */ 
/*     */   public String getKeyGeneratorFactory()
/*     */   {
/* 165 */     return this.keyGeneratorFactory;
/*     */   }
/*     */ 
/*     */   private JDBCCMPFieldMetaData constructLockingField(JDBCEntityMetaData entity, Element element)
/*     */     throws DeploymentException
/*     */   {
/* 179 */     String fieldName = MetaData.getOptionalChildContent(element, "field-name");
/* 180 */     if ((fieldName == null) || (fieldName.trim().length() < 1)) {
/* 181 */       fieldName = this.lockingStrategy == TIMESTAMP_COLUMN_STRATEGY ? "timestamp_lock" : this.lockingStrategy == VERSION_COLUMN_STRATEGY ? "version_lock" : "generated_lock";
/*     */     }
/*     */ 
/* 185 */     String columnName = MetaData.getOptionalChildContent(element, "column-name");
/* 186 */     if ((columnName == null) || (columnName.trim().length() < 1)) {
/* 187 */       columnName = this.lockingStrategy == TIMESTAMP_COLUMN_STRATEGY ? "timestamp_lock" : this.lockingStrategy == VERSION_COLUMN_STRATEGY ? "version_lock" : "generated_lock";
/*     */     }
/*     */ 
/* 191 */     Class fieldType = null;
/* 192 */     if (this.lockingStrategy == VERSION_COLUMN_STRATEGY)
/* 193 */       fieldType = Long.class;
/* 194 */     else if (this.lockingStrategy == TIMESTAMP_COLUMN_STRATEGY)
/* 195 */       fieldType = Date.class;
/* 196 */     String fieldTypeStr = MetaData.getOptionalChildContent(element, "field-type");
/* 197 */     if (fieldTypeStr != null)
/*     */     {
/*     */       try
/*     */       {
/* 201 */         fieldType = GetTCLAction.getContextClassLoader().loadClass(fieldTypeStr);
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/* 206 */         throw new DeploymentException("Could not load field type for optimistic locking field " + fieldName + ": " + fieldTypeStr);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 215 */     String jdbcTypeName = MetaData.getOptionalChildContent(element, "jdbc-type");
/*     */     String sqlType;
/*     */     int jdbcType;
/*     */     String sqlType;
/* 216 */     if (jdbcTypeName != null)
/*     */     {
/* 218 */       int jdbcType = JDBCMappingMetaData.getJdbcTypeFromName(jdbcTypeName);
/* 219 */       sqlType = MetaData.getUniqueChildContent(element, "sql-type");
/*     */     }
/*     */     else
/*     */     {
/* 223 */       jdbcType = -2147483648;
/* 224 */       sqlType = null;
/*     */     }
/*     */ 
/* 227 */     return new JDBCCMPFieldMetaData(entity, fieldName, fieldType, columnName, jdbcType, sqlType);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCOptimisticLockingMetaData
 * JD-Core Version:    0.6.0
 */