/*     */ package org.jboss.ejb.plugins.cmp.jdbc.metadata;
/*     */ 
/*     */ import java.util.Date;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public final class JDBCAuditMetaData
/*     */ {
/*     */   private final JDBCCMPFieldMetaData createdPrincipalField;
/*     */   private final JDBCCMPFieldMetaData createdTimeField;
/*     */   private final JDBCCMPFieldMetaData updatedPrincipalField;
/*     */   private final JDBCCMPFieldMetaData updatedTimeField;
/*     */   private final Logger log;
/*     */ 
/*     */   public JDBCAuditMetaData(JDBCEntityMetaData entityMetaData, Element element)
/*     */     throws DeploymentException
/*     */   {
/*  65 */     this.log = Logger.getLogger(entityMetaData.getName());
/*     */     Element workElement;
/*  69 */     if ((workElement = MetaData.getOptionalChild(element, "created-by")) != null)
/*     */     {
/*  71 */       this.createdPrincipalField = constructAuditField(entityMetaData, workElement, "audit_created_by");
/*     */ 
/*  73 */       this.log.debug("created-by: " + this.createdPrincipalField);
/*     */     }
/*     */     else {
/*  76 */       this.createdPrincipalField = null;
/*     */     }
/*  78 */     if ((workElement = MetaData.getOptionalChild(element, "created-time")) != null)
/*     */     {
/*  80 */       this.createdTimeField = constructAuditField(entityMetaData, workElement, "audit_created_time");
/*     */ 
/*  82 */       this.log.debug("created-time: " + this.createdTimeField);
/*     */     }
/*     */     else {
/*  85 */       this.createdTimeField = null;
/*     */     }
/*  87 */     if ((workElement = MetaData.getOptionalChild(element, "updated-by")) != null)
/*     */     {
/*  89 */       this.updatedPrincipalField = constructAuditField(entityMetaData, workElement, "audit_updated_by");
/*     */ 
/*  91 */       this.log.debug("updated-by: " + this.updatedPrincipalField);
/*     */     }
/*     */     else {
/*  94 */       this.updatedPrincipalField = null;
/*     */     }
/*  96 */     if ((workElement = MetaData.getOptionalChild(element, "updated-time")) != null)
/*     */     {
/*  98 */       this.updatedTimeField = constructAuditField(entityMetaData, workElement, "audit_updated_time");
/*     */ 
/* 100 */       this.log.debug("updated-time: " + this.updatedTimeField);
/*     */     }
/*     */     else {
/* 103 */       this.updatedTimeField = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public JDBCCMPFieldMetaData getCreatedPrincipalField()
/*     */   {
/* 110 */     return this.createdPrincipalField;
/*     */   }
/*     */ 
/*     */   public JDBCCMPFieldMetaData getCreatedTimeField()
/*     */   {
/* 115 */     return this.createdTimeField;
/*     */   }
/*     */ 
/*     */   public JDBCCMPFieldMetaData getUpdatedPrincipalField()
/*     */   {
/* 120 */     return this.updatedPrincipalField;
/*     */   }
/*     */ 
/*     */   public JDBCCMPFieldMetaData getUpdatedTimeField()
/*     */   {
/* 125 */     return this.updatedTimeField;
/*     */   }
/*     */ 
/*     */   private static JDBCCMPFieldMetaData constructAuditField(JDBCEntityMetaData entity, Element element, String defaultName)
/*     */     throws DeploymentException
/*     */   {
/* 141 */     String fieldName = MetaData.getOptionalChildContent(element, "field-name");
/* 142 */     if ((fieldName == null) || (fieldName.trim().length() < 1)) {
/* 143 */       fieldName = defaultName;
/*     */     }
/*     */ 
/* 146 */     String columnName = MetaData.getOptionalChildContent(element, "column-name");
/* 147 */     if ((columnName == null) || (columnName.trim().length() < 1)) {
/* 148 */       columnName = defaultName;
/*     */     }
/*     */ 
/* 152 */     String fieldTypeStr = MetaData.getOptionalChildContent(element, "field-type");
/*     */     Class fieldType;
/*     */     Class fieldType;
/* 153 */     if (fieldTypeStr != null)
/*     */     {
/*     */       try
/*     */       {
/* 157 */         fieldType = GetTCLAction.getContextClassLoader().loadClass(fieldTypeStr);
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/* 161 */         throw new DeploymentException("Could not load field type for audit field " + fieldName + ": " + fieldTypeStr);
/*     */       }
/*     */ 
/*     */     }
/* 168 */     else if (defaultName.endsWith("by"))
/* 169 */       fieldType = String.class;
/*     */     else {
/* 171 */       fieldType = Date.class;
/*     */     }
/*     */ 
/* 177 */     String jdbcTypeName = MetaData.getOptionalChildContent(element, "jdbc-type");
/*     */     String sqlType;
/*     */     int jdbcType;
/*     */     String sqlType;
/* 178 */     if (jdbcTypeName != null)
/*     */     {
/* 180 */       int jdbcType = JDBCMappingMetaData.getJdbcTypeFromName(jdbcTypeName);
/* 181 */       sqlType = MetaData.getUniqueChildContent(element, "sql-type");
/*     */     }
/*     */     else
/*     */     {
/* 185 */       jdbcType = -2147483648;
/* 186 */       sqlType = null;
/*     */     }
/*     */ 
/* 190 */     JDBCCMPFieldMetaData result = entity.getCMPFieldByName(fieldName);
/*     */ 
/* 192 */     if (result == null) {
/* 193 */       result = new JDBCCMPFieldMetaData(entity, fieldName, fieldType, columnName, jdbcType, sqlType);
/*     */     }
/* 195 */     return result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCAuditMetaData
 * JD-Core Version:    0.6.0
 */