/*    */ package org.jboss.ejb.plugins.cmp.jdbc.keygen;
/*    */ 
/*    */ import java.sql.Connection;
/*    */ import java.sql.PreparedStatement;
/*    */ import java.sql.ResultSet;
/*    */ import java.sql.SQLException;
/*    */ import java.sql.Statement;
/*    */ import javax.ejb.EJBException;
/*    */ import org.jboss.deployment.DeploymentException;
/*    */ import org.jboss.ejb.EntityEnterpriseContext;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCIdentityColumnCreateCommand;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class JDBCPostgreSQLCreateCommand extends JDBCIdentityColumnCreateCommand
/*    */ {
/*    */   private String sequence;
/*    */   private String sequenceSQL;
/*    */ 
/*    */   public void init(JDBCStoreManager manager)
/*    */     throws DeploymentException
/*    */   {
/* 53 */     super.init(manager);
/*    */   }
/*    */ 
/*    */   protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) throws DeploymentException
/*    */   {
/* 58 */     super.initEntityCommand(entityCommand);
/* 59 */     this.sequence = entityCommand.getAttribute("sequence");
/* 60 */     if (this.sequence == null) {
/* 61 */       this.sequence = (this.entity.getQualifiedTableName() + '_' + SQLUtil.getColumnNamesClause(this.pkField, new StringBuffer(20)) + "_seq");
/*    */     }
/*    */ 
/* 65 */     this.sequenceSQL = ("SELECT currval('" + this.sequence + "')");
/* 66 */     if (this.debug)
/* 67 */       this.log.debug("SEQUENCE SQL is :" + this.sequenceSQL);
/*    */   }
/*    */ 
/*    */   protected int executeInsert(int index, PreparedStatement ps, EntityEnterpriseContext ctx)
/*    */     throws SQLException
/*    */   {
/* 73 */     int rows = ps.executeUpdate();
/*    */ 
/* 75 */     Statement s = null;
/* 76 */     ResultSet rs = null;
/*    */     try {
/* 78 */       if (this.trace) {
/* 79 */         this.log.trace("Executing SQL :" + this.sequenceSQL);
/*    */       }
/* 81 */       Connection c = ps.getConnection();
/* 82 */       s = c.createStatement();
/* 83 */       rs = s.executeQuery(this.sequenceSQL);
/* 84 */       if (!rs.next()) {
/* 85 */         throw new EJBException("sequence sql returned an empty ResultSet");
/*    */       }
/* 87 */       this.pkField.loadInstanceResults(rs, 1, ctx);
/*    */     } catch (RuntimeException e) {
/* 89 */       throw e;
/*    */     }
/*    */     catch (Exception e) {
/* 92 */       throw new EJBException("Error extracting generated keys", e);
/*    */     } finally {
/* 94 */       JDBCUtil.safeClose(rs);
/* 95 */       JDBCUtil.safeClose(s);
/*    */     }
/*    */ 
/* 98 */     return rows;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.keygen.JDBCPostgreSQLCreateCommand
 * JD-Core Version:    0.6.0
 */