/*     */ package org.jboss.ejb.plugins.cmp.jdbc.bridge;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.ConcurrentModificationException;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.EJBLocalObject;
/*     */ import javax.ejb.NoSuchObjectLocalException;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.LocalProxyFactory;
/*     */ 
/*     */ public class RelationSet
/*     */   implements Set
/*     */ {
/*     */   private JDBCCMRFieldBridge cmrField;
/*     */   private EntityEnterpriseContext ctx;
/*     */   private List[] setHandle;
/*     */   private boolean readOnly;
/*     */   private Class relatedLocalInterface;
/*     */ 
/*     */   public RelationSet(JDBCCMRFieldBridge cmrField, EntityEnterpriseContext ctx, List[] setHandle, boolean readOnly)
/*     */   {
/*  70 */     this.cmrField = cmrField;
/*  71 */     this.ctx = ctx;
/*  72 */     this.setHandle = setHandle;
/*  73 */     this.readOnly = readOnly;
/*  74 */     this.relatedLocalInterface = cmrField.getRelatedLocalInterface();
/*     */   }
/*     */ 
/*     */   private List getIdList()
/*     */   {
/*  79 */     if (this.setHandle[0] == null)
/*     */     {
/*  81 */       throw new IllegalStateException("A CMR collection may only be used within the transction in which it was created");
/*     */     }
/*     */ 
/*  84 */     return this.setHandle[0];
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/*  89 */     List idList = getIdList();
/*  90 */     return idList.size();
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/*  95 */     List idList = getIdList();
/*  96 */     return idList.isEmpty();
/*     */   }
/*     */ 
/*     */   public boolean add(Object o)
/*     */   {
/* 101 */     if (o == null)
/*     */     {
/* 103 */       throw new IllegalArgumentException("Null cannot be added to a CMR relationship collection");
/*     */     }
/*     */ 
/* 107 */     checkForPKChange();
/*     */ 
/* 109 */     List idList = getIdList();
/* 110 */     if (this.readOnly)
/*     */     {
/* 112 */       throw new EJBException("This collection is a read-only snapshot");
/*     */     }
/*     */ 
/* 115 */     if (this.cmrField.isReadOnly())
/*     */     {
/* 117 */       throw new EJBException("Field is read-only: " + this.cmrField.getFieldName());
/*     */     }
/*     */ 
/* 121 */     if (!this.relatedLocalInterface.isInstance(o))
/*     */     {
/* 123 */       String msg = "Object must be an instance of " + this.relatedLocalInterface.getName() + ", but is an isntance of [";
/*     */ 
/* 125 */       Class[] classes = o.getClass().getInterfaces();
/* 126 */       for (int i = 0; i < classes.length; i++)
/*     */       {
/* 128 */         if (i > 0) msg = msg + ", ";
/* 129 */         msg = msg + classes[i].getName();
/*     */       }
/* 131 */       msg = msg + "]";
/* 132 */       throw new IllegalArgumentException(msg);
/*     */     }
/*     */ 
/* 135 */     Object id = getPrimaryKey((EJBLocalObject)o);
/* 136 */     if (idList.contains(id))
/*     */     {
/* 138 */       return false;
/*     */     }
/* 140 */     this.cmrField.createRelationLinks(this.ctx, id);
/* 141 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean addAll(Collection c)
/*     */   {
/* 146 */     if (this.readOnly)
/*     */     {
/* 148 */       throw new EJBException("This collection is a read-only snapshot");
/*     */     }
/* 150 */     if (this.cmrField.isReadOnly())
/*     */     {
/* 152 */       throw new EJBException("Field is read-only: " + this.cmrField.getFieldName());
/*     */     }
/*     */ 
/* 156 */     if (c == null)
/*     */     {
/* 158 */       return false;
/*     */     }
/*     */ 
/* 161 */     boolean isModified = false;
/*     */ 
/* 163 */     Iterator iterator = new HashSet(c).iterator();
/* 164 */     while (iterator.hasNext())
/*     */     {
/* 166 */       isModified = (add(iterator.next())) || (isModified);
/*     */     }
/* 168 */     return isModified;
/*     */   }
/*     */ 
/*     */   public boolean remove(Object o)
/*     */   {
/* 173 */     List idList = getIdList();
/* 174 */     if (this.readOnly)
/*     */     {
/* 176 */       throw new EJBException("This collection is a read-only snapshot");
/*     */     }
/* 178 */     if (this.cmrField.isReadOnly())
/*     */     {
/* 180 */       throw new EJBException("Field is read-only: " + this.cmrField.getFieldName());
/*     */     }
/*     */ 
/* 184 */     checkForPKChange();
/*     */ 
/* 186 */     if (!this.relatedLocalInterface.isInstance(o))
/*     */     {
/* 188 */       throw new IllegalArgumentException("Object must be an instance of " + this.relatedLocalInterface.getName());
/*     */     }
/*     */ 
/* 192 */     Object id = getPrimaryKey((EJBLocalObject)o);
/* 193 */     if (!idList.contains(id))
/*     */     {
/* 195 */       return false;
/*     */     }
/* 197 */     this.cmrField.destroyRelationLinks(this.ctx, id);
/* 198 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean removeAll(Collection c)
/*     */   {
/* 203 */     if (this.readOnly)
/*     */     {
/* 205 */       throw new EJBException("This collection is a read-only snapshot");
/*     */     }
/* 207 */     if (this.cmrField.isReadOnly())
/*     */     {
/* 209 */       throw new EJBException("Field is read-only: " + this.cmrField.getFieldName());
/*     */     }
/*     */ 
/* 213 */     if (c == null)
/*     */     {
/* 215 */       return false;
/*     */     }
/*     */ 
/* 218 */     boolean isModified = false;
/*     */ 
/* 220 */     Iterator iterator = new HashSet(c).iterator();
/* 221 */     while (iterator.hasNext())
/*     */     {
/* 223 */       isModified = (remove(iterator.next())) || (isModified);
/*     */     }
/* 225 */     return isModified;
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 230 */     checkForPKChange();
/*     */ 
/* 232 */     List idList = getIdList();
/* 233 */     if (this.readOnly)
/*     */     {
/* 235 */       throw new EJBException("This collection is a read-only snapshot");
/*     */     }
/* 237 */     if (this.cmrField.isReadOnly())
/*     */     {
/* 239 */       throw new EJBException("Field is read-only: " + this.cmrField.getFieldName());
/*     */     }
/*     */ 
/* 243 */     Iterator iterator = new ArrayList(idList).iterator();
/* 244 */     while (iterator.hasNext())
/*     */     {
/* 246 */       this.cmrField.destroyRelationLinks(this.ctx, iterator.next());
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean retainAll(Collection c)
/*     */   {
/* 252 */     List idList = getIdList();
/* 253 */     if (this.readOnly)
/*     */     {
/* 255 */       throw new EJBException("This collection is a read-only snapshot");
/*     */     }
/* 257 */     if (this.cmrField.isReadOnly())
/*     */     {
/* 259 */       throw new EJBException("Field is read-only: " + this.cmrField.getFieldName());
/*     */     }
/*     */ 
/* 263 */     checkForPKChange();
/*     */ 
/* 265 */     if (c == null)
/*     */     {
/* 267 */       if (idList.size() == 0)
/*     */       {
/* 269 */         return false;
/*     */       }
/* 271 */       clear();
/* 272 */       return true;
/*     */     }
/*     */ 
/* 276 */     List argIds = new ArrayList();
/* 277 */     Iterator iterator = c.iterator();
/* 278 */     while (iterator.hasNext())
/*     */     {
/* 280 */       EJBLocalObject localObject = (EJBLocalObject)iterator.next();
/* 281 */       Object relatedId = getPrimaryKey(localObject);
/* 282 */       argIds.add(relatedId);
/*     */     }
/*     */ 
/* 285 */     boolean isModified = false;
/*     */ 
/* 287 */     iterator = new ArrayList(idList).iterator();
/* 288 */     while (iterator.hasNext())
/*     */     {
/* 290 */       Object id = iterator.next();
/* 291 */       if (!argIds.contains(id))
/*     */       {
/* 293 */         this.cmrField.destroyRelationLinks(this.ctx, id);
/* 294 */         isModified = true;
/*     */       }
/*     */     }
/* 297 */     return isModified;
/*     */   }
/*     */ 
/*     */   public boolean contains(Object o)
/*     */   {
/* 302 */     List idList = getIdList();
/*     */ 
/* 304 */     if (!this.relatedLocalInterface.isInstance(o))
/*     */     {
/* 306 */       throw new IllegalArgumentException("Object must be an instance of " + this.relatedLocalInterface.getName());
/*     */     }
/*     */ 
/* 310 */     Object id = getPrimaryKey((EJBLocalObject)o);
/* 311 */     return idList.contains(id);
/*     */   }
/*     */ 
/*     */   public boolean containsAll(Collection c)
/*     */   {
/* 316 */     List idList = getIdList();
/*     */ 
/* 318 */     if (c == null)
/*     */     {
/* 320 */       return true;
/*     */     }
/*     */ 
/* 324 */     List argIds = new ArrayList();
/* 325 */     Iterator iterator = c.iterator();
/* 326 */     while (iterator.hasNext())
/*     */     {
/* 328 */       EJBLocalObject localObject = (EJBLocalObject)iterator.next();
/* 329 */       Object relatedId = getPrimaryKey(localObject);
/* 330 */       argIds.add(relatedId);
/*     */     }
/*     */ 
/* 333 */     return idList.containsAll(argIds);
/*     */   }
/*     */ 
/*     */   public Object[] toArray(Object[] a)
/*     */   {
/* 338 */     List idList = getIdList();
/*     */ 
/* 340 */     Collection c = this.cmrField.getRelatedInvoker().getEntityLocalCollection(idList);
/* 341 */     return c.toArray(a);
/*     */   }
/*     */ 
/*     */   public Object[] toArray()
/*     */   {
/* 346 */     List idList = getIdList();
/* 347 */     Collection c = this.cmrField.getRelatedInvoker().getEntityLocalCollection(idList);
/* 348 */     return c.toArray();
/*     */   }
/*     */ 
/*     */   private static void checkForPKChange()
/*     */   {
/*     */   }
/*     */ 
/*     */   public Iterator iterator()
/*     */   {
/* 372 */     return new Iterator() {
/* 374 */       private final Iterator idIterator = RelationSet.this.getIdList().iterator();
/* 375 */       private final LocalProxyFactory localFactory = RelationSet.this.cmrField.getRelatedInvoker();
/*     */       private Object currentId;
/*     */ 
/* 380 */       public boolean hasNext() { verifyIteratorIsValid();
/*     */         try
/*     */         {
/* 384 */           return this.idIterator.hasNext();
/*     */         }
/*     */         catch (ConcurrentModificationException e) {
/*     */         }
/* 388 */         throw new IllegalStateException("Underlying collection has been modified");
/*     */       }
/*     */ 
/*     */       public Object next()
/*     */       {
/* 395 */         verifyIteratorIsValid();
/*     */         try
/*     */         {
/* 399 */           this.currentId = this.idIterator.next();
/* 400 */           return this.localFactory.getEntityEJBLocalObject(this.currentId);
/*     */         }
/*     */         catch (ConcurrentModificationException e) {
/*     */         }
/* 404 */         throw new IllegalStateException("Underlying collection has been modified");
/*     */       }
/*     */ 
/*     */       public void remove()
/*     */       {
/* 411 */         verifyIteratorIsValid();
/* 412 */         if (RelationSet.this.readOnly)
/*     */         {
/* 414 */           throw new EJBException("This collection is a read-only snapshot");
/*     */         }
/* 416 */         if (RelationSet.this.cmrField.isReadOnly())
/*     */         {
/* 418 */           throw new EJBException("Field is read-only: " + RelationSet.this.cmrField.getFieldName());
/*     */         }
/*     */ 
/* 422 */         RelationSet.access$300();
/*     */         try
/*     */         {
/* 426 */           this.idIterator.remove();
/* 427 */           RelationSet.this.cmrField.destroyRelationLinks(RelationSet.this.ctx, this.currentId, false);
/*     */         }
/*     */         catch (ConcurrentModificationException e)
/*     */         {
/* 431 */           throw new IllegalStateException("Underlying collection has been modified");
/*     */         }
/*     */       }
/*     */ 
/*     */       private void verifyIteratorIsValid()
/*     */       {
/* 437 */         if (RelationSet.this.setHandle[0] == null)
/*     */         {
/* 439 */           throw new IllegalStateException("The iterator of a CMR collection may only be used within the transction in which it was created");
/*     */         }
/*     */       }
/*     */     };
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 449 */     return '[' + this.cmrField.getEntity().getEntityName() + '.' + this.cmrField.getFieldName() + ':' + getIdList() + ']';
/*     */   }
/*     */ 
/*     */   private Object getPrimaryKey(EJBLocalObject o)
/*     */   {
/*     */     try
/*     */     {
/* 463 */       return o.getPrimaryKey();
/*     */     }
/*     */     catch (NoSuchObjectLocalException e) {
/*     */     }
/* 467 */     throw new IllegalArgumentException(e.getMessage());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.bridge.RelationSet
 * JD-Core Version:    0.6.0
 */