/*      */ package org.jboss.ejb.plugins.cmp.jdbc.bridge;
/*      */ 
/*      */ import java.lang.reflect.Method;
/*      */ import java.rmi.RemoteException;
/*      */ import java.sql.PreparedStatement;
/*      */ import java.sql.ResultSet;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Arrays;
/*      */ import java.util.Collection;
/*      */ import java.util.Collections;
/*      */ import java.util.HashMap;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.NoSuchElementException;
/*      */ import java.util.Set;
/*      */ import javax.ejb.EJBException;
/*      */ import javax.ejb.RemoveException;
/*      */ import javax.naming.InitialContext;
/*      */ import javax.naming.NamingException;
/*      */ import javax.sql.DataSource;
/*      */ import org.jboss.deployment.DeploymentException;
/*      */ import org.jboss.ejb.EntityEnterpriseContext;
/*      */ import org.jboss.ejb.plugins.cmp.bridge.EntityBridgeInvocationHandler;
/*      */ import org.jboss.ejb.plugins.cmp.bridge.FieldBridge;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCContext;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCEntityPersistenceStore;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCTypeFactory;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.LockingStrategy;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCAuditMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCOptimisticLockingMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCReadAheadMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationshipRoleMetaData;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.proxy.compiler.InvocationHandler;
/*      */ import org.jboss.proxy.compiler.Proxies.ProxyTarget;
/*      */ 
/*      */ public class JDBCEntityBridge
/*      */   implements JDBCAbstractEntityBridge
/*      */ {
/*      */   public static final byte LOADED = 1;
/*      */   public static final byte LOAD_REQUIRED = 2;
/*      */   public static final byte DIRTY = 4;
/*      */   public static final byte CHECK_DIRTY = 8;
/*      */   public static final byte LOCKED = 16;
/*      */   public static final byte ADD_TO_SET_ON_UPDATE = 32;
/*      */   public static final byte ADD_TO_WHERE_ON_UPDATE = 64;
/*      */   private static final String DEFAULT_LOADGROUP_NAME = "*";
/*      */   private JDBCEntityMetaData metadata;
/*      */   private JDBCStoreManager manager;
/*      */   private DataSource dataSource;
/*      */   private String qualifiedTableName;
/*      */   private String tableName;
/*      */   private final String primaryKeyFieldName;
/*      */   private final Class primaryKeyClass;
/*      */   private JDBCCMPFieldBridge[] primaryKeyFields;
/*      */   private JDBCCMPFieldBridge[] cmpFields;
/*      */   private JDBCCMRFieldBridge[] cmrFields;
/*      */   private JDBCCMPFieldBridge[] tableFields;
/*      */   private JDBCCMPFieldBridge versionField;
/*      */   private JDBCCMPFieldBridge createdPrincipalField;
/*      */   private JDBCCMPFieldBridge createdTimeField;
/*      */   private JDBCCMPFieldBridge updatedPrincipalField;
/*      */   private JDBCCMPFieldBridge updatedTimeField;
/*      */   private Map selectorsByMethod;
/*      */   private Map loadGroupMasks;
/*      */   private List lazyLoadGroupMasks;
/*      */   private boolean[] eagerLoadGroupMask;
/*      */   private boolean[] defaultLockGroupMask;
/*      */   private int jdbcContextSize;
/*      */   private final Logger log;
/* 1424 */   public static final FieldIterator EMPTY_FIELD_ITERATOR = new FieldIterator()
/*      */   {
/*      */     public boolean hasNext()
/*      */     {
/* 1428 */       return false;
/*      */     }
/*      */ 
/*      */     public JDBCCMPFieldBridge next()
/*      */     {
/* 1433 */       throw new NoSuchElementException();
/*      */     }
/*      */ 
/*      */     public void remove()
/*      */     {
/* 1438 */       throw new UnsupportedOperationException();
/*      */     }
/*      */ 
/*      */     public void removeAll()
/*      */     {
/* 1443 */       throw new UnsupportedOperationException();
/*      */     }
/*      */ 
/*      */     public void reset()
/*      */     {
/*      */     }
/* 1424 */   };
/*      */ 
/*      */   public JDBCEntityBridge(JDBCEntityMetaData metadata, JDBCStoreManager manager)
/*      */     throws DeploymentException
/*      */   {
/*  137 */     this.metadata = metadata;
/*  138 */     this.manager = manager;
/*  139 */     this.primaryKeyFieldName = metadata.getPrimaryKeyFieldName();
/*  140 */     this.primaryKeyClass = metadata.getPrimaryKeyClass();
/*  141 */     this.log = Logger.getLogger(getClass().getName() + "." + metadata.getName());
/*      */   }
/*      */ 
/*      */   public void init() throws DeploymentException
/*      */   {
/*      */     try
/*      */     {
/*  148 */       InitialContext ic = new InitialContext();
/*  149 */       this.dataSource = ((DataSource)ic.lookup(this.metadata.getDataSourceName()));
/*      */     }
/*      */     catch (NamingException e)
/*      */     {
/*  153 */       throw new DeploymentException("Error: can't find data source: " + this.metadata.getDataSourceName(), e);
/*      */     }
/*      */ 
/*  157 */     this.qualifiedTableName = SQLUtil.fixTableName(this.metadata.getDefaultTableName(), this.dataSource);
/*  158 */     int dotIndex = this.qualifiedTableName.indexOf('.');
/*  159 */     this.tableName = (dotIndex == -1 ? this.qualifiedTableName : this.qualifiedTableName.substring(dotIndex + 1));
/*      */ 
/*  162 */     loadCMPFields(this.metadata);
/*      */ 
/*  165 */     loadCMRFields(this.metadata);
/*      */ 
/*  168 */     JDBCOptimisticLockingMetaData lockMetaData = this.metadata.getOptimisticLocking();
/*  169 */     if ((lockMetaData != null) && (lockMetaData.getLockingField() != null))
/*      */     {
/*  171 */       Integer strategy = lockMetaData.getLockingStrategy();
/*  172 */       JDBCCMPFieldMetaData versionMD = lockMetaData.getLockingField();
/*      */ 
/*  174 */       this.versionField = getCMPFieldByName(versionMD.getFieldName());
/*  175 */       boolean hidden = this.versionField == null;
/*  176 */       if (strategy == JDBCOptimisticLockingMetaData.VERSION_COLUMN_STRATEGY)
/*      */       {
/*  178 */         if (hidden)
/*  179 */           this.versionField = new JDBCLongVersionFieldBridge(this.manager, versionMD);
/*      */         else
/*  181 */           this.versionField = new JDBCLongVersionFieldBridge((JDBCCMP2xFieldBridge)this.versionField);
/*      */       }
/*  183 */       else if (strategy == JDBCOptimisticLockingMetaData.TIMESTAMP_COLUMN_STRATEGY)
/*      */       {
/*  185 */         if (hidden)
/*  186 */           this.versionField = new JDBCTimestampVersionFieldBridge(this.manager, versionMD);
/*      */         else
/*  188 */           this.versionField = new JDBCTimestampVersionFieldBridge((JDBCCMP2xFieldBridge)this.versionField);
/*      */       }
/*  190 */       else if (strategy == JDBCOptimisticLockingMetaData.KEYGENERATOR_COLUMN_STRATEGY)
/*      */       {
/*  192 */         if (hidden) {
/*  193 */           this.versionField = new JDBCKeyGenVersionFieldBridge(this.manager, versionMD, lockMetaData.getKeyGeneratorFactory());
/*      */         }
/*      */         else {
/*  196 */           this.versionField = new JDBCKeyGenVersionFieldBridge((JDBCCMP2xFieldBridge)this.versionField, lockMetaData.getKeyGeneratorFactory());
/*      */         }
/*      */       }
/*      */ 
/*  200 */       if (hidden)
/*  201 */         addCMPField(this.versionField);
/*      */       else {
/*  203 */         this.tableFields[this.versionField.getTableIndex()] = this.versionField;
/*      */       }
/*      */     }
/*      */ 
/*  207 */     JDBCAuditMetaData auditMetaData = this.metadata.getAudit();
/*  208 */     if (auditMetaData != null)
/*      */     {
/*  210 */       JDBCCMPFieldMetaData auditField = auditMetaData.getCreatedPrincipalField();
/*  211 */       if (auditField != null)
/*      */       {
/*  213 */         this.createdPrincipalField = getCMPFieldByName(auditField.getFieldName());
/*  214 */         if (this.createdPrincipalField == null)
/*      */         {
/*  216 */           this.createdPrincipalField = new JDBCCMP2xFieldBridge(this.manager, auditField);
/*  217 */           addCMPField(this.createdPrincipalField);
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  222 */         this.createdPrincipalField = null;
/*      */       }
/*      */ 
/*  225 */       auditField = auditMetaData.getCreatedTimeField();
/*  226 */       if (auditField != null)
/*      */       {
/*  228 */         this.createdTimeField = getCMPFieldByName(auditField.getFieldName());
/*  229 */         if (this.createdTimeField == null)
/*      */         {
/*  231 */           this.createdTimeField = new JDBCCMP2xFieldBridge(this.manager, auditField, JDBCTypeFactory.EQUALS, false);
/*  232 */           addCMPField(this.createdTimeField);
/*      */         }
/*      */         else
/*      */         {
/*  237 */           this.createdTimeField = new JDBCCMP2xFieldBridge((JDBCCMP2xFieldBridge)this.createdTimeField, JDBCTypeFactory.EQUALS, false);
/*      */ 
/*  239 */           this.tableFields[this.createdTimeField.getTableIndex()] = this.createdTimeField;
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  244 */         this.createdTimeField = null;
/*      */       }
/*      */ 
/*  247 */       auditField = auditMetaData.getUpdatedPrincipalField();
/*  248 */       if (auditField != null)
/*      */       {
/*  250 */         this.updatedPrincipalField = getCMPFieldByName(auditField.getFieldName());
/*  251 */         if (this.updatedPrincipalField == null)
/*      */         {
/*  253 */           this.updatedPrincipalField = new JDBCCMP2xUpdatedPrincipalFieldBridge(this.manager, auditField);
/*  254 */           addCMPField(this.updatedPrincipalField);
/*      */         }
/*      */         else
/*      */         {
/*  258 */           this.updatedPrincipalField = new JDBCCMP2xUpdatedPrincipalFieldBridge((JDBCCMP2xFieldBridge)this.updatedPrincipalField);
/*      */ 
/*  260 */           this.tableFields[this.updatedPrincipalField.getTableIndex()] = this.updatedPrincipalField;
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  265 */         this.updatedPrincipalField = null;
/*      */       }
/*      */ 
/*  268 */       auditField = auditMetaData.getUpdatedTimeField();
/*  269 */       if (auditField != null)
/*      */       {
/*  271 */         this.updatedTimeField = getCMPFieldByName(auditField.getFieldName());
/*  272 */         if (this.updatedTimeField == null)
/*      */         {
/*  274 */           this.updatedTimeField = new JDBCCMP2xUpdatedTimeFieldBridge(this.manager, auditField);
/*  275 */           addCMPField(this.updatedTimeField);
/*      */         }
/*      */         else
/*      */         {
/*  279 */           this.updatedTimeField = new JDBCCMP2xUpdatedTimeFieldBridge((JDBCCMP2xFieldBridge)this.updatedTimeField);
/*  280 */           this.tableFields[this.updatedTimeField.getTableIndex()] = this.updatedTimeField;
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  285 */         this.updatedTimeField = null;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  290 */     loadSelectors(this.metadata);
/*      */   }
/*      */ 
/*      */   public void resolveRelationships() throws DeploymentException
/*      */   {
/*  295 */     for (int i = 0; i < this.cmrFields.length; i++) {
/*  296 */       this.cmrFields[i].resolveRelationship();
/*      */     }
/*      */ 
/*  300 */     loadLoadGroups(this.metadata);
/*  301 */     loadEagerLoadGroup(this.metadata);
/*  302 */     loadLazyLoadGroups(this.metadata);
/*      */   }
/*      */ 
/*      */   public void start()
/*      */     throws DeploymentException
/*      */   {
/*  311 */     for (int i = 0; i < this.cmrFields.length; i++)
/*      */     {
/*  313 */       this.cmrFields[i].start();
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean removeFromRelations(EntityEnterpriseContext ctx, Object[] oldRelations)
/*      */   {
/*  319 */     boolean removed = false;
/*  320 */     for (int i = 0; i < this.cmrFields.length; i++)
/*      */     {
/*  322 */       if (this.cmrFields[i].removeFromRelations(ctx, oldRelations))
/*  323 */         removed = true;
/*      */     }
/*  325 */     return removed;
/*      */   }
/*      */ 
/*      */   public void cascadeDelete(EntityEnterpriseContext ctx, Map oldRelations)
/*      */     throws RemoveException, RemoteException
/*      */   {
/*  331 */     for (int i = 0; i < this.cmrFields.length; i++)
/*      */     {
/*  333 */       JDBCCMRFieldBridge cmrField = this.cmrFields[i];
/*  334 */       Object value = oldRelations.get(cmrField);
/*  335 */       if (value != null)
/*  336 */         cmrField.cascadeDelete(ctx, (List)value);
/*      */     }
/*      */   }
/*      */ 
/*      */   public String getEntityName()
/*      */   {
/*  342 */     return this.metadata.getName();
/*      */   }
/*      */ 
/*      */   public String getAbstractSchemaName()
/*      */   {
/*  347 */     return this.metadata.getAbstractSchemaName();
/*      */   }
/*      */ 
/*      */   public Class getRemoteInterface()
/*      */   {
/*  352 */     return this.metadata.getRemoteClass();
/*      */   }
/*      */ 
/*      */   public Class getLocalInterface()
/*      */   {
/*  357 */     return this.metadata.getLocalClass();
/*      */   }
/*      */ 
/*      */   public JDBCEntityMetaData getMetaData()
/*      */   {
/*  362 */     return this.metadata;
/*      */   }
/*      */ 
/*      */   public JDBCEntityPersistenceStore getManager()
/*      */   {
/*  367 */     return this.manager;
/*      */   }
/*      */ 
/*      */   public DataSource getDataSource()
/*      */   {
/*  375 */     return this.dataSource;
/*      */   }
/*      */ 
/*      */   public String getTableName()
/*      */   {
/*  380 */     return this.tableName;
/*      */   }
/*      */ 
/*      */   public String getQualifiedTableName()
/*      */   {
/*  385 */     return this.qualifiedTableName;
/*      */   }
/*      */ 
/*      */   public Class getPrimaryKeyClass()
/*      */   {
/*  390 */     return this.primaryKeyClass;
/*      */   }
/*      */ 
/*      */   public int getListCacheMax()
/*      */   {
/*  395 */     return this.metadata.getListCacheMax();
/*      */   }
/*      */ 
/*      */   public int getFetchSize()
/*      */   {
/*  400 */     return this.metadata.getFetchSize();
/*      */   }
/*      */ 
/*      */   public Object createPrimaryKeyInstance()
/*      */   {
/*  405 */     if (this.primaryKeyFieldName == null)
/*      */     {
/*      */       try
/*      */       {
/*  409 */         return this.primaryKeyClass.newInstance();
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  413 */         throw new EJBException("Error creating primary key instance: ", e);
/*      */       }
/*      */     }
/*  416 */     return null;
/*      */   }
/*      */ 
/*      */   public JDBCFieldBridge[] getPrimaryKeyFields()
/*      */   {
/*  421 */     return this.primaryKeyFields;
/*      */   }
/*      */ 
/*      */   public List getFields()
/*      */   {
/*  430 */     int fieldsTotal = this.primaryKeyFields.length + this.cmpFields.length + this.cmrFields.length;
/*  431 */     JDBCFieldBridge[] fields = new JDBCFieldBridge[fieldsTotal];
/*  432 */     int position = 0;
/*      */ 
/*  434 */     System.arraycopy(this.primaryKeyFields, 0, fields, position, this.primaryKeyFields.length);
/*  435 */     position += this.primaryKeyFields.length;
/*      */ 
/*  437 */     System.arraycopy(this.cmpFields, 0, fields, position, this.cmpFields.length);
/*  438 */     position += this.cmpFields.length;
/*      */ 
/*  440 */     System.arraycopy(this.cmrFields, 0, fields, position, this.cmrFields.length);
/*  441 */     return Arrays.asList(fields);
/*      */   }
/*      */ 
/*      */   public FieldBridge getFieldByName(String name)
/*      */   {
/*  446 */     FieldBridge field = null;
/*  447 */     for (int i = 0; i < this.primaryKeyFields.length; i++)
/*      */     {
/*  449 */       JDBCCMPFieldBridge primaryKeyField = this.primaryKeyFields[i];
/*  450 */       if (!primaryKeyField.getFieldName().equals(name))
/*      */         continue;
/*  452 */       field = primaryKeyField;
/*  453 */       break;
/*      */     }
/*      */ 
/*  456 */     if (field == null)
/*      */     {
/*  458 */       field = getCMPFieldByName(name);
/*      */     }
/*  460 */     if (field == null)
/*      */     {
/*  462 */       field = getCMRFieldByName(name);
/*      */     }
/*  464 */     return field;
/*      */   }
/*      */ 
/*      */   public boolean[] getEagerLoadMask()
/*      */   {
/*  469 */     return this.eagerLoadGroupMask;
/*      */   }
/*      */ 
/*      */   public Iterator getLazyLoadGroupMasks()
/*      */   {
/*  474 */     return this.lazyLoadGroupMasks.iterator();
/*      */   }
/*      */ 
/*      */   public boolean[] getLoadGroupMask(String name)
/*      */   {
/*  479 */     boolean[] mask = (boolean[])(boolean[])this.loadGroupMasks.get(name);
/*  480 */     if (mask == null)
/*      */     {
/*  482 */       throw new IllegalStateException("Load group '" + name + "' is not defined. Defined load groups: " + this.loadGroupMasks.keySet());
/*      */     }
/*      */ 
/*  486 */     return mask;
/*      */   }
/*      */ 
/*      */   public FieldIterator getLoadIterator(JDBCCMPFieldBridge requiredField, JDBCReadAheadMetaData readahead, EntityEnterpriseContext ctx)
/*      */   {
/*      */     boolean[] loadGroup;
/*      */     boolean[] loadGroup;
/*      */     int requiredInd;
/*      */     Iterator groups;
/*  494 */     if (requiredField == null)
/*      */     {
/*      */       boolean[] loadGroup;
/*  496 */       if ((readahead != null) && (!readahead.isNone()))
/*      */       {
/*  498 */         if (this.log.isTraceEnabled())
/*      */         {
/*  500 */           this.log.trace("Eager-load for entity: readahead=" + readahead);
/*      */         }
/*  502 */         loadGroup = getLoadGroupMask(readahead.getEagerLoadGroup());
/*      */       }
/*      */       else
/*      */       {
/*  506 */         if (this.log.isTraceEnabled())
/*      */         {
/*  508 */           this.log.trace("Default eager-load for entity: readahead=" + readahead);
/*      */         }
/*  510 */         loadGroup = this.eagerLoadGroupMask;
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  515 */       loadGroup = new boolean[this.tableFields.length];
/*  516 */       requiredInd = requiredField.getTableIndex();
/*  517 */       loadGroup[requiredInd] = true;
/*  518 */       for (groups = this.lazyLoadGroupMasks.iterator(); groups.hasNext(); )
/*      */       {
/*  520 */         boolean[] lazyGroup = (boolean[])(boolean[])groups.next();
/*  521 */         if (lazyGroup[requiredInd] != 0)
/*      */         {
/*  523 */           for (int i = 0; i < loadGroup.length; i++)
/*  524 */             loadGroup[i] = ((loadGroup[i] != 0) || (lazyGroup[i] != 0) ? 1 : false);
/*      */         }
/*      */       }
/*      */     }
/*      */     FieldIterator loadIter;
/*      */     FieldIterator loadIter;
/*  530 */     if (loadGroup != null)
/*      */     {
/*  533 */       int fieldsToLoad = 0;
/*  534 */       EntityState entityState = getEntityState(ctx);
/*  535 */       for (int i = 0; i < this.tableFields.length; i++)
/*      */       {
/*  537 */         JDBCCMPFieldBridge field = this.tableFields[i];
/*  538 */         if ((loadGroup[i] == 0) || (field.isPrimaryKeyMember()) || (field.isLoaded(ctx)))
/*      */           continue;
/*  540 */         entityState.setLoadRequired(i);
/*  541 */         fieldsToLoad++;
/*      */       }
/*      */ 
/*  544 */       loadIter = fieldsToLoad > 0 ? entityState.getLoadIterator(ctx) : EMPTY_FIELD_ITERATOR;
/*      */     }
/*      */     else
/*      */     {
/*  548 */       loadIter = EMPTY_FIELD_ITERATOR;
/*      */     }
/*  550 */     return loadIter;
/*      */   }
/*      */ 
/*      */   public JDBCCMPFieldBridge getCMPFieldByName(String name)
/*      */   {
/*  559 */     for (int i = 0; i < this.primaryKeyFields.length; i++)
/*      */     {
/*  561 */       JDBCCMPFieldBridge cmpField = this.primaryKeyFields[i];
/*  562 */       if (cmpField.getFieldName().equals(name))
/*  563 */         return cmpField;
/*      */     }
/*  565 */     for (int i = 0; i < this.cmpFields.length; i++)
/*      */     {
/*  567 */       JDBCCMPFieldBridge cmpField = this.cmpFields[i];
/*  568 */       if (cmpField.getFieldName().equals(name))
/*  569 */         return cmpField;
/*      */     }
/*  571 */     return null;
/*      */   }
/*      */ 
/*      */   public JDBCAbstractCMRFieldBridge[] getCMRFields()
/*      */   {
/*  576 */     return this.cmrFields;
/*      */   }
/*      */ 
/*      */   public JDBCCMRFieldBridge getCMRFieldByName(String name)
/*      */   {
/*  581 */     for (int i = 0; i < this.cmrFields.length; i++)
/*      */     {
/*  583 */       JDBCCMRFieldBridge cmrField = this.cmrFields[i];
/*  584 */       if (cmrField.getFieldName().equals(name))
/*  585 */         return cmrField;
/*      */     }
/*  587 */     return null;
/*      */   }
/*      */ 
/*      */   public JDBCCMPFieldBridge getVersionField()
/*      */   {
/*  592 */     return this.versionField;
/*      */   }
/*      */ 
/*      */   public JDBCCMPFieldBridge getCreatedPrincipalField()
/*      */   {
/*  597 */     return this.createdPrincipalField;
/*      */   }
/*      */ 
/*      */   public JDBCCMPFieldBridge getCreatedTimeField()
/*      */   {
/*  602 */     return this.createdTimeField;
/*      */   }
/*      */ 
/*      */   public JDBCCMPFieldBridge getUpdatedPrincipalField()
/*      */   {
/*  607 */     return this.updatedPrincipalField;
/*      */   }
/*      */ 
/*      */   public JDBCCMPFieldBridge getUpdatedTimeField()
/*      */   {
/*  612 */     return this.updatedTimeField;
/*      */   }
/*      */ 
/*      */   public Collection getSelectors()
/*      */   {
/*  617 */     return this.selectorsByMethod.values();
/*      */   }
/*      */ 
/*      */   public void initInstance(EntityEnterpriseContext ctx)
/*      */   {
/*  622 */     for (int i = 0; i < this.tableFields.length; i++) {
/*  623 */       this.tableFields[i].initInstance(ctx);
/*      */     }
/*      */ 
/*  628 */     for (int i = 0; i < this.cmrFields.length; i++)
/*      */     {
/*  630 */       JDBCCMRFieldBridge cmrField = this.cmrFields[i];
/*  631 */       cmrField.initInstance(ctx);
/*      */     }
/*      */   }
/*      */ 
/*      */   public static boolean isEjbCreateDone(EntityEnterpriseContext ctx)
/*      */   {
/*  637 */     return getEntityState(ctx).ejbCreateDone;
/*      */   }
/*      */ 
/*      */   public static void setCreated(EntityEnterpriseContext ctx)
/*      */   {
/*  642 */     getEntityState(ctx).setCreated();
/*      */   }
/*      */ 
/*      */   public static void setEjbCreateDone(EntityEnterpriseContext ctx)
/*      */   {
/*  647 */     EntityState.access$002(getEntityState(ctx), true);
/*      */   }
/*      */ 
/*      */   public boolean isModified(EntityEnterpriseContext ctx)
/*      */   {
/*  659 */     boolean invalidateCache = false;
/*  660 */     EntityState entityState = getEntityState(ctx);
/*  661 */     if (entityState.isCreated())
/*      */     {
/*  663 */       invalidateCache = areCmpFieldsDirty(ctx, entityState);
/*  664 */       if (!invalidateCache)
/*      */       {
/*  666 */         for (int i = 0; i < this.cmrFields.length; i++)
/*      */         {
/*  668 */           if (!this.cmrFields[i].invalidateCache(ctx))
/*      */             continue;
/*  670 */           invalidateCache = true;
/*  671 */           break;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  676 */     return invalidateCache;
/*      */   }
/*      */ 
/*      */   public boolean isStoreRequired(EntityEnterpriseContext ctx)
/*      */   {
/*  681 */     boolean modified = false;
/*  682 */     EntityState entityState = getEntityState(ctx);
/*  683 */     if (entityState.isCreated())
/*      */     {
/*  685 */       modified = areCmpFieldsDirty(ctx, entityState);
/*  686 */       if (!modified)
/*      */       {
/*  688 */         for (int i = 0; i < this.cmrFields.length; i++)
/*      */         {
/*  690 */           if (!this.cmrFields[i].isDirty(ctx))
/*      */             continue;
/*  692 */           modified = true;
/*  693 */           break;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  698 */     return modified;
/*      */   }
/*      */ 
/*      */   private boolean areCmpFieldsDirty(EntityEnterpriseContext ctx, EntityState entityState)
/*      */   {
/*  704 */     for (int i = 0; i < this.tableFields.length; i++)
/*      */     {
/*  706 */       JDBCCMPFieldBridge field = this.tableFields[i];
/*  707 */       if ((entityState.isCheckDirty(i)) && (field.isDirty(ctx)))
/*      */       {
/*  709 */         return true;
/*      */       }
/*      */     }
/*  712 */     return false;
/*      */   }
/*      */ 
/*      */   public FieldIterator getDirtyIterator(EntityEnterpriseContext ctx)
/*      */   {
/*  717 */     int dirtyFields = 0;
/*  718 */     EntityState entityState = getEntityState(ctx);
/*  719 */     for (int i = 0; i < this.tableFields.length; i++)
/*      */     {
/*  721 */       JDBCCMPFieldBridge field = this.tableFields[i];
/*  722 */       if ((!entityState.isCheckDirty(i)) || (!field.isDirty(ctx)))
/*      */         continue;
/*  724 */       entityState.setUpdateRequired(i);
/*  725 */       dirtyFields++;
/*      */     }
/*      */ 
/*  729 */     return dirtyFields > 0 ? getEntityState(ctx).getDirtyIterator(ctx) : EMPTY_FIELD_ITERATOR;
/*      */   }
/*      */ 
/*      */   public boolean hasLockedFields(EntityEnterpriseContext ctx)
/*      */   {
/*  734 */     return getEntityState(ctx).hasLockedFields();
/*      */   }
/*      */ 
/*      */   public FieldIterator getLockedIterator(EntityEnterpriseContext ctx)
/*      */   {
/*  739 */     return getEntityState(ctx).getLockedIterator(ctx);
/*      */   }
/*      */ 
/*      */   public void initPersistenceContext(EntityEnterpriseContext ctx)
/*      */   {
/*  746 */     Object instance = ctx.getInstance();
/*  747 */     if ((instance instanceof Proxies.ProxyTarget))
/*      */     {
/*  749 */       InvocationHandler handler = ((Proxies.ProxyTarget)instance).getInvocationHandler();
/*  750 */       if ((handler instanceof EntityBridgeInvocationHandler))
/*  751 */         ((EntityBridgeInvocationHandler)handler).setContext(ctx);
/*      */     }
/*  753 */     ctx.setPersistenceContext(new JDBCContext(this.jdbcContextSize, new EntityState()));
/*      */   }
/*      */ 
/*      */   public void resetPersistenceContext(EntityEnterpriseContext ctx)
/*      */   {
/*  761 */     for (int i = 0; i < this.primaryKeyFields.length; i++)
/*  762 */       this.primaryKeyFields[i].resetPersistenceContext(ctx);
/*  763 */     for (int i = 0; i < this.cmpFields.length; i++)
/*  764 */       this.cmpFields[i].resetPersistenceContext(ctx);
/*  765 */     for (int i = 0; i < this.cmrFields.length; i++)
/*  766 */       this.cmrFields[i].resetPersistenceContext(ctx);
/*      */   }
/*      */ 
/*      */   public static void destroyPersistenceContext(EntityEnterpriseContext ctx)
/*      */   {
/*  774 */     Object instance = ctx.getInstance();
/*  775 */     if ((instance instanceof Proxies.ProxyTarget))
/*      */     {
/*  777 */       InvocationHandler handler = ((Proxies.ProxyTarget)instance).getInvocationHandler();
/*  778 */       if ((handler instanceof EntityBridgeInvocationHandler))
/*  779 */         ((EntityBridgeInvocationHandler)handler).setContext(null);
/*      */     }
/*  781 */     ctx.setPersistenceContext(null);
/*      */   }
/*      */ 
/*      */   public int setPrimaryKeyParameters(PreparedStatement ps, int parameterIndex, Object primaryKey)
/*      */   {
/*  790 */     for (int i = 0; i < this.primaryKeyFields.length; i++)
/*  791 */       parameterIndex = this.primaryKeyFields[i].setPrimaryKeyParameters(ps, parameterIndex, primaryKey);
/*  792 */     return parameterIndex;
/*      */   }
/*      */ 
/*      */   public int loadPrimaryKeyResults(ResultSet rs, int parameterIndex, Object[] pkRef)
/*      */   {
/*  797 */     pkRef[0] = createPrimaryKeyInstance();
/*  798 */     for (int i = 0; i < this.primaryKeyFields.length; i++)
/*  799 */       parameterIndex = this.primaryKeyFields[i].loadPrimaryKeyResults(rs, parameterIndex, pkRef);
/*  800 */     return parameterIndex;
/*      */   }
/*      */ 
/*      */   public Object extractPrimaryKeyFromInstance(EntityEnterpriseContext ctx)
/*      */   {
/*      */     try
/*      */     {
/*  807 */       Object pk = null;
/*  808 */       for (int i = 0; i < this.primaryKeyFields.length; i++)
/*      */       {
/*  810 */         JDBCCMPFieldBridge pkField = this.primaryKeyFields[i];
/*  811 */         Object fieldValue = pkField.getInstanceValue(ctx);
/*      */ 
/*  815 */         pk = pkField.setPrimaryKeyValue(pk, fieldValue);
/*      */       }
/*  817 */       return pk;
/*      */     }
/*      */     catch (EJBException e)
/*      */     {
/*  822 */       throw e;
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*      */     }
/*  827 */     throw new EJBException("Internal error extracting primary key from instance", e);
/*      */   }
/*      */ 
/*      */   public void injectPrimaryKeyIntoInstance(EntityEnterpriseContext ctx, Object pk)
/*      */   {
/*  834 */     for (int i = 0; i < this.primaryKeyFields.length; i++)
/*      */     {
/*  836 */       JDBCCMPFieldBridge pkField = this.primaryKeyFields[i];
/*  837 */       Object fieldValue = pkField.getPrimaryKeyValue(pk);
/*  838 */       pkField.setInstanceValue(ctx, fieldValue);
/*      */     }
/*      */   }
/*      */ 
/*      */   int getNextJDBCContextIndex()
/*      */   {
/*  844 */     return this.jdbcContextSize++;
/*      */   }
/*      */ 
/*      */   int addTableField(JDBCCMPFieldBridge field)
/*      */   {
/*  849 */     JDBCCMPFieldBridge[] tmpFields = this.tableFields;
/*  850 */     if (this.tableFields == null)
/*      */     {
/*  852 */       this.tableFields = new JDBCCMPFieldBridge[1];
/*      */     }
/*      */     else
/*      */     {
/*  856 */       this.tableFields = new JDBCCMPFieldBridge[this.tableFields.length + 1];
/*  857 */       System.arraycopy(tmpFields, 0, this.tableFields, 0, tmpFields.length);
/*      */     }
/*  859 */     int index = this.tableFields.length - 1;
/*  860 */     this.tableFields[index] = field;
/*      */ 
/*  862 */     return index;
/*      */   }
/*      */ 
/*      */   public JDBCFieldBridge[] getTableFields()
/*      */   {
/*  867 */     return this.tableFields;
/*      */   }
/*      */ 
/*      */   public void setRemoved(EntityEnterpriseContext ctx)
/*      */   {
/*  876 */     getEntityState(ctx).setRemoved();
/*      */   }
/*      */ 
/*      */   public boolean isRemoved(EntityEnterpriseContext ctx)
/*      */   {
/*  885 */     return getEntityState(ctx).isRemoved();
/*      */   }
/*      */ 
/*      */   public void setIsBeingRemoved(EntityEnterpriseContext ctx)
/*      */   {
/*  893 */     getEntityState(ctx).setIsBeingRemoved();
/*      */   }
/*      */ 
/*      */   public boolean isBeingRemoved(EntityEnterpriseContext ctx)
/*      */   {
/*  902 */     return getEntityState(ctx).isBeingRemoved();
/*      */   }
/*      */ 
/*      */   public void scheduleForCascadeDelete(EntityEnterpriseContext ctx)
/*      */   {
/*  911 */     getEntityState(ctx).scheduleForCascadeDelete();
/*  912 */     if (this.log.isTraceEnabled())
/*  913 */       this.log.trace("Scheduled for cascade-delete: " + ctx.getId());
/*      */   }
/*      */ 
/*      */   public boolean isScheduledForCascadeDelete(EntityEnterpriseContext ctx)
/*      */   {
/*  922 */     return getEntityState(ctx).isScheduledForCascadeDelete();
/*      */   }
/*      */ 
/*      */   public void scheduleForBatchCascadeDelete(EntityEnterpriseContext ctx)
/*      */   {
/*  931 */     getEntityState(ctx).scheduleForBatchCascadeDelete();
/*  932 */     if (this.log.isTraceEnabled())
/*  933 */       this.log.trace("Scheduled for batch-cascade-delete: " + ctx.getId());
/*      */   }
/*      */ 
/*      */   public boolean isScheduledForBatchCascadeDelete(EntityEnterpriseContext ctx)
/*      */   {
/*  942 */     return getEntityState(ctx).isScheduledForBatchCascadeDelete();
/*      */   }
/*      */ 
/*      */   private static EntityState getEntityState(EntityEnterpriseContext ctx)
/*      */   {
/*  947 */     JDBCContext jdbcCtx = (JDBCContext)ctx.getPersistenceContext();
/*  948 */     EntityState entityState = jdbcCtx.getEntityState();
/*  949 */     if (entityState == null)
/*  950 */       throw new IllegalStateException("Entity state is null.");
/*  951 */     return entityState;
/*      */   }
/*      */ 
/*      */   private void loadCMPFields(JDBCEntityMetaData metadata)
/*      */     throws DeploymentException
/*      */   {
/*  959 */     List cmpFieldsMD = metadata.getCMPFields();
/*  960 */     List cmpFieldsList = new ArrayList(cmpFieldsMD.size());
/*      */ 
/*  962 */     List pkFieldsList = new ArrayList(cmpFieldsMD.size());
/*      */ 
/*  965 */     for (int i = 0; i < cmpFieldsMD.size(); i++)
/*      */     {
/*  967 */       JDBCCMPFieldMetaData fieldMD = (JDBCCMPFieldMetaData)cmpFieldsMD.get(i);
/*  968 */       if (!fieldMD.isPrimaryKeyMember())
/*      */         continue;
/*  970 */       JDBCCMPFieldBridge cmpField = createCMPField(metadata, fieldMD);
/*  971 */       pkFieldsList.add(cmpField);
/*      */     }
/*      */ 
/*  976 */     for (int i = 0; i < cmpFieldsMD.size(); i++)
/*      */     {
/*  978 */       JDBCCMPFieldMetaData fieldMD = (JDBCCMPFieldMetaData)cmpFieldsMD.get(i);
/*  979 */       if (fieldMD.isPrimaryKeyMember())
/*      */         continue;
/*  981 */       JDBCCMPFieldBridge cmpField = createCMPField(metadata, fieldMD);
/*  982 */       cmpFieldsList.add(cmpField);
/*      */     }
/*      */ 
/*  987 */     this.primaryKeyFields = new JDBCCMPFieldBridge[pkFieldsList.size()];
/*  988 */     for (int i = 0; i < pkFieldsList.size(); i++) {
/*  989 */       this.primaryKeyFields[i] = ((JDBCCMPFieldBridge)pkFieldsList.get(i));
/*      */     }
/*      */ 
/*  992 */     this.cmpFields = new JDBCCMPFieldBridge[cmpFieldsMD.size() - this.primaryKeyFields.length];
/*  993 */     int cmpFieldIndex = 0;
/*  994 */     for (int i = 0; i < cmpFieldsList.size(); i++)
/*  995 */       this.cmpFields[(cmpFieldIndex++)] = ((JDBCCMPFieldBridge)cmpFieldsList.get(i));
/*      */   }
/*      */ 
/*      */   private void loadCMRFields(JDBCEntityMetaData metadata)
/*      */     throws DeploymentException
/*      */   {
/* 1001 */     this.cmrFields = new JDBCCMRFieldBridge[metadata.getRelationshipRoles().size()];
/*      */ 
/* 1003 */     int cmrFieldIndex = 0;
/* 1004 */     for (Iterator iter = metadata.getRelationshipRoles().iterator(); iter.hasNext(); )
/*      */     {
/* 1006 */       JDBCRelationshipRoleMetaData relationshipRole = (JDBCRelationshipRoleMetaData)iter.next();
/* 1007 */       JDBCCMRFieldBridge cmrField = new JDBCCMRFieldBridge(this, this.manager, relationshipRole);
/* 1008 */       this.cmrFields[(cmrFieldIndex++)] = cmrField;
/*      */     }
/*      */   }
/*      */ 
/*      */   private void loadLoadGroups(JDBCEntityMetaData metadata)
/*      */     throws DeploymentException
/*      */   {
/* 1015 */     this.loadGroupMasks = new HashMap();
/*      */ 
/* 1018 */     JDBCOptimisticLockingMetaData olMD = metadata.getOptimisticLocking();
/* 1019 */     if (olMD != null)
/*      */     {
/* 1021 */       if (this.versionField != null)
/*      */       {
/* 1023 */         this.defaultLockGroupMask = new boolean[this.tableFields.length];
/* 1024 */         this.defaultLockGroupMask[this.versionField.getTableIndex()] = true;
/* 1025 */         this.versionField.setLockingStrategy(LockingStrategy.VERSION);
/*      */       }
/* 1027 */       else if (olMD.getGroupName() != null)
/*      */       {
/* 1029 */         this.defaultLockGroupMask = loadGroupMask(olMD.getGroupName(), null);
/* 1030 */         for (int i = 0; i < this.tableFields.length; i++)
/*      */         {
/* 1032 */           if (this.defaultLockGroupMask[i] == 0)
/*      */             continue;
/* 1034 */           JDBCCMPFieldBridge tableField = this.tableFields[i];
/* 1035 */           tableField.setLockingStrategy(LockingStrategy.GROUP);
/* 1036 */           tableField.addDefaultFlag(64);
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/* 1042 */         LockingStrategy strategy = olMD.getLockingStrategy() == JDBCOptimisticLockingMetaData.READ_STRATEGY ? LockingStrategy.READ : LockingStrategy.MODIFIED;
/*      */ 
/* 1046 */         for (int i = 0; i < this.tableFields.length; i++)
/*      */         {
/* 1048 */           JDBCCMPFieldBridge field = this.tableFields[i];
/* 1049 */           if (!field.isPrimaryKeyMember()) {
/* 1050 */             field.setLockingStrategy(strategy);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1056 */     boolean[] defaultLoadGroup = new boolean[this.tableFields.length];
/* 1057 */     Arrays.fill(defaultLoadGroup, true);
/* 1058 */     for (int i = 0; i < this.primaryKeyFields.length; i++)
/*      */     {
/* 1060 */       int tableIndex = this.primaryKeyFields[i].getTableIndex();
/* 1061 */       defaultLoadGroup[tableIndex] = false;
/*      */     }
/* 1063 */     this.loadGroupMasks.put("*", defaultLoadGroup);
/*      */ 
/* 1066 */     Iterator groupNames = metadata.getLoadGroups().keySet().iterator();
/* 1067 */     while (groupNames.hasNext())
/*      */     {
/* 1070 */       String groupName = (String)groupNames.next();
/* 1071 */       boolean[] loadGroup = loadGroupMask(groupName, this.defaultLockGroupMask);
/* 1072 */       this.loadGroupMasks.put(groupName, loadGroup);
/*      */     }
/* 1074 */     this.loadGroupMasks = Collections.unmodifiableMap(this.loadGroupMasks);
/*      */   }
/*      */ 
/*      */   private boolean[] loadGroupMask(String groupName, boolean[] defaultGroup)
/*      */     throws DeploymentException
/*      */   {
/* 1080 */     List fieldNames = this.metadata.getLoadGroup(groupName);
/* 1081 */     boolean[] group = new boolean[this.tableFields.length];
/* 1082 */     if (defaultGroup != null)
/* 1083 */       System.arraycopy(defaultGroup, 0, group, 0, group.length);
/* 1084 */     for (Iterator iter = fieldNames.iterator(); iter.hasNext(); )
/*      */     {
/* 1086 */       String fieldName = (String)iter.next();
/* 1087 */       JDBCFieldBridge field = (JDBCFieldBridge)getFieldByName(fieldName);
/* 1088 */       if (field == null) {
/* 1089 */         throw new DeploymentException("Field " + fieldName + " not found for entity " + getEntityName());
/*      */       }
/*      */ 
/* 1092 */       if ((field instanceof JDBCCMRFieldBridge))
/*      */       {
/* 1094 */         JDBCCMRFieldBridge cmrField = (JDBCCMRFieldBridge)field;
/* 1095 */         if (cmrField.hasForeignKey())
/*      */         {
/* 1097 */           JDBCCMPFieldBridge[] fkFields = (JDBCCMPFieldBridge[])(JDBCCMPFieldBridge[])cmrField.getForeignKeyFields();
/* 1098 */           for (int i = 0; i < fkFields.length; i++)
/*      */           {
/* 1100 */             group[fkFields[i].getTableIndex()] = true;
/*      */           }
/*      */         }
/*      */         else
/*      */         {
/* 1105 */           throw new DeploymentException("Only CMR fields that have a foreign-key may be a member of a load group: fieldName=" + fieldName);
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/* 1112 */         group[((JDBCCMPFieldBridge)field).getTableIndex()] = true;
/*      */       }
/*      */     }
/* 1115 */     return group;
/*      */   }
/*      */ 
/*      */   private void loadEagerLoadGroup(JDBCEntityMetaData metadata)
/*      */   {
/* 1120 */     String eagerLoadGroupName = metadata.getEagerLoadGroup();
/* 1121 */     if (eagerLoadGroupName == null)
/*      */     {
/* 1124 */       this.eagerLoadGroupMask = this.defaultLockGroupMask;
/*      */     }
/*      */     else
/* 1127 */       this.eagerLoadGroupMask = ((boolean[])(boolean[])this.loadGroupMasks.get(eagerLoadGroupName));
/*      */   }
/*      */ 
/*      */   private void loadLazyLoadGroups(JDBCEntityMetaData metadata)
/*      */   {
/* 1132 */     List lazyGroupNames = metadata.getLazyLoadGroups();
/* 1133 */     this.lazyLoadGroupMasks = new ArrayList(lazyGroupNames.size());
/* 1134 */     for (Iterator lazyLoadGroupNames = lazyGroupNames.iterator(); lazyLoadGroupNames.hasNext(); )
/*      */     {
/* 1136 */       String lazyLoadGroupName = (String)lazyLoadGroupNames.next();
/* 1137 */       this.lazyLoadGroupMasks.add(this.loadGroupMasks.get(lazyLoadGroupName));
/*      */     }
/* 1139 */     this.lazyLoadGroupMasks = Collections.unmodifiableList(this.lazyLoadGroupMasks);
/*      */   }
/*      */ 
/*      */   private JDBCCMPFieldBridge createCMPField(JDBCEntityMetaData metadata, JDBCCMPFieldMetaData cmpFieldMetaData)
/*      */     throws DeploymentException
/*      */   {
/*      */     JDBCCMPFieldBridge cmpField;
/*      */     JDBCCMPFieldBridge cmpField;
/* 1147 */     if (metadata.isCMP1x())
/* 1148 */       cmpField = new JDBCCMP1xFieldBridge(this.manager, cmpFieldMetaData);
/*      */     else
/* 1150 */       cmpField = new JDBCCMP2xFieldBridge(this.manager, cmpFieldMetaData);
/* 1151 */     return cmpField;
/*      */   }
/*      */ 
/*      */   private void loadSelectors(JDBCEntityMetaData metadata)
/*      */   {
/* 1159 */     this.selectorsByMethod = new HashMap(metadata.getQueries().size());
/* 1160 */     Iterator definedFinders = this.manager.getMetaData().getQueries().iterator();
/* 1161 */     while (definedFinders.hasNext())
/*      */     {
/* 1163 */       JDBCQueryMetaData q = (JDBCQueryMetaData)definedFinders.next();
/* 1164 */       if (q.getMethod().getName().startsWith("ejbSelect"))
/* 1165 */         this.selectorsByMethod.put(q.getMethod(), new JDBCSelectorBridge(this.manager, q));
/*      */     }
/* 1167 */     this.selectorsByMethod = Collections.unmodifiableMap(this.selectorsByMethod);
/*      */   }
/*      */ 
/*      */   private void addCMPField(JDBCCMPFieldBridge field)
/*      */   {
/* 1172 */     JDBCCMPFieldBridge[] tmpCMPFields = this.cmpFields;
/* 1173 */     this.cmpFields = new JDBCCMPFieldBridge[this.cmpFields.length + 1];
/* 1174 */     System.arraycopy(tmpCMPFields, 0, this.cmpFields, 0, tmpCMPFields.length);
/* 1175 */     this.cmpFields[tmpCMPFields.length] = field;
/*      */   }
/*      */ 
/*      */   public static abstract interface FieldIterator
/*      */   {
/*      */     public abstract boolean hasNext();
/*      */ 
/*      */     public abstract JDBCCMPFieldBridge next();
/*      */ 
/*      */     public abstract void remove();
/*      */ 
/*      */     public abstract void removeAll();
/*      */ 
/*      */     public abstract void reset();
/*      */   }
/*      */ 
/*      */   public class EntityState
/*      */   {
/*      */     private static final byte REMOVED = 1;
/*      */     private static final byte SCHEDULED_FOR_CASCADE_DELETE = 2;
/*      */     private static final byte SCHEDULED_FOR_BATCH_CASCADE_DELETE = 4;
/*      */     private static final byte IS_BEING_REMOVED = 8;
/* 1186 */     private boolean ejbCreateDone = false;
/*      */ 
/* 1188 */     private boolean ejbPostCreateDone = false;
/*      */     private byte entityFlags;
/* 1193 */     private final byte[] fieldFlags = new byte[JDBCEntityBridge.this.tableFields.length];
/*      */ 
/*      */     public EntityState()
/*      */     {
/* 1197 */       for (int i = 0; i < JDBCEntityBridge.this.tableFields.length; i++)
/*      */       {
/* 1199 */         this.fieldFlags[i] = JDBCEntityBridge.access$100(JDBCEntityBridge.this)[i].getDefaultFlags();
/*      */       }
/*      */     }
/*      */ 
/*      */     public void setRemoved()
/*      */     {
/* 1205 */       this.entityFlags = (byte)(this.entityFlags | 0x1);
/* 1206 */       this.entityFlags = (byte)(this.entityFlags & 0xFFFFFFF1);
/*      */     }
/*      */ 
/*      */     public boolean isRemoved()
/*      */     {
/* 1211 */       return (this.entityFlags & 0x1) > 0;
/*      */     }
/*      */ 
/*      */     public void setIsBeingRemoved()
/*      */     {
/* 1216 */       this.entityFlags = (byte)(this.entityFlags | 0x8);
/*      */     }
/*      */ 
/*      */     public boolean isBeingRemoved()
/*      */     {
/* 1221 */       return (this.entityFlags & 0x8) > 0;
/*      */     }
/*      */ 
/*      */     public void scheduleForCascadeDelete()
/*      */     {
/* 1226 */       this.entityFlags = (byte)(this.entityFlags | 0x2);
/*      */     }
/*      */ 
/*      */     public boolean isScheduledForCascadeDelete()
/*      */     {
/* 1231 */       return (this.entityFlags & 0x2) > 0;
/*      */     }
/*      */ 
/*      */     public void scheduleForBatchCascadeDelete()
/*      */     {
/* 1236 */       this.entityFlags = (byte)(this.entityFlags | 0x6);
/*      */     }
/*      */ 
/*      */     public boolean isScheduledForBatchCascadeDelete()
/*      */     {
/* 1241 */       return (this.entityFlags & 0x4) > 0;
/*      */     }
/*      */ 
/*      */     public void setCreated()
/*      */     {
/* 1246 */       this.ejbCreateDone = true;
/* 1247 */       this.ejbPostCreateDone = true;
/*      */     }
/*      */ 
/*      */     public boolean isCreated()
/*      */     {
/* 1252 */       return (this.ejbCreateDone) && (this.ejbPostCreateDone);
/*      */     }
/*      */ 
/*      */     public boolean isLoaded(int fieldIndex)
/*      */     {
/* 1261 */       return (this.fieldFlags[fieldIndex] & 0x1) > 0;
/*      */     }
/*      */ 
/*      */     public void setLoaded(int fieldIndex)
/*      */     {
/*      */       int tmp5_4 = fieldIndex;
/*      */       byte[] tmp5_1 = this.fieldFlags; tmp5_1[tmp5_4] = (byte)(tmp5_1[tmp5_4] | 0x1);
/*      */     }
/*      */ 
/*      */     public void setLoadRequired(int fieldIndex)
/*      */     {
/*      */       int tmp5_4 = fieldIndex;
/*      */       byte[] tmp5_1 = this.fieldFlags; tmp5_1[tmp5_4] = (byte)(tmp5_1[tmp5_4] | 0x2);
/*      */     }
/*      */ 
/*      */     public void setUpdateRequired(int fieldIndex)
/*      */     {
/*      */       int tmp5_4 = fieldIndex;
/*      */       byte[] tmp5_1 = this.fieldFlags; tmp5_1[tmp5_4] = (byte)(tmp5_1[tmp5_4] | 0x4);
/*      */     }
/*      */ 
/*      */     public void setCheckDirty(int fieldIndex)
/*      */     {
/*      */       int tmp5_4 = fieldIndex;
/*      */       byte[] tmp5_1 = this.fieldFlags; tmp5_1[tmp5_4] = (byte)(tmp5_1[tmp5_4] | 0x8);
/*      */     }
/*      */ 
/*      */     public boolean isCheckDirty(int fieldIndex)
/*      */     {
/* 1306 */       return (this.fieldFlags[fieldIndex] & 0x8) > 0;
/*      */     }
/*      */ 
/*      */     public void setClean(int fieldIndex)
/*      */     {
/*      */       int tmp5_4 = fieldIndex;
/*      */       byte[] tmp5_1 = this.fieldFlags; tmp5_1[tmp5_4] = (byte)(tmp5_1[tmp5_4] & 0xFFFFFFE3);
/*      */     }
/*      */ 
/*      */     public void resetFlags(int fieldIndex)
/*      */     {
/* 1324 */       this.fieldFlags[fieldIndex] = JDBCEntityBridge.access$100(JDBCEntityBridge.this)[fieldIndex].getDefaultFlags();
/*      */     }
/*      */ 
/*      */     public JDBCEntityBridge.FieldIterator getDirtyIterator(EntityEnterpriseContext ctx)
/*      */     {
/* 1329 */       return new MaskFieldIterator(36);
/*      */     }
/*      */ 
/*      */     public boolean hasLockedFields()
/*      */     {
/* 1334 */       boolean result = false;
/* 1335 */       for (int i = 0; i < this.fieldFlags.length; i++)
/*      */       {
/* 1337 */         if ((this.fieldFlags[i] & 0x50) <= 0)
/*      */           continue;
/* 1339 */         result = true;
/* 1340 */         break;
/*      */       }
/*      */ 
/* 1343 */       return result;
/*      */     }
/*      */ 
/*      */     public JDBCEntityBridge.FieldIterator getLockedIterator(EntityEnterpriseContext ctx)
/*      */     {
/* 1348 */       return new MaskFieldIterator(80);
/*      */     }
/*      */ 
/*      */     public boolean lockValue(int fieldIndex)
/*      */     {
/* 1353 */       boolean lock = false;
/* 1354 */       byte fieldFlag = this.fieldFlags[fieldIndex];
/* 1355 */       if (((fieldFlag & 0x1) > 0) && ((fieldFlag & 0x10) == 0))
/*      */       {
/*      */         int tmp27_26 = fieldIndex;
/*      */         byte[] tmp27_23 = this.fieldFlags; tmp27_23[tmp27_26] = (byte)(tmp27_23[tmp27_26] | 0x10);
/* 1358 */         lock = true;
/*      */       }
/* 1360 */       return lock;
/*      */     }
/*      */ 
/*      */     public JDBCEntityBridge.FieldIterator getLoadIterator(EntityEnterpriseContext ctx)
/*      */     {
/* 1365 */       return new MaskFieldIterator(2);
/*      */     }
/*      */ 
/*      */     private class MaskFieldIterator
/*      */       implements JDBCEntityBridge.FieldIterator
/*      */     {
/*      */       private final byte flagMask;
/* 1373 */       private int nextIndex = 0;
/* 1374 */       private int curIndex = -1;
/*      */ 
/*      */       public MaskFieldIterator(byte flagMask)
/*      */       {
/* 1378 */         this.flagMask = flagMask;
/*      */       }
/*      */ 
/*      */       public boolean hasNext()
/*      */       {
/* 1383 */         while (this.nextIndex < JDBCEntityBridge.EntityState.this.fieldFlags.length)
/*      */         {
/* 1385 */           if ((JDBCEntityBridge.EntityState.this.fieldFlags[this.nextIndex] & this.flagMask) > 0)
/*      */           {
/* 1387 */             return true;
/*      */           }
/*      */ 
/* 1390 */           this.nextIndex += 1;
/*      */         }
/*      */ 
/* 1393 */         return false;
/*      */       }
/*      */ 
/*      */       public JDBCCMPFieldBridge next()
/*      */       {
/* 1398 */         if (!hasNext())
/* 1399 */           throw new NoSuchElementException();
/* 1400 */         this.curIndex = this.nextIndex;
/* 1401 */         return JDBCEntityBridge.this.tableFields[(this.nextIndex++)];
/*      */       }
/*      */ 
/*      */       public void remove()
/*      */       {
/*      */         int tmp11_8 = this.curIndex;
/*      */         byte[] tmp11_4 = JDBCEntityBridge.EntityState.this.fieldFlags; tmp11_4[tmp11_8] = (byte)(tmp11_4[tmp11_8] & (this.flagMask ^ 0xFFFFFFFF));
/*      */       }
/*      */ 
/*      */       public void removeAll()
/*      */       {
/* 1411 */         int inversedMask = this.flagMask ^ 0xFFFFFFFF;
/* 1412 */         for (int i = 0; i < JDBCEntityBridge.EntityState.this.fieldFlags.length; i++)
/*      */         {
/*      */           int tmp29_28 = i;
/*      */           byte[] tmp29_25 = JDBCEntityBridge.EntityState.this.fieldFlags; tmp29_25[tmp29_28] = (byte)(tmp29_25[tmp29_28] & inversedMask);
/*      */         }
/*      */       }
/*      */ 
/*      */       public void reset() {
/* 1418 */         this.nextIndex = 0;
/* 1419 */         this.curIndex = -1;
/*      */       }
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge
 * JD-Core Version:    0.6.0
 */