/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.DatabaseMetaData;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Statement;
/*     */ import javax.sql.DataSource;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractCMRFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationshipRoleMetaData;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public final class JDBCStopCommand
/*     */ {
/*     */   private final JDBCEntityPersistenceStore manager;
/*     */   private final JDBCAbstractEntityBridge entity;
/*     */   private final JDBCEntityMetaData entityMetaData;
/*     */   private final Logger log;
/*     */ 
/*     */   public JDBCStopCommand(JDBCEntityPersistenceStore manager)
/*     */   {
/*  58 */     this.manager = manager;
/*  59 */     this.entity = manager.getEntityBridge();
/*  60 */     this.entityMetaData = this.entity.getMetaData();
/*     */ 
/*  63 */     this.log = Logger.getLogger(getClass().getName() + "." + manager.getMetaData().getName());
/*     */   }
/*     */ 
/*     */   public boolean execute()
/*     */   {
/*  71 */     boolean success = true;
/*     */ 
/*  74 */     JDBCAbstractCMRFieldBridge[] cmrFields = this.entity.getCMRFields();
/*  75 */     for (int i = 0; i < cmrFields.length; i++)
/*     */     {
/*  77 */       JDBCAbstractCMRFieldBridge cmrField = cmrFields[i];
/*  78 */       JDBCRelationMetaData relationMetaData = cmrField.getMetaData().getRelationMetaData();
/*  79 */       if ((!relationMetaData.isTableMappingStyle()) || (relationMetaData.isTableDropped()))
/*     */         continue;
/*  81 */       if (!relationMetaData.getRemoveTable())
/*     */         continue;
/*  83 */       boolean dropped = dropTable(relationMetaData.getDataSource(), cmrField.getQualifiedTableName());
/*  84 */       if (!dropped)
/*     */       {
/*  86 */         success = false;
/*     */       }
/*     */       else
/*     */       {
/*  90 */         relationMetaData.setTableDropped();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  96 */     if (this.entityMetaData.getRemoveTable())
/*     */     {
/*  98 */       boolean dropped = dropTable(this.entity.getDataSource(), this.entity.getQualifiedTableName());
/*  99 */       if (!dropped)
/*     */       {
/* 101 */         success = false;
/*     */       }
/*     */     }
/*     */ 
/* 105 */     return success;
/*     */   }
/*     */ 
/*     */   private boolean dropTable(DataSource dataSource, String qualifiedTableName)
/*     */   {
/* 111 */     Connection con = null;
/* 112 */     ResultSet rs = null;
/*     */ 
/* 114 */     String schema = SQLUtil.getSchema(qualifiedTableName);
/* 115 */     String tableName = schema != null ? SQLUtil.getTableNameWithoutSchema(qualifiedTableName) : qualifiedTableName;
/*     */     try
/*     */     {
/* 120 */       con = dataSource.getConnection();
/* 121 */       DatabaseMetaData dmd = con.getMetaData();
/* 122 */       rs = dmd.getTables(con.getCatalog(), schema, tableName, null);
/* 123 */       if (!rs.next())
/*     */       {
/* 125 */         i = 1; jsr 42;
/*     */       }
/*     */     }
/*     */     catch (SQLException e)
/*     */     {
/*     */       int i;
/* 130 */       this.log.debug("Error getting database metadata for DROP TABLE command.  DROP TABLE will not be executed. ", e);
/*     */ 
/* 132 */       return 1;
/*     */     }
/*     */     finally
/*     */     {
/* 136 */       JDBCUtil.safeClose(rs);
/* 137 */       JDBCUtil.safeClose(con);
/*     */     }
/*     */ 
/* 143 */     TransactionManager tm = this.manager.getContainer().getTransactionManager();
/* 144 */     Transaction oldTransaction = null;
/*     */     try
/*     */     {
/* 147 */       oldTransaction = tm.suspend();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 151 */       this.log.error("Could not suspend current transaction before drop table. '" + qualifiedTableName + "' will not be dropped.", e);
/*     */     }
/*     */     boolean success;
/*     */     try
/*     */     {
/* 157 */       Statement statement = null;
/*     */       try
/*     */       {
/* 160 */         con = dataSource.getConnection();
/* 161 */         statement = con.createStatement();
/*     */ 
/* 164 */         String sql = "DROP TABLE " + qualifiedTableName;
/* 165 */         this.log.debug("Executing SQL: " + sql);
/* 166 */         statement.executeUpdate(sql);
/* 167 */         success = true;
/*     */       }
/*     */       finally
/*     */       {
/* 171 */         JDBCUtil.safeClose(statement);
/* 172 */         JDBCUtil.safeClose(con);
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 177 */       this.log.debug("Could not drop table " + qualifiedTableName + ": " + e.getMessage());
/* 178 */       success = false;
/*     */     }
/*     */     finally
/*     */     {
/*     */       try
/*     */       {
/* 185 */         if (oldTransaction != null)
/*     */         {
/* 187 */           tm.resume(oldTransaction);
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 192 */         this.log.error("Could not reattach original transaction after drop table");
/*     */       }
/*     */     }
/*     */ 
/* 196 */     return success;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCStopCommand
 * JD-Core Version:    0.6.0
 */