/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.StringReader;
/*     */ import java.math.BigDecimal;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.SQLException;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract interface JDBCParameterSetter
/*     */ {
/*  82 */   public static final JDBCParameterSetter CLOB = new JDBCAbstractParameterSetter()
/*     */   {
/*     */     protected void setNotNull(PreparedStatement ps, int index, int jdbcType, Object value, Logger log)
/*     */       throws SQLException
/*     */     {
/*  87 */       String string = value.toString();
/*  88 */       ps.setCharacterStream(index, new StringReader(string), string.length());
/*     */     }
/*  82 */   };
/*     */ 
/*  95 */   public static final JDBCParameterSetter BINARY = new JDBCAbstractParameterSetter()
/*     */   {
/*     */     protected void setNotNull(PreparedStatement ps, int index, int jdbcType, Object value, Logger log)
/*     */       throws SQLException
/*     */     {
/* 100 */       byte[] bytes = JDBCUtil.convertObjectToByteArray(value);
/* 101 */       ps.setBytes(index, bytes);
/*     */     }
/*  95 */   };
/*     */ 
/* 108 */   public static final JDBCParameterSetter BLOB = new JDBCAbstractParameterSetter()
/*     */   {
/*     */     protected void setNotNull(PreparedStatement ps, int index, int jdbcType, Object value, Logger log)
/*     */       throws SQLException
/*     */     {
/* 113 */       byte[] bytes = JDBCUtil.convertObjectToByteArray(value);
/* 114 */       ps.setBinaryStream(index, new ByteArrayInputStream(bytes), bytes.length);
/*     */     }
/* 108 */   };
/*     */ 
/* 121 */   public static final JDBCParameterSetter NUMERIC = new JDBCAbstractParameterSetter()
/*     */   {
/*     */     protected void setNotNull(PreparedStatement ps, int index, int jdbcType, Object value, Logger log)
/*     */       throws SQLException
/*     */     {
/* 126 */       if ((value instanceof BigDecimal))
/*     */       {
/* 128 */         ps.setBigDecimal(index, (BigDecimal)value);
/*     */       }
/*     */       else
/*     */       {
/* 132 */         ps.setObject(index, value, jdbcType, 0);
/*     */       }
/*     */     }
/* 121 */   };
/*     */ 
/* 140 */   public static final JDBCParameterSetter OBJECT = new JDBCAbstractParameterSetter()
/*     */   {
/*     */     protected void setNotNull(PreparedStatement ps, int index, int jdbcType, Object value, Logger log)
/*     */       throws SQLException
/*     */     {
/* 145 */       ps.setObject(index, value, jdbcType);
/*     */     }
/* 140 */   };
/*     */ 
/*     */   public abstract void set(PreparedStatement paramPreparedStatement, int paramInt1, int paramInt2, Object paramObject, Logger paramLogger)
/*     */     throws SQLException;
/*     */ 
/*     */   public static abstract class JDBCAbstractParameterSetter
/*     */     implements JDBCParameterSetter
/*     */   {
/*     */     public void set(PreparedStatement ps, int index, int jdbcType, Object value, Logger log)
/*     */       throws SQLException
/*     */     {
/*  56 */       if (log.isTraceEnabled())
/*     */       {
/*  58 */         log.trace("param: i=" + index + ", " + "type=" + JDBCUtil.getJDBCTypeName(jdbcType) + ", " + "value=" + (value == null ? "NULL" : value));
/*     */       }
/*     */ 
/*  64 */       if (value == null)
/*     */       {
/*  66 */         ps.setNull(index, jdbcType);
/*     */       }
/*     */       else
/*     */       {
/*  70 */         value = JDBCUtil.coerceToSQLType(jdbcType, value);
/*  71 */         setNotNull(ps, index, jdbcType, value, log);
/*     */       }
/*     */     }
/*     */ 
/*     */     protected abstract void setNotNull(PreparedStatement paramPreparedStatement, int paramInt1, int paramInt2, Object paramObject, Logger paramLogger)
/*     */       throws SQLException;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCParameterSetter
 * JD-Core Version:    0.6.0
 */