/*    */ package org.jboss.ejb.plugins.cmp.jdbc;
/*    */ 
/*    */ import java.lang.reflect.Method;
/*    */ import org.jboss.deployment.DeploymentException;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCReadAheadMetaData;
/*    */ 
/*    */ public final class JDBCFindByQuery extends JDBCAbstractQueryCommand
/*    */ {
/*    */   private final JDBCCMPFieldBridge cmpField;
/*    */ 
/*    */   public JDBCFindByQuery(JDBCStoreManager manager, JDBCQueryMetaData q)
/*    */     throws DeploymentException
/*    */   {
/* 52 */     super(manager, q);
/*    */ 
/* 54 */     JDBCEntityBridge entity = (JDBCEntityBridge)manager.getEntityBridge();
/*    */ 
/* 56 */     String finderName = q.getMethod().getName();
/*    */ 
/* 60 */     String cmpFieldName = Character.toLowerCase(finderName.charAt(6)) + finderName.substring(7);
/*    */ 
/* 63 */     this.cmpField = entity.getCMPFieldByName(cmpFieldName);
/* 64 */     if (this.cmpField == null)
/*    */     {
/* 66 */       throw new IllegalArgumentException("No finder for this method: " + finderName);
/*    */     }
/*    */ 
/* 71 */     JDBCReadAheadMetaData readAhead = q.getReadAhead();
/* 72 */     if (readAhead.isOnFind())
/*    */     {
/* 74 */       setEagerLoadGroup(readAhead.getEagerLoadGroup());
/*    */     }
/*    */ 
/* 78 */     StringBuffer sql = new StringBuffer(300);
/* 79 */     sql.append("SELECT ");
/*    */ 
/* 81 */     SQLUtil.getColumnNamesClause(entity.getPrimaryKeyFields(), sql);
/* 82 */     if (getEagerLoadGroup() != null)
/*    */     {
/* 84 */       SQLUtil.appendColumnNamesClause(entity, getEagerLoadGroup(), sql);
/*    */     }
/* 86 */     sql.append(" FROM ").append(entity.getQualifiedTableName()).append(" WHERE ");
/*    */ 
/* 89 */     SQLUtil.getWhereClause(this.cmpField, sql);
/*    */ 
/* 91 */     setSQL(sql.toString());
/* 92 */     setParameterList(QueryParameter.createParameters(0, this.cmpField));
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCFindByQuery
 * JD-Core Version:    0.6.0
 */