/*      */ package org.jboss.ejb.plugins.cmp.jdbc;
/*      */ 
/*      */ import java.io.StringReader;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collection;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.Map.Entry;
/*      */ import java.util.Set;
/*      */ import org.jboss.deployment.DeploymentException;
/*      */ import org.jboss.ejb.EntityPersistenceStore;
/*      */ import org.jboss.ejb.plugins.cmp.bridge.CMPFieldBridge;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTAbs;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTAbstractSchema;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTAvg;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTBooleanLiteral;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTCollectionMemberDeclaration;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTConcat;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTCount;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTEJBQL;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTEntityComparison;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTExactNumericLiteral;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTFrom;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTIdentifier;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTIsEmpty;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTLCase;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTLength;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTLimitOffset;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTLocate;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTMax;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTMemberOf;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTMin;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTMod;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTNullComparison;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTOrderBy;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTParameter;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTPath;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTRangeVariableDeclaration;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTSelect;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTSqrt;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTSubstring;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTSum;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTUCase;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTValueClassComparison;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTWhere;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTWhereConditionalTerm;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.BasicVisitor;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.Catalog;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.EJBQLParser;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.EJBQLTypes;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.JBossQLParser;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.Node;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.SelectFunction;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.SimpleNode;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractCMRFieldBridge;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMRFieldBridge;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCFunctionMappingMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCReadAheadMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCTypeMappingMetaData;
/*      */ 
/*      */ public final class JDBCEJBQLCompiler extends BasicVisitor
/*      */   implements QLCompiler
/*      */ {
/*      */   private final Catalog catalog;
/*      */   private Class returnType;
/*      */   private Class[] parameterTypes;
/*      */   private JDBCReadAheadMetaData readAhead;
/*      */   private boolean lazyResultSetLoading;
/*      */   private AliasManager aliasManager;
/*  108 */   private Set declaredPaths = new HashSet();
/*  109 */   private Set ctermJoinPaths = new HashSet();
/*  110 */   private Set allJoinPaths = new HashSet();
/*  111 */   private Map ctermCollectionMemberJoinPaths = new HashMap();
/*  112 */   private Map allCollectionMemberJoinPaths = new HashMap();
/*  113 */   private Map ctermLeftJoinPaths = new HashMap();
/*  114 */   private Map allLeftJoinPaths = new HashMap();
/*      */   private JDBCTypeMappingMetaData typeMapping;
/*      */   private JDBCTypeFactory typeFactory;
/*      */   private boolean subquerySupported;
/*      */   private boolean forceDistinct;
/*      */   private String sql;
/*      */   private int offsetParam;
/*      */   private int offsetValue;
/*      */   private int limitParam;
/*      */   private int limitValue;
/*      */   private JDBCStoreManager selectManager;
/*      */   private Object selectObject;
/*  130 */   private List inputParameters = new ArrayList();
/*      */ 
/*  135 */   private List leftJoinCMRList = new ArrayList();
/*      */   private StringBuffer onFindCMRJoin;
/*      */   private boolean countCompositePk;
/*      */   private String selectAlias;
/*      */   private boolean selectDistinct;
/*      */ 
/*      */   public JDBCEJBQLCompiler(Catalog catalog)
/*      */   {
/*  144 */     this.catalog = catalog;
/*      */   }
/*      */ 
/*      */   public void compileEJBQL(String ejbql, Class returnType, Class[] parameterTypes, JDBCQueryMetaData metadata)
/*      */     throws Exception
/*      */   {
/*  153 */     reset();
/*      */ 
/*  156 */     this.returnType = returnType;
/*  157 */     this.parameterTypes = parameterTypes;
/*  158 */     this.readAhead = metadata.getReadAhead();
/*  159 */     this.lazyResultSetLoading = metadata.isLazyResultSetLoading();
/*      */ 
/*  162 */     EJBQLParser parser = new EJBQLParser(new StringReader(""));
/*      */     try
/*      */     {
/*  168 */       ASTEJBQL ejbqlNode = parser.parse(this.catalog, parameterTypes, ejbql);
/*      */ 
/*  171 */       this.sql = ejbqlNode.jjtAccept(this, new StringBuffer()).toString();
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  176 */       reset();
/*  177 */       throw e;
/*      */     }
/*      */     catch (Error e)
/*      */     {
/*  182 */       reset();
/*  183 */       throw e;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void compileJBossQL(String ejbql, Class returnType, Class[] parameterTypes, JDBCQueryMetaData metadata)
/*      */     throws Exception
/*      */   {
/*  194 */     reset();
/*      */ 
/*  197 */     this.returnType = returnType;
/*  198 */     this.parameterTypes = parameterTypes;
/*  199 */     this.readAhead = metadata.getReadAhead();
/*  200 */     this.lazyResultSetLoading = metadata.isLazyResultSetLoading();
/*      */ 
/*  203 */     JBossQLParser parser = new JBossQLParser(new StringReader(""));
/*      */     try
/*      */     {
/*  209 */       ASTEJBQL ejbqlNode = parser.parse(this.catalog, parameterTypes, ejbql);
/*      */ 
/*  212 */       this.sql = ejbqlNode.jjtAccept(this, new StringBuffer()).toString();
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  217 */       reset();
/*  218 */       throw e;
/*      */     }
/*      */     catch (Error e)
/*      */     {
/*  223 */       reset();
/*  224 */       throw e;
/*      */     }
/*      */   }
/*      */ 
/*      */   private void reset()
/*      */   {
/*  230 */     this.returnType = null;
/*  231 */     this.parameterTypes = null;
/*  232 */     this.readAhead = null;
/*  233 */     this.inputParameters.clear();
/*  234 */     this.declaredPaths.clear();
/*  235 */     clearPerTermJoinPaths();
/*  236 */     this.allJoinPaths.clear();
/*  237 */     this.allCollectionMemberJoinPaths.clear();
/*  238 */     this.allLeftJoinPaths.clear();
/*  239 */     this.selectObject = null;
/*  240 */     this.selectManager = null;
/*  241 */     this.typeFactory = null;
/*  242 */     this.typeMapping = null;
/*  243 */     this.aliasManager = null;
/*  244 */     this.subquerySupported = true;
/*  245 */     this.forceDistinct = false;
/*  246 */     this.limitParam = 0;
/*  247 */     this.limitValue = 0;
/*  248 */     this.offsetParam = 0;
/*  249 */     this.offsetValue = 0;
/*  250 */     this.leftJoinCMRList.clear();
/*  251 */     this.onFindCMRJoin = null;
/*  252 */     this.countCompositePk = false;
/*  253 */     this.selectAlias = null;
/*  254 */     this.selectDistinct = false;
/*      */   }
/*      */ 
/*      */   public String getSQL()
/*      */   {
/*  259 */     return this.sql;
/*      */   }
/*      */ 
/*      */   public int getOffsetValue()
/*      */   {
/*  264 */     return this.offsetValue;
/*      */   }
/*      */ 
/*      */   public int getOffsetParam()
/*      */   {
/*  269 */     return this.offsetParam;
/*      */   }
/*      */ 
/*      */   public int getLimitValue()
/*      */   {
/*  274 */     return this.limitValue;
/*      */   }
/*      */ 
/*      */   public int getLimitParam()
/*      */   {
/*  279 */     return this.limitParam;
/*      */   }
/*      */ 
/*      */   public boolean isSelectEntity()
/*      */   {
/*  284 */     return this.selectObject instanceof JDBCEntityBridge;
/*      */   }
/*      */ 
/*      */   public JDBCAbstractEntityBridge getSelectEntity()
/*      */   {
/*  289 */     return (JDBCAbstractEntityBridge)this.selectObject;
/*      */   }
/*      */ 
/*      */   public boolean isSelectField()
/*      */   {
/*  294 */     return this.selectObject instanceof JDBCCMPFieldBridge;
/*      */   }
/*      */ 
/*      */   public JDBCFieldBridge getSelectField()
/*      */   {
/*  299 */     return (JDBCCMPFieldBridge)this.selectObject;
/*      */   }
/*      */ 
/*      */   public SelectFunction getSelectFunction()
/*      */   {
/*  304 */     return (SelectFunction)this.selectObject;
/*      */   }
/*      */ 
/*      */   public EntityPersistenceStore getStoreManager()
/*      */   {
/*  309 */     return this.selectManager;
/*      */   }
/*      */ 
/*      */   public List getInputParameters()
/*      */   {
/*  314 */     return this.inputParameters;
/*      */   }
/*      */ 
/*      */   public List getLeftJoinCMRList()
/*      */   {
/*  319 */     return this.leftJoinCMRList;
/*      */   }
/*      */ 
/*      */   public boolean isSelectDistinct()
/*      */   {
/*  324 */     return this.selectDistinct;
/*      */   }
/*      */ 
/*      */   public Object visit(SimpleNode node, Object data)
/*      */   {
/*  329 */     throw new RuntimeException("Internal error: Found unknown node type in EJB-QL abstract syntax tree: node=" + node);
/*      */   }
/*      */ 
/*      */   private void setTypeFactory(JDBCTypeFactory typeFactory)
/*      */   {
/*  335 */     this.typeFactory = typeFactory;
/*  336 */     this.typeMapping = typeFactory.getTypeMapping();
/*  337 */     this.aliasManager = new AliasManager(this.typeMapping.getAliasHeaderPrefix(), this.typeMapping.getAliasHeaderSuffix(), this.typeMapping.getAliasMaxLength());
/*      */ 
/*  340 */     this.subquerySupported = this.typeMapping.isSubquerySupported();
/*      */   }
/*      */ 
/*      */   private Class getParameterType(int index)
/*      */   {
/*  345 */     int zeroBasedIndex = index - 1;
/*  346 */     Class[] params = this.parameterTypes;
/*  347 */     if (zeroBasedIndex < params.length)
/*      */     {
/*  349 */       return params[zeroBasedIndex];
/*      */     }
/*  351 */     return null;
/*      */   }
/*      */ 
/*      */   private void verifyParameterEntityType(int number, JDBCEntityBridge entity)
/*      */   {
/*  358 */     Class parameterType = getParameterType(number);
/*  359 */     Class remoteClass = entity.getMetaData().getRemoteClass();
/*  360 */     Class localClass = entity.getMetaData().getLocalClass();
/*  361 */     if (((localClass == null) || (!localClass.isAssignableFrom(parameterType))) && ((remoteClass == null) || (!remoteClass.isAssignableFrom(parameterType))))
/*      */     {
/*  371 */       throw new IllegalStateException("Only like types can be compared: from entity=" + entity.getEntityName() + " to parameter type=" + parameterType);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void compareEntity(boolean not, Node fromNode, Node toNode, StringBuffer buf)
/*      */   {
/*  383 */     buf.append('(');
/*  384 */     if (not)
/*      */     {
/*  386 */       buf.append(" NOT ").append('(');
/*      */     }
/*      */ 
/*  391 */     ASTPath fromPath = (ASTPath)fromNode;
/*  392 */     addJoinPath(fromPath);
/*  393 */     String fromAlias = this.aliasManager.getAlias(fromPath.getPath());
/*  394 */     JDBCEntityBridge fromEntity = (JDBCEntityBridge)fromPath.getEntity();
/*      */ 
/*  396 */     if ((toNode instanceof ASTParameter))
/*      */     {
/*  398 */       ASTParameter toParam = (ASTParameter)toNode;
/*      */ 
/*  401 */       verifyParameterEntityType(toParam.number, fromEntity);
/*      */ 
/*  403 */       this.inputParameters.addAll(QueryParameter.createParameters(toParam.number - 1, fromEntity));
/*      */ 
/*  405 */       SQLUtil.getWhereClause(fromEntity.getPrimaryKeyFields(), fromAlias, buf);
/*      */     }
/*      */     else
/*      */     {
/*  411 */       ASTPath toPath = (ASTPath)toNode;
/*  412 */       addJoinPath(toPath);
/*  413 */       String toAlias = this.aliasManager.getAlias(toPath.getPath());
/*  414 */       JDBCEntityBridge toEntity = (JDBCEntityBridge)toPath.getEntity();
/*      */ 
/*  417 */       if (!fromEntity.equals(toEntity))
/*      */       {
/*  419 */         throw new IllegalStateException("Only like types can be compared: from entity=" + fromEntity.getEntityName() + " to entity=" + toEntity.getEntityName());
/*      */       }
/*      */ 
/*  425 */       SQLUtil.getSelfCompareWhereClause(fromEntity.getPrimaryKeyFields(), fromAlias, toAlias, buf);
/*      */     }
/*      */ 
/*  428 */     if (not)
/*      */     {
/*  430 */       buf.append(')');
/*      */     }
/*  432 */     buf.append(')');
/*      */   }
/*      */ 
/*      */   private void existsClause(ASTPath path, StringBuffer buf, boolean not)
/*      */   {
/*  437 */     if (!path.isCMRField())
/*      */     {
/*  439 */       throw new IllegalArgumentException("path must be a cmr field");
/*      */     }
/*      */ 
/*  442 */     JDBCCMRFieldBridge cmrField = (JDBCCMRFieldBridge)path.getCMRField();
/*  443 */     String pathStr = path.getPath(path.size() - 2);
/*  444 */     String parentAlias = this.aliasManager.getAlias(pathStr);
/*      */ 
/*  447 */     if (!this.subquerySupported)
/*      */     {
/*  450 */       addLeftJoinPath(pathStr, path);
/*  451 */       this.forceDistinct = true;
/*      */ 
/*  453 */       addJoinPath(path);
/*      */ 
/*  455 */       if (cmrField.getRelationMetaData().isForeignKeyMappingStyle())
/*      */       {
/*  457 */         JDBCEntityBridge childEntity = (JDBCEntityBridge)cmrField.getRelatedEntity();
/*  458 */         String childAlias = this.aliasManager.getAlias(path.getPath());
/*  459 */         SQLUtil.getIsNullClause(!not, childEntity.getPrimaryKeyFields(), childAlias, buf);
/*      */       }
/*      */       else
/*      */       {
/*  463 */         String relationTableAlias = this.aliasManager.getRelationTableAlias(path.getPath());
/*  464 */         SQLUtil.getIsNullClause(!not, cmrField.getTableKeyFields(), relationTableAlias, buf);
/*      */       }
/*  466 */       return;
/*      */     }
/*      */ 
/*  469 */     if (not)
/*      */     {
/*  471 */       buf.append(" NOT ");
/*      */     }
/*  473 */     buf.append("EXISTS ").append('(');
/*      */ 
/*  475 */     if (cmrField.getRelationMetaData().isForeignKeyMappingStyle())
/*      */     {
/*  477 */       JDBCEntityBridge childEntity = (JDBCEntityBridge)cmrField.getRelatedEntity();
/*  478 */       String childAlias = this.aliasManager.getAlias(path.getPath());
/*      */ 
/*  480 */       buf.append("SELECT ");
/*      */ 
/*  482 */       SQLUtil.getColumnNamesClause(childEntity.getPrimaryKeyFields(), childAlias, buf).append(" FROM ").append(childEntity.getQualifiedTableName()).append(' ').append(childAlias).append(" WHERE ");
/*      */ 
/*  486 */       SQLUtil.getJoinClause(cmrField, parentAlias, childAlias, buf);
/*      */     }
/*      */     else
/*      */     {
/*  490 */       String relationTableAlias = this.aliasManager.getRelationTableAlias(path.getPath());
/*  491 */       buf.append("SELECT ");
/*  492 */       SQLUtil.getColumnNamesClause(cmrField.getTableKeyFields(), relationTableAlias, buf).append(" FROM ").append(cmrField.getQualifiedTableName()).append(' ').append(relationTableAlias).append(" WHERE ");
/*      */ 
/*  498 */       SQLUtil.getRelationTableJoinClause(cmrField, parentAlias, relationTableAlias, buf);
/*      */     }
/*      */ 
/*  501 */     buf.append(')');
/*      */   }
/*      */ 
/*      */   public Object visit(ASTEJBQL node, Object data)
/*      */   {
/*  506 */     Node selectNode = node.jjtGetChild(0);
/*  507 */     Node fromNode = node.jjtGetChild(1);
/*  508 */     Node whereNode = null;
/*  509 */     Node orderByNode = null;
/*  510 */     Node limitNode = null;
/*      */ 
/*  512 */     for (int childNode = 2; childNode < node.jjtGetNumChildren(); childNode++)
/*      */     {
/*  514 */       Node temp = node.jjtGetChild(childNode);
/*  515 */       if ((temp instanceof ASTWhere))
/*      */       {
/*  517 */         whereNode = temp;
/*      */       }
/*  519 */       else if ((temp instanceof ASTOrderBy))
/*      */       {
/*  521 */         orderByNode = temp;
/*      */       } else {
/*  523 */         if (!(temp instanceof ASTLimitOffset))
/*      */           continue;
/*  525 */         limitNode = temp;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  530 */     StringBuffer select = new StringBuffer();
/*  531 */     selectNode.jjtAccept(this, select);
/*      */ 
/*  536 */     Set selectJoinPaths = new HashSet(this.ctermJoinPaths);
/*  537 */     Map selectCollectionMemberJoinPaths = new HashMap(this.ctermCollectionMemberJoinPaths);
/*  538 */     Map selectLeftJoinPaths = new HashMap(this.ctermLeftJoinPaths);
/*      */ 
/*  541 */     StringBuffer where = new StringBuffer();
/*  542 */     if (whereNode != null)
/*      */     {
/*  544 */       whereNode.jjtAccept(this, where);
/*      */     }
/*      */ 
/*  548 */     this.ctermJoinPaths = selectJoinPaths;
/*  549 */     this.ctermCollectionMemberJoinPaths = selectCollectionMemberJoinPaths;
/*  550 */     this.ctermLeftJoinPaths = selectLeftJoinPaths;
/*      */ 
/*  553 */     StringBuffer orderBy = new StringBuffer();
/*  554 */     if (orderByNode != null)
/*      */     {
/*  556 */       orderByNode.jjtAccept(this, orderBy);
/*      */ 
/*  559 */       for (int i = 0; i < orderByNode.jjtGetNumChildren(); i++)
/*      */       {
/*  561 */         Node orderByPath = orderByNode.jjtGetChild(i);
/*  562 */         ASTPath path = (ASTPath)orderByPath.jjtGetChild(0);
/*  563 */         if (isSelected(path))
/*      */           continue;
/*  565 */         select.append(", ");
/*  566 */         path.jjtAccept(this, select);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  571 */     if (limitNode != null)
/*      */     {
/*  573 */       limitNode.jjtAccept(this, null);
/*      */     }
/*      */ 
/*  576 */     StringBuffer from = new StringBuffer(50);
/*  577 */     fromNode.jjtAccept(this, from);
/*      */ 
/*  579 */     StringBuffer fromThetaJoin = new StringBuffer();
/*  580 */     createThetaJoin(fromThetaJoin);
/*      */ 
/*  582 */     if ((where.length() != 0) && (fromThetaJoin.length() != 0))
/*      */     {
/*  584 */       where.insert(0, '(').append(')').append(" AND ").append(fromThetaJoin);
/*      */     }
/*  589 */     else if (fromThetaJoin.length() != 0)
/*      */     {
/*  591 */       where.append(fromThetaJoin.toString());
/*      */     }
/*      */ 
/*  594 */     this.selectDistinct = isDistinct(selectNode);
/*      */ 
/*  597 */     if (this.lazyResultSetLoading)
/*      */     {
/*  599 */       StringBuffer buf = new StringBuffer(200);
/*  600 */       if (isSelectEntity())
/*      */       {
/*  602 */         JDBCFieldBridge[] pkFields = getSelectEntity().getPrimaryKeyFields();
/*  603 */         if (pkFields.length == 1)
/*      */         {
/*  605 */           buf.append('(').append("SELECT ").append("count(");
/*  606 */           if (this.selectDistinct)
/*      */           {
/*  608 */             buf.append("DISTINCT ");
/*      */           }
/*  610 */           SQLUtil.getColumnNamesClause(pkFields, this.selectAlias, buf);
/*  611 */           buf.append(')').append(" FROM ");
/*  612 */           buf.append(from);
/*  613 */           if (where.length() > 0)
/*      */           {
/*  615 */             buf.append(" WHERE ").append(where);
/*      */           }
/*  617 */           buf.append("), ");
/*  618 */           select.insert(0, buf);
/*      */         }
/*      */         else
/*      */         {
/*  622 */           buf.append('(').append("SELECT ").append("count(*)").append(" FROM ").append('(').append("SELECT ");
/*      */ 
/*  626 */           if (this.selectDistinct)
/*      */           {
/*  628 */             buf.append("DISTINCT ");
/*      */           }
/*      */ 
/*  631 */           SQLUtil.getColumnNamesClause(pkFields, this.selectAlias, buf);
/*  632 */           buf.append(" FROM ").append(from);
/*      */ 
/*  634 */           if (where.length() > 0)
/*      */           {
/*  636 */             buf.append(" WHERE ").append(where);
/*      */           }
/*  638 */           buf.append(") t_count), ");
/*  639 */           select.insert(0, buf);
/*      */         }
/*      */       }
/*  642 */       else if (isSelectField())
/*      */       {
/*  644 */         buf.append('(').append("SELECT ").append("count(");
/*  645 */         if (this.selectDistinct)
/*      */         {
/*  647 */           buf.append("DISTINCT ");
/*      */         }
/*  649 */         buf.append(select).append(')').append(" FROM ");
/*  650 */         buf.append(from);
/*  651 */         if (where.length() > 0)
/*      */         {
/*  653 */           buf.append(" WHERE ").append(where);
/*      */         }
/*  655 */         buf.append("), ");
/*  656 */         select.insert(0, buf);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  661 */     if (this.selectDistinct)
/*      */     {
/*  663 */       select.insert(0, "DISTINCT ");
/*      */     }
/*      */ 
/*  666 */     StringBuffer buf = (StringBuffer)data;
/*  667 */     if (this.selectManager.getMetaData().hasRowLocking())
/*      */     {
/*  669 */       JDBCFunctionMappingMetaData rowLockingTemplate = this.typeMapping.getRowLockingTemplate();
/*  670 */       Object[] args = { select, from, where.length() == 0 ? null : where, orderBy.length() == 0 ? null : orderBy };
/*      */ 
/*  676 */       rowLockingTemplate.getFunctionSql(args, buf);
/*      */     }
/*      */     else
/*      */     {
/*  680 */       buf.append("SELECT ").append(select).append(" FROM ").append(from);
/*      */ 
/*  685 */       if (where.length() > 0)
/*      */       {
/*  687 */         buf.append(" WHERE ").append(where);
/*      */       }
/*      */ 
/*  691 */       if (orderBy.length() != 0)
/*      */       {
/*  693 */         buf.append(" ORDER BY ").append(orderBy);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  699 */     if (this.countCompositePk)
/*      */     {
/*  701 */       buf.insert(0, "SELECT COUNT(*) FROM (").append(") t_count");
/*      */     }
/*      */ 
/*  704 */     return buf;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTFrom node, Object data)
/*      */   {
/*  709 */     StringBuffer buf = (StringBuffer)data;
/*      */ 
/*  711 */     node.jjtGetChild(0).jjtAccept(this, buf);
/*  712 */     for (int i = 1; i < node.jjtGetNumChildren(); i++)
/*      */     {
/*  714 */       buf.append(", ");
/*  715 */       node.jjtGetChild(i).jjtAccept(this, buf);
/*      */     }
/*      */     Iterator iter;
/*  719 */     if (!this.allJoinPaths.isEmpty())
/*      */     {
/*  721 */       for (iter = this.allJoinPaths.iterator(); iter.hasNext(); )
/*      */       {
/*  723 */         ASTPath path = (ASTPath)iter.next();
/*  724 */         for (int i = 0; i < path.size(); i++)
/*      */         {
/*  726 */           declareTables(path, i, buf);
/*      */         }
/*      */       }
/*      */     }
/*      */     Iterator iter;
/*  732 */     if (!this.allCollectionMemberJoinPaths.isEmpty())
/*      */     {
/*  734 */       for (iter = this.allCollectionMemberJoinPaths.values().iterator(); iter.hasNext(); )
/*      */       {
/*  736 */         ASTPath path = (ASTPath)iter.next();
/*      */ 
/*  738 */         for (int i = 0; i < path.size() - 1; i++)
/*      */         {
/*  740 */           declareTables(path, i, buf);
/*      */         }
/*      */       }
/*      */     }
/*      */     Iterator iter;
/*  746 */     if (!this.allLeftJoinPaths.isEmpty())
/*      */     {
/*  748 */       Set allLeftJoins = new HashSet();
/*  749 */       for (Iterator iter = this.allLeftJoinPaths.values().iterator(); iter.hasNext(); )
/*      */       {
/*  751 */         allLeftJoins.addAll((Set)iter.next());
/*      */       }
/*      */ 
/*  755 */       for (iter = allLeftJoins.iterator(); iter.hasNext(); )
/*      */       {
/*  757 */         ASTPath path = (ASTPath)iter.next();
/*      */ 
/*  759 */         for (int i = 0; i < path.size() - 1; i++)
/*      */         {
/*  761 */           declareTables(path, i, buf);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  766 */     return buf;
/*      */   }
/*      */ 
/*      */   private void declareTables(ASTPath path, int i, StringBuffer buf)
/*      */   {
/*  771 */     if ((!path.isCMRField(i)) || (this.declaredPaths.contains(path.getPath(i))))
/*      */     {
/*  773 */       return;
/*      */     }
/*      */ 
/*  776 */     JDBCCMRFieldBridge cmrField = (JDBCCMRFieldBridge)path.getCMRField(i);
/*  777 */     JDBCEntityBridge entity = (JDBCEntityBridge)path.getEntity(i);
/*      */ 
/*  779 */     buf.append(", ").append(entity.getQualifiedTableName()).append(' ').append(this.aliasManager.getAlias(path.getPath(i)));
/*      */ 
/*  783 */     leftJoins(path.getPath(i), buf);
/*      */ 
/*  785 */     if (cmrField.getRelationMetaData().isTableMappingStyle())
/*      */     {
/*  787 */       String relationTableAlias = this.aliasManager.getRelationTableAlias(path.getPath(i));
/*  788 */       buf.append(", ").append(cmrField.getQualifiedTableName()).append(' ').append(relationTableAlias);
/*      */     }
/*      */ 
/*  794 */     this.declaredPaths.add(path.getPath(i));
/*      */   }
/*      */ 
/*      */   private void leftJoins(String parentPath, StringBuffer buf)
/*      */   {
/*  799 */     Set paths = (Set)this.ctermLeftJoinPaths.get(parentPath);
/*  800 */     if ((this.subquerySupported) || (paths == null))
/*      */     {
/*  802 */       return;
/*      */     }
/*      */ 
/*  805 */     for (Iterator iter = paths.iterator(); iter.hasNext(); )
/*      */     {
/*  807 */       ASTPath path = (ASTPath)iter.next();
/*      */ 
/*  809 */       JDBCCMRFieldBridge cmrField = (JDBCCMRFieldBridge)path.getCMRField();
/*  810 */       String parentAlias = this.aliasManager.getAlias(parentPath);
/*      */ 
/*  812 */       if (cmrField.getRelationMetaData().isForeignKeyMappingStyle())
/*      */       {
/*  814 */         JDBCEntityBridge childEntity = (JDBCEntityBridge)cmrField.getRelatedEntity();
/*  815 */         String childAlias = this.aliasManager.getAlias(path.getPath());
/*      */ 
/*  817 */         buf.append(" LEFT JOIN ").append(childEntity.getQualifiedTableName()).append(' ').append(childAlias).append(" ON ");
/*      */ 
/*  822 */         SQLUtil.getJoinClause(cmrField, parentAlias, childAlias, buf);
/*      */       }
/*      */       else
/*      */       {
/*  826 */         String relationTableAlias = this.aliasManager.getRelationTableAlias(path.getPath());
/*  827 */         buf.append(" LEFT JOIN ").append(cmrField.getQualifiedTableName()).append(' ').append(relationTableAlias).append(" ON ");
/*      */ 
/*  832 */         SQLUtil.getRelationTableJoinClause(cmrField, parentAlias, relationTableAlias, buf);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void createThetaJoin(StringBuffer buf)
/*      */   {
/*  839 */     Set joinedAliases = new HashSet();
/*      */     Iterator iter;
/*  841 */     if (!this.ctermJoinPaths.isEmpty())
/*      */     {
/*  843 */       for (iter = this.ctermJoinPaths.iterator(); iter.hasNext(); )
/*      */       {
/*  845 */         ASTPath path = (ASTPath)iter.next();
/*  846 */         for (int i = 0; i < path.size(); i++)
/*      */         {
/*  848 */           createThetaJoin(path, i, joinedAliases, buf);
/*      */         }
/*      */       }
/*      */     }
/*      */     Iterator iter;
/*  854 */     if (!this.ctermCollectionMemberJoinPaths.isEmpty())
/*      */     {
/*  856 */       for (iter = this.ctermCollectionMemberJoinPaths.entrySet().iterator(); iter.hasNext(); )
/*      */       {
/*  858 */         Map.Entry entry = (Map.Entry)iter.next();
/*  859 */         String childAlias = (String)entry.getKey();
/*  860 */         ASTPath path = (ASTPath)entry.getValue();
/*      */ 
/*  863 */         createThetaJoin(path, path.size() - 1, joinedAliases, childAlias, buf);
/*      */ 
/*  866 */         for (int i = 0; i < path.size() - 1; i++)
/*      */         {
/*  868 */           createThetaJoin(path, i, joinedAliases, buf);
/*      */         }
/*      */       }
/*      */     }
/*      */     Iterator iter;
/*  874 */     if (!this.ctermLeftJoinPaths.isEmpty())
/*      */     {
/*  876 */       Set allLeftJoins = new HashSet();
/*  877 */       for (Iterator iter = this.ctermLeftJoinPaths.values().iterator(); iter.hasNext(); )
/*      */       {
/*  879 */         allLeftJoins.addAll((Set)iter.next());
/*      */       }
/*      */ 
/*  883 */       for (iter = allLeftJoins.iterator(); iter.hasNext(); )
/*      */       {
/*  885 */         ASTPath path = (ASTPath)iter.next();
/*      */ 
/*  887 */         for (int i = 0; i < path.size() - 1; i++)
/*      */         {
/*  889 */           createThetaJoin(path, i, joinedAliases, buf);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void createThetaJoin(ASTPath path, int i, Set joinedAliases, StringBuffer buf)
/*      */   {
/*  900 */     String childAlias = this.aliasManager.getAlias(path.getPath(i));
/*  901 */     createThetaJoin(path, i, joinedAliases, childAlias, buf);
/*      */   }
/*      */ 
/*      */   private void createThetaJoin(ASTPath path, int i, Set joinedAliases, String childAlias, StringBuffer buf)
/*      */   {
/*  910 */     if ((!path.isCMRField(i)) || (joinedAliases.contains(childAlias)))
/*      */     {
/*  912 */       return;
/*      */     }
/*      */ 
/*  915 */     JDBCCMRFieldBridge cmrField = (JDBCCMRFieldBridge)path.getCMRField(i);
/*  916 */     String parentAlias = this.aliasManager.getAlias(path.getPath(i - 1));
/*      */ 
/*  918 */     if (joinedAliases.size() > 0)
/*      */     {
/*  920 */       buf.append(" AND ");
/*      */     }
/*      */ 
/*  923 */     if (cmrField.getRelationMetaData().isForeignKeyMappingStyle())
/*      */     {
/*  925 */       SQLUtil.getJoinClause(cmrField, parentAlias, childAlias, buf);
/*      */     }
/*      */     else
/*      */     {
/*  929 */       String relationTableAlias = this.aliasManager.getRelationTableAlias(path.getPath(i));
/*      */ 
/*  932 */       SQLUtil.getRelationTableJoinClause(cmrField, parentAlias, relationTableAlias, buf).append(" AND ");
/*      */ 
/*  935 */       SQLUtil.getRelationTableJoinClause(cmrField.getRelatedCMRField(), childAlias, relationTableAlias, buf);
/*      */     }
/*      */ 
/*  938 */     joinedAliases.add(childAlias);
/*      */   }
/*      */ 
/*      */   public Object visit(ASTCollectionMemberDeclaration node, Object data)
/*      */   {
/*  944 */     StringBuffer buf = (StringBuffer)data;
/*      */ 
/*  947 */     ASTPath path = (ASTPath)node.jjtGetChild(0);
/*      */ 
/*  950 */     this.declaredPaths.add(path.getPath());
/*      */ 
/*  953 */     JDBCEntityBridge entity = (JDBCEntityBridge)path.getEntity();
/*      */ 
/*  956 */     ASTIdentifier id = (ASTIdentifier)node.jjtGetChild(1);
/*      */ 
/*  959 */     String alias = this.aliasManager.getAlias(id.identifier);
/*      */ 
/*  962 */     addCollectionMemberJoinPath(alias, path);
/*      */ 
/*  965 */     this.aliasManager.addAlias(path.getPath(), alias);
/*      */ 
/*  967 */     buf.append(entity.getQualifiedTableName());
/*  968 */     buf.append(' ');
/*  969 */     buf.append(alias);
/*  970 */     leftJoins(path.getPath(), buf);
/*      */ 
/*  972 */     if ((this.onFindCMRJoin != null) && (alias.equals(this.selectAlias)))
/*      */     {
/*  974 */       buf.append(this.onFindCMRJoin);
/*  975 */       this.onFindCMRJoin = null;
/*      */     }
/*      */ 
/*  979 */     JDBCCMRFieldBridge cmrField = (JDBCCMRFieldBridge)path.getCMRField();
/*  980 */     if (cmrField.getRelationMetaData().isTableMappingStyle())
/*      */     {
/*  982 */       String relationTableAlias = this.aliasManager.getRelationTableAlias(path.getPath());
/*  983 */       buf.append(", ").append(cmrField.getQualifiedTableName()).append(' ').append(relationTableAlias);
/*      */     }
/*      */ 
/*  989 */     return buf;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTRangeVariableDeclaration node, Object data)
/*      */   {
/*  994 */     StringBuffer buf = (StringBuffer)data;
/*      */ 
/*  996 */     ASTAbstractSchema schema = (ASTAbstractSchema)node.jjtGetChild(0);
/*  997 */     JDBCEntityBridge entity = (JDBCEntityBridge)schema.entity;
/*  998 */     ASTIdentifier id = (ASTIdentifier)node.jjtGetChild(1);
/*      */ 
/* 1000 */     String alias = this.aliasManager.getAlias(id.identifier);
/* 1001 */     buf.append(entity.getQualifiedTableName()).append(' ').append(alias);
/*      */ 
/* 1004 */     leftJoins(id.identifier, buf);
/*      */ 
/* 1006 */     if ((this.onFindCMRJoin != null) && (alias.equals(this.selectAlias)))
/*      */     {
/* 1008 */       buf.append(this.onFindCMRJoin);
/* 1009 */       this.onFindCMRJoin = null;
/*      */     }
/*      */ 
/* 1012 */     return buf;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTSelect node, Object data)
/*      */   {
/* 1017 */     StringBuffer buf = (StringBuffer)data;
/*      */ 
/* 1019 */     Node child0 = node.jjtGetChild(0);
/*      */ 
/* 1021 */     if ((child0 instanceof ASTPath))
/*      */     {
/* 1023 */       ASTPath path = (ASTPath)child0;
/*      */ 
/* 1025 */       if (path.isCMPField())
/*      */       {
/* 1028 */         JDBCCMPFieldBridge selectField = (JDBCCMPFieldBridge)path.getCMPField();
/* 1029 */         this.selectManager = ((JDBCStoreManager)selectField.getManager());
/* 1030 */         this.selectObject = selectField;
/* 1031 */         setTypeFactory(this.selectManager.getJDBCTypeFactory());
/*      */ 
/* 1033 */         addJoinPath(path);
/* 1034 */         this.selectAlias = this.aliasManager.getAlias(path.getPath(path.size() - 2));
/* 1035 */         SQLUtil.getColumnNamesClause(selectField, this.selectAlias, buf);
/*      */       }
/*      */       else
/*      */       {
/* 1040 */         JDBCEntityBridge selectEntity = (JDBCEntityBridge)path.getEntity();
/* 1041 */         this.selectManager = ((JDBCStoreManager)selectEntity.getManager());
/* 1042 */         this.selectObject = selectEntity;
/* 1043 */         setTypeFactory(this.selectManager.getJDBCTypeFactory());
/* 1044 */         selectEntity(path, node.distinct, buf);
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 1050 */       ASTPath path = getPathFromChildren(child0);
/*      */ 
/* 1052 */       if (path == null)
/*      */       {
/* 1054 */         throw new IllegalStateException("The function in SELECT clause does not contain a path expression.");
/*      */       }
/*      */ 
/* 1057 */       if (path.isCMPField())
/*      */       {
/* 1059 */         JDBCCMPFieldBridge selectField = (JDBCCMPFieldBridge)path.getCMPField();
/* 1060 */         this.selectManager = ((JDBCStoreManager)selectField.getManager());
/*      */       }
/* 1062 */       else if (path.isCMRField())
/*      */       {
/* 1064 */         JDBCCMRFieldBridge cmrField = (JDBCCMRFieldBridge)path.getCMRField();
/* 1065 */         this.selectManager = ((JDBCStoreManager)cmrField.getEntity().getManager());
/* 1066 */         addJoinPath(path);
/*      */       }
/*      */       else
/*      */       {
/* 1070 */         JDBCEntityBridge entity = (JDBCEntityBridge)path.getEntity();
/* 1071 */         this.selectManager = ((JDBCStoreManager)entity.getManager());
/* 1072 */         addJoinPath(path);
/*      */       }
/*      */ 
/* 1075 */       setTypeFactory(this.selectManager.getJDBCTypeFactory());
/* 1076 */       this.selectObject = child0;
/* 1077 */       child0.jjtAccept(this, buf);
/*      */     }
/*      */ 
/* 1080 */     return buf;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTWhere node, Object data)
/*      */   {
/* 1088 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 1089 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTNullComparison node, Object data)
/*      */   {
/* 1094 */     StringBuffer buf = (StringBuffer)data;
/*      */ 
/* 1096 */     Node child0 = node.jjtGetChild(0);
/* 1097 */     if ((child0 instanceof ASTPath))
/*      */     {
/* 1099 */       ASTPath path = (ASTPath)child0;
/*      */ 
/* 1101 */       if (path.isCMRField())
/*      */       {
/* 1103 */         JDBCCMRFieldBridge cmrField = (JDBCCMRFieldBridge)path.getCMRField();
/* 1104 */         if (cmrField.getRelationMetaData().isTableMappingStyle())
/*      */         {
/* 1106 */           existsClause(path, buf, !node.not);
/* 1107 */           return buf;
/*      */         }
/*      */       }
/*      */ 
/* 1111 */       String alias = this.aliasManager.getAlias(path.getPath(path.size() - 2));
/* 1112 */       JDBCFieldBridge field = (JDBCFieldBridge)path.getField();
/*      */ 
/* 1118 */       if (field.getJDBCType() == null)
/*      */       {
/* 1120 */         existsClause(path, buf, !node.not);
/* 1121 */         return buf;
/*      */       }
/*      */ 
/* 1125 */       if (path.fieldList.size() > 2)
/*      */       {
/* 1127 */         for (int i = 0; i < path.fieldList.size(); i++)
/*      */         {
/* 1129 */           Object pathEl = path.fieldList.get(i);
/* 1130 */           if (!(pathEl instanceof JDBCCMRFieldBridge))
/*      */             continue;
/* 1132 */           addJoinPath(path);
/* 1133 */           break;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1138 */       buf = SQLUtil.getIsNullClause(node.not, field, alias, buf);
/*      */     }
/* 1140 */     else if ((child0 instanceof ASTParameter))
/*      */     {
/* 1142 */       ASTParameter param = (ASTParameter)child0;
/* 1143 */       Class type = getParameterType(param.number);
/*      */ 
/* 1145 */       QueryParameter queryParam = new QueryParameter(param.number - 1, this.typeFactory.getJDBCType(type));
/* 1146 */       this.inputParameters.add(queryParam);
/*      */ 
/* 1148 */       buf.append("? IS ");
/* 1149 */       if (node.not)
/*      */       {
/* 1151 */         buf.append(" NOT ");
/*      */       }
/* 1153 */       buf.append("NULL");
/*      */     }
/*      */     else
/*      */     {
/* 1157 */       throw new IllegalStateException("Unexpected node in IS NULL clause: " + node);
/*      */     }
/*      */ 
/* 1160 */     return buf;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTIsEmpty node, Object data)
/*      */   {
/* 1165 */     StringBuffer buf = (StringBuffer)data;
/* 1166 */     ASTPath path = (ASTPath)node.jjtGetChild(0);
/*      */ 
/* 1168 */     existsClause(path, buf, !node.not);
/* 1169 */     return buf;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTMemberOf node, Object data)
/*      */   {
/* 1177 */     StringBuffer buf = (StringBuffer)data;
/*      */ 
/* 1180 */     ASTPath toPath = (ASTPath)node.jjtGetChild(1);
/*      */ 
/* 1182 */     JDBCCMRFieldBridge toCMRField = (JDBCCMRFieldBridge)toPath.getCMRField();
/*      */ 
/* 1184 */     JDBCEntityBridge toChildEntity = (JDBCEntityBridge)toPath.getEntity();
/*      */ 
/* 1186 */     String pathStr = toPath.getPath(toPath.size() - 2);
/* 1187 */     String toParentAlias = this.aliasManager.getAlias(pathStr);
/* 1188 */     String toChildAlias = this.aliasManager.getAlias(toPath.getPath());
/* 1189 */     String relationTableAlias = null;
/* 1190 */     if (toCMRField.getRelationMetaData().isTableMappingStyle())
/*      */     {
/* 1192 */       relationTableAlias = this.aliasManager.getRelationTableAlias(toPath.getPath());
/*      */     }
/*      */ 
/* 1196 */     String fromAlias = null;
/* 1197 */     int fromParamNumber = -1;
/* 1198 */     if ((node.jjtGetChild(0) instanceof ASTParameter))
/*      */     {
/* 1200 */       ASTParameter fromParam = (ASTParameter)node.jjtGetChild(0);
/*      */ 
/* 1203 */       verifyParameterEntityType(fromParam.number, toChildEntity);
/*      */ 
/* 1205 */       fromParamNumber = fromParam.number;
/*      */     }
/*      */     else
/*      */     {
/* 1209 */       ASTPath fromPath = (ASTPath)node.jjtGetChild(0);
/* 1210 */       addJoinPath(fromPath);
/*      */ 
/* 1212 */       JDBCEntityBridge fromEntity = (JDBCEntityBridge)fromPath.getEntity();
/* 1213 */       fromAlias = this.aliasManager.getAlias(fromPath.getPath());
/*      */ 
/* 1216 */       if (!fromEntity.equals(toChildEntity))
/*      */       {
/* 1218 */         throw new IllegalStateException("Only like types can be compared: from entity=" + fromEntity.getEntityName() + " to entity=" + toChildEntity.getEntityName());
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1226 */     addLeftJoinPath(pathStr, toPath);
/*      */ 
/* 1229 */     if (!this.subquerySupported)
/*      */     {
/* 1231 */       addJoinPath(toPath);
/*      */ 
/* 1234 */       if (node.not)
/*      */       {
/* 1236 */         buf.append(" NOT ");
/*      */       }
/* 1238 */       buf.append('(');
/*      */ 
/* 1240 */       if (relationTableAlias == null)
/*      */       {
/* 1242 */         SQLUtil.getIsNullClause(true, toChildEntity.getPrimaryKeyFields(), toChildAlias, buf);
/*      */       }
/*      */       else
/*      */       {
/* 1246 */         SQLUtil.getIsNullClause(true, toCMRField.getTableKeyFields(), relationTableAlias, buf);
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 1252 */       if (node.not)
/*      */       {
/* 1254 */         buf.append(" NOT ");
/*      */       }
/*      */ 
/* 1257 */       buf.append("EXISTS ").append('(');
/*      */ 
/* 1259 */       if (relationTableAlias == null)
/*      */       {
/* 1261 */         buf.append("SELECT ");
/* 1262 */         SQLUtil.getColumnNamesClause(toChildEntity.getPrimaryKeyFields(), toChildAlias, buf).append(" FROM ").append(toChildEntity.getQualifiedTableName()).append(' ').append(toChildAlias).append(" WHERE ");
/*      */ 
/* 1268 */         SQLUtil.getJoinClause(toCMRField, toParentAlias, toChildAlias, buf);
/*      */       }
/*      */       else
/*      */       {
/* 1272 */         buf.append("SELECT ");
/* 1273 */         SQLUtil.getColumnNamesClause(toCMRField.getRelatedCMRField().getTableKeyFields(), relationTableAlias, buf).append(" FROM ").append(toCMRField.getQualifiedTableName()).append(' ').append(relationTableAlias).append(" WHERE ");
/*      */ 
/* 1279 */         SQLUtil.getRelationTableJoinClause(toCMRField, toParentAlias, relationTableAlias, buf);
/*      */       }
/*      */     }
/*      */ 
/* 1283 */     buf.append(" AND ");
/*      */ 
/* 1286 */     if (fromAlias != null)
/*      */     {
/* 1289 */       if (relationTableAlias == null)
/*      */       {
/* 1291 */         SQLUtil.getSelfCompareWhereClause(toChildEntity.getPrimaryKeyFields(), toChildAlias, fromAlias, buf);
/*      */       }
/*      */       else
/*      */       {
/* 1298 */         SQLUtil.getRelationTableJoinClause(toCMRField.getRelatedCMRField(), fromAlias, relationTableAlias, buf);
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 1307 */       this.inputParameters.addAll(QueryParameter.createParameters(fromParamNumber - 1, toChildEntity));
/*      */ 
/* 1311 */       if (relationTableAlias == null)
/*      */       {
/* 1313 */         SQLUtil.getWhereClause(toChildEntity.getPrimaryKeyFields(), toChildAlias, buf);
/*      */       }
/*      */       else
/*      */       {
/* 1317 */         SQLUtil.getWhereClause(toCMRField.getRelatedCMRField().getTableKeyFields(), relationTableAlias, buf);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1323 */     buf.append(')');
/*      */ 
/* 1325 */     return buf;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTValueClassComparison node, Object data)
/*      */   {
/* 1330 */     StringBuffer buf = (StringBuffer)data;
/*      */ 
/* 1332 */     boolean not = node.opp.equals("<>");
/* 1333 */     String comparison = node.opp;
/* 1334 */     buf.append('(');
/* 1335 */     if (not)
/*      */     {
/* 1337 */       buf.append(" NOT ").append('(');
/* 1338 */       comparison = "=";
/*      */     }
/*      */ 
/* 1342 */     ASTPath fromPath = (ASTPath)node.jjtGetChild(0);
/* 1343 */     addJoinPath(fromPath);
/* 1344 */     String fromAlias = this.aliasManager.getAlias(fromPath.getPath(fromPath.size() - 2));
/* 1345 */     JDBCCMPFieldBridge fromCMPField = (JDBCCMPFieldBridge)fromPath.getCMPField();
/*      */ 
/* 1347 */     Node toNode = node.jjtGetChild(1);
/* 1348 */     if ((toNode instanceof ASTParameter))
/*      */     {
/* 1350 */       ASTParameter toParam = (ASTParameter)toNode;
/*      */ 
/* 1353 */       Class parameterType = getParameterType(toParam.number);
/* 1354 */       if (!fromCMPField.getFieldType().equals(parameterType))
/*      */       {
/* 1356 */         throw new IllegalStateException("Only like types can be compared: from CMP field=" + fromCMPField.getFieldType() + " to parameter=" + parameterType);
/*      */       }
/*      */ 
/* 1362 */       this.inputParameters.addAll(QueryParameter.createParameters(toParam.number - 1, fromCMPField));
/* 1363 */       SQLUtil.getWhereClause(fromCMPField.getJDBCType(), fromAlias, comparison, buf);
/*      */     }
/*      */     else
/*      */     {
/* 1367 */       ASTPath toPath = (ASTPath)toNode;
/* 1368 */       addJoinPath(toPath);
/* 1369 */       String toAlias = this.aliasManager.getAlias(toPath.getPath(toPath.size() - 2));
/* 1370 */       JDBCCMPFieldBridge toCMPField = (JDBCCMPFieldBridge)toPath.getCMPField();
/*      */ 
/* 1373 */       if (!fromCMPField.getFieldType().equals(toCMPField.getFieldType()))
/*      */       {
/* 1375 */         throw new IllegalStateException("Only like types can be compared: from CMP field=" + fromCMPField.getFieldType() + " to CMP field=" + toCMPField.getFieldType());
/*      */       }
/*      */ 
/* 1381 */       SQLUtil.getSelfCompareWhereClause(fromCMPField, toCMPField, fromAlias, toAlias, comparison, buf);
/*      */     }
/*      */ 
/* 1384 */     return (not ? buf.append(')') : buf).append(')');
/*      */   }
/*      */ 
/*      */   public Object visit(ASTEntityComparison node, Object data)
/*      */   {
/* 1392 */     StringBuffer buf = (StringBuffer)data;
/* 1393 */     Node arg0 = node.jjtGetChild(0);
/* 1394 */     Node arg1 = node.jjtGetChild(1);
/* 1395 */     if (node.opp.equals("<>"))
/*      */     {
/* 1397 */       compareEntity(true, arg0, arg1, buf);
/*      */     }
/*      */     else
/*      */     {
/* 1401 */       compareEntity(false, arg0, arg1, buf);
/*      */     }
/* 1403 */     return buf;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTConcat node, Object data)
/*      */   {
/* 1411 */     StringBuffer buf = (StringBuffer)data;
/* 1412 */     JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("concat");
/* 1413 */     Object[] args = { new NodeStringWrapper(node.jjtGetChild(0)), new NodeStringWrapper(node.jjtGetChild(1)) };
/*      */ 
/* 1417 */     function.getFunctionSql(args, buf);
/* 1418 */     return buf;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTSubstring node, Object data)
/*      */   {
/* 1426 */     StringBuffer buf = (StringBuffer)data;
/* 1427 */     JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("substring");
/* 1428 */     Object[] args = { new NodeStringWrapper(node.jjtGetChild(0)), new NodeStringWrapper(node.jjtGetChild(1)), new NodeStringWrapper(node.jjtGetChild(2)) };
/*      */ 
/* 1433 */     function.getFunctionSql(args, buf);
/* 1434 */     return buf;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTLCase node, Object data)
/*      */   {
/* 1442 */     StringBuffer buf = (StringBuffer)data;
/* 1443 */     JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("lcase");
/* 1444 */     Object[] args = { new NodeStringWrapper(node.jjtGetChild(0)) };
/*      */ 
/* 1447 */     function.getFunctionSql(args, buf);
/* 1448 */     return buf;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTUCase node, Object data)
/*      */   {
/* 1456 */     StringBuffer buf = (StringBuffer)data;
/* 1457 */     JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("ucase");
/* 1458 */     Object[] args = { new NodeStringWrapper(node.jjtGetChild(0)) };
/*      */ 
/* 1461 */     function.getFunctionSql(args, buf);
/* 1462 */     return buf;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTLength node, Object data)
/*      */   {
/* 1470 */     StringBuffer buf = (StringBuffer)data;
/* 1471 */     JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("length");
/* 1472 */     Object[] args = { new NodeStringWrapper(node.jjtGetChild(0)) };
/*      */ 
/* 1475 */     function.getFunctionSql(args, buf);
/* 1476 */     return buf;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTLocate node, Object data)
/*      */   {
/* 1484 */     StringBuffer buf = (StringBuffer)data;
/*      */ 
/* 1486 */     JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("locate");
/* 1487 */     Object[] args = new Object[3];
/* 1488 */     args[0] = new NodeStringWrapper(node.jjtGetChild(0));
/* 1489 */     args[1] = new NodeStringWrapper(node.jjtGetChild(1));
/* 1490 */     if (node.jjtGetNumChildren() == 3)
/*      */     {
/* 1492 */       args[2] = new NodeStringWrapper(node.jjtGetChild(2));
/*      */     }
/*      */     else
/*      */     {
/* 1496 */       args[2] = "1";
/*      */     }
/*      */ 
/* 1500 */     function.getFunctionSql(args, buf);
/* 1501 */     return buf;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTAbs node, Object data)
/*      */   {
/* 1509 */     StringBuffer buf = (StringBuffer)data;
/* 1510 */     JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("abs");
/* 1511 */     Object[] args = { new NodeStringWrapper(node.jjtGetChild(0)) };
/*      */ 
/* 1514 */     function.getFunctionSql(args, buf);
/* 1515 */     return buf;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTMod node, Object data)
/*      */   {
/* 1523 */     StringBuffer buf = (StringBuffer)data;
/* 1524 */     JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("mod");
/* 1525 */     Object[] args = { new NodeStringWrapper(node.jjtGetChild(0)), new NodeStringWrapper(node.jjtGetChild(1)) };
/*      */ 
/* 1529 */     function.getFunctionSql(args, buf);
/* 1530 */     return buf;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTSqrt node, Object data)
/*      */   {
/* 1538 */     StringBuffer buf = (StringBuffer)data;
/* 1539 */     JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("sqrt");
/* 1540 */     Object[] args = { new NodeStringWrapper(node.jjtGetChild(0)) };
/*      */ 
/* 1543 */     function.getFunctionSql(args, buf);
/* 1544 */     return buf;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTCount node, Object data)
/*      */   {
/* 1549 */     StringBuffer buf = (StringBuffer)data;
/* 1550 */     node.setResultType(this.returnType);
/*      */ 
/* 1553 */     ASTPath cntPath = (ASTPath)node.jjtGetChild(0);
/*      */     Object[] args;
/*      */     Object[] args;
/* 1554 */     if (cntPath.isCMPField())
/*      */     {
/* 1556 */       args = new Object[] { node.distinct, new NodeStringWrapper(cntPath) };
/*      */     }
/*      */     else
/*      */     {
/* 1560 */       JDBCEntityBridge entity = (JDBCEntityBridge)cntPath.getEntity();
/* 1561 */       JDBCFieldBridge[] pkFields = entity.getPrimaryKeyFields();
/* 1562 */       if (pkFields.length > 1)
/*      */       {
/* 1564 */         this.countCompositePk = true;
/* 1565 */         this.forceDistinct = (node.distinct.length() > 0);
/* 1566 */         selectEntity(cntPath, this.forceDistinct, buf);
/* 1567 */         return buf;
/*      */       }
/*      */ 
/* 1572 */       String alias = this.aliasManager.getAlias(cntPath.getPath());
/* 1573 */       StringBuffer keyColumn = new StringBuffer(20);
/* 1574 */       SQLUtil.getColumnNamesClause(pkFields[0], alias, keyColumn);
/* 1575 */       args = new Object[] { node.distinct, keyColumn.toString() };
/*      */     }
/*      */ 
/* 1579 */     return JDBCTypeMappingMetaData.COUNT_FUNC.getFunctionSql(args, buf);
/*      */   }
/*      */ 
/*      */   public Object visit(ASTMax node, Object data)
/*      */   {
/* 1584 */     node.setResultType(this.returnType);
/* 1585 */     StringBuffer buf = (StringBuffer)data;
/* 1586 */     Object[] args = { node.distinct, new NodeStringWrapper(node.jjtGetChild(0)) };
/*      */ 
/* 1590 */     return JDBCTypeMappingMetaData.MAX_FUNC.getFunctionSql(args, buf);
/*      */   }
/*      */ 
/*      */   public Object visit(ASTMin node, Object data)
/*      */   {
/* 1595 */     node.setResultType(this.returnType);
/* 1596 */     StringBuffer buf = (StringBuffer)data;
/* 1597 */     Object[] args = { node.distinct, new NodeStringWrapper(node.jjtGetChild(0)) };
/*      */ 
/* 1601 */     return JDBCTypeMappingMetaData.MIN_FUNC.getFunctionSql(args, buf);
/*      */   }
/*      */ 
/*      */   public Object visit(ASTAvg node, Object data)
/*      */   {
/* 1606 */     node.setResultType(this.returnType);
/* 1607 */     StringBuffer buf = (StringBuffer)data;
/* 1608 */     Object[] args = { node.distinct, new NodeStringWrapper(node.jjtGetChild(0)) };
/*      */ 
/* 1612 */     return JDBCTypeMappingMetaData.AVG_FUNC.getFunctionSql(args, buf);
/*      */   }
/*      */ 
/*      */   public Object visit(ASTSum node, Object data)
/*      */   {
/* 1617 */     node.setResultType(this.returnType);
/* 1618 */     StringBuffer buf = (StringBuffer)data;
/* 1619 */     Object[] args = { node.distinct, new NodeStringWrapper(node.jjtGetChild(0)) };
/*      */ 
/* 1623 */     return JDBCTypeMappingMetaData.SUM_FUNC.getFunctionSql(args, buf);
/*      */   }
/*      */ 
/*      */   public Object visit(ASTPath node, Object data)
/*      */   {
/* 1631 */     StringBuffer buf = (StringBuffer)data;
/* 1632 */     if (!node.isCMPField())
/*      */     {
/* 1634 */       throw new IllegalStateException("Can only visit cmp valued path node. Should have been handled at a higher level.");
/*      */     }
/*      */ 
/* 1638 */     JDBCCMPFieldBridge cmpField = (JDBCCMPFieldBridge)node.getCMPField();
/*      */ 
/* 1641 */     switch (node.type)
/*      */     {
/*      */     case 5:
/*      */     case 6:
/* 1645 */       if ((cmpField.getJDBCType().hasMapper()) || (cmpField.getJDBCType().getParameterSetter() != null))
/*      */       {
/*      */         break;
/*      */       }
/*      */ 
/*      */     case -1:
/* 1651 */       throw new IllegalStateException("Can not visit multi-column path node. Should have been handled at a higher level.");
/*      */     }
/*      */ 
/* 1655 */     addJoinPath(node);
/* 1656 */     String alias = this.aliasManager.getAlias(node.getPath(node.size() - 2));
/* 1657 */     SQLUtil.getColumnNamesClause(cmpField, alias, buf);
/* 1658 */     return buf;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTAbstractSchema node, Object data)
/*      */   {
/* 1663 */     throw new IllegalStateException("Can not visit abstract schema node. Should have been handled at a higher level.");
/*      */   }
/*      */ 
/*      */   public Object visit(ASTParameter node, Object data)
/*      */   {
/* 1672 */     StringBuffer buf = (StringBuffer)data;
/* 1673 */     Class type = getParameterType(node.number);
/*      */ 
/* 1676 */     int ejbqlType = EJBQLTypes.getEJBQLType(type);
/* 1677 */     if ((ejbqlType == 5) || (ejbqlType == 6) || (ejbqlType == -1))
/*      */     {
/* 1681 */       throw new IllegalStateException("Can not visit multi-column parameter node. Should have been handled at a higher level.");
/*      */     }
/*      */ 
/* 1685 */     QueryParameter param = new QueryParameter(node.number - 1, this.typeFactory.getJDBCType(type));
/* 1686 */     this.inputParameters.add(param);
/* 1687 */     buf.append('?');
/* 1688 */     return buf;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTBooleanLiteral node, Object data)
/*      */   {
/* 1696 */     StringBuffer buf = (StringBuffer)data;
/* 1697 */     if (node.value)
/*      */     {
/* 1699 */       buf.append(this.typeMapping.getTrueMapping());
/*      */     }
/*      */     else
/*      */     {
/* 1703 */       buf.append(this.typeMapping.getFalseMapping());
/*      */     }
/* 1705 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTLimitOffset node, Object data)
/*      */   {
/* 1710 */     int child = 0;
/* 1711 */     if (node.hasOffset)
/*      */     {
/* 1713 */       Node offsetNode = node.jjtGetChild(child++);
/* 1714 */       if ((offsetNode instanceof ASTParameter))
/*      */       {
/* 1716 */         ASTParameter param = (ASTParameter)offsetNode;
/* 1717 */         Class parameterType = getParameterType(param.number);
/* 1718 */         if ((Integer.TYPE != parameterType) && (Integer.class != parameterType))
/*      */         {
/* 1720 */           throw new UnsupportedOperationException("OFFSET parameter must be an int");
/*      */         }
/* 1722 */         this.offsetParam = param.number;
/*      */       }
/*      */       else
/*      */       {
/* 1726 */         ASTExactNumericLiteral param = (ASTExactNumericLiteral)offsetNode;
/* 1727 */         this.offsetValue = (int)param.value;
/*      */       }
/*      */     }
/* 1730 */     if (node.hasLimit)
/*      */     {
/* 1732 */       Node limitNode = node.jjtGetChild(child);
/* 1733 */       if ((limitNode instanceof ASTParameter))
/*      */       {
/* 1735 */         ASTParameter param = (ASTParameter)limitNode;
/* 1736 */         Class parameterType = getParameterType(param.number);
/* 1737 */         if ((Integer.TYPE != parameterType) && (Integer.class != parameterType))
/*      */         {
/* 1739 */           throw new UnsupportedOperationException("LIMIT parameter must be an int");
/*      */         }
/* 1741 */         this.limitParam = param.number;
/*      */       }
/*      */       else
/*      */       {
/* 1745 */         ASTExactNumericLiteral param = (ASTExactNumericLiteral)limitNode;
/* 1746 */         this.limitValue = (int)param.value;
/*      */       }
/*      */     }
/* 1749 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTWhereConditionalTerm node, Object data)
/*      */   {
/* 1755 */     clearPerTermJoinPaths();
/*      */ 
/* 1757 */     StringBuffer buf = (StringBuffer)data;
/* 1758 */     buf.append('(');
/* 1759 */     for (int i = 0; i < node.jjtGetNumChildren(); i++)
/*      */     {
/* 1761 */       node.jjtGetChild(i).jjtAccept(this, data);
/*      */     }
/*      */ 
/* 1764 */     StringBuffer thetaJoin = new StringBuffer();
/* 1765 */     createThetaJoin(thetaJoin);
/*      */ 
/* 1767 */     if (thetaJoin.length() > 0)
/*      */     {
/* 1769 */       buf.append(" AND ").append(thetaJoin.toString());
/*      */     }
/*      */ 
/* 1772 */     buf.append(')');
/* 1773 */     return data;
/*      */   }
/*      */ 
/*      */   private ASTPath getPathFromChildren(Node selectFunction)
/*      */   {
/* 1806 */     for (int childInd = 0; childInd < selectFunction.jjtGetNumChildren(); childInd++)
/*      */     {
/* 1808 */       Node child = selectFunction.jjtGetChild(childInd);
/* 1809 */       if ((child instanceof ASTPath))
/*      */       {
/* 1811 */         return (ASTPath)child;
/*      */       }
/* 1813 */       if (!(child instanceof SelectFunction))
/*      */         continue;
/* 1815 */       Node path = getPathFromChildren(child);
/* 1816 */       if (path != null)
/*      */       {
/* 1818 */         return (ASTPath)path;
/*      */       }
/*      */     }
/*      */ 
/* 1822 */     return null;
/*      */   }
/*      */ 
/*      */   private boolean isSelected(ASTPath path)
/*      */   {
/* 1833 */     boolean selected = false;
/*      */ 
/* 1835 */     CMPFieldBridge cmpField = path.getCMPField();
/* 1836 */     if (((this.selectObject instanceof JDBCCMPFieldBridge)) && (cmpField == this.selectObject))
/*      */     {
/* 1838 */       selected = true;
/*      */     }
/* 1840 */     else if ((this.selectObject instanceof JDBCEntityBridge))
/*      */     {
/* 1842 */       JDBCEntityBridge entity = (JDBCEntityBridge)this.selectObject;
/* 1843 */       JDBCFieldBridge[] pkFields = entity.getPrimaryKeyFields();
/* 1844 */       for (int pkInd = 0; pkInd < pkFields.length; pkInd++)
/*      */       {
/* 1846 */         if (pkFields[pkInd] != cmpField)
/*      */           continue;
/* 1848 */         selected = true;
/* 1849 */         break;
/*      */       }
/*      */ 
/*      */     }
/* 1853 */     else if ((this.selectObject instanceof SelectFunction))
/*      */     {
/* 1855 */       Node funcNode = (Node)this.selectObject;
/* 1856 */       ASTPath fieldPath = getPathFromChildren(funcNode);
/* 1857 */       if (fieldPath.getCMPField() == cmpField)
/*      */       {
/* 1859 */         selected = true;
/*      */       }
/*      */     }
/*      */ 
/* 1863 */     return selected;
/*      */   }
/*      */ 
/*      */   private void selectEntity(ASTPath path, boolean distinct, StringBuffer buf)
/*      */   {
/* 1868 */     JDBCEntityBridge selectEntity = (JDBCEntityBridge)path.getEntity();
/*      */ 
/* 1870 */     StringBuffer columnNamesClause = new StringBuffer(200);
/* 1871 */     addJoinPath(path);
/* 1872 */     this.selectAlias = this.aliasManager.getAlias(path.getPath());
/*      */ 
/* 1876 */     SQLUtil.getColumnNamesClause(selectEntity.getPrimaryKeyFields(), this.selectAlias, columnNamesClause);
/*      */ 
/* 1878 */     if (this.readAhead.isOnFind())
/*      */     {
/* 1880 */       String eagerLoadGroupName = this.readAhead.getEagerLoadGroup();
/* 1881 */       boolean[] loadGroupMask = selectEntity.getLoadGroupMask(eagerLoadGroupName);
/* 1882 */       if (distinct)
/* 1883 */         SQLUtil.appendSearchableColumnNamesClause(selectEntity.getTableFields(), loadGroupMask, this.selectAlias, columnNamesClause);
/*      */       else {
/* 1885 */         SQLUtil.appendColumnNamesClause(selectEntity.getTableFields(), loadGroupMask, this.selectAlias, columnNamesClause);
/*      */       }
/*      */       try
/*      */       {
/* 1889 */         this.leftJoinCMRList = JDBCAbstractQueryCommand.getLeftJoinCMRNodes(selectEntity, path.getPath(), this.readAhead.getLeftJoins(), this.declaredPaths);
/*      */       }
/*      */       catch (DeploymentException e)
/*      */       {
/* 1894 */         throw new IllegalStateException(e.getMessage());
/*      */       }
/*      */ 
/* 1897 */       if (!this.leftJoinCMRList.isEmpty())
/*      */       {
/* 1899 */         this.onFindCMRJoin = new StringBuffer(100);
/* 1900 */         JDBCAbstractQueryCommand.leftJoinCMRNodes(this.selectAlias, this.leftJoinCMRList, this.aliasManager, this.onFindCMRJoin);
/* 1901 */         JDBCAbstractQueryCommand.appendLeftJoinCMRColumnNames(this.leftJoinCMRList, this.aliasManager, columnNamesClause);
/*      */       }
/*      */     }
/* 1904 */     buf.append(columnNamesClause);
/*      */   }
/*      */ 
/*      */   private void addJoinPath(ASTPath path)
/*      */   {
/* 1909 */     this.ctermJoinPaths.add(path);
/* 1910 */     this.allJoinPaths.add(path);
/*      */   }
/*      */ 
/*      */   private void addCollectionMemberJoinPath(String alias, ASTPath path)
/*      */   {
/* 1915 */     this.ctermCollectionMemberJoinPaths.put(alias, path);
/* 1916 */     this.allCollectionMemberJoinPaths.put(alias, path);
/*      */   }
/*      */ 
/*      */   private void addLeftJoinPath(String pathStr, ASTPath path)
/*      */   {
/* 1921 */     Set set = (Set)this.ctermLeftJoinPaths.get(pathStr);
/* 1922 */     if (set == null)
/*      */     {
/* 1924 */       set = new HashSet();
/* 1925 */       this.ctermLeftJoinPaths.put(pathStr, set);
/*      */     }
/* 1927 */     set.add(path);
/*      */ 
/* 1929 */     set = (Set)this.allLeftJoinPaths.get(pathStr);
/* 1930 */     if (set == null)
/*      */     {
/* 1932 */       set = new HashSet();
/* 1933 */       this.allLeftJoinPaths.put(pathStr, set);
/*      */     }
/* 1935 */     set.add(path);
/*      */   }
/*      */ 
/*      */   private void clearPerTermJoinPaths()
/*      */   {
/* 1940 */     this.ctermJoinPaths.clear();
/* 1941 */     this.ctermCollectionMemberJoinPaths.clear();
/* 1942 */     this.ctermLeftJoinPaths.clear();
/*      */   }
/*      */ 
/*      */   private boolean isDistinct(Node selectNode)
/*      */   {
/* 1947 */     return (((ASTSelect)selectNode).distinct) || (this.returnType.equals(Set.class)) || (this.forceDistinct);
/*      */   }
/*      */ 
/*      */   private final class NodeStringWrapper
/*      */   {
/*      */     final Node node;
/*      */ 
/*      */     public NodeStringWrapper(Node node)
/*      */     {
/* 1789 */       this.node = node;
/*      */     }
/*      */ 
/*      */     public String toString()
/*      */     {
/* 1794 */       return this.node.jjtAccept(JDBCEJBQLCompiler.this, new StringBuffer()).toString();
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCEJBQLCompiler
 * JD-Core Version:    0.6.0
 */