/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.Principal;
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.SQLException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Date;
/*     */ import java.util.List;
/*     */ import javax.ejb.CreateException;
/*     */ import javax.ejb.EJBContext;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.sql.DataSource;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMRFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.ConfigurationMetaData;
/*     */ import org.jboss.mx.util.MBeanProxyExt;
/*     */ import org.jboss.security.AuthenticationManager;
/*     */ 
/*     */ public abstract class JDBCAbstractCreateCommand
/*     */   implements JDBCCreateCommand
/*     */ {
/*     */   protected Logger log;
/*     */   protected boolean debug;
/*     */   protected boolean trace;
/*     */   protected JDBCEntityBridge entity;
/*     */   protected AuthenticationManager securityManager;
/*     */   protected boolean createAllowed;
/*     */   protected SQLExceptionProcessorMBean exceptionProcessor;
/*     */   protected String insertSQL;
/*     */   protected JDBCFieldBridge[] insertFields;
/*     */   protected boolean insertAfterEjbPostCreate;
/*     */   private JDBCCMPFieldBridge createdPrincipal;
/*     */   private JDBCCMPFieldBridge createdTime;
/*     */   private JDBCCMPFieldBridge updatedPrincipal;
/*     */   private JDBCCMPFieldBridge updatedTime;
/*     */ 
/*     */   public void init(JDBCStoreManager manager)
/*     */     throws DeploymentException
/*     */   {
/*  74 */     this.log = Logger.getLogger(getClass().getName() + '.' + manager.getMetaData().getName());
/*  75 */     this.debug = this.log.isDebugEnabled();
/*  76 */     this.trace = this.log.isTraceEnabled();
/*     */ 
/*  78 */     this.entity = ((JDBCEntityBridge)manager.getEntityBridge());
/*  79 */     this.securityManager = manager.getContainer().getSecurityManager();
/*     */ 
/*  81 */     this.insertAfterEjbPostCreate = manager.getContainer().getBeanMetaData().getContainerConfiguration().isInsertAfterEjbPostCreate();
/*     */ 
/*  85 */     this.createAllowed = true;
/*  86 */     JDBCFieldBridge[] pkFields = this.entity.getPrimaryKeyFields();
/*  87 */     for (int i = 0; i < pkFields.length; i++)
/*     */     {
/*  89 */       if (!pkFields[i].isReadOnly())
/*     */         continue;
/*  91 */       this.createAllowed = false;
/*  92 */       this.log.debug("Create will not be allowed because pk field " + pkFields[i].getFieldName() + "is read only.");
/*     */ 
/*  94 */       break;
/*     */     }
/*     */ 
/*  98 */     initGeneratedFields();
/*     */ 
/* 100 */     JDBCEntityCommandMetaData entityCommand = manager.getMetaData().getEntityCommand();
/* 101 */     if (entityCommand == null)
/*     */     {
/* 103 */       throw new DeploymentException("entity-command is null");
/*     */     }
/* 105 */     initEntityCommand(entityCommand);
/*     */ 
/* 107 */     initInsertFields();
/* 108 */     initInsertSQL();
/*     */   }
/*     */ 
/*     */   protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) throws DeploymentException
/*     */   {
/* 113 */     String objectName = entityCommand.getAttribute("SQLExceptionProcessor");
/* 114 */     if (objectName != null)
/*     */     {
/*     */       try
/*     */       {
/* 118 */         this.exceptionProcessor = ((SQLExceptionProcessorMBean)MBeanProxyExt.create(SQLExceptionProcessorMBean.class, objectName));
/*     */       }
/*     */       catch (MalformedObjectNameException e)
/*     */       {
/* 122 */         throw new DeploymentException("Invalid object name for SQLExceptionProcessor: ", e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object execute(Method m, Object[] args, EntityEnterpriseContext ctx)
/*     */     throws CreateException
/*     */   {
/* 130 */     if (this.insertAfterEjbPostCreate)
/*     */     {
/* 132 */       if (!JDBCEntityBridge.isEjbCreateDone(ctx))
/*     */       {
/* 134 */         checkCreateAllowed();
/* 135 */         generateFields(ctx);
/* 136 */         JDBCEntityBridge.setEjbCreateDone(ctx);
/*     */       }
/*     */       else
/*     */       {
/* 140 */         beforeInsert(ctx);
/* 141 */         performInsert(ctx);
/* 142 */         afterInsert(ctx);
/* 143 */         JDBCEntityBridge.setCreated(ctx);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 148 */       checkCreateAllowed();
/* 149 */       generateFields(ctx);
/* 150 */       beforeInsert(ctx);
/* 151 */       performInsert(ctx);
/* 152 */       afterInsert(ctx);
/* 153 */       JDBCEntityBridge.setCreated(ctx);
/*     */     }
/* 155 */     return getPrimaryKey(ctx);
/*     */   }
/*     */ 
/*     */   protected void checkCreateAllowed() throws CreateException
/*     */   {
/* 160 */     if (!this.createAllowed)
/*     */     {
/* 162 */       throw new CreateException("Creation is not allowed because a primary key field is read only.");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected JDBCCMPFieldBridge getGeneratedPKField()
/*     */     throws DeploymentException
/*     */   {
/* 169 */     JDBCCMPFieldBridge pkField = null;
/* 170 */     JDBCFieldBridge[] pkFields = this.entity.getPrimaryKeyFields();
/* 171 */     for (int i = 0; i < pkFields.length; i++)
/*     */     {
/* 173 */       if (pkField != null)
/* 174 */         throw new DeploymentException("Generation only supported with single PK field");
/* 175 */       pkField = (JDBCCMPFieldBridge)pkFields[i];
/*     */     }
/* 177 */     return pkField;
/*     */   }
/*     */ 
/*     */   protected void initGeneratedFields() throws DeploymentException
/*     */   {
/* 182 */     this.createdPrincipal = this.entity.getCreatedPrincipalField();
/* 183 */     if ((this.securityManager == null) && (this.createdPrincipal != null))
/*     */     {
/* 185 */       throw new DeploymentException("No security-domain configured but created-by specified");
/*     */     }
/* 187 */     this.updatedPrincipal = this.entity.getUpdatedPrincipalField();
/* 188 */     if ((this.securityManager == null) && (this.updatedPrincipal != null))
/*     */     {
/* 190 */       throw new DeploymentException("No security-domain configured but updated-by specified");
/*     */     }
/* 192 */     this.createdTime = this.entity.getCreatedTimeField();
/* 193 */     this.updatedTime = this.entity.getUpdatedTimeField();
/*     */   }
/*     */ 
/*     */   protected void generateFields(EntityEnterpriseContext ctx)
/*     */     throws CreateException
/*     */   {
/* 199 */     if (this.securityManager != null)
/*     */     {
/* 201 */       String principalName = ctx.getEJBContext().getCallerPrincipal().getName();
/* 202 */       if ((this.createdPrincipal != null) && (this.createdPrincipal.getInstanceValue(ctx) == null))
/*     */       {
/* 204 */         this.createdPrincipal.setInstanceValue(ctx, principalName);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 215 */     Date date = null;
/* 216 */     if ((this.createdTime != null) && (this.createdTime.getInstanceValue(ctx) == null))
/*     */     {
/* 218 */       date = new Date();
/* 219 */       this.createdTime.setInstanceValue(ctx, date);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void initInsertFields()
/*     */   {
/* 233 */     JDBCFieldBridge[] fields = this.entity.getTableFields();
/* 234 */     List insertFieldsList = new ArrayList(fields.length);
/* 235 */     for (int i = 0; i < fields.length; i++)
/*     */     {
/* 237 */       JDBCFieldBridge field = fields[i];
/* 238 */       if (isInsertField(field)) {
/* 239 */         insertFieldsList.add(field);
/*     */       }
/*     */     }
/* 242 */     this.insertFields = ((JDBCFieldBridge[])(JDBCFieldBridge[])insertFieldsList.toArray(new JDBCFieldBridge[insertFieldsList.size()]));
/*     */   }
/*     */ 
/*     */   protected boolean isInsertField(JDBCFieldBridge field)
/*     */   {
/* 247 */     boolean result = (!(field instanceof JDBCCMRFieldBridge)) && (field.getJDBCType() != null) && (!field.isReadOnly());
/*     */ 
/* 251 */     if ((field instanceof JDBCCMPFieldBridge))
/* 252 */       result = (result) && (!((JDBCCMPFieldBridge)field).isRelationTableField());
/* 253 */     return result;
/*     */   }
/*     */ 
/*     */   protected void initInsertSQL()
/*     */   {
/* 258 */     StringBuffer sql = new StringBuffer(250);
/* 259 */     sql.append("INSERT INTO ").append(this.entity.getQualifiedTableName()).append(" (");
/*     */ 
/* 263 */     SQLUtil.getColumnNamesClause(this.insertFields, sql);
/*     */ 
/* 265 */     sql.append(')').append(" VALUES ").append('(');
/*     */ 
/* 267 */     SQLUtil.getValuesClause(this.insertFields, sql).append(')');
/*     */ 
/* 269 */     this.insertSQL = sql.toString();
/*     */ 
/* 271 */     if (this.debug)
/* 272 */       this.log.debug("Insert Entity SQL: " + this.insertSQL);
/*     */   }
/*     */ 
/*     */   protected void beforeInsert(EntityEnterpriseContext ctx) throws CreateException
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void performInsert(EntityEnterpriseContext ctx) throws CreateException
/*     */   {
/* 281 */     Connection c = null;
/* 282 */     PreparedStatement ps = null;
/* 283 */     boolean throwRuntimeExceptions = this.entity.getMetaData().getThrowRuntimeExceptions();
/*     */ 
/* 287 */     if (throwRuntimeExceptions)
/*     */     {
/*     */       try
/*     */       {
/* 291 */         c = this.entity.getDataSource().getConnection();
/*     */       }
/*     */       catch (SQLException sqle)
/*     */       {
/* 295 */         EJBException ejbe = new EJBException("Could not get a connection; " + sqle);
/* 296 */         ejbe.initCause(sqle);
/* 297 */         throw ejbe;
/*     */       }
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 303 */       if (this.debug) {
/* 304 */         this.log.debug("Executing SQL: " + this.insertSQL);
/*     */       }
/*     */ 
/* 308 */       if (!throwRuntimeExceptions)
/*     */       {
/* 310 */         c = this.entity.getDataSource().getConnection();
/*     */       }
/* 312 */       ps = prepareStatement(c, this.insertSQL, ctx);
/*     */ 
/* 315 */       int index = 1;
/* 316 */       for (int fieldInd = 0; fieldInd < this.insertFields.length; fieldInd++)
/*     */       {
/* 318 */         index = this.insertFields[fieldInd].setInstanceParameters(ps, index, ctx);
/*     */       }
/*     */ 
/* 322 */       int rowsAffected = executeInsert(index, ps, ctx);
/* 323 */       if (rowsAffected != 1)
/*     */       {
/* 325 */         throw new CreateException("Expected one affected row but update returned" + rowsAffected + " for id=" + ctx.getId());
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (SQLException e)
/*     */     {
/* 331 */       if ((this.exceptionProcessor != null) && (this.exceptionProcessor.isDuplicateKey(e)))
/*     */       {
/* 333 */         this.log.error("Failed to create instance.", e);
/* 334 */         throw new CreateException("Integrity constraint violation. Possibly unique key violation or invalid foreign key value.");
/*     */       }
/*     */ 
/* 340 */       this.log.error("Could not create entity", e);
/* 341 */       CreateException ce = new CreateException("Could not create entity: " + e);
/* 342 */       ce.initCause(e);
/* 343 */       throw ce;
/*     */     }
/*     */     finally
/*     */     {
/* 348 */       JDBCUtil.safeClose(ps);
/* 349 */       JDBCUtil.safeClose(c);
/*     */     }
/*     */ 
/* 353 */     for (int fieldInd = 0; fieldInd < this.insertFields.length; fieldInd++)
/*     */     {
/* 355 */       this.insertFields[fieldInd].setClean(ctx);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected PreparedStatement prepareStatement(Connection c, String sql, EntityEnterpriseContext ctx) throws SQLException
/*     */   {
/* 361 */     return c.prepareStatement(sql);
/*     */   }
/*     */ 
/*     */   protected int executeInsert(int paramIndex, PreparedStatement ps, EntityEnterpriseContext ctx) throws SQLException
/*     */   {
/* 366 */     return ps.executeUpdate();
/*     */   }
/*     */ 
/*     */   protected void afterInsert(EntityEnterpriseContext ctx) throws CreateException
/*     */   {
/*     */   }
/*     */ 
/*     */   protected Object getPrimaryKey(EntityEnterpriseContext ctx)
/*     */   {
/* 375 */     return this.entity.extractPrimaryKeyFromInstance(ctx);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCAbstractCreateCommand
 * JD-Core Version:    0.6.0
 */