/*    */ package org.jboss.ejb.plugins.cmp.ejbql;
/*    */ 
/*    */ import java.util.HashMap;
/*    */ import java.util.List;
/*    */ import java.util.Map;
/*    */ import org.jboss.ejb.plugins.cmp.bridge.CMRFieldBridge;
/*    */ import org.jboss.ejb.plugins.cmp.bridge.EntityBridge;
/*    */ 
/*    */ public final class IdentifierManager
/*    */ {
/*    */   private final Catalog catalog;
/* 39 */   private final Map pathLists = new HashMap();
/* 40 */   private final Map fieldLists = new HashMap();
/* 41 */   private final Map identifiers = new HashMap();
/*    */ 
/*    */   public IdentifierManager(Catalog catalog) {
/* 44 */     this.catalog = catalog;
/*    */   }
/*    */ 
/*    */   public void declareRangeVariable(String identifier, String abstractSchemaName)
/*    */   {
/* 51 */     this.identifiers.put(identifier, this.catalog.getEntityByAbstractSchemaName(abstractSchemaName));
/*    */   }
/*    */ 
/*    */   public void declareCollectionMember(String identifier, String path)
/*    */   {
/* 60 */     List fieldList = (List)this.fieldLists.get(path);
/* 61 */     Object field = fieldList.get(fieldList.size() - 1);
/* 62 */     if (!(field instanceof CMRFieldBridge)) {
/* 63 */       throw new IllegalArgumentException("Path is collection valued: " + path);
/*    */     }
/* 65 */     CMRFieldBridge cmrField = (CMRFieldBridge)field;
/* 66 */     if (cmrField.isSingleValued()) {
/* 67 */       throw new IllegalArgumentException("Path is collection valued: " + path);
/*    */     }
/* 69 */     this.identifiers.put(identifier, cmrField.getRelatedEntity());
/*    */   }
/*    */ 
/*    */   public EntityBridge getEntity(String identificationVariable) {
/* 73 */     return (EntityBridge)this.identifiers.get(identificationVariable);
/*    */   }
/*    */ 
/*    */   public void registerPath(String path, List pathList, List fieldList)
/*    */   {
/* 81 */     if (pathList.size() != fieldList.size()) {
/* 82 */       throw new IllegalArgumentException("Path list and field list must have the same size: pathList.size=" + pathList.size() + " fieldList.size=" + fieldList.size());
/*    */     }
/*    */ 
/* 86 */     this.pathLists.put(path, pathList);
/* 87 */     this.fieldLists.put(path, fieldList);
/*    */   }
/*    */ 
/*    */   public List getPathList(String path) {
/* 91 */     return (List)this.pathLists.get(path);
/*    */   }
/*    */ 
/*    */   public List getFieldList(String path) {
/* 95 */     return (List)this.fieldLists.get(path);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.ejbql.IdentifierManager
 * JD-Core Version:    0.6.0
 */