/*     */ package org.jboss.ejb.plugins.cmp.ejbql;
/*     */ 
/*     */ import java.util.List;
/*     */ import org.jboss.ejb.plugins.cmp.bridge.CMPFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.bridge.CMRFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.bridge.EntityBridge;
/*     */ import org.jboss.ejb.plugins.cmp.bridge.FieldBridge;
/*     */ 
/*     */ public final class ASTPath extends SimpleNode
/*     */ {
/*     */   public List pathList;
/*     */   public List fieldList;
/*     */   public int type;
/*     */   public boolean innerJoin;
/*     */ 
/*     */   public ASTPath(int id)
/*     */   {
/*  47 */     super(id);
/*     */   }
/*     */ 
/*     */   public String getPath()
/*     */   {
/*  52 */     return (String)this.pathList.get(this.pathList.size() - 1);
/*     */   }
/*     */ 
/*     */   public String getPath(int i)
/*     */   {
/*  57 */     return (String)this.pathList.get(i);
/*     */   }
/*     */ 
/*     */   public FieldBridge getField()
/*     */   {
/*  62 */     return (FieldBridge)this.fieldList.get(this.fieldList.size() - 1);
/*     */   }
/*     */ 
/*     */   public boolean isCMPField()
/*     */   {
/*  67 */     return this.fieldList.get(this.fieldList.size() - 1) instanceof CMPFieldBridge;
/*     */   }
/*     */ 
/*     */   public CMPFieldBridge getCMPField()
/*     */   {
/*  72 */     return (CMPFieldBridge)this.fieldList.get(this.fieldList.size() - 1);
/*     */   }
/*     */ 
/*     */   public boolean isCMRField()
/*     */   {
/*  77 */     return this.fieldList.get(this.fieldList.size() - 1) instanceof CMRFieldBridge;
/*     */   }
/*     */ 
/*     */   public boolean isCMRField(int i)
/*     */   {
/*  82 */     return this.fieldList.get(i) instanceof CMRFieldBridge;
/*     */   }
/*     */ 
/*     */   public CMRFieldBridge getCMRField()
/*     */   {
/*  87 */     return (CMRFieldBridge)this.fieldList.get(this.fieldList.size() - 1);
/*     */   }
/*     */ 
/*     */   public CMRFieldBridge getCMRField(int i)
/*     */   {
/*  92 */     return (CMRFieldBridge)this.fieldList.get(i);
/*     */   }
/*     */ 
/*     */   public EntityBridge getEntity()
/*     */   {
/*  97 */     Object field = this.fieldList.get(this.fieldList.size() - 1);
/*  98 */     if ((field instanceof CMRFieldBridge))
/*     */     {
/* 100 */       return ((CMRFieldBridge)field).getRelatedEntity();
/*     */     }
/* 102 */     if ((field instanceof EntityBridge))
/*     */     {
/* 104 */       return (EntityBridge)field;
/*     */     }
/*     */ 
/* 108 */     return null;
/*     */   }
/*     */ 
/*     */   public EntityBridge getEntity(int i)
/*     */   {
/* 114 */     Object field = this.fieldList.get(i);
/* 115 */     if ((field instanceof CMRFieldBridge))
/*     */     {
/* 117 */       return ((CMRFieldBridge)field).getRelatedEntity();
/*     */     }
/* 119 */     if ((field instanceof EntityBridge))
/*     */     {
/* 121 */       return (EntityBridge)field;
/*     */     }
/*     */ 
/* 125 */     return null;
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 131 */     return this.fieldList.size();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 136 */     return this.pathList.get(this.pathList.size() - 1) + " <" + this.type + ">";
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/* 141 */     if ((o instanceof ASTPath))
/*     */     {
/* 143 */       ASTPath path = (ASTPath)o;
/* 144 */       return path.getPath().equals(getPath());
/*     */     }
/* 146 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 151 */     return getPath().hashCode();
/*     */   }
/*     */ 
/*     */   public Object jjtAccept(JBossQLParserVisitor visitor, Object data)
/*     */   {
/* 159 */     return visitor.visit(this, data);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.ejbql.ASTPath
 * JD-Core Version:    0.6.0
 */