/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.Interceptor;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.InvocationKey;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.naming.ENCThreadLocalKey;
/*     */ 
/*     */ public class ProxyFactoryFinderInterceptor extends AbstractInterceptor
/*     */ {
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void setProxyFactory(String invokerBinding, Invocation mi)
/*     */     throws Exception
/*     */   {
/*  49 */     if (invokerBinding == null)
/*     */     {
/*  51 */       this.log.trace("invokerBInding is null in ProxyFactoryFinder");
/*  52 */       return;
/*     */     }
/*     */ 
/*  66 */     Object proxyFactory = this.container.lookupProxyFactory(invokerBinding);
/*  67 */     if (proxyFactory == null)
/*     */     {
/*     */       String methodName;
/*     */       String methodName;
/*  70 */       if (mi.getMethod() != null) {
/*  71 */         methodName = mi.getMethod().getName();
/*     */       }
/*     */       else {
/*  74 */         methodName = "<no method>";
/*     */       }
/*     */ 
/*  77 */       this.log.error("***************** proxyFactory is null ********");
/*  78 */       this.log.error("Method name: " + methodName);
/*  79 */       this.log.error("jmx name: " + this.container.getJmxName().toString());
/*  80 */       this.log.error("invokerBinding: " + invokerBinding);
/*  81 */       this.log.error("Stack trace", new Throwable());
/*  82 */       this.log.error("*************************");
/*  83 */       throw new EJBException("Couldn't find proxy factory");
/*     */     }
/*  85 */     this.container.setProxyFactory(proxyFactory);
/*     */   }
/*     */ 
/*     */   public Object invokeHome(Invocation mi)
/*     */     throws Exception
/*     */   {
/*  91 */     String invokerBinding = (String)mi.getAsIsValue(InvocationKey.INVOKER_PROXY_BINDING);
/*     */ 
/*  93 */     setProxyFactory(invokerBinding, mi);
/*     */ 
/*  95 */     String oldInvokerBinding = ENCThreadLocalKey.getKey();
/*     */ 
/*  98 */     if ((invokerBinding != null) || (oldInvokerBinding == null))
/*     */     {
/* 100 */       ENCThreadLocalKey.setKey(invokerBinding);
/*     */     }
/*     */ 
/* 103 */     Interceptor next = getNext();
/* 104 */     Object value = null;
/*     */     try
/*     */     {
/* 107 */       value = next.invokeHome(mi);
/*     */     }
/*     */     finally
/*     */     {
/* 111 */       ENCThreadLocalKey.setKey(oldInvokerBinding);
/*     */     }
/*     */ 
/* 116 */     return value;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation mi)
/*     */     throws Exception
/*     */   {
/* 122 */     String invokerBinding = (String)mi.getAsIsValue(InvocationKey.INVOKER_PROXY_BINDING);
/*     */ 
/* 124 */     setProxyFactory(invokerBinding, mi);
/*     */ 
/* 126 */     String oldInvokerBinding = ENCThreadLocalKey.getKey();
/*     */ 
/* 129 */     if ((invokerBinding != null) || (oldInvokerBinding == null))
/*     */     {
/* 131 */       ENCThreadLocalKey.setKey(invokerBinding);
/*     */     }
/*     */ 
/* 134 */     Interceptor next = getNext();
/* 135 */     Object value = null;
/*     */     try
/*     */     {
/* 138 */       value = next.invoke(mi);
/*     */     }
/*     */     finally
/*     */     {
/* 142 */       ENCThreadLocalKey.setKey(oldInvokerBinding);
/*     */     }
/*     */ 
/* 147 */     return value;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.ProxyFactoryFinderInterceptor
 * JD-Core Version:    0.6.0
 */