/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.RemoteException;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.Interceptor;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.CMRInvocation;
/*     */ import org.jboss.ejb.plugins.lock.Entrancy;
/*     */ import org.jboss.ejb.plugins.lock.NonReentrantLock;
/*     */ import org.jboss.ejb.plugins.lock.NonReentrantLock.ReentranceException;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.InvocationType;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.EntityMetaData;
/*     */ 
/*     */ public class EntityReentranceInterceptor extends AbstractInterceptor
/*     */ {
/*  56 */   protected boolean reentrant = false;
/*     */   private static final Method getEJBHome;
/*     */   private static final Method getHandle;
/*     */   private static final Method getPrimaryKey;
/*     */   private static final Method isIdentical;
/*     */   private static final Method remove;
/*     */ 
/*     */   public void setContainer(Container container)
/*     */   {
/*  62 */     super.setContainer(container);
/*  63 */     if (container != null)
/*     */     {
/*  65 */       EntityMetaData meta = (EntityMetaData)container.getBeanMetaData();
/*  66 */       this.reentrant = meta.isReentrant();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected boolean isTxExpired(Transaction miTx)
/*     */     throws Exception
/*     */   {
/*  74 */     return (miTx != null) && (miTx.getStatus() == 1);
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation mi)
/*     */     throws Exception
/*     */   {
/*  83 */     EntityEnterpriseContext ctx = (EntityEnterpriseContext)mi.getEnterpriseContext();
/*  84 */     boolean nonReentrant = (!this.reentrant) && (!isReentrantMethod(mi));
/*     */ 
/*  87 */     NonReentrantLock methodLock = ctx.getMethodLock();
/*  88 */     Transaction miTx = ctx.getTransaction();
/*  89 */     boolean locked = false;
/*     */     try
/*     */     {
/*  92 */       while (!locked)
/*     */       {
/*  94 */         if (methodLock.attempt(5000L, miTx, nonReentrant))
/*     */         {
/*  96 */           locked = true; continue;
/*     */         }
/*     */ 
/* 100 */         if (!isTxExpired(miTx))
/*     */           continue;
/* 102 */         this.log.error("Saw rolled back tx=" + miTx);
/* 103 */         throw new RuntimeException("Transaction marked for rollback, possibly a timeout");
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (NonReentrantLock.ReentranceException re)
/*     */     {
/* 110 */       if (mi.getType() == InvocationType.REMOTE)
/*     */       {
/* 112 */         throw new RemoteException("Reentrant method call detected: " + this.container.getBeanMetaData().getEjbName() + " " + ctx.getId().toString());
/*     */       }
/*     */ 
/* 118 */       throw new EJBException("Reentrant method call detected: " + this.container.getBeanMetaData().getEjbName() + " " + ctx.getId().toString());
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 125 */       ctx.lock();
/* 126 */       re = getNext().invoke(mi);
/*     */     }
/*     */     finally
/*     */     {
/* 130 */       ctx.unlock();
/* 131 */       methodLock.release(nonReentrant);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected boolean isReentrantMethod(Invocation mi)
/*     */   {
/* 164 */     Method m = mi.getMethod();
/* 165 */     if ((m != null) && ((m.equals(getEJBHome)) || (m.equals(getHandle)) || (m.equals(getPrimaryKey)) || (m.equals(isIdentical)) || (m.equals(remove))))
/*     */     {
/* 172 */       return true;
/*     */     }
/*     */ 
/* 176 */     if ((mi instanceof CMRInvocation))
/*     */     {
/* 178 */       Entrancy entrancy = ((CMRInvocation)mi).getEntrancy();
/* 179 */       if (entrancy == Entrancy.NON_ENTRANT)
/*     */       {
/* 181 */         this.log.trace("NON_ENTRANT invocation");
/* 182 */         return true;
/*     */       }
/*     */     }
/*     */ 
/* 186 */     return false;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/* 147 */       Class[] noArg = new Class[0];
/* 148 */       getEJBHome = EJBObject.class.getMethod("getEJBHome", noArg);
/* 149 */       getHandle = EJBObject.class.getMethod("getHandle", noArg);
/* 150 */       getPrimaryKey = EJBObject.class.getMethod("getPrimaryKey", noArg);
/* 151 */       isIdentical = EJBObject.class.getMethod("isIdentical", new Class[] { EJBObject.class });
/* 152 */       remove = EJBObject.class.getMethod("remove", noArg);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 156 */       e.printStackTrace();
/* 157 */       throw new ExceptionInInitializerError(e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.EntityReentranceInterceptor
 * JD-Core Version:    0.6.0
 */