/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.rmi.NoSuchObjectException;
/*     */ import java.rmi.RemoteException;
/*     */ import org.jboss.ejb.BeanLockManager;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EnterpriseContext;
/*     */ import org.jboss.ejb.EntityCache;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.EntityPersistenceManager;
/*     */ import org.jboss.ejb.GlobalTxEntityMap;
/*     */ import org.jboss.ejb.InstancePool;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.ConfigurationMetaData;
/*     */ import org.jboss.metadata.EntityMetaData;
/*     */ import org.jboss.util.propertyeditor.PropertyEditors;
/*     */ 
/*     */ public class EntityInstanceCache extends AbstractInstanceCache
/*     */   implements EntityCache, EntityInstanceCacheMBean
/*     */ {
/*     */   private EntityContainer m_container;
/*     */ 
/*     */   public void setContainer(Container c)
/*     */   {
/*  63 */     this.m_container = ((EntityContainer)c);
/*     */   }
/*     */ 
/*     */   public Object createCacheKey(Object id)
/*     */   {
/*  69 */     return id;
/*     */   }
/*     */ 
/*     */   public EnterpriseContext get(Object id)
/*     */     throws RemoteException, NoSuchObjectException
/*     */   {
/*  76 */     EnterpriseContext rtn = null;
/*  77 */     rtn = super.get(id);
/*  78 */     return rtn;
/*     */   }
/*     */ 
/*     */   public void remove(String id)
/*     */     throws Exception
/*     */   {
/*  87 */     EntityMetaData metaData = (EntityMetaData)this.m_container.getBeanMetaData();
/*  88 */     String primKeyClass = metaData.getPrimaryKeyClass();
/*  89 */     Object key = PropertyEditors.convertValue(id, primKeyClass);
/*  90 */     remove(key);
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*  95 */     synchronized (this)
/*     */     {
/*  97 */       this.m_container = null;
/*     */     }
/*  99 */     super.destroy();
/*     */   }
/*     */ 
/*     */   protected Object getKey(EnterpriseContext ctx)
/*     */   {
/* 104 */     return ((EntityEnterpriseContext)ctx).getCacheKey();
/*     */   }
/*     */ 
/*     */   protected void setKey(Object id, EnterpriseContext ctx)
/*     */   {
/* 109 */     ((EntityEnterpriseContext)ctx).setCacheKey(id);
/* 110 */     ctx.setId(id);
/*     */   }
/*     */ 
/*     */   protected synchronized Container getContainer()
/*     */   {
/* 115 */     return this.m_container;
/*     */   }
/*     */ 
/*     */   protected void passivate(EnterpriseContext ctx) throws RemoteException
/*     */   {
/* 120 */     this.m_container.getPersistenceManager().passivateEntity((EntityEnterpriseContext)ctx);
/*     */   }
/*     */ 
/*     */   protected void activate(EnterpriseContext ctx) throws RemoteException
/*     */   {
/* 125 */     this.m_container.getPersistenceManager().activateEntity((EntityEnterpriseContext)ctx);
/*     */   }
/*     */ 
/*     */   protected EnterpriseContext acquireContext() throws Exception
/*     */   {
/* 130 */     return this.m_container.getInstancePool().get();
/*     */   }
/*     */ 
/*     */   protected void freeContext(EnterpriseContext ctx)
/*     */   {
/* 135 */     this.m_container.getInstancePool().free(ctx);
/*     */   }
/*     */ 
/*     */   protected boolean canPassivate(EnterpriseContext ctx)
/*     */   {
/* 140 */     if (ctx.isLocked())
/*     */     {
/* 143 */       return false;
/*     */     }
/*     */ 
/* 146 */     if (ctx.getTransaction() != null)
/*     */     {
/* 148 */       return false;
/*     */     }
/*     */ 
/* 151 */     Object key = ((EntityEnterpriseContext)ctx).getCacheKey();
/* 152 */     return this.m_container.getLockManager().canPassivate(key);
/*     */   }
/*     */ 
/*     */   protected void unableToPassivateDueToCtxLock(EnterpriseContext ctx, boolean passivateAfterCommit)
/*     */   {
/* 161 */     EntityEnterpriseContext ectx = (EntityEnterpriseContext)ctx;
/* 162 */     ectx.setPassivateAfterCommit(passivateAfterCommit);
/* 163 */     ConfigurationMetaData config = this.m_container.getBeanMetaData().getContainerConfiguration();
/* 164 */     if ((!config.isStoreNotFlushed()) && (ectx.hasTxSynchronization()))
/*     */     {
/* 166 */       ectx.setTxAssociation(GlobalTxEntityMap.PREVENT_SYNC);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.EntityInstanceCache
 * JD-Core Version:    0.6.0
 */