/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.io.BufferedInputStream;
/*     */ import java.io.BufferedOutputStream;
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.Iterator;
/*     */ import javax.ejb.CreateException;
/*     */ import javax.ejb.DuplicateKeyException;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.ejb.FinderException;
/*     */ import javax.ejb.Handle;
/*     */ import javax.ejb.RemoveException;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.EntityPersistenceStore;
/*     */ import org.jboss.ejb.GenericEntityObjectFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.EntityMetaData;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.system.server.ServerConfig;
/*     */ import org.jboss.system.server.ServerConfigLocator;
/*     */ import org.jboss.util.file.FilenameSuffixFilter;
/*     */ 
/*     */ public class CMPFilePersistenceManager extends ServiceMBeanSupport
/*     */   implements EntityPersistenceStore
/*     */ {
/*     */   public static final String DEFAULT_STORE_DIRECTORY_NAME = "entities";
/*     */   private EntityContainer con;
/*     */   private String storeDirName;
/*     */   private File storeDir;
/*     */   private Field idField;
/*     */   private Method isModified;
/*     */ 
/*     */   public CMPFilePersistenceManager()
/*     */   {
/* 116 */     this.storeDirName = "entities";
/*     */   }
/*     */ 
/*     */   public void setContainer(Container c)
/*     */   {
/* 135 */     this.con = ((EntityContainer)c);
/*     */   }
/*     */ 
/*     */   public void setStoreDirectoryName(String dirName)
/*     */   {
/* 161 */     this.storeDirName = dirName;
/*     */   }
/*     */ 
/*     */   public String getStoreDirectoryName()
/*     */   {
/* 176 */     return this.storeDirName;
/*     */   }
/*     */ 
/*     */   public File getStoreDirectory()
/*     */   {
/* 188 */     return this.storeDir;
/*     */   }
/*     */ 
/*     */   protected void createService()
/*     */     throws Exception
/*     */   {
/* 195 */     String ejbName = this.con.getBeanMetaData().getEjbName();
/*     */ 
/* 198 */     File dir = ServerConfigLocator.locate().getServerDataDir();
/*     */ 
/* 207 */     dir = new File(dir, this.storeDirName);
/* 208 */     dir = new File(dir, ejbName);
/* 209 */     this.storeDir = dir;
/*     */ 
/* 211 */     this.log.debug("Storing entity state for '" + ejbName + "' in: " + this.storeDir);
/*     */ 
/* 214 */     if ((!this.storeDir.exists()) && 
/* 215 */       (!this.storeDir.mkdirs())) {
/* 216 */       throw new IOException("Failed to create directory: " + this.storeDir);
/*     */     }
/*     */ 
/* 221 */     if (!this.storeDir.isDirectory()) {
/* 222 */       throw new IOException("File exists where directory expected: " + this.storeDir);
/*     */     }
/*     */ 
/* 226 */     if ((!this.storeDir.canWrite()) || (!this.storeDir.canRead())) {
/* 227 */       throw new IOException("Directory must be readable and writable: " + this.storeDir);
/*     */     }
/*     */ 
/* 231 */     this.idField = this.con.getBeanClass().getField("id");
/* 232 */     this.log.debug("Using id field: " + this.idField);
/*     */     try
/*     */     {
/* 237 */       this.isModified = this.con.getBeanClass().getMethod("isModified", new Class[0]);
/* 238 */       if (!this.isModified.getReturnType().equals(Boolean.TYPE)) {
/* 239 */         this.isModified = null;
/* 240 */         this.log.warn("Found isModified method, but return type is not boolean; ignoring");
/*     */       }
/*     */       else {
/* 243 */         this.log.debug("Using isModified method: " + this.isModified);
/*     */       }
/*     */     }
/*     */     catch (NoSuchMethodException ignored)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void destroyService()
/*     */     throws Exception
/*     */   {
/* 254 */     this.storeDir.delete();
/*     */   }
/*     */ 
/*     */   public Object createBeanClassInstance() throws Exception
/*     */   {
/* 259 */     return this.con.getBeanClass().newInstance();
/*     */   }
/*     */ 
/*     */   public void initEntity(EntityEnterpriseContext ctx)
/*     */   {
/* 276 */     Object instance = ctx.getInstance();
/* 277 */     Class ejbClass = instance.getClass();
/*     */ 
/* 281 */     EntityMetaData metaData = (EntityMetaData)this.con.getBeanMetaData();
/* 282 */     Iterator i = metaData.getCMPFields();
/*     */ 
/* 284 */     while (i.hasNext())
/*     */     {
/*     */       try
/*     */       {
/* 289 */         Field cmpField = ejbClass.getField((String)i.next());
/* 290 */         Class cmpFieldType = cmpField.getType();
/*     */ 
/* 293 */         if (cmpFieldType.equals(Boolean.TYPE))
/*     */         {
/* 295 */           cmpField.setBoolean(instance, false);
/*     */         }
/* 297 */         else if (cmpFieldType.equals(Byte.TYPE))
/*     */         {
/* 299 */           cmpField.setByte(instance, 0);
/*     */         }
/* 301 */         else if (cmpFieldType.equals(Integer.TYPE))
/*     */         {
/* 303 */           cmpField.setInt(instance, 0);
/*     */         }
/* 305 */         else if (cmpFieldType.equals(Long.TYPE))
/*     */         {
/* 307 */           cmpField.setLong(instance, 0L);
/*     */         }
/* 309 */         else if (cmpFieldType.equals(Short.TYPE))
/*     */         {
/* 311 */           cmpField.setShort(instance, 0);
/*     */         }
/* 313 */         else if (cmpFieldType.equals(Character.TYPE))
/*     */         {
/* 315 */           cmpField.setChar(instance, '\000');
/*     */         }
/* 317 */         else if (cmpFieldType.equals(Double.TYPE))
/*     */         {
/* 319 */           cmpField.setDouble(instance, 0.0D);
/*     */         }
/* 321 */         else if (cmpFieldType.equals(Float.TYPE))
/*     */         {
/* 323 */           cmpField.setFloat(instance, 0.0F);
/*     */         }
/*     */         else
/*     */         {
/* 327 */           cmpField.set(instance, null);
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (NoSuchFieldException e)
/*     */       {
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 337 */         throw new EJBException(e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object createEntity(Method m, Object[] args, EntityEnterpriseContext ctx)
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 348 */       Object id = this.idField.get(ctx.getInstance());
/*     */ 
/* 351 */       if (getFile(id).exists()) {
/* 352 */         throw new DuplicateKeyException("Already exists: " + id);
/*     */       }
/*     */ 
/* 355 */       storeEntity(id, ctx.getInstance());
/*     */ 
/* 357 */       return id;
/*     */     }
/*     */     catch (IllegalAccessException e) {
/*     */     }
/* 361 */     throw new CreateException("Could not create entity: " + e);
/*     */   }
/*     */ 
/*     */   public Object postCreateEntity(Method m, Object[] args, EntityEnterpriseContext ctx)
/*     */     throws Exception
/*     */   {
/* 370 */     return null;
/*     */   }
/*     */ 
/*     */   public Object findEntity(Method finderMethod, Object[] args, EntityEnterpriseContext ctx, GenericEntityObjectFactory factory)
/*     */     throws FinderException
/*     */   {
/* 379 */     if (finderMethod.getName().equals("findByPrimaryKey"))
/*     */     {
/* 381 */       if (!getFile(args[0]).exists()) {
/* 382 */         throw new FinderException(args[0] + " does not exist");
/*     */       }
/* 384 */       return factory.getEntityEJBObject(args[0]);
/*     */     }
/*     */ 
/* 387 */     return null;
/*     */   }
/*     */ 
/*     */   public Collection findEntities(Method finderMethod, Object[] args, EntityEnterpriseContext ctx, GenericEntityObjectFactory factory)
/*     */   {
/* 395 */     if (finderMethod.getName().equals("findAll"))
/*     */     {
/* 397 */       String[] files = this.storeDir.list(new FilenameSuffixFilter(".ser"));
/* 398 */       ArrayList result = new ArrayList(files.length);
/* 399 */       for (int i = 0; i < files.length; i++) {
/* 400 */         String key = files[i].substring(0, files[i].length() - 4);
/* 401 */         result.add(factory.getEntityEJBObject(key));
/*     */       }
/*     */ 
/* 404 */       return result;
/*     */     }
/*     */ 
/* 409 */     return Collections.EMPTY_LIST;
/*     */   }
/*     */ 
/*     */   public void activateEntity(EntityEnterpriseContext ctx)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void loadEntity(EntityEnterpriseContext ctx)
/*     */   {
/*     */     try
/*     */     {
/* 425 */       Object obj = ctx.getInstance();
/*     */ 
/* 428 */       ObjectInputStream in = new CMPObjectInputStream(new BufferedInputStream(new FileInputStream(getFile(ctx.getId()))));
/*     */       try
/*     */       {
/* 432 */         Field[] f = obj.getClass().getFields();
/* 433 */         for (int i = 0; i < f.length; i++)
/*     */         {
/* 435 */           f[i].set(obj, in.readObject());
/*     */         }
/*     */       }
/*     */       finally {
/* 439 */         in.close();
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 444 */       throw new EJBException("Load failed", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void storeEntity(Object id, Object obj)
/*     */   {
/*     */     try
/*     */     {
/* 453 */       ObjectOutputStream out = new CMPObjectOutputStream(new BufferedOutputStream(new FileOutputStream(getFile(id))));
/*     */       try
/*     */       {
/* 457 */         Field[] f = obj.getClass().getFields();
/* 458 */         for (int i = 0; i < f.length; i++)
/*     */         {
/* 460 */           out.writeObject(f[i].get(obj));
/*     */         }
/*     */       }
/*     */       finally {
/* 464 */         out.close();
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 469 */       throw new EJBException("Store failed", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isStoreRequired(EntityEnterpriseContext ctx) throws Exception
/*     */   {
/* 475 */     if (this.isModified == null)
/*     */     {
/* 477 */       return true;
/*     */     }
/*     */ 
/* 480 */     Boolean modified = (Boolean)this.isModified.invoke(ctx.getInstance(), new Object[0]);
/* 481 */     return modified.booleanValue();
/*     */   }
/*     */ 
/*     */   public boolean isModified(EntityEnterpriseContext ctx) throws Exception
/*     */   {
/* 486 */     return isStoreRequired(ctx);
/*     */   }
/*     */ 
/*     */   public void storeEntity(EntityEnterpriseContext ctx)
/*     */   {
/* 491 */     storeEntity(ctx.getId(), ctx.getInstance());
/*     */   }
/*     */ 
/*     */   public void passivateEntity(EntityEnterpriseContext ctx)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void removeEntity(EntityEnterpriseContext ctx)
/*     */     throws RemoveException
/*     */   {
/* 506 */     File file = getFile(ctx.getId());
/*     */ 
/* 508 */     if (!file.delete())
/* 509 */       throw new RemoveException("Could not remove file: " + file);
/*     */   }
/*     */ 
/*     */   protected File getFile(Object id)
/*     */   {
/* 515 */     return new File(this.storeDir, String.valueOf(id) + ".ser");
/*     */   }
/*     */ 
/*     */   static class CMPObjectInputStream extends ObjectInputStream
/*     */   {
/*     */     public CMPObjectInputStream(InputStream in)
/*     */       throws IOException
/*     */     {
/* 546 */       super();
/* 547 */       enableResolveObject(true);
/*     */     }
/*     */ 
/*     */     protected Object resolveObject(Object obj)
/*     */       throws IOException
/*     */     {
/* 553 */       if ((obj instanceof Handle)) {
/* 554 */         return ((Handle)obj).getEJBObject();
/*     */       }
/* 556 */       return obj;
/*     */     }
/*     */   }
/*     */ 
/*     */   static class CMPObjectOutputStream extends ObjectOutputStream
/*     */   {
/*     */     public CMPObjectOutputStream(OutputStream out)
/*     */       throws IOException
/*     */     {
/* 526 */       super();
/* 527 */       enableReplaceObject(true);
/*     */     }
/*     */ 
/*     */     protected Object replaceObject(Object obj)
/*     */       throws IOException
/*     */     {
/* 533 */       if ((obj instanceof EJBObject)) {
/* 534 */         return ((EJBObject)obj).getHandle();
/*     */       }
/* 536 */       return obj;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.CMPFilePersistenceManager
 * JD-Core Version:    0.6.0
 */