/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.rmi.RemoteException;
/*     */ import java.util.Hashtable;
/*     */ import javax.ejb.EJBContext;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.RefAddr;
/*     */ import javax.naming.Reference;
/*     */ import javax.naming.spi.ObjectFactory;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.ejb.AllowedOperationsAssociation;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EnterpriseContext;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.tm.TxUtils;
/*     */ 
/*     */ abstract class AbstractTxInterceptorBMT extends AbstractTxInterceptor
/*     */ {
/*     */   private ThreadLocal userTransaction;
/*     */   protected boolean stateless;
/*     */ 
/*     */   AbstractTxInterceptorBMT()
/*     */   {
/*  60 */     this.userTransaction = new ThreadLocal();
/*     */ 
/*  68 */     this.stateless = true;
/*     */   }
/*     */ 
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/*  81 */     super.create();
/*     */ 
/*  84 */     RefAddr refAddr = new RefAddr("userTransaction")
/*     */     {
/*     */       private static final long serialVersionUID = -8228448967597474960L;
/*     */ 
/*     */       public Object getContent()
/*     */       {
/*  91 */         return AbstractTxInterceptorBMT.this.userTransaction;
/*     */       }
/*     */     };
/*  95 */     Reference ref = new Reference("javax.transaction.UserTransaction", refAddr, new UserTxFactory().getClass().getName(), null);
/*     */ 
/*  97 */     ((Context)new InitialContext().lookup("java:comp/")).bind("UserTransaction", ref);
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*     */     try
/*     */     {
/* 105 */       ((Context)new InitialContext().lookup("java:comp/")).unbind("UserTransaction");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Object invokeNext(Invocation mi)
/*     */     throws Exception
/*     */   {
/* 133 */     Transaction oldTransaction = mi.getTransaction();
/*     */ 
/* 137 */     Object oldUserTx = this.userTransaction.get();
/*     */ 
/* 141 */     Transaction threadTx = this.tm.suspend();
/*     */     try
/*     */     {
/* 145 */       EnterpriseContext ctx = (EnterpriseContext)mi.getEnterpriseContext();
/*     */       try
/*     */       {
/* 150 */         AllowedOperationsAssociation.pushInMethodFlag(IN_INTERCEPTOR_METHOD);
/* 151 */         this.userTransaction.set(ctx.getEJBContext().getUserTransaction());
/*     */       }
/*     */       finally
/*     */       {
/* 155 */         AllowedOperationsAssociation.popInMethodFlag();
/*     */       }
/*     */ 
/* 159 */       Transaction beanTx = ctx.getTransaction();
/*     */ 
/* 163 */       if (beanTx != null) {
/* 164 */         this.tm.resume(beanTx);
/*     */       }
/*     */ 
/* 167 */       mi.setTransaction(beanTx);
/*     */       try
/*     */       {
/* 173 */         Object localObject2 = super.invokeNext(mi, false);
/*     */         try
/*     */         {
/* 179 */           if (this.stateless)
/* 180 */             checkStatelessDone();
/*     */           else
/* 182 */             checkBadStateful();
/*     */         }
/*     */         finally
/*     */         {
/* 186 */           this.tm.suspend();
/*     */         }
/*     */ 
/* 193 */         this.userTransaction.set(oldUserTx);
/*     */ 
/* 197 */         mi.setTransaction(oldTransaction);
/*     */ 
/* 200 */         if (threadTx != null)
/* 201 */           this.tm.resume(threadTx); return localObject2;
/*     */       }
/*     */       finally
/*     */       {
/*     */         try
/*     */         {
/* 179 */           if (this.stateless)
/* 180 */             checkStatelessDone();
/*     */           else
/* 182 */             checkBadStateful();
/*     */         }
/*     */         finally
/*     */         {
/* 186 */           this.tm.suspend();
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */     finally
/*     */     {
/* 193 */       this.userTransaction.set(oldUserTx);
/*     */ 
/* 197 */       mi.setTransaction(oldTransaction);
/*     */ 
/* 200 */       if (threadTx != null)
/* 201 */         this.tm.resume(threadTx); 
/* 201 */     }throw localObject6;
/*     */   }
/*     */ 
/*     */   private void checkStatelessDone()
/*     */     throws RemoteException
/*     */   {
/* 207 */     int status = 6;
/*     */     try
/*     */     {
/* 211 */       status = this.tm.getStatus();
/*     */     }
/*     */     catch (SystemException ex)
/*     */     {
/* 215 */       this.log.error("Failed to get status", ex);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 220 */       switch (status)
/*     */       {
/*     */       case 0:
/*     */       case 1:
/*     */       case 7:
/*     */       case 8:
/*     */       case 9:
/*     */         try
/*     */         {
/* 229 */           this.tm.rollback();
/*     */         }
/*     */         catch (Exception ex)
/*     */         {
/* 233 */           this.log.error("Failed to rollback", ex);
/*     */         }
/*     */ 
/*     */       case 2:
/* 237 */         String msg = "Application error: BMT stateless bean " + this.container.getBeanMetaData().getEjbName() + " should complete transactions before" + " returning (ejb1.1 spec, 11.6.1)";
/*     */ 
/* 239 */         this.log.error(msg);
/*     */ 
/* 242 */         throw new RemoteException(msg);
/*     */       case 3:
/*     */       case 4:
/*     */       case 5:
/*     */       case 6:
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/*     */       Transaction tx;
/*     */       String msg;
/* 247 */       Transaction tx = null;
/*     */       try
/*     */       {
/* 250 */         tx = this.tm.suspend();
/*     */       }
/*     */       catch (SystemException ex)
/*     */       {
/* 254 */         this.log.error("Failed to suspend transaction", ex);
/*     */       }
/* 256 */       if (tx != null)
/*     */       {
/* 258 */         String msg = "Application error: BMT stateless bean " + this.container.getBeanMetaData().getEjbName() + " should complete transactions before " + " returning (ejb1.1 spec, 11.6.1), suspended tx=" + tx;
/*     */ 
/* 260 */         this.log.error(msg);
/* 261 */         throw new RemoteException(msg);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void checkBadStateful() throws RemoteException
/*     */   {
/* 268 */     int status = 6;
/*     */     try
/*     */     {
/* 272 */       status = this.tm.getStatus();
/*     */     }
/*     */     catch (SystemException ex)
/*     */     {
/* 276 */       this.log.error("Failed to get status", ex);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 282 */       switch (status)
/*     */       {
/*     */       case 1:
/*     */       case 7:
/*     */       case 8:
/*     */       case 9:
/*     */         try
/*     */         {
/* 290 */           this.tm.rollback();
/*     */         }
/*     */         catch (Exception ex)
/*     */         {
/* 294 */           this.log.error("Failed to rollback", ex);
/*     */         }
/* 296 */         String msg = "BMT stateful bean '" + this.container.getBeanMetaData().getEjbName() + "' did not complete user transaction properly status=" + TxUtils.getStatusAsString(status);
/*     */ 
/* 298 */         this.log.error(msg);
/*     */       case 2:
/*     */       case 3:
/*     */       case 4:
/*     */       case 5:
/*     */       case 6:
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/*     */       Transaction tx;
/*     */       String msg;
/* 303 */       Transaction tx = null;
/*     */       try
/*     */       {
/* 306 */         tx = this.tm.suspend();
/*     */       }
/*     */       catch (SystemException ex)
/*     */       {
/* 310 */         this.log.error("Failed to suspend transaction", ex);
/*     */       }
/* 312 */       if (tx != null)
/*     */       {
/* 314 */         String msg = "BMT stateful bean " + this.container.getBeanMetaData().getEjbName() + " did not complete user transaction properly tx=" + tx;
/*     */ 
/* 316 */         this.log.error(msg);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class UserTxFactory
/*     */     implements ObjectFactory
/*     */   {
/*     */     public Object getObjectInstance(Object ref, Name name, Context nameCtx, Hashtable environment)
/*     */       throws Exception
/*     */     {
/* 328 */       RefAddr refAddr = ((Reference)ref).get(0);
/*     */ 
/* 330 */       ThreadLocal threadLocal = (ThreadLocal)refAddr.getContent();
/*     */ 
/* 333 */       return threadLocal.get();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.AbstractTxInterceptorBMT
 * JD-Core Version:    0.6.0
 */