/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.io.PrintWriter;
/*     */ import java.io.StringWriter;
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.NoSuchObjectException;
/*     */ import java.rmi.RemoteException;
/*     */ import java.rmi.ServerException;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.NoSuchEntityException;
/*     */ import javax.ejb.NoSuchObjectLocalException;
/*     */ import javax.ejb.TimedObject;
/*     */ import javax.ejb.Timer;
/*     */ import javax.ejb.TransactionRolledbackLocalException;
/*     */ import javax.transaction.RollbackException;
/*     */ import javax.transaction.Synchronization;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import javax.transaction.TransactionRolledbackException;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.Interceptor;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.InvocationType;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.tm.TxUtils;
/*     */ 
/*     */ abstract class AbstractTxInterceptor extends AbstractInterceptor
/*     */ {
/*     */   protected static final Method ejbTimeout;
/*     */   protected TransactionManager tm;
/*     */ 
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/*  88 */     super.create();
/*  89 */     this.tm = getContainer().getTransactionManager();
/*     */   }
/*     */ 
/*     */   protected Object invokeNext(Invocation invocation, boolean inheritedTx) throws Exception {
/* 112 */     InvocationType type = invocation.getType();
/*     */     TransactionRolledbackException ex;
/*     */     try {
/* 115 */       if ((type == InvocationType.REMOTE) || (type == InvocationType.LOCAL) || (type == InvocationType.SERVICE_ENDPOINT))
/*     */       {
/* 118 */         if (ejbTimeout.equals(invocation.getMethod())) {
/* 119 */           registerTimer(invocation);
/*     */         }
/* 121 */         return getNext().invoke(invocation);
/*     */       }
/*     */ 
/* 125 */       return getNext().invokeHome(invocation);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 131 */       if (((e instanceof Exception)) && (!(e instanceof RuntimeException)) && (!(e instanceof RemoteException)))
/*     */       {
/* 134 */         throw ((Exception)e);
/*     */       }
/*     */ 
/* 138 */       Transaction tx = invocation.getTransaction();
/* 139 */       if (tx == null)
/*     */       {
/*     */         try
/*     */         {
/* 144 */           tx = this.tm.getTransaction();
/* 145 */           if (!TxUtils.isActive(tx))
/* 146 */             tx = null;
/*     */         }
/*     */         catch (Exception ex)
/*     */         {
/* 150 */           this.log.warn("Unable to determine transaction context", ex);
/*     */         }
/*     */       }
/* 153 */       if (tx != null)
/*     */       {
/*     */         try
/*     */         {
/* 157 */           tx.setRollbackOnly();
/*     */         }
/*     */         catch (SystemException ex)
/*     */         {
/* 161 */           this.log.error("SystemException while setting transaction for rollback only", ex);
/*     */         }
/*     */         catch (IllegalStateException ex)
/*     */         {
/* 166 */           this.log.error("IllegalStateException while setting transaction for rollback only", ex);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 172 */       boolean isLocal = (type == InvocationType.LOCAL) || (type == InvocationType.LOCALHOME);
/*     */ 
/* 179 */       if (!inheritedTx)
/*     */       {
/* 181 */         if ((e instanceof Exception))
/*     */         {
/* 183 */           throw ((Exception)e);
/*     */         }
/* 185 */         if ((e instanceof Error))
/*     */         {
/* 187 */           throw ((Error)e);
/*     */         }
/*     */ 
/* 191 */         if (isLocal)
/*     */         {
/* 193 */           String msg = formatException("Unexpected Throwable", e);
/* 194 */           throw new EJBException(msg);
/*     */         }
/*     */ 
/* 198 */         ServerException ex = new ServerException("Unexpected Throwable");
/* 199 */         ex.detail = e;
/* 200 */         throw ex;
/*     */       }
/*     */       Throwable cause;
/* 207 */       if ((e instanceof NoSuchEntityException))
/*     */       {
/* 209 */         NoSuchEntityException nsee = (NoSuchEntityException)e;
/*     */         Throwable cause;
/* 210 */         if (isLocal)
/*     */         {
/* 212 */           cause = new NoSuchObjectLocalException(nsee.getMessage(), nsee.getCausedByException());
/*     */         }
/*     */         else
/*     */         {
/* 217 */           Throwable cause = new NoSuchObjectException(nsee.getMessage());
/*     */ 
/* 220 */           ((NoSuchObjectException)cause).detail = nsee.getCausedByException();
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/*     */         Throwable cause;
/* 226 */         if (isLocal)
/*     */         {
/*     */           Throwable cause;
/* 230 */           if ((e instanceof Exception))
/*     */           {
/* 232 */             cause = e;
/*     */           }
/*     */           else
/*     */           {
/*     */             Throwable cause;
/* 234 */             if ((e instanceof Error))
/*     */             {
/* 236 */               String msg = formatException("Unexpected Error", e);
/* 237 */               cause = new EJBException(msg);
/*     */             }
/*     */             else
/*     */             {
/* 241 */               String msg = formatException("Unexpected Throwable", e);
/* 242 */               cause = new EJBException(msg);
/*     */             }
/*     */           }
/*     */ 
/*     */         }
/*     */         else
/*     */         {
/* 249 */           cause = e;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 254 */       if (isLocal)
/*     */       {
/* 256 */         if ((cause instanceof TransactionRolledbackLocalException))
/*     */         {
/* 258 */           throw ((TransactionRolledbackLocalException)cause);
/*     */         }
/*     */ 
/* 262 */         throw new TransactionRolledbackLocalException(cause.getMessage(), (Exception)cause);
/*     */       }
/*     */ 
/* 268 */       if ((cause instanceof TransactionRolledbackException))
/*     */       {
/* 270 */         throw ((TransactionRolledbackException)cause);
/*     */       }
/*     */ 
/* 274 */       ex = new TransactionRolledbackException(cause.getMessage());
/*     */ 
/* 276 */       ex.detail = cause;
/* 277 */     }throw ex;
/*     */   }
/*     */ 
/*     */   private void registerTimer(Invocation invocation)
/*     */     throws RollbackException, SystemException
/*     */   {
/* 286 */     Timer timer = (Timer)invocation.getArguments()[0];
/* 287 */     Transaction transaction = invocation.getTransaction();
/* 288 */     if ((transaction != null) && ((timer instanceof Synchronization)))
/* 289 */       transaction.registerSynchronization((Synchronization)timer);
/*     */   }
/*     */ 
/*     */   private String formatException(String msg, Throwable t)
/*     */   {
/* 294 */     StringWriter sw = new StringWriter();
/* 295 */     PrintWriter pw = new PrintWriter(sw);
/* 296 */     if (msg != null)
/*     */     {
/* 298 */       pw.println(msg);
/*     */     }
/* 300 */     t.printStackTrace(pw);
/* 301 */     return sw.toString();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  73 */       ejbTimeout = TimedObject.class.getMethod("ejbTimeout", new Class[] { Timer.class });
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  77 */       throw new ExceptionInInitializerError(e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.AbstractTxInterceptor
 * JD-Core Version:    0.6.0
 */