/*    */ package org.jboss.ejb.deployers;
/*    */ 
/*    */ import org.jboss.deployers.spi.DeploymentException;
/*    */ import org.jboss.deployers.spi.attachments.MutableAttachments;
/*    */ import org.jboss.deployers.spi.deployer.DeploymentStages;
/*    */ import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
/*    */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*    */ import org.jboss.deployment.AnnotationMetaDataDeployer;
/*    */ import org.jboss.metadata.ejb.jboss.JBossMetaData;
/*    */ import org.jboss.metadata.ejb.spec.AnnotationMergedView;
/*    */ import org.jboss.metadata.ejb.spec.EjbJar30MetaData;
/*    */ import org.jboss.metadata.ejb.spec.EjbJar3xMetaData;
/*    */ import org.jboss.metadata.ejb.spec.EjbJarMetaData;
/*    */ 
/*    */ public class MergedJBossMetaDataDeployer extends AbstractDeployer
/*    */ {
/* 44 */   public static final String EJB_MERGED_ATTACHMENT_NAME = "merged." + JBossMetaData.class.getName();
/*    */ 
/*    */   public MergedJBossMetaDataDeployer()
/*    */   {
/* 51 */     setStage(DeploymentStages.POST_CLASSLOADER);
/*    */ 
/* 53 */     addInput(EjbJarMetaData.class);
/*    */ 
/* 55 */     addInput(JBossMetaData.class);
/*    */ 
/* 57 */     addInput(AnnotationMetaDataDeployer.EJB_ANNOTATED_ATTACHMENT_NAME);
/*    */ 
/* 59 */     setOutput(JBossMetaData.class);
/*    */ 
/* 61 */     addOutput(EJB_MERGED_ATTACHMENT_NAME);
/*    */   }
/*    */ 
/*    */   public void deploy(DeploymentUnit unit) throws DeploymentException
/*    */   {
/* 66 */     EjbJarMetaData specMetaData = (EjbJarMetaData)unit.getAttachment(EjbJarMetaData.class);
/* 67 */     JBossMetaData metaData = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
/* 68 */     if ((specMetaData == null) && (metaData == null)) {
/* 69 */       return;
/*    */     }
/*    */ 
/* 72 */     String key = AnnotationMetaDataDeployer.EJB_ANNOTATED_ATTACHMENT_NAME;
/* 73 */     EjbJar3xMetaData annotatedMetaData = (EjbJar3xMetaData)unit.getAttachment(key, EjbJar3xMetaData.class);
/* 74 */     if (annotatedMetaData != null)
/*    */     {
/* 76 */       if (specMetaData != null)
/*    */       {
/* 78 */         EjbJar3xMetaData specMerged = new EjbJar30MetaData();
/* 79 */         AnnotationMergedView.merge(specMerged, (EjbJar3xMetaData)specMetaData, annotatedMetaData);
/* 80 */         specMetaData = specMerged;
/*    */       }
/*    */       else {
/* 83 */         specMetaData = annotatedMetaData;
/*    */       }
/*    */     }
/*    */ 
/* 87 */     JBossMetaData mergedMetaData = new JBossMetaData();
/* 88 */     mergedMetaData.merge(metaData, specMetaData);
/* 89 */     unit.getTransientManagedObjects().addAttachment(JBossMetaData.class, mergedMetaData);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.deployers.MergedJBossMetaDataDeployer
 * JD-Core Version:    0.6.0
 */