/*     */ package org.jboss.ejb;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.RemoteException;
/*     */ import java.security.Principal;
/*     */ import java.util.Collection;
/*     */ import java.util.Date;
/*     */ import javax.ejb.EJBContext;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.EJBHome;
/*     */ import javax.ejb.EJBLocalHome;
/*     */ import javax.ejb.MessageDrivenBean;
/*     */ import javax.ejb.MessageDrivenContext;
/*     */ import javax.ejb.Timer;
/*     */ import javax.ejb.TimerService;
/*     */ import javax.transaction.UserTransaction;
/*     */ import org.jboss.metadata.MessageDrivenMetaData;
/*     */ import org.jboss.util.NestedError;
/*     */ 
/*     */ public class MessageDrivenEnterpriseContext extends EnterpriseContext
/*     */ {
/*     */   private MessageDrivenContext ctx;
/*     */ 
/*     */   public MessageDrivenEnterpriseContext(Object instance, Container con)
/*     */     throws Exception
/*     */   {
/*  73 */     super(instance, con);
/*     */ 
/*  75 */     this.ctx = new MessageDrivenContextImpl();
/*  76 */     ((MessageDrivenBean)instance).setMessageDrivenContext(this.ctx);
/*     */     try
/*     */     {
/*  80 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_CREATE);
/*  81 */       Method ejbCreate = instance.getClass().getMethod("ejbCreate", new Class[0]);
/*  82 */       ejbCreate.invoke(instance, new Object[0]);
/*     */     }
/*     */     catch (InvocationTargetException e)
/*     */     {
/*  86 */       Throwable t = e.getTargetException();
/*     */ 
/*  88 */       if ((t instanceof RuntimeException)) {
/*  89 */         if ((t instanceof EJBException)) {
/*  90 */           throw ((EJBException)t);
/*     */         }
/*     */ 
/*  94 */         throw new EJBException((RuntimeException)t);
/*     */       }
/*     */ 
/*  97 */       if ((t instanceof Exception)) {
/*  98 */         throw ((Exception)t);
/*     */       }
/* 100 */       if ((t instanceof Error)) {
/* 101 */         throw ((Error)t);
/*     */       }
/*     */ 
/* 104 */       throw new NestedError("Unexpected Throwable", t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public MessageDrivenContext getMessageDrivenContext()
/*     */   {
/* 111 */     return this.ctx;
/*     */   }
/*     */ 
/*     */   public void discard()
/*     */     throws RemoteException
/*     */   {
/* 121 */     ((MessageDrivenBean)this.instance).ejbRemove();
/*     */   }
/*     */ 
/*     */   public EJBContext getEJBContext()
/*     */   {
/* 126 */     return this.ctx;
/*     */   }
/*     */ 
/*     */   public class TimerServiceWrapper
/*     */     implements TimerService
/*     */   {
/*     */     private EnterpriseContext.EJBContextImpl context;
/*     */     private TimerService timerService;
/*     */ 
/*     */     public TimerServiceWrapper(EnterpriseContext.EJBContextImpl ctx, TimerService timerService)
/*     */     {
/* 248 */       this.context = ctx;
/* 249 */       this.timerService = timerService;
/*     */     }
/*     */ 
/*     */     public Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException
/*     */     {
/* 254 */       assertAllowedIn("TimerService.createTimer");
/* 255 */       return this.timerService.createTimer(duration, info);
/*     */     }
/*     */ 
/*     */     public Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException
/*     */     {
/* 260 */       assertAllowedIn("TimerService.createTimer");
/* 261 */       return this.timerService.createTimer(initialDuration, intervalDuration, info);
/*     */     }
/*     */ 
/*     */     public Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException
/*     */     {
/* 266 */       assertAllowedIn("TimerService.createTimer");
/* 267 */       return this.timerService.createTimer(expiration, info);
/*     */     }
/*     */ 
/*     */     public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException
/*     */     {
/* 272 */       assertAllowedIn("TimerService.createTimer");
/* 273 */       return this.timerService.createTimer(initialExpiration, intervalDuration, info);
/*     */     }
/*     */ 
/*     */     public Collection getTimers() throws IllegalStateException, EJBException
/*     */     {
/* 278 */       assertAllowedIn("TimerService.getTimers");
/* 279 */       return this.timerService.getTimers();
/*     */     }
/*     */ 
/*     */     private void assertAllowedIn(String timerMethod)
/*     */     {
/* 284 */       AllowedOperationsAssociation.assertAllowedIn(timerMethod, AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected class MessageDrivenContextImpl extends EnterpriseContext.EJBContextImpl
/*     */     implements MessageDrivenContext
/*     */   {
/*     */     protected MessageDrivenContextImpl()
/*     */     {
/* 132 */       super();
/*     */     }
/*     */ 
/*     */     public EJBHome getEJBHome()
/*     */     {
/* 139 */       throw new IllegalStateException("getEJBHome should not be access from a message driven bean");
/*     */     }
/*     */ 
/*     */     public EJBLocalHome getEJBLocalHome()
/*     */     {
/* 144 */       throw new IllegalStateException("getEJBHome should not be access from a message driven bean");
/*     */     }
/*     */ 
/*     */     public TimerService getTimerService() throws IllegalStateException
/*     */     {
/* 149 */       AllowedOperationsAssociation.assertAllowedIn("getTimerService", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT);
/*     */ 
/* 151 */       return new MessageDrivenEnterpriseContext.TimerServiceWrapper(MessageDrivenEnterpriseContext.this, this, super.getTimerService());
/*     */     }
/*     */ 
/*     */     public Principal getCallerPrincipal()
/*     */     {
/* 156 */       AllowedOperationsAssociation.assertAllowedIn("getCallerPrincipal", AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT);
/*     */ 
/* 158 */       return super.getCallerPrincipal();
/*     */     }
/*     */ 
/*     */     public boolean isCallerInRole(String id)
/*     */     {
/* 163 */       throw new IllegalStateException("isCallerInRole should not be access from a message driven bean");
/*     */     }
/*     */ 
/*     */     public UserTransaction getUserTransaction()
/*     */     {
/* 168 */       if (MessageDrivenEnterpriseContext.this.isContainerManagedTx()) {
/* 169 */         throw new IllegalStateException("getUserTransaction should not be access for container managed Tx");
/*     */       }
/* 171 */       AllowedOperationsAssociation.assertAllowedIn("getUserTransaction", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT);
/*     */ 
/* 174 */       return super.getUserTransaction();
/*     */     }
/*     */ 
/*     */     public boolean getRollbackOnly()
/*     */     {
/* 186 */       if (MessageDrivenEnterpriseContext.this.isUserManagedTx()) {
/* 187 */         throw new IllegalStateException("getRollbackOnly should not be access for user managed Tx");
/*     */       }
/* 189 */       AllowedOperationsAssociation.assertAllowedIn("getRollbackOnly", AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT);
/*     */ 
/* 198 */       if (!isTxRequired()) {
/* 199 */         throw new IllegalStateException("getRollbackOnly must only be called in the context of a transaction (EJB 2.0 - 15.5.1)");
/*     */       }
/*     */ 
/* 203 */       return super.getRollbackOnly();
/*     */     }
/*     */ 
/*     */     public void setRollbackOnly()
/*     */     {
/* 215 */       if (MessageDrivenEnterpriseContext.this.isUserManagedTx()) {
/* 216 */         throw new IllegalStateException("setRollbackOnly should not be access for user managed Tx");
/*     */       }
/* 218 */       AllowedOperationsAssociation.assertAllowedIn("getRollbackOnly", AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT);
/*     */ 
/* 221 */       if (!isTxRequired()) {
/* 222 */         throw new IllegalStateException("setRollbackOnly must only be called in the context of a transaction (EJB 2.0 - 15.5.1)");
/*     */       }
/*     */ 
/* 226 */       super.setRollbackOnly();
/*     */     }
/*     */ 
/*     */     private boolean isTxRequired()
/*     */     {
/* 232 */       MessageDrivenMetaData md = (MessageDrivenMetaData)MessageDrivenEnterpriseContext.this.con.getBeanMetaData();
/* 233 */       return md.getMethodTransactionType() == 1;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.MessageDrivenEnterpriseContext
 * JD-Core Version:    0.6.0
 */