/*      */ package org.jboss.ejb;
/*      */ 
/*      */ import java.lang.reflect.Method;
/*      */ import java.net.URL;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collection;
/*      */ import java.util.Collections;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.LinkedList;
/*      */ import java.util.ListIterator;
/*      */ import java.util.Map;
/*      */ import javax.ejb.EJBLocalHome;
/*      */ import javax.management.MBeanServer;
/*      */ import javax.management.ObjectName;
/*      */ import javax.naming.InitialContext;
/*      */ import javax.naming.NamingException;
/*      */ import javax.security.jacc.EJBMethodPermission;
/*      */ import javax.security.jacc.PolicyConfiguration;
/*      */ import javax.security.jacc.PolicyConfigurationFactory;
/*      */ import javax.security.jacc.PolicyContextException;
/*      */ import javax.transaction.TransactionManager;
/*      */ import org.jboss.classloading.spi.RealClassLoader;
/*      */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*      */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*      */ import org.jboss.deployment.DeploymentException;
/*      */ import org.jboss.deployment.DeploymentInfo;
/*      */ import org.jboss.ejb.plugins.CMPPersistenceManager;
/*      */ import org.jboss.ejb.plugins.SecurityProxyInterceptor;
/*      */ import org.jboss.ejb.plugins.StatefulSessionInstancePool;
/*      */ import org.jboss.ejb.txtimer.EJBTimerService;
/*      */ import org.jboss.invocation.InvocationType;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.metadata.ApplicationMetaData;
/*      */ import org.jboss.metadata.BeanMetaData;
/*      */ import org.jboss.metadata.ConfigurationMetaData;
/*      */ import org.jboss.metadata.EntityMetaData;
/*      */ import org.jboss.metadata.InvokerProxyBindingMetaData;
/*      */ import org.jboss.metadata.MetaData;
/*      */ import org.jboss.metadata.SessionMetaData;
/*      */ import org.jboss.metadata.XmlLoadable;
/*      */ import org.jboss.metadata.ejb.jboss.JBossMetaData;
/*      */ import org.jboss.mx.util.MBeanProxyExt;
/*      */ import org.jboss.mx.util.ObjectNameFactory;
/*      */ import org.jboss.security.AuthenticationManager;
/*      */ import org.jboss.security.AuthorizationManager;
/*      */ import org.jboss.security.ISecurityManagement;
/*      */ import org.jboss.security.RealmMapping;
/*      */ import org.jboss.security.SecurityUtil;
/*      */ import org.jboss.security.authorization.PolicyRegistration;
/*      */ import org.jboss.security.plugins.SecurityDomainContext;
/*      */ import org.jboss.system.Registry;
/*      */ import org.jboss.system.ServiceControllerMBean;
/*      */ import org.jboss.system.ServiceMBeanSupport;
/*      */ import org.jboss.tm.TransactionManagerFactory;
/*      */ import org.jboss.util.loading.DelegatingClassLoader;
/*      */ import org.jboss.virtual.VirtualFile;
/*      */ import org.jboss.web.WebClassLoader;
/*      */ import org.jboss.web.WebClassLoaderFactory;
/*      */ import org.jboss.web.WebServiceMBean;
/*      */ import org.w3c.dom.Element;
/*      */ 
/*      */ public class EjbModule extends ServiceMBeanSupport
/*      */   implements EjbModuleMBean
/*      */ {
/*      */   public static final String BASE_EJB_MODULE_NAME = "jboss.j2ee:service=EjbModule";
/*  110 */   public static final ObjectName EJB_MODULE_QUERY_NAME = ObjectNameFactory.create("jboss.j2ee:service=EjbModule,*");
/*      */ 
/*  112 */   public static String DEFAULT_STATELESS_CONFIGURATION = "Default Stateless SessionBean";
/*  113 */   public static String DEFAULT_STATEFUL_CONFIGURATION = "Default Stateful SessionBean";
/*  114 */   public static String DEFAULT_ENTITY_BMP_CONFIGURATION = "Default BMP EntityBean";
/*  115 */   public static String DEFAULT_ENTITY_CMP_CONFIGURATION = "Default CMP EntityBean";
/*  116 */   public static String DEFAULT_MESSAGEDRIVEN_CONFIGURATION = "Default MesageDriven Bean";
/*      */   public static final int BMT = 1;
/*      */   public static final int CMT = 2;
/*      */   public static final int ANY = 3;
/*      */   static final String BMT_VALUE = "Bean";
/*      */   static final String CMT_VALUE = "Container";
/*      */   static final String ANY_VALUE = "Both";
/*  128 */   private static final Logger log = Logger.getLogger(EjbModule.class);
/*      */ 
/*  135 */   HashMap containers = new HashMap();
/*      */ 
/*  137 */   LinkedList containerOrdering = new LinkedList();
/*      */ 
/*  139 */   HashMap localHomes = new HashMap();
/*      */ 
/*  142 */   ClassLoader classLoader = null;
/*      */   final String name;
/*      */   private VFSDeploymentUnit deploymentUnit;
/*      */   private ServiceControllerMBean serviceController;
/*  151 */   private final Map moduleData = Collections.synchronizedMap(new HashMap());
/*      */   private ObjectName webServiceName;
/*      */   private TransactionManagerFactory tmFactory;
/*      */   private EJBTimerService timerService;
/*      */   private boolean callByValue;
/*      */   private ApplicationMetaData appMetaData;
/*      */ 
/*      */   public EjbModule(VFSDeploymentUnit unit, ApplicationMetaData metaData)
/*      */   {
/*  165 */     this.appMetaData = metaData;
/*  166 */     this.deploymentUnit = unit;
/*  167 */     String name = this.deploymentUnit.getName();
/*  168 */     if (name.endsWith("/"))
/*      */     {
/*  170 */       name = name.substring(0, name.length() - 1);
/*      */     }
/*  172 */     this.name = name;
/*      */ 
/*  175 */     Boolean flag = (Boolean)unit.getAttachment("EJB.callByValue", Boolean.class);
/*  176 */     if (flag == null)
/*      */     {
/*  179 */       flag = (Boolean)unit.getAttachment("EAR.callByValue", Boolean.class);
/*      */     }
/*  181 */     if (flag != null) {
/*  182 */       this.callByValue = flag.booleanValue();
/*      */     }
/*      */ 
/*  185 */     if (metaData.getUnauthenticatedPrincipal() == null)
/*      */     {
/*  187 */       String unauthenticatedPrincipal = (String)unit.getAttachment("EJB.unauthenticatedIdentity", String.class);
/*  188 */       if (unauthenticatedPrincipal == null)
/*  189 */         unauthenticatedPrincipal = (String)unit.getAttachment("EAR.unauthenticatedIdentity", String.class);
/*  190 */       metaData.getJBossMetaData().setUnauthenticatedPrincipal(unauthenticatedPrincipal);
/*      */     }
/*      */ 
/*  193 */     if (unit.getAttachment(ApplicationMetaData.class) == null)
/*  194 */       unit.addAttachment(ApplicationMetaData.class, metaData);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public EjbModule(DeploymentInfo di, TransactionManager tm, ObjectName webServiceName)
/*      */   {
/*  203 */     this.name = "deprecated";
/*      */   }
/*      */ 
/*      */   public void setTransactionManagerFactory(TransactionManagerFactory tm)
/*      */   {
/*  208 */     this.tmFactory = tm;
/*      */   }
/*      */ 
/*      */   public EJBTimerService getTimerService()
/*      */   {
/*  213 */     return this.timerService;
/*      */   }
/*      */ 
/*      */   public void setTimerService(EJBTimerService timerService)
/*      */   {
/*  218 */     this.timerService = timerService;
/*      */   }
/*      */ 
/*      */   public ObjectName getWebServiceName()
/*      */   {
/*  223 */     return this.webServiceName;
/*      */   }
/*      */ 
/*      */   public void setWebServiceName(ObjectName webServiceName) {
/*  227 */     this.webServiceName = webServiceName;
/*      */   }
/*      */ 
/*      */   public Map getModuleDataMap()
/*      */   {
/*  232 */     return this.moduleData;
/*      */   }
/*      */ 
/*      */   public Object getModuleData(Object key)
/*      */   {
/*  237 */     return this.moduleData.get(key);
/*      */   }
/*      */ 
/*      */   public void putModuleData(Object key, Object value)
/*      */   {
/*  242 */     this.moduleData.put(key, value);
/*      */   }
/*      */ 
/*      */   public void removeModuleData(Object key)
/*      */   {
/*  247 */     this.moduleData.remove(key);
/*      */   }
/*      */ 
/*      */   private void addContainer(Container con)
/*      */     throws DeploymentException
/*      */   {
/*  258 */     String ejbName = con.getBeanMetaData().getEjbName();
/*  259 */     if (this.containers.containsKey(ejbName)) {
/*  260 */       throw new DeploymentException("Duplicate ejb-name. Container for " + ejbName + " already exists.");
/*      */     }
/*  262 */     this.containers.put(ejbName, con);
/*  263 */     this.containerOrdering.add(con);
/*  264 */     con.setEjbModule(this);
/*      */   }
/*      */ 
/*      */   public void removeContainer(Container con)
/*      */   {
/*  274 */     this.containers.remove(con.getBeanMetaData().getEjbName());
/*  275 */     this.containerOrdering.remove(con);
/*      */   }
/*      */ 
/*      */   public void addLocalHome(Container con, EJBLocalHome localHome)
/*      */   {
/*  280 */     this.localHomes.put(con.getBeanMetaData().getEjbName(), localHome);
/*      */   }
/*      */ 
/*      */   public void removeLocalHome(Container con)
/*      */   {
/*  285 */     this.localHomes.remove(con.getBeanMetaData().getEjbName());
/*      */   }
/*      */ 
/*      */   public EJBLocalHome getLocalHome(Container con)
/*      */   {
/*  290 */     return (EJBLocalHome)this.localHomes.get(con.getBeanMetaData().getEjbName());
/*      */   }
/*      */ 
/*      */   public boolean isCallByValue()
/*      */   {
/*  300 */     return this.callByValue;
/*      */   }
/*      */ 
/*      */   public Container getContainer(String name)
/*      */   {
/*  313 */     return (Container)this.containers.get(name);
/*      */   }
/*      */ 
/*      */   public Collection getContainers()
/*      */   {
/*  325 */     return this.containerOrdering;
/*      */   }
/*      */ 
/*      */   public ClassLoader getClassLoader()
/*      */   {
/*  335 */     return this.classLoader;
/*      */   }
/*      */ 
/*      */   public void setClassLoader(ClassLoader cl)
/*      */   {
/*  345 */     this.classLoader = cl;
/*      */   }
/*      */ 
/*      */   public URL getURL()
/*      */   {
/*  355 */     return this.appMetaData.getUrl();
/*      */   }
/*      */ 
/*      */   protected void createService()
/*      */     throws Exception
/*      */   {
/*  362 */     this.serviceController = ((ServiceControllerMBean)MBeanProxyExt.create(ServiceControllerMBean.class, ServiceControllerMBean.OBJECT_NAME, this.server));
/*      */ 
/*  367 */     log.debug("createService, begin");
/*      */     try
/*      */     {
/*  372 */       Iterator beans = this.appMetaData.getEnterpriseBeans();
/*  373 */       String contextID = this.appMetaData.getJaccContextID();
/*  374 */       if (contextID == null) {
/*  375 */         contextID = this.deploymentUnit.getSimpleName();
/*      */       }
/*      */ 
/*  378 */       while (beans.hasNext())
/*      */       {
/*  380 */         BeanMetaData bean = (BeanMetaData)beans.next();
/*  381 */         log.info("Deploying " + bean.getEjbName());
/*  382 */         Container con = createContainer(bean, this.deploymentUnit);
/*  383 */         addContainer(con);
/*      */ 
/*  385 */         con.setJaccContextID(contextID);
/*      */       }
/*      */ 
/*  392 */       ListIterator iter = this.containerOrdering.listIterator();
/*  393 */       while (iter.hasNext())
/*      */       {
/*  395 */         Container con = (Container)iter.next();
/*  396 */         ObjectName jmxName = con.getJmxName();
/*      */ 
/*  400 */         this.server.registerMBean(con, jmxName);
/*      */ 
/*  402 */         BeanMetaData metaData = con.getBeanMetaData();
/*  403 */         Collection depends = new ArrayList();
/*  404 */         for (String dependsName : metaData.getDepends())
/*      */         {
/*  406 */           depends.add(ObjectName.getInstance(dependsName));
/*      */         }
/*  408 */         this.serviceController.create(jmxName, depends);
/*      */ 
/*  410 */         int jmxHash = jmxName.hashCode();
/*  411 */         Registry.bind(new Integer(jmxHash), jmxName);
/*  412 */         log.debug("Bound jmxName=" + jmxName + ", hash=" + jmxHash + "into Registry");
/*      */       }
/*      */ 
/*  416 */       String securityDomain = SecurityUtil.unprefixSecurityDomain(this.appMetaData.getSecurityDomain());
/*  417 */       if (securityDomain == null)
/*  418 */         securityDomain = "jboss-ejb-policy";
/*  419 */       VirtualFile xacmlFile = this.deploymentUnit.getMetaDataFile("jboss-xacml-policy.xml");
/*  420 */       if (xacmlFile != null)
/*      */       {
/*  423 */         InitialContext ic = new InitialContext();
/*  424 */         String amCtx = "java:/jaas/" + securityDomain + "/authorizationMgr";
/*      */         try
/*      */         {
/*  427 */           AuthorizationManager authzmgr = (AuthorizationManager)ic.lookup(amCtx);
/*  428 */           if ((authzmgr instanceof PolicyRegistration))
/*      */           {
/*  430 */             PolicyRegistration xam = (PolicyRegistration)authzmgr;
/*  431 */             xam.registerPolicy(contextID, xacmlFile.toURL());
/*      */           }
/*      */         }
/*      */         catch (ClassCastException cce)
/*      */         {
/*  436 */           log.trace("CCE encountered while looking up authorizationmgr for " + securityDomain, cce);
/*      */         }
/*      */       }
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  442 */       destroyService();
/*  443 */       throw e;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void startService()
/*      */     throws Exception
/*      */   {
/*  459 */     ListIterator iter = this.containerOrdering.listIterator();
/*  460 */     while (iter.hasNext())
/*      */     {
/*  462 */       Container con = (Container)iter.next();
/*  463 */       if (con.getBeanMetaData().isEntity())
/*      */       {
/*  465 */         ClassLoader oldCl = SecurityActions.getContextClassLoader();
/*  466 */         SecurityActions.setContextClassLoader(con.getClassLoader());
/*  467 */         con.pushENC();
/*      */         try
/*      */         {
/*  470 */           ((EntityContainer)con).getPersistenceManager().start();
/*      */         }
/*      */         finally
/*      */         {
/*  474 */           con.popENC();
/*      */ 
/*  476 */           SecurityActions.setContextClassLoader(oldCl);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  481 */     iter = this.containerOrdering.listIterator();
/*  482 */     while (iter.hasNext())
/*      */     {
/*  484 */       Container con = (Container)iter.next();
/*  485 */       log.debug("startService, starting container: " + con.getBeanMetaData().getEjbName());
/*  486 */       this.serviceController.start(con.getJmxName());
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void stopService()
/*      */     throws Exception
/*      */   {
/*  495 */     ListIterator iter = this.containerOrdering.listIterator(this.containerOrdering.size());
/*  496 */     while (iter.hasPrevious())
/*      */     {
/*  498 */       Container con = (Container)iter.previous();
/*      */       try
/*      */       {
/*  501 */         ObjectName jmxName = con.getJmxName();
/*      */ 
/*  503 */         BeanMetaData metaData = con.getBeanMetaData();
/*  504 */         String ejbName = metaData != null ? metaData.getEjbName() : "Unknown";
/*  505 */         log.debug("stopService, stopping container: " + ejbName);
/*      */ 
/*  507 */         this.serviceController.stop(jmxName);
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  511 */         log.error("unexpected exception stopping Container: " + con.getJmxName(), e);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void destroyService() throws Exception
/*      */   {
/*  518 */     WebServiceMBean webServer = null;
/*  519 */     if (this.webServiceName != null)
/*      */     {
/*  521 */       webServer = (WebServiceMBean)MBeanProxyExt.create(WebServiceMBean.class, this.webServiceName);
/*      */     }
/*      */ 
/*  525 */     ListIterator iter = this.containerOrdering.listIterator(this.containerOrdering.size());
/*      */ 
/*  527 */     String contextID = this.appMetaData.getJaccContextID();
/*      */ 
/*  529 */     String securityDomain = SecurityUtil.unprefixSecurityDomain(this.appMetaData.getSecurityDomain());
/*  530 */     if (securityDomain != null)
/*      */     {
/*  533 */       InitialContext ic = new InitialContext();
/*  534 */       String amCtx = "java:/jaas/" + securityDomain + "/authorizationMgr";
/*      */       try
/*      */       {
/*  537 */         AuthorizationManager authzmgr = (AuthorizationManager)ic.lookup(amCtx);
/*  538 */         if ((authzmgr instanceof PolicyRegistration))
/*      */         {
/*  540 */           PolicyRegistration xam = (PolicyRegistration)authzmgr;
/*  541 */           xam.deRegisterPolicy(contextID);
/*      */         }
/*      */       }
/*      */       catch (ClassCastException cce)
/*      */       {
/*  546 */         log.trace("CCE experienced in looking up authorization manager for " + securityDomain, cce);
/*      */       }
/*      */     }
/*      */ 
/*  550 */     while (iter.hasPrevious())
/*      */     {
/*  552 */       Container con = (Container)iter.previous();
/*  553 */       ObjectName jmxName = con.getJmxName();
/*  554 */       int conState = con.getState();
/*  555 */       boolean destroyContainer = true;
/*  556 */       log.debug("Looking to destroy container: " + jmxName + ", state: " + con.getStateString() + ", destroy: " + destroyContainer);
/*      */ 
/*  560 */       int jmxHash = jmxName.hashCode();
/*  561 */       Registry.unbind(new Integer(jmxHash));
/*      */ 
/*  566 */       if (webServer != null)
/*      */       {
/*  568 */         ClassLoader wcl = con.getWebClassLoader();
/*  569 */         if (wcl != null)
/*      */         {
/*      */           try
/*      */           {
/*  573 */             webServer.removeClassLoader(wcl);
/*      */           }
/*      */           catch (Throwable e)
/*      */           {
/*  577 */             log.warn("Failed to unregister webClassLoader", e);
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  583 */       if (destroyContainer)
/*      */       {
/*      */         try
/*      */         {
/*  587 */           this.serviceController.destroy(jmxName);
/*  588 */           this.serviceController.remove(jmxName);
/*  589 */           log.info("Undeployed " + con.getBeanMetaData().getEjbName());
/*  590 */           if (this.server.isRegistered(jmxName))
/*  591 */             this.server.unregisterMBean(jmxName);
/*      */         }
/*      */         catch (Throwable e)
/*      */         {
/*  595 */           log.error("unexpected exception destroying Container: " + jmxName, e);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  601 */       con.setBeanMetaData(null);
/*  602 */       con.setWebClassLoader(null);
/*  603 */       con.setClassLoader(null);
/*  604 */       con.setEjbModule(null);
/*  605 */       con.setDeploymentInfo(null);
/*  606 */       con.setTransactionManager(null);
/*  607 */       con.setSecurityManager(null);
/*  608 */       con.setRealmMapping(null);
/*  609 */       con.setSecurityProxy(null);
/*  610 */       con.setSecurityManagement(null);
/*  611 */       con.proxyFactories.clear();
/*      */     }
/*      */ 
/*  614 */     this.containers.clear();
/*  615 */     this.localHomes.clear();
/*  616 */     this.containerOrdering.clear();
/*  617 */     this.moduleData.clear();
/*  618 */     this.serviceController = null;
/*      */   }
/*      */ 
/*      */   private Container createContainer(BeanMetaData bean, VFSDeploymentUnit unit)
/*      */     throws Exception
/*      */   {
/*  628 */     Container container = null;
/*      */ 
/*  630 */     if (bean.isMessageDriven())
/*      */     {
/*  632 */       container = createMessageDrivenContainer(bean, unit);
/*      */     }
/*  634 */     else if (bean.isSession())
/*      */     {
/*  636 */       if (((SessionMetaData)bean).isStateless())
/*      */       {
/*  638 */         container = createStatelessSessionContainer((SessionMetaData)bean, unit);
/*      */       }
/*      */       else
/*      */       {
/*  642 */         container = createStatefulSessionContainer((SessionMetaData)bean, unit);
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  647 */       container = createEntityContainer(bean, unit);
/*      */     }
/*      */ 
/*  650 */     container.setDeploymentUnit(unit);
/*      */ 
/*  652 */     return container;
/*      */   }
/*      */ 
/*      */   private MessageDrivenContainer createMessageDrivenContainer(BeanMetaData bean, DeploymentUnit unit)
/*      */     throws Exception
/*      */   {
/*  661 */     ConfigurationMetaData conf = bean.getContainerConfiguration();
/*      */ 
/*  664 */     MessageDrivenContainer container = new MessageDrivenContainer();
/*  665 */     int transType = bean.isContainerManagedTx() ? 2 : 1;
/*      */ 
/*  667 */     initializeContainer(container, conf, bean, transType, unit);
/*  668 */     createProxyFactories(bean, container);
/*  669 */     container.setInstancePool(createInstancePool(conf, unit.getClassLoader()));
/*      */ 
/*  671 */     return container;
/*      */   }
/*      */ 
/*      */   private StatelessSessionContainer createStatelessSessionContainer(SessionMetaData bean, DeploymentUnit unit)
/*      */     throws Exception
/*      */   {
/*  680 */     ConfigurationMetaData conf = bean.getContainerConfiguration();
/*      */ 
/*  682 */     StatelessSessionContainer container = new StatelessSessionContainer();
/*  683 */     int transType = bean.isContainerManagedTx() ? 2 : 1;
/*  684 */     initializeContainer(container, conf, bean, transType, unit);
/*  685 */     if ((bean.getHome() != null) || (bean.getServiceEndpoint() != null))
/*      */     {
/*  687 */       createProxyFactories(bean, container);
/*      */     }
/*  689 */     container.setInstancePool(createInstancePool(conf, unit.getClassLoader()));
/*      */ 
/*  691 */     return container;
/*      */   }
/*      */ 
/*      */   private StatefulSessionContainer createStatefulSessionContainer(SessionMetaData bean, DeploymentUnit unit)
/*      */     throws Exception
/*      */   {
/*  700 */     ConfigurationMetaData conf = bean.getContainerConfiguration();
/*      */ 
/*  702 */     StatefulSessionContainer container = new StatefulSessionContainer();
/*  703 */     int transType = bean.isContainerManagedTx() ? 2 : 1;
/*  704 */     initializeContainer(container, conf, bean, transType, unit);
/*  705 */     if ((bean.getHome() != null) || (bean.getServiceEndpoint() != null))
/*      */     {
/*  707 */       createProxyFactories(bean, container);
/*      */     }
/*      */ 
/*  710 */     ClassLoader cl = unit.getClassLoader();
/*  711 */     container.setInstanceCache(createInstanceCache(conf, cl));
/*      */ 
/*  713 */     StatefulSessionInstancePool ip = new StatefulSessionInstancePool();
/*  714 */     ip.importXml(conf.getContainerPoolConf());
/*  715 */     container.setInstancePool(ip);
/*      */ 
/*  717 */     container.setPersistenceManager((StatefulSessionPersistenceManager)cl.loadClass(conf.getPersistenceManager()).newInstance());
/*      */ 
/*  719 */     container.setLockManager(createBeanLockManager(container, false, conf.getLockClass(), cl));
/*      */ 
/*  721 */     return container;
/*      */   }
/*      */ 
/*      */   private EntityContainer createEntityContainer(BeanMetaData bean, DeploymentUnit unit)
/*      */     throws Exception
/*      */   {
/*  730 */     ConfigurationMetaData conf = bean.getContainerConfiguration();
/*      */ 
/*  732 */     EntityContainer container = new EntityContainer();
/*  733 */     int transType = 2;
/*  734 */     initializeContainer(container, conf, bean, transType, unit);
/*  735 */     if (bean.getHome() != null)
/*      */     {
/*  737 */       createProxyFactories(bean, container);
/*      */     }
/*      */ 
/*  740 */     ClassLoader cl = unit.getClassLoader();
/*  741 */     container.setInstanceCache(createInstanceCache(conf, cl));
/*  742 */     container.setInstancePool(createInstancePool(conf, cl));
/*      */ 
/*  744 */     boolean reentrant = ((EntityMetaData)bean).isReentrant();
/*  745 */     BeanLockManager lockMgr = createBeanLockManager(container, reentrant, conf.getLockClass(), cl);
/*  746 */     container.setLockManager(lockMgr);
/*      */ 
/*  749 */     if (((EntityMetaData)bean).isBMP())
/*      */     {
/*  751 */       Class pmClass = cl.loadClass(conf.getPersistenceManager());
/*  752 */       EntityPersistenceManager pm = (EntityPersistenceManager)pmClass.newInstance();
/*  753 */       container.setPersistenceManager(pm);
/*      */     }
/*      */     else
/*      */     {
/*  758 */       CMPPersistenceManager persistenceManager = new CMPPersistenceManager();
/*      */ 
/*  762 */       Class pmClass = cl.loadClass(conf.getPersistenceManager());
/*  763 */       EntityPersistenceStore pm = (EntityPersistenceStore)pmClass.newInstance();
/*  764 */       persistenceManager.setPersistenceStore(pm);
/*      */ 
/*  766 */       container.setPersistenceManager(persistenceManager);
/*      */     }
/*      */ 
/*  769 */     return container;
/*      */   }
/*      */ 
/*      */   private void initializeContainer(Container container, ConfigurationMetaData conf, BeanMetaData bean, int transType, DeploymentUnit unit)
/*      */     throws NamingException, DeploymentException
/*      */   {
/*  791 */     container.setEjbModule(this);
/*  792 */     container.setBeanMetaData(bean);
/*      */ 
/*  794 */     ClassLoader unitCl = unit.getClassLoader();
/*      */ 
/*  797 */     String webClassLoaderName = getWebClassLoader(conf, bean);
/*  798 */     log.debug("Creating WebClassLoader of class " + webClassLoaderName);
/*  799 */     WebClassLoader wcl = null;
/*      */     try
/*      */     {
/*  802 */       Class clazz = unitCl.loadClass(webClassLoaderName);
/*  803 */       wcl = WebClassLoaderFactory.createWebClassLoader(clazz, container.getJmxName(), (RealClassLoader)unitCl);
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  807 */       throw new DeploymentException("Failed to create WebClassLoader of class " + webClassLoaderName + ": ", e);
/*      */     }
/*      */ 
/*  812 */     if (this.webServiceName != null)
/*      */     {
/*  814 */       WebServiceMBean webServer = (WebServiceMBean)MBeanProxyExt.create(WebServiceMBean.class, this.webServiceName);
/*      */ 
/*  817 */       URL[] codebase = { webServer.addClassLoader(wcl) };
/*      */ 
/*  820 */       wcl.setWebURLs(codebase);
/*      */     }
/*      */ 
/*  823 */     container.setWebClassLoader(wcl);
/*      */ 
/*  826 */     container.setClassLoader(new DelegatingClassLoader(wcl));
/*      */ 
/*  829 */     InitialContext iniCtx = new InitialContext();
/*  830 */     container.setTransactionManager(this.tmFactory.getTransactionManager());
/*      */ 
/*  833 */     container.setTimerService(this.timerService);
/*      */ 
/*  836 */     String securityDomain = bean.getApplicationMetaData().getSecurityDomain();
/*  837 */     String confSecurityDomain = conf.getSecurityDomain();
/*      */ 
/*  839 */     if (confSecurityDomain == null) {
/*  840 */       confSecurityDomain = securityDomain;
/*      */     }
/*      */ 
/*  843 */     if ((confSecurityDomain != null) && (confSecurityDomain.length() == 0)) {
/*  844 */       confSecurityDomain = null;
/*      */     }
/*  846 */     if (confSecurityDomain != null)
/*      */     {
/*      */       try
/*      */       {
/*  850 */         String unprefixed = SecurityUtil.unprefixSecurityDomain(confSecurityDomain);
/*  851 */         log.debug("Setting security domain from: " + confSecurityDomain);
/*  852 */         String domainCtx = "java:/jaas/" + unprefixed + "/domainContext";
/*  853 */         SecurityDomainContext sdc = (SecurityDomainContext)iniCtx.lookup(domainCtx);
/*  854 */         Object securityMgr = sdc.getSecurityManager();
/*      */ 
/*  857 */         AuthenticationManager ejbS = (AuthenticationManager)securityMgr;
/*  858 */         RealmMapping rM = (RealmMapping)securityMgr;
/*  859 */         container.setSecurityManager(ejbS);
/*  860 */         container.setRealmMapping(rM);
/*      */ 
/*  862 */         container.setSecurityManagement((ISecurityManagement)unit.getAttachment("EJB.securityManagement"));
/*      */ 
/*  864 */         container.setDefaultSecurityDomain((String)unit.getAttachment("EJB.defaultSecurityDomain"));
/*  865 */         container.setSecurityContextClassName((String)unit.getAttachment("EJB.securityContextClassName"));
/*      */       }
/*      */       catch (NamingException e)
/*      */       {
/*  869 */         throw new DeploymentException("Could not find the security-domain, name=" + confSecurityDomain, e);
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  873 */         throw new DeploymentException("Invalid security-domain specified, name=" + confSecurityDomain, e);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  878 */     String securityProxyClassName = bean.getSecurityProxy();
/*  879 */     if (securityProxyClassName != null)
/*      */     {
/*      */       try
/*      */       {
/*  883 */         Class proxyClass = unitCl.loadClass(securityProxyClassName);
/*  884 */         Object proxy = proxyClass.newInstance();
/*  885 */         container.setSecurityProxy(proxy);
/*  886 */         log.debug("setSecurityProxy, " + proxy);
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  890 */         throw new DeploymentException("Failed to create SecurityProxy of type: " + securityProxyClassName, e);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  896 */     addInterceptors(container, transType, conf.getContainerInterceptorsConf());
/*      */   }
/*      */ 
/*      */   private static String getWebClassLoader(ConfigurationMetaData conf, BeanMetaData bmd)
/*      */     throws DeploymentException
/*      */   {
/*  906 */     String webClassLoader = null;
/*  907 */     Iterator it = bmd.getInvokerBindings();
/*  908 */     int count = 0;
/*  909 */     while (it.hasNext())
/*      */     {
/*  911 */       String invoker = (String)it.next();
/*  912 */       ApplicationMetaData amd = bmd.getApplicationMetaData();
/*  913 */       InvokerProxyBindingMetaData imd = amd.getInvokerProxyBindingMetaDataByName(invoker);
/*      */ 
/*  915 */       if (imd == null)
/*      */       {
/*  917 */         String msg = "Failed to find InvokerProxyBindingMetaData for: '" + invoker + "'. Check the invoker-proxy-binding-name to " + "invoker-proxy-binding/name mappings in jboss.xml";
/*      */ 
/*  920 */         throw new DeploymentException(msg);
/*      */       }
/*      */ 
/*  923 */       Element proxyFactoryConfig = imd.getProxyFactoryConfig();
/*  924 */       String webCL = MetaData.getOptionalChildContent(proxyFactoryConfig, "web-class-loader");
/*      */ 
/*  926 */       if (webCL != null)
/*      */       {
/*  928 */         log.debug("Invoker " + invoker + " specified WebClassLoader class" + webCL);
/*      */ 
/*  930 */         webClassLoader = webCL;
/*  931 */         count++;
/*      */       }
/*      */     }
/*  934 */     if (count > 1)
/*      */     {
/*  936 */       log.warn(count + " invokers have WebClassLoader specifications.");
/*  937 */       log.warn("Using the last specification seen (" + webClassLoader + ").");
/*      */     }
/*  940 */     else if (count == 0)
/*      */     {
/*  942 */       webClassLoader = conf.getWebClassLoader();
/*  943 */       if (webClassLoader == null)
/*  944 */         webClassLoader = "org.jboss.web.WebClassLoader";
/*      */     }
/*  946 */     return webClassLoader;
/*      */   }
/*      */ 
/*      */   private void addInterceptors(Container container, int transType, Element element)
/*      */     throws DeploymentException
/*      */   {
/*  965 */     Iterator interceptorElements = MetaData.getChildrenByTagName(element, "interceptor");
/*  966 */     String transTypeString = stringTransactionValue(transType);
/*  967 */     ClassLoader loader = container.getClassLoader();
/*      */ 
/*  971 */     ArrayList istack = new ArrayList();
/*  972 */     while ((interceptorElements != null) && (interceptorElements.hasNext()))
/*      */     {
/*  974 */       Element ielement = (Element)interceptorElements.next();
/*      */ 
/*  979 */       String transAttr = ielement.getAttribute("transaction");
/*  980 */       if ((transAttr == null) || (transAttr.length() == 0))
/*  981 */         transAttr = "Both";
/*  982 */       if ((transAttr.equalsIgnoreCase("Both")) || (transAttr.equalsIgnoreCase(transTypeString)))
/*      */       {
/*  985 */         String className = null;
/*      */         try
/*      */         {
/*  988 */           className = MetaData.getFirstElementContent(ielement, null);
/*  989 */           Class clazz = loader.loadClass(className);
/*  990 */           Interceptor interceptor = (Interceptor)clazz.newInstance();
/*  991 */           if ((interceptor instanceof XmlLoadable))
/*      */           {
/*  993 */             ((XmlLoadable)interceptor).importXml(ielement);
/*      */           }
/*  995 */           istack.add(interceptor);
/*      */         }
/*      */         catch (ClassNotFoundException e)
/*      */         {
/*  999 */           log.warn("Could not load the " + className + " interceptor", e);
/*      */         }
/*      */         catch (Exception e)
/*      */         {
/* 1003 */           log.warn("Could not load the " + className + " interceptor for this container", e);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1008 */     if (istack.size() == 0) {
/* 1009 */       log.warn("There are no interceptors configured. Check the standardjboss.xml file");
/*      */     }
/*      */ 
/* 1012 */     for (int i = 0; i < istack.size(); i++)
/*      */     {
/* 1014 */       Interceptor interceptor = (Interceptor)istack.get(i);
/* 1015 */       container.addInterceptor(interceptor);
/*      */     }
/*      */ 
/* 1021 */     if (container.getSecurityProxy() != null) {
/* 1022 */       container.addInterceptor(new SecurityProxyInterceptor());
/*      */     }
/*      */ 
/* 1025 */     container.addInterceptor(container.createContainerInterceptor());
/*      */   }
/*      */ 
/*      */   void createMissingPermissions(Container con, BeanMetaData bean)
/*      */     throws ClassNotFoundException, PolicyContextException
/*      */   {
/* 1040 */     String contextID = con.getJaccContextID();
/* 1041 */     PolicyConfigurationFactory pcFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
/* 1042 */     PolicyConfiguration pc = pcFactory.getPolicyConfiguration(contextID, false);
/* 1043 */     Class clazz = con.getHomeClass();
/*      */ 
/* 1045 */     boolean hasSecurityDomain = con.getSecurityManager() != null;
/* 1046 */     boolean exclude = hasSecurityDomain ? bean.isExcludeMissingMethods() : false;
/*      */ 
/* 1048 */     if (clazz != null)
/*      */     {
/* 1050 */       addMissingMethodPermissions(bean, exclude, clazz, InvocationType.HOME, pc);
/*      */     }
/* 1052 */     clazz = con.getLocalHomeClass();
/* 1053 */     if (clazz != null)
/*      */     {
/* 1055 */       addMissingMethodPermissions(bean, exclude, clazz, InvocationType.LOCALHOME, pc);
/*      */     }
/* 1057 */     clazz = con.getLocalClass();
/* 1058 */     if (clazz != null)
/*      */     {
/* 1060 */       addMissingMethodPermissions(bean, exclude, clazz, InvocationType.LOCAL, pc);
/*      */     }
/* 1062 */     clazz = con.getRemoteClass();
/* 1063 */     if (clazz != null)
/*      */     {
/* 1065 */       addMissingMethodPermissions(bean, exclude, clazz, InvocationType.REMOTE, pc);
/*      */     }
/* 1067 */     pc.commit();
/*      */   }
/*      */ 
/*      */   private void getInterfaces(Class iface, HashSet tmp)
/*      */   {
/* 1072 */     tmp.add(iface);
/* 1073 */     Class[] ifaces = iface.getInterfaces();
/* 1074 */     for (int n = 0; n < ifaces.length; n++)
/*      */     {
/* 1076 */       Class iface2 = ifaces[n];
/* 1077 */       tmp.add(iface2);
/* 1078 */       getInterfaces(iface2, tmp);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addMissingMethodPermissions(BeanMetaData bean, boolean exclude, Class iface, InvocationType type, PolicyConfiguration pc)
/*      */     throws PolicyContextException
/*      */   {
/* 1085 */     String ejbName = bean.getEjbName();
/* 1086 */     HashSet tmp = new HashSet();
/* 1087 */     getInterfaces(iface, tmp);
/* 1088 */     Class[] ifaces = new Class[tmp.size()];
/* 1089 */     tmp.toArray(ifaces);
/* 1090 */     for (int n = 0; n < ifaces.length; n++)
/*      */     {
/* 1092 */       Class c = ifaces[n];
/* 1093 */       Method[] methods = c.getDeclaredMethods();
/* 1094 */       for (int m = 0; m < methods.length; m++)
/*      */       {
/* 1096 */         String methodName = methods[m].getName();
/* 1097 */         Class[] params = methods[m].getParameterTypes();
/*      */ 
/* 1099 */         if (bean.hasMethodPermission(methodName, params, type)) {
/*      */           continue;
/*      */         }
/* 1102 */         EJBMethodPermission p = new EJBMethodPermission(ejbName, type.toInterfaceString(), methods[m]);
/*      */ 
/* 1104 */         if (exclude)
/* 1105 */           pc.addToExcludedPolicy(p);
/*      */         else
/* 1107 */           pc.addToUncheckedPolicy(p);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private static String stringTransactionValue(int transType)
/*      */   {
/* 1114 */     String transaction = "Both";
/* 1115 */     switch (transType)
/*      */     {
/*      */     case 1:
/* 1118 */       transaction = "Bean";
/* 1119 */       break;
/*      */     case 2:
/* 1121 */       transaction = "Container";
/*      */     }
/*      */ 
/* 1124 */     return transaction;
/*      */   }
/*      */ 
/*      */   private static void createProxyFactories(BeanMetaData conf, Container container)
/*      */     throws Exception
/*      */   {
/* 1133 */     ClassLoader cl = container.getClassLoader();
/* 1134 */     Iterator it = conf.getInvokerBindings();
/* 1135 */     boolean foundOne = false;
/* 1136 */     while (it.hasNext())
/*      */     {
/* 1138 */       String invoker = (String)it.next();
/* 1139 */       String jndiBinding = conf.getInvokerBinding(invoker);
/* 1140 */       log.debug("creating binding for " + jndiBinding + ":" + invoker);
/* 1141 */       InvokerProxyBindingMetaData imd = conf.getApplicationMetaData().getInvokerProxyBindingMetaDataByName(invoker);
/* 1142 */       EJBProxyFactory ci = null;
/*      */       try
/*      */       {
/* 1147 */         ci = (EJBProxyFactory)cl.loadClass(imd.getProxyFactory()).newInstance();
/* 1148 */         ci.setContainer(container);
/* 1149 */         ci.setInvokerMetaData(imd);
/* 1150 */         ci.setInvokerBinding(jndiBinding);
/* 1151 */         if ((ci instanceof XmlLoadable))
/*      */         {
/* 1154 */           ((XmlLoadable)ci).importXml(imd.getProxyFactoryConfig());
/*      */         }
/* 1156 */         container.addProxyFactory(invoker, ci);
/* 1157 */         foundOne = true;
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/* 1161 */         log.warn("The Container Invoker " + invoker + " (in jboss.xml or standardjboss.xml) could not be created because of " + e + " We will ignore this error, but you may miss a transport for this bean.");
/*      */       }
/*      */     }
/*      */ 
/* 1165 */     if (!foundOne)
/* 1166 */       throw new DeploymentException("Missing or invalid Container Invokers (in jboss.xml or standardjboss.xml).");
/*      */   }
/*      */ 
/*      */   private static BeanLockManager createBeanLockManager(Container container, boolean reentrant, String beanLock, ClassLoader cl)
/*      */     throws Exception
/*      */   {
/* 1176 */     BeanLockManager lockManager = new BeanLockManager(container);
/*      */ 
/* 1178 */     Class lockClass = null;
/*      */     try
/*      */     {
/* 1181 */       if (beanLock == null)
/* 1182 */         beanLock = "org.jboss.ejb.plugins.lock.QueuedPessimisticEJBLock";
/* 1183 */       lockClass = cl.loadClass(beanLock);
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 1187 */       throw new DeploymentException("Missing or invalid lock class (in jboss.xml or standardjboss.xml): " + beanLock + " - " + e);
/*      */     }
/*      */ 
/* 1190 */     lockManager.setLockCLass(lockClass);
/* 1191 */     lockManager.setReentrant(reentrant);
/*      */ 
/* 1193 */     return lockManager;
/*      */   }
/*      */ 
/*      */   private static InstancePool createInstancePool(ConfigurationMetaData conf, ClassLoader cl)
/*      */     throws Exception
/*      */   {
/* 1201 */     InstancePool ip = null;
/*      */     try
/*      */     {
/* 1205 */       ip = (InstancePool)cl.loadClass(conf.getInstancePool()).newInstance();
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 1209 */       throw new DeploymentException("Missing or invalid Instance Pool (in jboss.xml or standardjboss.xml)", e);
/*      */     }
/*      */ 
/* 1212 */     if ((ip instanceof XmlLoadable)) {
/* 1213 */       ((XmlLoadable)ip).importXml(conf.getContainerPoolConf());
/*      */     }
/* 1215 */     return ip;
/*      */   }
/*      */ 
/*      */   private static InstanceCache createInstanceCache(ConfigurationMetaData conf, ClassLoader cl)
/*      */     throws Exception
/*      */   {
/* 1223 */     InstanceCache ic = null;
/*      */     try
/*      */     {
/* 1227 */       ic = (InstanceCache)cl.loadClass(conf.getInstanceCache()).newInstance();
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 1231 */       throw new DeploymentException("Missing or invalid Instance Cache (in jboss.xml or standardjboss.xml)", e);
/*      */     }
/*      */ 
/* 1234 */     if ((ic instanceof XmlLoadable)) {
/* 1235 */       ((XmlLoadable)ic).importXml(conf.getContainerCacheConf());
/*      */     }
/* 1237 */     return ic;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.EjbModule
 * JD-Core Version:    0.6.0
 */