/*    */ package org.jboss.ejb;
/*    */ 
/*    */ import java.io.PrintWriter;
/*    */ import java.io.StringWriter;
/*    */ import java.lang.reflect.Method;
/*    */ import java.security.ProtectionDomain;
/*    */ import javax.management.MBeanServer;
/*    */ import javax.management.ObjectName;
/*    */ import javax.management.RuntimeOperationsException;
/*    */ import org.jboss.system.ServiceMBeanSupport;
/*    */ 
/*    */ public class ContainerRelection extends ServiceMBeanSupport
/*    */   implements ContainerRelectionMBean
/*    */ {
/*    */   public String inspectEJB(String jndiName)
/*    */   {
/* 53 */     MBeanServer server = getServer();
/* 54 */     StringBuffer buffer = new StringBuffer();
/*    */     try
/*    */     {
/* 57 */       buffer.append("<pre>");
/* 58 */       ObjectName containerName = new ObjectName(":service=Container,jndiName=" + jndiName);
/* 59 */       Class homeClass = (Class)server.invoke(containerName, "getHome", null, null);
/* 60 */       buffer.append("\nHome class = " + homeClass);
/* 61 */       buffer.append("\nClassLoader: " + homeClass.getClassLoader());
/* 62 */       buffer.append("\nCodeSource: " + homeClass.getProtectionDomain().getCodeSource());
/* 63 */       buffer.append("\n- Methods:");
/* 64 */       Method[] homeMethods = homeClass.getMethods();
/* 65 */       for (int m = 0; m < homeMethods.length; m++)
/* 66 */         buffer.append("\n--- " + homeMethods[m]);
/* 67 */       Class remoteClass = (Class)server.invoke(containerName, "getRemote", null, null);
/* 68 */       buffer.append("\nRemote class = " + remoteClass);
/* 69 */       buffer.append("\n- Methods:");
/* 70 */       Method[] remoteMethods = remoteClass.getMethods();
/* 71 */       for (int m = 0; m < remoteMethods.length; m++)
/* 72 */         buffer.append("\n--- " + remoteMethods[m]);
/* 73 */       buffer.append("\n</pre>\n");
/*    */     }
/*    */     catch (Throwable e)
/*    */     {
/* 77 */       if ((e instanceof RuntimeOperationsException))
/*    */       {
/* 79 */         RuntimeOperationsException roe = (RuntimeOperationsException)e;
/* 80 */         e = roe.getTargetException();
/*    */       }
/* 82 */       StringWriter sw = new StringWriter();
/* 83 */       PrintWriter pw = new PrintWriter(sw);
/* 84 */       e.printStackTrace(pw);
/* 85 */       buffer.append(sw.toString());
/* 86 */       buffer.append("\n</pre>\n");
/*    */     }
/* 88 */     return buffer.toString();
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 93 */     return "ContainerRelection";
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.ContainerRelection
 * JD-Core Version:    0.6.0
 */