/*     */ package org.jboss.deployment.security;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.vfs.spi.deployer.AbstractVFSRealDeployer;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.JBossMetaData;
/*     */ import org.jboss.metadata.web.jboss.JBossWebMetaData;
/*     */ import org.jboss.system.metadata.ServiceAttributeMetaData;
/*     */ import org.jboss.system.metadata.ServiceConstructorMetaData;
/*     */ import org.jboss.system.metadata.ServiceDependencyMetaData;
/*     */ import org.jboss.system.metadata.ServiceDeployment;
/*     */ import org.jboss.system.metadata.ServiceInjectionValueMetaData;
/*     */ import org.jboss.system.metadata.ServiceMetaData;
/*     */ 
/*     */ public class SecurityDeployer extends AbstractVFSRealDeployer
/*     */ {
/*  59 */   private HashSet<String> ignoreSuffixes = null;
/*     */ 
/*  61 */   String BASE_OBJECT_NAME = "jboss:service=jacc,id=";
/*     */ 
/*     */   public SecurityDeployer()
/*     */   {
/*  65 */     setTopLevelOnly(true);
/*     */ 
/*  68 */     setInputs(new String[] { JBossWebMetaData.class.getName(), JBossMetaData.class.getName(), JBossEnterpriseBeanMetaData.class.getName(), JaccPolicyUtil.IGNORE_ME_NAME });
/*     */ 
/*  74 */     setOutputs(new String[] { "jboss.jacc" });
/*     */   }
/*     */ 
/*     */   public void setIgnoreSuffixes(HashSet<String> suffixSet)
/*     */   {
/*  79 */     this.ignoreSuffixes = suffixSet;
/*     */   }
/*     */ 
/*     */   public void deploy(VFSDeploymentUnit unit)
/*     */     throws DeploymentException
/*     */   {
/*  85 */     String contextId = unit.getSimpleName();
/*     */ 
/*  87 */     for (String suffix : this.ignoreSuffixes)
/*     */     {
/*  89 */       String dotSuffix = "." + suffix;
/*  90 */       if (contextId.endsWith(dotSuffix))
/*     */       {
/*  92 */         this.log.debug("Ignoring: " + contextId);
/*  93 */         return;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  98 */     List jaccDeployments = JaccPolicyUtil.getJaccDeployments(unit, this.ignoreSuffixes);
/*     */ 
/* 100 */     if (jaccDeployments.size() == 0)
/*     */     {
/* 102 */       boolean ejbJar = (contextId.endsWith("jar")) && (JaccPolicyUtil.isEJBDeployment(unit));
/* 103 */       if ((contextId.endsWith("war")) || (ejbJar))
/*     */       {
/* 105 */         createTopLevelServiceBeanWithMetaData(contextId, unit);
/* 106 */         return;
/*     */       }
/* 108 */       return;
/*     */     }
/*     */ 
/* 112 */     if (getMetaData(unit) != null)
/* 113 */       createTopLevelServiceBeanWithMetaData(contextId, unit);
/*     */     else {
/* 115 */       createTopLevelServiceBean(contextId, unit);
/*     */     }
/*     */ 
/* 118 */     for (String str : jaccDeployments)
/*     */     {
/* 121 */       DeploymentUnit childDU = getChildDeployment(unit, str);
/*     */ 
/* 123 */       Object metadata = getMetaData(childDU);
/* 124 */       if (metadata == null)
/*     */       {
/* 126 */         this.log.debug("meta data is null for child deployment:" + childDU.getSimpleName() + "; No Jacc policy created.");
/*     */ 
/* 128 */         continue;
/*     */       }
/*     */ 
/* 131 */       ServiceMetaData subjaccPolicy = new ServiceMetaData();
/* 132 */       subjaccPolicy.setCode(PolicyConfigurationFacade.class.getName());
/*     */       try
/*     */       {
/* 135 */         subjaccPolicy.setObjectName(new ObjectName(this.BASE_OBJECT_NAME + str));
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 139 */         throw new RuntimeException(e);
/*     */       }
/*     */ 
/* 142 */       ServiceConstructorMetaData constructor = new ServiceConstructorMetaData();
/* 143 */       constructor.setSignature(new String[] { String.class.getName(), Object.class.getName() });
/* 144 */       constructor.setParameters(new Object[] { str, getMetaData(childDU) });
/* 145 */       subjaccPolicy.setConstructor(constructor);
/*     */ 
/* 147 */       ArrayList services = new ArrayList();
/* 148 */       services.add(subjaccPolicy);
/* 149 */       childDU.addAttachment("jboss.jacc", subjaccPolicy, ServiceMetaData.class);
/*     */ 
/* 152 */       ServiceMetaData parentJacc = (ServiceMetaData)childDU.getParent().getAttachment("jboss.jacc");
/* 153 */       if (parentJacc == null) {
/* 154 */         throw new IllegalStateException("Parent JACC Policy is null");
/*     */       }
/* 156 */       List dependencies = new ArrayList();
/* 157 */       ServiceDependencyMetaData sdmd = new ServiceDependencyMetaData();
/* 158 */       sdmd.setIDependOnObjectName(subjaccPolicy.getObjectName());
/* 159 */       dependencies.add(sdmd);
/* 160 */       parentJacc.setDependencies(dependencies);
/*     */ 
/* 163 */       List attributes = new ArrayList();
/* 164 */       ServiceAttributeMetaData attribute = new ServiceAttributeMetaData();
/* 165 */       attribute.setName("JaccPolicyMBean");
/* 166 */       String parentObjectName = parentJacc.getObjectName().getCanonicalName();
/* 167 */       ServiceInjectionValueMetaData sivmd = new ServiceInjectionValueMetaData(parentObjectName);
/* 168 */       sivmd.setDependentState(ControllerState.CONFIGURED);
/* 169 */       attribute.setValue(sivmd);
/* 170 */       attributes.add(attribute);
/* 171 */       attributes.addAll(subjaccPolicy.getAttributes());
/* 172 */       subjaccPolicy.setAttributes(attributes);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void undeploy(VFSDeploymentUnit unit)
/*     */   {
/* 180 */     unit.removeAttachment("jboss.jaccpolicy", ServiceDeployment.class);
/* 181 */     List jaccDeployments = JaccPolicyUtil.getJaccDeployments(unit, this.ignoreSuffixes);
/* 182 */     for (String deployment : jaccDeployments)
/*     */     {
/* 184 */       DeploymentUnit childDU = getChildDeployment(unit, deployment);
/* 185 */       if (childDU != null)
/* 186 */         childDU.removeAttachment("jboss.jaccpolicy", ServiceDeployment.class);
/*     */     }
/*     */   }
/*     */ 
/*     */   private DeploymentUnit getChildDeployment(DeploymentUnit parent, String id)
/*     */   {
/* 195 */     List children = parent.getChildren();
/* 196 */     for (DeploymentUnit child : children)
/*     */     {
/* 198 */       if (id.equals(child.getSimpleName())) {
/* 199 */         return child;
/*     */       }
/*     */     }
/* 202 */     return null;
/*     */   }
/*     */ 
/*     */   private void createTopLevelServiceBeanWithMetaData(String contextId, DeploymentUnit unit)
/*     */   {
/* 208 */     ServiceConstructorMetaData constructor = new ServiceConstructorMetaData();
/* 209 */     constructor.setSignature(new String[] { String.class.getName(), Object.class.getName(), Boolean.class.getName() });
/*     */ 
/* 211 */     constructor.setParameters(new Object[] { contextId, getMetaData(unit), Boolean.TRUE });
/* 212 */     createJaccPolicyBean(constructor, unit);
/*     */   }
/*     */ 
/*     */   private void createTopLevelServiceBean(String contextId, DeploymentUnit unit)
/*     */   {
/* 218 */     ServiceConstructorMetaData constructor = new ServiceConstructorMetaData();
/* 219 */     constructor.setSignature(new String[] { String.class.getName() });
/* 220 */     constructor.setParameters(new Object[] { contextId });
/*     */ 
/* 222 */     createJaccPolicyBean(constructor, unit);
/*     */   }
/*     */ 
/*     */   private void createJaccPolicyBean(ServiceConstructorMetaData constructor, DeploymentUnit unit)
/*     */   {
/* 228 */     ServiceMetaData jaccPolicy = new ServiceMetaData();
/* 229 */     jaccPolicy.setCode(JaccPolicy.class.getName());
/*     */     try
/*     */     {
/* 232 */       jaccPolicy.setObjectName(new ObjectName(this.BASE_OBJECT_NAME + unit.getSimpleName()));
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 236 */       throw new RuntimeException(e);
/*     */     }
/*     */ 
/* 239 */     jaccPolicy.setConstructor(constructor);
/* 240 */     ArrayList services = new ArrayList();
/* 241 */     services.add(jaccPolicy);
/*     */ 
/* 243 */     unit.addAttachment("jboss.jacc", jaccPolicy, ServiceMetaData.class);
/*     */   }
/*     */ 
/*     */   private Object getMetaData(DeploymentUnit du)
/*     */   {
/* 248 */     Object md = null;
/*     */ 
/* 250 */     md = du.getAttachment(JBossWebMetaData.class.getName());
/*     */ 
/* 252 */     if (md == null) {
/* 253 */       md = du.getAttachment(JBossMetaData.class.getName());
/*     */     }
/* 255 */     if (md == null)
/* 256 */       md = du.getAttachment(JBossEnterpriseBeanMetaData.class.getName());
/* 257 */     return md;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.security.SecurityDeployer
 * JD-Core Version:    0.6.0
 */