/*     */ package org.jboss.deployment;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Date;
/*     */ import java.util.List;
/*     */ import javax.management.ObjectName;
/*     */ 
/*     */ public class SerializableDeploymentInfo
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -3847995513551913798L;
/*     */   public Date date;
/*     */   public URL url;
/*     */   public URL localUrl;
/*     */   public URL watch;
/*     */   public String shortName;
/*     */   public long lastDeployed;
/*     */   public long lastModified;
/*     */   public String status;
/*     */   public DeploymentState state;
/*     */   public ObjectName deployer;
/*  67 */   public Collection classpath = new ArrayList();
/*     */   public List mbeans;
/*     */   public List subDeployments;
/*     */   public SerializableDeploymentInfo parent;
/*     */   public String webContext;
/*     */   public URL documentUrl;
/*     */   public boolean isXML;
/*     */   public boolean isScript;
/*     */   public boolean isDirectory;
/*     */   public ObjectName deployedObject;
/*     */ 
/*     */   public SerializableDeploymentInfo(DeploymentInfo info)
/*     */   {
/*  93 */     this.date = info.date;
/*  94 */     this.url = info.url;
/*  95 */     this.localUrl = info.localUrl;
/*  96 */     this.watch = info.watch;
/*  97 */     this.shortName = info.shortName;
/*  98 */     this.lastDeployed = info.lastDeployed;
/*  99 */     this.lastModified = info.lastModified;
/* 100 */     this.status = info.status;
/* 101 */     this.state = info.state;
/* 102 */     this.deployer = info.deployer.getServiceName();
/* 103 */     this.classpath = info.classpath;
/* 104 */     this.mbeans = info.mbeans;
/* 105 */     this.webContext = info.webContext;
/* 106 */     this.documentUrl = info.documentUrl;
/* 107 */     this.isXML = info.isXML;
/* 108 */     this.isScript = info.isScript;
/* 109 */     this.isDirectory = info.isDirectory;
/* 110 */     this.deployedObject = info.deployedObject;
/*     */ 
/* 113 */     this.parent = null;
/* 114 */     this.subDeployments = new ArrayList();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 122 */     StringBuffer s = new StringBuffer(super.toString());
/* 123 */     s.append(" { url=" + this.url + " }\n");
/* 124 */     s.append("  deployer: " + this.deployer + "\n");
/* 125 */     s.append("  status: " + this.status + "\n");
/* 126 */     s.append("  state: " + this.state + "\n");
/* 127 */     s.append("  watch: " + this.watch + "\n");
/* 128 */     s.append("  lastDeployed: " + this.lastDeployed + "\n");
/* 129 */     s.append("  lastModified: " + this.lastModified + "\n");
/* 130 */     s.append("  mbeans: " + this.mbeans + "\n");
/* 131 */     s.append(" }\n");
/* 132 */     return s.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.SerializableDeploymentInfo
 * JD-Core Version:    0.6.0
 */