/*     */ package org.jboss.deployment;
/*     */ 
/*     */ import java.net.URL;
/*     */ import java.util.Set;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.vfs.spi.deployer.SchemaResolverDeployer;
/*     */ import org.jboss.metadata.ApplicationMetaData;
/*     */ import org.jboss.metadata.common.jboss.LoaderRepositoryConfigMetaData;
/*     */ import org.jboss.metadata.common.jboss.LoaderRepositoryMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.JBossMetaData;
/*     */ import org.jboss.metadata.ejb.spec.EjbJarMetaData;
/*     */ import org.jboss.mx.loading.LoaderRepositoryFactory.LoaderRepositoryConfig;
/*     */ import org.jboss.virtual.VFS;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class JBossEjbParsingDeployer extends SchemaResolverDeployer<JBossMetaData>
/*     */ {
/*     */   private JBossMetaData standardMetaData;
/*     */   private URL standardJBossXmlPath;
/*  59 */   private boolean ignoreMissingStandardJBossXml = false;
/*     */ 
/*     */   public JBossEjbParsingDeployer()
/*     */   {
/*  67 */     super(JBossMetaData.class);
/*  68 */     setName("jboss.xml");
/*     */ 
/*  71 */     addInput(EjbJarMetaData.class);
/*     */ 
/*  73 */     addOutput(ApplicationMetaData.class.getName());
/*     */ 
/*  75 */     addOutput("standardjboss.xml");
/*     */ 
/*  77 */     addOutput(LoaderRepositoryFactory.LoaderRepositoryConfig.class);
/*     */   }
/*     */ 
/*     */   public URL getStandardJBossXmlPath()
/*     */   {
/*  82 */     return this.standardJBossXmlPath;
/*     */   }
/*     */ 
/*     */   public void setStandardJBossXmlPath(URL standardJBossXmlPath) {
/*  86 */     this.standardJBossXmlPath = standardJBossXmlPath;
/*     */   }
/*     */ 
/*     */   public boolean isIgnoreMissingStandardJBossXml()
/*     */   {
/*  92 */     return this.ignoreMissingStandardJBossXml;
/*     */   }
/*     */ 
/*     */   public void setIgnoreMissingStandardJBossXml(boolean ignoreMissingStandardJBossXml)
/*     */   {
/*  97 */     this.ignoreMissingStandardJBossXml = ignoreMissingStandardJBossXml;
/*     */   }
/*     */ 
/*     */   protected void createMetaData(DeploymentUnit unit, String name, String suffix)
/*     */     throws DeploymentException
/*     */   {
/* 105 */     super.createMetaData(unit, name, suffix);
/*     */ 
/* 107 */     JBossMetaData jbossMetaData = (JBossMetaData)unit.getAttachment(getOutput());
/* 108 */     EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)unit.getAttachment(EjbJarMetaData.class);
/* 109 */     if ((ejbJarMetaData != null) || (jbossMetaData != null))
/*     */     {
/* 112 */       JBossMetaData stdMetaData = getStandardMetaData();
/* 113 */       if (stdMetaData != null) {
/* 114 */         unit.addAttachment("standardjboss.xml", stdMetaData);
/*     */       }
/* 116 */       if (jbossMetaData != null)
/*     */       {
/* 119 */         ApplicationMetaData amd = new ApplicationMetaData(jbossMetaData);
/* 120 */         unit.addAttachment(ApplicationMetaData.class, amd);
/*     */ 
/* 123 */         LoaderRepositoryFactory.LoaderRepositoryConfig loaderRepositoryConfig = createLoaderRepositoryConfig(jbossMetaData);
/* 124 */         if (loaderRepositoryConfig != null)
/* 125 */           unit.addAttachment(LoaderRepositoryFactory.LoaderRepositoryConfig.class.getName(), loaderRepositoryConfig);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected LoaderRepositoryFactory.LoaderRepositoryConfig createLoaderRepositoryConfig(JBossMetaData jbossMetaData)
/*     */     throws DeploymentException
/*     */   {
/* 139 */     LoaderRepositoryMetaData config = jbossMetaData.getLoaderRepository();
/* 140 */     if (config == null) {
/* 141 */       return null;
/*     */     }
/* 143 */     LoaderRepositoryFactory.LoaderRepositoryConfig repositoryConfig = new LoaderRepositoryFactory.LoaderRepositoryConfig();
/*     */ 
/* 145 */     repositoryConfig.repositoryClassName = config.getLoaderRepositoryClass();
/* 146 */     if ((repositoryConfig.repositoryClassName == null) || (repositoryConfig.repositoryClassName.length() == 0)) {
/* 147 */       repositoryConfig.repositoryClassName = "org.jboss.mx.loading.HeirarchicalLoaderRepository3";
/*     */     }
/*     */ 
/* 150 */     String name = config.getName();
/* 151 */     if (name != null)
/*     */     {
/*     */       try
/*     */       {
/* 155 */         repositoryConfig.repositoryName = new ObjectName(name.trim());
/*     */       }
/*     */       catch (MalformedObjectNameException e)
/*     */       {
/* 159 */         throw new DeploymentException("Loader repository name is malformed: " + name, e);
/*     */       }
/*     */     }
/*     */ 
/* 163 */     StringBuilder configData = new StringBuilder();
/* 164 */     Set children = config.getLoaderRepositoryConfig();
/* 165 */     if (children != null)
/*     */     {
/* 167 */       for (LoaderRepositoryConfigMetaData child : children)
/*     */       {
/* 170 */         String parserClassName = child.getConfigParserClass();
/* 171 */         if ((parserClassName == null) || (parserClassName.length() == 0))
/* 172 */           repositoryConfig.configParserClassName = "org.jboss.mx.loading.HeirarchicalLoaderRepository3ConfigParser";
/*     */         else {
/* 174 */           repositoryConfig.configParserClassName = parserClassName;
/*     */         }
/*     */ 
/* 177 */         String childConfig = child.getConfig();
/* 178 */         if (childConfig != null)
/* 179 */           configData.append(childConfig);
/*     */       }
/*     */     }
/* 182 */     repositoryConfig.repositoryConfig = configData.toString().trim();
/* 183 */     return repositoryConfig;
/*     */   }
/*     */ 
/*     */   private JBossMetaData getStandardMetaData() throws DeploymentException
/*     */   {
/* 188 */     if (this.standardMetaData == null)
/*     */     {
/*     */       try
/*     */       {
/* 192 */         if (this.standardJBossXmlPath == null)
/*     */         {
/* 195 */           String configPath = System.getProperty("jboss.server.config.url");
/* 196 */           if (configPath == null)
/*     */           {
/* 198 */             if (!this.ignoreMissingStandardJBossXml)
/* 199 */               throw new DeploymentException("standardjboss.xml not specified and jboss.server.config.url does not exist");
/* 200 */             return null;
/*     */           }
/* 202 */           URL configUrl = new URL(configPath);
/* 203 */           this.standardJBossXmlPath = new URL(configUrl, "standardjboss.xml");
/*     */         }
/*     */ 
/* 206 */         VirtualFile stdJBoss = VFS.getRoot(this.standardJBossXmlPath);
/* 207 */         if ((stdJBoss == null) && (!this.ignoreMissingStandardJBossXml))
/*     */         {
/* 209 */           throw new DeploymentException("standardjboss.xml not found in config dir: " + this.standardJBossXmlPath);
/*     */         }
/* 211 */         this.standardMetaData = ((JBossMetaData)super.parse(null, stdJBoss, null));
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 215 */         DeploymentException.rethrowAsDeploymentException(ex.getMessage(), ex);
/*     */       }
/*     */     }
/* 218 */     return this.standardMetaData;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.JBossEjbParsingDeployer
 * JD-Core Version:    0.6.0
 */