/*     */ package org.jboss.deployment;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.util.List;
/*     */ import java.util.jar.Attributes;
/*     */ import java.util.jar.Attributes.Name;
/*     */ import java.util.jar.Manifest;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.deployer.DeploymentStages;
/*     */ import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.ear.jboss.JBoss50AppMetaData;
/*     */ import org.jboss.metadata.ear.jboss.JBossAppMetaData;
/*     */ import org.jboss.metadata.ear.jboss.ServiceModuleMetaData;
/*     */ import org.jboss.metadata.ear.spec.AbstractModule;
/*     */ import org.jboss.metadata.ear.spec.ConnectorModuleMetaData;
/*     */ import org.jboss.metadata.ear.spec.EjbModuleMetaData;
/*     */ import org.jboss.metadata.ear.spec.JavaModuleMetaData;
/*     */ import org.jboss.metadata.ear.spec.ModuleMetaData;
/*     */ import org.jboss.metadata.ear.spec.ModulesMetaData;
/*     */ import org.jboss.metadata.ear.spec.WebModuleMetaData;
/*     */ import org.jboss.virtual.VFSUtils;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class EARContentsDeployer extends AbstractDeployer
/*     */ {
/*  60 */   private boolean requiresEarSuffix = false;
/*     */ 
/*     */   public EARContentsDeployer(int appParsingOrder)
/*     */   {
/*  71 */     setStage(DeploymentStages.PARSE);
/*  72 */     setRelativeOrder(appParsingOrder + 1);
/*  73 */     setOutput(JBossAppMetaData.class);
/*     */   }
/*     */ 
/*     */   public boolean isRequiresEarSuffix()
/*     */   {
/*  78 */     return this.requiresEarSuffix;
/*     */   }
/*     */ 
/*     */   public void setRequiresEarSuffix(boolean requiresEarSuffix) {
/*  82 */     this.requiresEarSuffix = requiresEarSuffix;
/*     */   }
/*     */ 
/*     */   public void deploy(DeploymentUnit unit)
/*     */     throws DeploymentException
/*     */   {
/*  88 */     if (unit.getParent() != null)
/*     */     {
/*  90 */       return;
/*     */     }
/*     */ 
/*  93 */     if (!(unit instanceof VFSDeploymentUnit))
/*     */     {
/*  95 */       this.log.trace("Not a vfs deployment: " + unit.getName());
/*  96 */       return;
/*     */     }
/*     */ 
/*  99 */     if ((this.requiresEarSuffix) && (!unit.getSimpleName().endsWith(".ear")))
/*     */     {
/* 101 */       this.log.trace("Unit name does not end in .ear: " + unit.getSimpleName());
/* 102 */       return;
/*     */     }
/* 104 */     VFSDeploymentUnit vfsunit = (VFSDeploymentUnit)VFSDeploymentUnit.class.cast(unit);
/*     */ 
/* 108 */     VirtualFile appXml = vfsunit.getMetaDataFile("application.xml");
/* 109 */     if (appXml != null)
/*     */     {
/* 111 */       this.log.trace("Ignoring ear with META-INF/application.xml: " + unit.getSimpleName());
/* 112 */       return;
/*     */     }
/*     */ 
/* 115 */     deploy(vfsunit);
/*     */   }
/*     */ 
/*     */   public void deploy(VFSDeploymentUnit unit)
/*     */     throws DeploymentException
/*     */   {
/* 125 */     VirtualFile root = unit.getRoot();
/* 126 */     VirtualFile ear = unit.getFile(unit.getRelativePath());
/* 127 */     deploy(unit, root, ear);
/*     */   }
/*     */ 
/*     */   protected void deploy(VFSDeploymentUnit unit, VirtualFile root, VirtualFile file)
/*     */   {
/*     */     try
/*     */     {
/* 141 */       JBossAppMetaData j2eeMetaData = new JBoss50AppMetaData();
/*     */ 
/* 143 */       scanEar(unit, file, j2eeMetaData);
/*     */ 
/* 145 */       unit.addAttachment(JBossAppMetaData.class, j2eeMetaData);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 149 */       throw new RuntimeException("Error determining ear contents: " + file.getName(), e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void scanEar(VFSDeploymentUnit unit, VirtualFile root, JBossAppMetaData j2eeMetaData)
/*     */     throws IOException
/*     */   {
/* 176 */     List archives = root.getChildren();
/*     */     String earPath;
/*     */     ModulesMetaData modules;
/* 177 */     if (archives != null)
/*     */     {
/* 179 */       earPath = root.getPathName();
/* 180 */       modules = j2eeMetaData.getModules();
/* 181 */       if (modules == null)
/*     */       {
/* 183 */         modules = new ModulesMetaData();
/* 184 */         j2eeMetaData.setModules(modules);
/*     */       }
/* 186 */       for (VirtualFile vfArchive : archives)
/*     */       {
/* 188 */         String filename = earRelativePath(earPath, vfArchive.getPathName());
/*     */ 
/* 190 */         ModuleMetaData moduleMetaData = j2eeMetaData.getModule(filename);
/* 191 */         int type = typeFromSuffix(unit, filename, vfArchive);
/* 192 */         if ((type >= 0) && (moduleMetaData == null))
/*     */         {
/* 194 */           moduleMetaData = new ModuleMetaData();
/* 195 */           AbstractModule module = null;
/* 196 */           switch (type)
/*     */           {
/*     */           case 0:
/* 199 */             module = new EjbModuleMetaData();
/* 200 */             break;
/*     */           case 2:
/* 202 */             module = new JavaModuleMetaData();
/* 203 */             break;
/*     */           case 3:
/* 205 */             module = new ConnectorModuleMetaData();
/* 206 */             break;
/*     */           case 4:
/*     */           case 5:
/* 209 */             module = new ServiceModuleMetaData();
/* 210 */             break;
/*     */           case 1:
/* 212 */             module = new WebModuleMetaData();
/*     */           }
/*     */ 
/* 215 */           module.setFileName(filename);
/* 216 */           moduleMetaData.setValue(module);
/* 217 */           modules.add(moduleMetaData);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private int typeFromSuffix(VFSDeploymentUnit unit, String path, VirtualFile archive)
/*     */     throws IOException
/*     */   {
/* 226 */     int type = -1;
/* 227 */     if (path.endsWith(".war")) {
/* 228 */       type = 1;
/* 229 */     } else if (path.endsWith(".rar")) {
/* 230 */       type = 3;
/* 231 */     } else if (path.endsWith(".har")) {
/* 232 */       type = 5;
/* 233 */     } else if (path.endsWith(".sar")) {
/* 234 */       type = 4;
/* 235 */     } else if (path.endsWith(".jar"))
/*     */     {
/* 238 */       VirtualFile mfFile = unit.getMetaDataFile("MANIFEST.MF");
/* 239 */       VirtualFile clientXml = unit.getMetaDataFile("application-client.xml");
/* 240 */       VirtualFile ejbXml = unit.getMetaDataFile("ejb-jar.xml");
/* 241 */       VirtualFile jbossXml = unit.getMetaDataFile("jboss.xml");
/*     */ 
/* 243 */       if (clientXml != null)
/*     */       {
/* 245 */         type = 2;
/*     */       }
/* 247 */       else if (mfFile != null)
/*     */       {
/* 249 */         Manifest mf = VFSUtils.readManifest(mfFile);
/* 250 */         Attributes attrs = mf.getMainAttributes();
/* 251 */         if (attrs.containsKey(Attributes.Name.MAIN_CLASS))
/*     */         {
/* 253 */           type = 2;
/*     */         }
/*     */         else
/*     */         {
/* 258 */           type = 0;
/*     */         }
/*     */       }
/* 261 */       else if ((ejbXml != null) || (jbossXml != null))
/*     */       {
/* 263 */         type = 0;
/*     */       }
/*     */       else
/*     */       {
/* 268 */         type = 0;
/*     */       }
/*     */     }
/*     */ 
/* 272 */     return type;
/*     */   }
/*     */ 
/*     */   private String earRelativePath(String earPath, String pathName)
/*     */   {
/* 277 */     StringBuilder tmp = new StringBuilder(pathName);
/* 278 */     tmp.delete(0, earPath.length());
/* 279 */     return tmp.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.EARContentsDeployer
 * JD-Core Version:    0.6.0
 */