/*     */ package org.jboss.deployment;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.InputStream;
/*     */ import java.io.Serializable;
/*     */ import java.net.URL;
/*     */ import java.net.URLClassLoader;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Date;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import java.util.jar.JarFile;
/*     */ import java.util.jar.Manifest;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.loading.LoaderRepositoryFactory;
/*     */ import org.jboss.mx.loading.LoaderRepositoryFactory.LoaderRepositoryConfig;
/*     */ import org.jboss.mx.loading.RepositoryClassLoader;
/*     */ import org.jboss.util.collection.ListSet;
/*     */ import org.jboss.util.file.Files;
/*     */ import org.w3c.dom.Document;
/*     */ 
/*     */ public class DeploymentInfo
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1131841473723490707L;
/*  64 */   private static final Logger log = Logger.getLogger(DeploymentInfo.class);
/*     */ 
/*  69 */   public Date date = new Date();
/*     */   public URL url;
/*     */   public URL localUrl;
/*     */   public URL watch;
/*     */   public String shortName;
/*  84 */   public long lastDeployed = 0L;
/*     */ 
/*  87 */   public long lastModified = 0L;
/*     */   public String status;
/*  93 */   public DeploymentState state = DeploymentState.CONSTRUCTED;
/*     */   public transient SubDeployer deployer;
/*     */   public transient RepositoryClassLoader ucl;
/*     */   public transient URLClassLoader localCl;
/*     */   public transient URLClassLoader annotationsCl;
/* 114 */   public final Collection classpath = new ArrayList();
/*     */ 
/* 117 */   public final List<ObjectName> mbeans = new ArrayList();
/*     */ 
/* 120 */   public final Set subDeployments = new ListSet();
/*     */ 
/* 123 */   public DeploymentInfo parent = null;
/*     */   public String webContext;
/*     */   public transient Manifest manifest;
/*     */   public Document document;
/*     */   public URL documentUrl;
/*     */   public transient Object metaData;
/*     */   public String alternativeDD;
/* 151 */   public transient HashMap context = new HashMap();
/*     */   public boolean isXML;
/*     */   public boolean isScript;
/*     */   public boolean isDirectory;
/* 163 */   public boolean sortedSubDeployments = false;
/*     */   public ObjectName deployedObject;
/*     */   public LoaderRepositoryFactory.LoaderRepositoryConfig repositoryConfig;
/*     */   private transient MBeanServer server;
/*     */ 
/*     */   public DeploymentInfo(URL url, DeploymentInfo parent, MBeanServer server)
/*     */     throws DeploymentException
/*     */   {
/* 183 */     this.server = server;
/*     */ 
/* 185 */     this.url = url;
/*     */ 
/* 188 */     this.watch = url;
/*     */ 
/* 191 */     this.parent = parent;
/*     */ 
/* 194 */     if ((url.getProtocol().startsWith("file")) && (new File(url.getFile()).isDirectory())) {
/* 195 */       this.isDirectory = true;
/*     */     }
/*     */ 
/* 198 */     if (!this.isDirectory)
/*     */     {
/*     */       try
/*     */       {
/* 202 */         url.openStream().close();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 206 */         throw new DeploymentException("url " + url + " could not be opened, does it exist?");
/*     */       }
/*     */     }
/*     */ 
/* 210 */     if (parent != null)
/*     */     {
/* 212 */       parent.subDeployments.add(this);
/*     */ 
/* 214 */       this.repositoryConfig = getTopRepositoryConfig();
/*     */     }
/*     */ 
/* 218 */     this.shortName = getShortName(url.getPath());
/*     */ 
/* 221 */     this.isXML = this.shortName.toLowerCase().endsWith(".xml");
/*     */ 
/* 224 */     this.isScript = this.shortName.toLowerCase().endsWith(".bsh");
/*     */   }
/*     */ 
/*     */   public MBeanServer getServer()
/*     */   {
/* 229 */     return this.server;
/*     */   }
/*     */ 
/*     */   public void setServer(MBeanServer server)
/*     */   {
/* 234 */     this.server = server;
/*     */   }
/*     */ 
/*     */   public void createClassLoaders()
/*     */     throws Exception
/*     */   {
/* 245 */     if (this.localCl == null) {
/* 246 */       this.localCl = new URLClassLoader(new URL[] { this.localUrl });
/*     */     }
/*     */ 
/* 253 */     URL origUrl = this.url;
/* 254 */     DeploymentInfo current = this;
/* 255 */     while (current.parent != null)
/*     */     {
/* 257 */       current = current.parent;
/*     */     }
/* 259 */     origUrl = current.url;
/* 260 */     this.repositoryConfig = current.repositoryConfig;
/* 261 */     if (this.parent == null)
/*     */     {
/* 263 */       if (this.repositoryConfig == null) {
/* 264 */         this.repositoryConfig = new LoaderRepositoryFactory.LoaderRepositoryConfig();
/*     */       }
/* 266 */       LoaderRepositoryFactory.createLoaderRepository(this.server, this.repositoryConfig);
/* 267 */       log.debug("createLoaderRepository from config: " + this.repositoryConfig);
/*     */ 
/* 270 */       Object[] args = { this.isXML ? null : this.localUrl, origUrl, Boolean.TRUE };
/* 271 */       String[] sig = { "java.net.URL", "java.net.URL", "boolean" };
/* 272 */       this.ucl = ((RepositoryClassLoader)this.server.invoke(this.repositoryConfig.repositoryName, "newClassLoader", args, sig));
/*     */     }
/*     */     else
/*     */     {
/* 278 */       LoaderRepositoryFactory.createLoaderRepository(this.server, this.repositoryConfig);
/*     */ 
/* 280 */       this.ucl = this.parent.ucl;
/* 281 */       this.ucl.addURL(this.localUrl);
/*     */     }
/*     */ 
/* 284 */     if (this.classpath.size() > 0)
/*     */     {
/* 286 */       Iterator jars = this.classpath.iterator();
/* 287 */       while (jars.hasNext())
/*     */       {
/* 289 */         URL jar = (URL)jars.next();
/* 290 */         this.ucl.addURL(jar);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setRepositoryInfo(LoaderRepositoryFactory.LoaderRepositoryConfig config)
/*     */     throws Exception
/*     */   {
/* 303 */     if (this.parent != null)
/*     */     {
/* 305 */       log.warn("Only the root deployment can set the loader repository, ignoring config=" + config);
/*     */ 
/* 307 */       return;
/*     */     }
/*     */ 
/* 310 */     this.repositoryConfig = config;
/*     */ 
/* 312 */     if (this.ucl != null)
/*     */     {
/* 314 */       this.ucl.unregister();
/*     */ 
/* 316 */       LoaderRepositoryFactory.createLoaderRepository(this.server, this.repositoryConfig);
/* 317 */       log.debug("createLoaderRepository from config: " + this.repositoryConfig);
/*     */ 
/* 320 */       Object[] args = { this.isXML ? null : this.localUrl, this.url, Boolean.TRUE };
/* 321 */       String[] sig = { "java.net.URL", "java.net.URL", "boolean" };
/* 322 */       this.ucl = ((RepositoryClassLoader)this.server.invoke(this.repositoryConfig.repositoryName, "newClassLoader", args, sig));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addLibraryJar(URL libJar)
/*     */   {
/* 334 */     DeploymentInfo current = this;
/* 335 */     while (current.parent != null)
/*     */     {
/* 337 */       current = current.parent;
/*     */     }
/*     */ 
/* 342 */     if (current.ucl != null)
/* 343 */       current.ucl.addURL(libJar);
/*     */     else
/* 345 */       this.classpath.add(libJar);
/*     */   }
/*     */ 
/*     */   public LoaderRepositoryFactory.LoaderRepositoryConfig getTopRepositoryConfig()
/*     */   {
/* 352 */     LoaderRepositoryFactory.LoaderRepositoryConfig topConfig = this.repositoryConfig;
/* 353 */     DeploymentInfo info = this;
/* 354 */     while (info.parent != null)
/*     */     {
/* 356 */       info = info.parent;
/* 357 */       topConfig = info.repositoryConfig;
/*     */     }
/* 359 */     return topConfig;
/*     */   }
/*     */ 
/*     */   public Manifest getManifest()
/*     */   {
/*     */     try
/*     */     {
/* 370 */       if (this.manifest == null)
/*     */       {
/* 372 */         File file = new File(this.localUrl.getFile());
/*     */ 
/* 374 */         if (file.isDirectory())
/*     */         {
/* 376 */           FileInputStream fis = new FileInputStream(new File(file, "META-INF/MANIFEST.MF"));
/*     */           try
/*     */           {
/* 379 */             this.manifest = new Manifest(fis);
/*     */           }
/*     */           finally
/*     */           {
/* 383 */             fis.close();
/*     */           }
/*     */         }
/* 386 */         else if (!this.isXML) {
/* 387 */           this.manifest = new JarFile(file).getManifest();
/*     */         }
/*     */       }
/* 390 */       return this.manifest;
/*     */     } catch (Exception ignored) {
/*     */     }
/* 393 */     return null;
/*     */   }
/*     */ 
/*     */   public void cleanup()
/*     */   {
/* 399 */     if ((this.parent == null) && (this.ucl != null))
/* 400 */       this.ucl.unregister();
/* 401 */     this.ucl = null;
/*     */ 
/* 404 */     if (this.repositoryConfig != null)
/*     */     {
/* 406 */       LoaderRepositoryFactory.destroyLoaderRepository(this.server, this.repositoryConfig.repositoryName);
/*     */     }
/*     */ 
/* 410 */     this.subDeployments.clear();
/* 411 */     this.mbeans.clear();
/* 412 */     this.context.clear();
/* 413 */     if ((this.localUrl == null) || (this.localUrl.equals(this.url)))
/*     */     {
/* 415 */       log.debug("Not deleting localUrl, it is null or not a copy: " + this.localUrl);
/*     */     }
/* 417 */     else if (Files.delete(this.localUrl.getFile()))
/*     */     {
/* 419 */       log.debug("Cleaned Deployment: " + this.localUrl);
/*     */     }
/*     */     else
/*     */     {
/* 423 */       log.debug("Could not delete " + this.localUrl + " restart will delete it");
/*     */     }
/*     */ 
/* 427 */     this.localCl = null;
/* 428 */     this.annotationsCl = null;
/* 429 */     this.localUrl = null;
/* 430 */     this.repositoryConfig = null;
/* 431 */     this.watch = null;
/* 432 */     this.parent = null;
/* 433 */     this.manifest = null;
/* 434 */     this.document = null;
/* 435 */     this.metaData = null;
/* 436 */     this.server = null;
/* 437 */     this.classpath.clear();
/* 438 */     this.state = DeploymentState.DESTROYED;
/*     */   }
/*     */ 
/*     */   public String getCanonicalName()
/*     */   {
/* 446 */     String name = this.shortName;
/* 447 */     if (this.parent != null)
/* 448 */       name = this.parent.getCanonicalName() + "/" + name;
/* 449 */     return name;
/*     */   }
/*     */ 
/*     */   private String getShortName(String name)
/*     */   {
/* 454 */     if (name.endsWith("/")) name = name.substring(0, name.length() - 1);
/* 455 */     name = name.substring(name.lastIndexOf("/") + 1);
/* 456 */     return name;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 461 */     return this.url.hashCode();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other)
/*     */   {
/* 466 */     if ((other instanceof DeploymentInfo))
/*     */     {
/* 468 */       return ((DeploymentInfo)other).url.equals(this.url);
/*     */     }
/* 470 */     return false;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 475 */     StringBuffer s = new StringBuffer(super.toString());
/* 476 */     s.append(" { url=" + this.url + " }\n");
/* 477 */     s.append("  deployer: " + this.deployer + "\n");
/* 478 */     s.append("  status: " + this.status + "\n");
/* 479 */     s.append("  state: " + this.state + "\n");
/* 480 */     s.append("  watch: " + this.watch + "\n");
/* 481 */     s.append("  altDD: " + this.alternativeDD + "\n");
/* 482 */     s.append("  lastDeployed: " + this.lastDeployed + "\n");
/* 483 */     s.append("  lastModified: " + this.lastModified + "\n");
/* 484 */     s.append("  mbeans:\n");
/* 485 */     for (Iterator i = this.mbeans.iterator(); i.hasNext(); )
/*     */     {
/* 487 */       ObjectName o = (ObjectName)i.next();
/*     */       try
/*     */       {
/* 490 */         String state = (String)this.server.getAttribute(o, "StateString");
/* 491 */         s.append("    " + o + " state: " + state + "\n");
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 495 */         s.append("    " + o + " (state not available)\n");
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 500 */     return s.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.DeploymentInfo
 * JD-Core Version:    0.6.0
 */