/*    */ package org.jboss.deployers.vfs.spi.deployer;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import java.lang.reflect.UndeclaredThrowableException;
/*    */ import java.security.AccessController;
/*    */ import java.security.PrivilegedActionException;
/*    */ import java.security.PrivilegedExceptionAction;
/*    */ import org.jboss.virtual.VirtualFile;
/*    */ 
/*    */ public class SecurityActions
/*    */ {
/*    */   static InputStream openStream(VirtualFile f)
/*    */     throws IOException
/*    */   {
/* 84 */     SecurityManager sm = System.getSecurityManager();
/* 85 */     if (sm != null) {
/* 86 */       return FileActions.PRIVILEGED.openStream(f);
/*    */     }
/* 88 */     return FileActions.NON_PRIVILEGED.openStream(f);
/*    */   }
/*    */ 
/*    */   static abstract interface FileActions
/*    */   {
/* 44 */     public static final FileActions PRIVILEGED = new FileActions()
/*    */     {
/*    */       public InputStream openStream(VirtualFile f) throws IOException {
/*    */         Exception ex;
/*    */         try {
/* 50 */           return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(f)
/*    */           {
/*    */             public InputStream run() throws Exception
/*    */             {
/* 54 */               return this.val$f.openStream();
/*    */             }
/*    */           });
/*    */         }
/*    */         catch (PrivilegedActionException e) {
/* 60 */           ex = e.getException();
/* 61 */           if ((ex instanceof IOException))
/* 62 */             throw ((IOException)ex);
/* 63 */           if ((ex instanceof RuntimeException))
/* 64 */             throw ((RuntimeException)ex);
/*    */         }
/* 66 */         throw new UndeclaredThrowableException(ex);
/*    */       }
/* 44 */     };
/*    */ 
/* 71 */     public static final FileActions NON_PRIVILEGED = new FileActions()
/*    */     {
/*    */       public InputStream openStream(VirtualFile f) throws IOException
/*    */       {
/* 75 */         return f.openStream();
/*    */       }
/* 71 */     };
/*    */ 
/*    */     public abstract InputStream openStream(VirtualFile paramVirtualFile)
/*    */       throws IOException;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.spi.deployer.SecurityActions
 * JD-Core Version:    0.6.0
 */