/*    */ package org.jboss.deployers.vfs.plugins.structure;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.lang.reflect.UndeclaredThrowableException;
/*    */ import java.security.AccessController;
/*    */ import java.security.PrivilegedActionException;
/*    */ import java.security.PrivilegedExceptionAction;
/*    */ import org.jboss.virtual.VirtualFile;
/*    */ 
/*    */ public class SecurityActions
/*    */ {
/*    */   static boolean isLeaf(VirtualFile f)
/*    */     throws IOException
/*    */   {
/* 84 */     SecurityManager sm = System.getSecurityManager();
/* 85 */     if (sm != null) {
/* 86 */       return FileActions.PRIVILEGED.isLeaf(f).booleanValue();
/*    */     }
/* 88 */     return FileActions.NON_PRIVILEGED.isLeaf(f).booleanValue();
/*    */   }
/*    */ 
/*    */   static abstract interface FileActions
/*    */   {
/* 43 */     public static final FileActions PRIVILEGED = new FileActions()
/*    */     {
/*    */       public Boolean isLeaf(VirtualFile f) throws IOException {
/*    */         Exception ex;
/*    */         try {
/* 49 */           return (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(f)
/*    */           {
/*    */             public Boolean run() throws Exception
/*    */             {
/* 53 */               return Boolean.valueOf(this.val$f.isLeaf());
/*    */             }
/*    */           });
/*    */         }
/*    */         catch (PrivilegedActionException e) {
/* 59 */           ex = e.getException();
/* 60 */           if ((ex instanceof IOException))
/* 61 */             throw ((IOException)ex);
/* 62 */           if ((ex instanceof RuntimeException))
/* 63 */             throw ((RuntimeException)ex);
/*    */         }
/* 65 */         throw new UndeclaredThrowableException(ex);
/*    */       }
/* 43 */     };
/*    */ 
/* 70 */     public static final FileActions NON_PRIVILEGED = new FileActions()
/*    */     {
/*    */       public Boolean isLeaf(VirtualFile f) throws IOException
/*    */       {
/* 74 */         return Boolean.valueOf(f.isLeaf());
/*    */       }
/* 70 */     };
/*    */ 
/*    */     public abstract Boolean isLeaf(VirtualFile paramVirtualFile)
/*    */       throws IOException;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.plugins.structure.SecurityActions
 * JD-Core Version:    0.6.0
 */