/*     */ package org.jboss.deployers.vfs.plugins.structure;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.net.URI;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.List;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.structure.spi.helpers.AbstractDeploymentContext;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentContext;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentResourceLoader;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.virtual.VFSUtils;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class AbstractVFSDeploymentContext extends AbstractDeploymentContext
/*     */   implements VFSDeploymentContext
/*     */ {
/*     */   private static final long serialVersionUID = 4474515937180482776L;
/*  51 */   private static final Logger log = Logger.getLogger(AbstractVFSDeploymentContext.class);
/*     */   private VirtualFile root;
/*     */   private List<VirtualFile> metaDataLocations;
/*     */   private List<VirtualFile> classPath;
/*     */   private transient VFSDeploymentResourceLoader loader;
/*     */ 
/*     */   static final String safeVirtualFileName(VirtualFile root)
/*     */   {
/*  73 */     if (root == null)
/*  74 */       throw new IllegalArgumentException("Null root");
/*     */     try
/*     */     {
/*  77 */       return root.toURI().toString();
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/*  81 */     return root.getName();
/*     */   }
/*     */ 
/*     */   public AbstractVFSDeploymentContext()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AbstractVFSDeploymentContext(VirtualFile root, String relativePath)
/*     */   {
/* 100 */     super(safeVirtualFileName(root), root.getName(), relativePath);
/* 101 */     this.root = root;
/*     */   }
/*     */ 
/*     */   public VirtualFile getRoot()
/*     */   {
/* 106 */     return this.root;
/*     */   }
/*     */ 
/*     */   public void setMetaDataPath(List<String> paths)
/*     */   {
/* 111 */     if (paths == null)
/*     */     {
/* 113 */       setMetaDataLocations(null);
/* 114 */       return;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 119 */       List locations = new ArrayList();
/* 120 */       for (String path : paths)
/*     */       {
/* 122 */         if (path == null) {
/* 123 */           throw new IllegalArgumentException("Null path in paths: " + paths);
/*     */         }
/* 125 */         locations.add(this.root.findChild(path));
/*     */       }
/* 127 */       setMetaDataLocations(locations);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 131 */       log.debug("Meta data path does not exist: root=" + this.root.getPathName() + " paths=" + paths);
/*     */     }
/*     */   }
/*     */ 
/*     */   public List<VirtualFile> getMetaDataLocations()
/*     */   {
/* 137 */     if (this.metaDataLocations == null) {
/* 138 */       return Collections.emptyList();
/*     */     }
/* 140 */     return this.metaDataLocations;
/*     */   }
/*     */ 
/*     */   public void setMetaDataLocations(List<VirtualFile> locations)
/*     */   {
/* 145 */     this.metaDataLocations = locations;
/*     */   }
/*     */ 
/*     */   public VirtualFile getMetaDataFile(String name)
/*     */   {
/* 150 */     if (name == null) {
/* 151 */       throw new IllegalArgumentException("Null name");
/*     */     }
/*     */     try
/*     */     {
/* 155 */       if ((this.metaDataLocations == null) || (this.metaDataLocations.isEmpty()))
/*     */       {
/* 158 */         if ((this.root != null) && (SecurityActions.isLeaf(this.root)))
/*     */         {
/* 160 */           String fileName = this.root.getName();
/* 161 */           if (fileName.equals(name)) {
/* 162 */             return this.root;
/*     */           }
/*     */         }
/*     */ 
/* 166 */         return null;
/*     */       }
/*     */ 
/* 169 */       return searchMetaDataLocations(name);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 173 */       log.trace("Error retrieving meta data: " + name + " reason=" + e);
/* 174 */     }return null;
/*     */   }
/*     */ 
/*     */   protected VirtualFile searchMetaDataLocations(String name)
/*     */   {
/* 187 */     VirtualFile result = null;
/* 188 */     for (VirtualFile location : getMetaDataLocations())
/*     */     {
/*     */       try
/*     */       {
/* 192 */         result = location.findChild(name);
/* 193 */         if (result != null)
/*     */         {
/* 195 */           log.trace("Found " + name + " in " + location.getName());
/* 196 */           deployed();
/* 197 */           break;
/*     */         }
/*     */       }
/*     */       catch (IOException ignored)
/*     */       {
/*     */       }
/*     */     }
/* 204 */     return result;
/*     */   }
/*     */ 
/*     */   public List<VirtualFile> getMetaDataFiles(String name, String suffix)
/*     */   {
/* 209 */     if ((name == null) && (suffix == null)) {
/* 210 */       throw new IllegalArgumentException("Null name and suffix");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 215 */       if ((this.metaDataLocations == null) || (this.metaDataLocations.isEmpty()))
/*     */       {
/* 218 */         if ((this.root != null) && (SecurityActions.isLeaf(this.root)))
/*     */         {
/* 220 */           String fileName = this.root.getName();
/* 221 */           if ((name != null) && (fileName.equals(name)))
/* 222 */             return Collections.singletonList(this.root);
/* 223 */           if ((suffix != null) && (fileName.endsWith(suffix))) {
/* 224 */             return Collections.singletonList(this.root);
/*     */           }
/*     */         }
/*     */ 
/* 228 */         return Collections.emptyList();
/*     */       }
/*     */ 
/* 231 */       List results = new ArrayList();
/* 232 */       for (VirtualFile location : this.metaDataLocations)
/*     */       {
/* 234 */         List result = location.getChildren(new MetaDataMatchFilter(name, suffix));
/* 235 */         if ((result != null) && (!result.isEmpty()))
/*     */         {
/* 237 */           log.trace("Found " + name + " in " + location.getName());
/* 238 */           results.addAll(result);
/* 239 */           deployed();
/*     */         }
/*     */       }
/* 242 */       return results;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 246 */       log.debug("Error retrieving meta data: name=" + name + " suffix=" + suffix, e);
/* 247 */     }return Collections.emptyList();
/*     */   }
/*     */ 
/*     */   public VirtualFile getFile(String name)
/*     */   {
/* 253 */     return getResourceLoader().getFile(name);
/*     */   }
/*     */ 
/*     */   public List<VirtualFile> getClassPath()
/*     */   {
/* 258 */     return this.classPath;
/*     */   }
/*     */ 
/*     */   public void setClassPath(List<VirtualFile> paths)
/*     */   {
/* 263 */     this.classPath = paths;
/* 264 */     if ((log.isTraceEnabled()) && (paths != null))
/* 265 */       log.trace("ClassPath for " + this.root.getPathName() + " is " + VFSUtils.getPathsString(paths));
/*     */   }
/*     */ 
/*     */   public VFSDeploymentContext getTopLevel()
/*     */   {
/* 271 */     return (VFSDeploymentContext)super.getTopLevel();
/*     */   }
/*     */ 
/*     */   public VFSDeploymentResourceLoader getResourceLoader()
/*     */   {
/* 277 */     if (this.loader != null) {
/* 278 */       return this.loader;
/*     */     }
/* 280 */     this.loader = new VFSDeploymentResourceLoaderImpl(getRoot());
/* 281 */     return this.loader;
/*     */   }
/*     */ 
/*     */   protected DeploymentUnit createDeploymentUnit()
/*     */   {
/* 286 */     return new AbstractVFSDeploymentUnit(this);
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 292 */     super.readExternal(in);
/* 293 */     this.root = ((VirtualFile)in.readObject());
/* 294 */     boolean isNullOrEmpty = in.readBoolean();
/* 295 */     if (!isNullOrEmpty)
/* 296 */       this.metaDataLocations = ((List)in.readObject());
/* 297 */     this.classPath = ((List)in.readObject());
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 309 */     super.writeExternal(out);
/* 310 */     out.writeObject(this.root);
/* 311 */     boolean isNullOrEmpty = (this.metaDataLocations == null) || (this.metaDataLocations.isEmpty());
/* 312 */     out.writeBoolean(isNullOrEmpty);
/* 313 */     if (!isNullOrEmpty)
/* 314 */       out.writeObject(this.metaDataLocations);
/* 315 */     out.writeObject(this.classPath);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.plugins.structure.AbstractVFSDeploymentContext
 * JD-Core Version:    0.6.0
 */