/*     */ package org.jboss.deployers.vfs.plugins.classloader;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import org.jboss.deployers.structure.spi.classloading.ExportAll;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.virtual.VirtualFileVisitor;
/*     */ import org.jboss.virtual.VisitorAttributes;
/*     */ 
/*     */ class PackageVisitor
/*     */   implements VirtualFileVisitor
/*     */ {
/*  44 */   private Set<String> packages = new HashSet();
/*     */   private String rootPath;
/*     */   private ExportAll exportAll;
/*     */ 
/*     */   public PackageVisitor(ExportAll exportAll)
/*     */   {
/*  60 */     if (exportAll == null)
/*  61 */       throw new IllegalArgumentException("Null exportAll policy");
/*  62 */     this.exportAll = exportAll;
/*     */   }
/*     */ 
/*     */   public void setRoot(VirtualFile root)
/*     */   {
/*  73 */     if (root == null)
/*  74 */       throw new IllegalArgumentException("Null root");
/*  75 */     this.rootPath = (root.getPathName() + "/");
/*     */   }
/*     */ 
/*     */   public Set<String> getPackages()
/*     */   {
/*  85 */     return this.packages;
/*     */   }
/*     */ 
/*     */   public VisitorAttributes getAttributes()
/*     */   {
/*  90 */     VisitorAttributes attributes = new VisitorAttributes();
/*  91 */     attributes.setIncludeRoot(true);
/*  92 */     attributes.setRecurseFilter(VisitorAttributes.RECURSE_ALL);
/*  93 */     return attributes;
/*     */   }
/*     */ 
/*     */   public void visit(VirtualFile file)
/*     */   {
/*     */     try
/*     */     {
/* 101 */       if (!file.isLeaf())
/*     */       {
/* 103 */         boolean empty = true;
/*     */ 
/* 105 */         if (this.exportAll == ExportAll.ALL) {
/* 106 */           empty = false;
/*     */         }
/*     */         else
/*     */         {
/* 110 */           List children = file.getChildren();
/* 111 */           if ((children != null) && (!children.isEmpty()))
/*     */           {
/* 113 */             for (VirtualFile child : children)
/*     */             {
/* 116 */               if (child.isLeaf())
/*     */               {
/* 118 */                 empty = false;
/* 119 */                 break;
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */ 
/* 125 */         if (!empty)
/*     */         {
/* 127 */           String path = file.getPathName();
/* 128 */           if (path.startsWith(this.rootPath))
/* 129 */             path = path.substring(this.rootPath.length());
/* 130 */           this.packages.add(path.replace('/', '.'));
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 136 */       throw new Error("Error visiting " + file, e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.plugins.classloader.PackageVisitor
 * JD-Core Version:    0.6.0
 */