/*     */ package org.jboss.deployers.vfs.deployer.kernel;
/*     */ 
/*     */ import java.util.List;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.deployer.helpers.AbstractComponentDeployer;
/*     */ import org.jboss.deployers.spi.deployer.helpers.DeploymentVisitor;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.kernel.spi.deployment.KernelDeployment;
/*     */ 
/*     */ public class KernelDeploymentDeployer extends AbstractComponentDeployer<KernelDeployment, BeanMetaData>
/*     */ {
/*     */   public KernelDeploymentDeployer()
/*     */   {
/*  40 */     setDeploymentVisitor(new KernelDeploymentVisitor());
/*  41 */     setComponentVisitor(new BeanMetaDataVisitor());
/*     */   }
/*     */ 
/*     */   protected static void addBeanComponent(DeploymentUnit unit, BeanMetaData bean)
/*     */   {
/*  46 */     DeploymentUnit component = unit.addComponent(bean.getName());
/*  47 */     component.addAttachment(BeanMetaData.class.getName(), bean);
/*     */   }
/*     */ 
/*     */   protected static void removeBeanComponent(DeploymentUnit unit, BeanMetaData bean)
/*     */   {
/*  52 */     unit.removeComponent(bean.getName());
/*     */   }
/*     */ 
/*     */   public static class BeanMetaDataVisitor
/*     */     implements DeploymentVisitor<BeanMetaData>
/*     */   {
/*     */     public Class<BeanMetaData> getVisitorType()
/*     */     {
/*  93 */       return BeanMetaData.class;
/*     */     }
/*     */ 
/*     */     public void deploy(DeploymentUnit unit, BeanMetaData deployment) throws DeploymentException
/*     */     {
/*  98 */       KernelDeploymentDeployer.addBeanComponent(unit, deployment);
/*     */     }
/*     */ 
/*     */     public void undeploy(DeploymentUnit unit, BeanMetaData deployment)
/*     */     {
/* 103 */       KernelDeploymentDeployer.removeBeanComponent(unit, deployment);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class KernelDeploymentVisitor
/*     */     implements DeploymentVisitor<KernelDeployment>
/*     */   {
/*     */     public Class<KernelDeployment> getVisitorType()
/*     */     {
/*  62 */       return KernelDeployment.class;
/*     */     }
/*     */ 
/*     */     public void deploy(DeploymentUnit unit, KernelDeployment deployment) throws DeploymentException
/*     */     {
/*  67 */       List beans = deployment.getBeans();
/*  68 */       if ((beans != null) && (!beans.isEmpty()))
/*     */       {
/*  70 */         for (BeanMetaData bean : beans)
/*  71 */           KernelDeploymentDeployer.addBeanComponent(unit, bean);
/*     */       }
/*     */     }
/*     */ 
/*     */     public void undeploy(DeploymentUnit unit, KernelDeployment deployment)
/*     */     {
/*  77 */       List beans = deployment.getBeans();
/*  78 */       if ((beans != null) && (!beans.isEmpty()))
/*     */       {
/*  80 */         for (BeanMetaData bean : beans)
/*  81 */           KernelDeploymentDeployer.removeBeanComponent(unit, bean);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.deployer.kernel.KernelDeploymentDeployer
 * JD-Core Version:    0.6.0
 */