/*     */ package org.jboss.deployers.structure.spi.classloading.helpers;
/*     */ 
/*     */ import org.jboss.deployers.structure.spi.classloading.RequirePackage;
/*     */ import org.jboss.deployers.structure.spi.classloading.VersionRange;
/*     */ 
/*     */ public class RequirePackageImpl
/*     */   implements RequirePackage
/*     */ {
/*     */   private static final long serialVersionUID = -7552921085464308835L;
/*     */   private String name;
/*     */   private VersionRange versionRange;
/*     */ 
/*     */   public RequirePackageImpl(String name)
/*     */   {
/*  52 */     this(name, null);
/*     */   }
/*     */ 
/*     */   public RequirePackageImpl(String name, VersionRange versionRange)
/*     */   {
/*  64 */     if (name == null)
/*  65 */       throw new IllegalArgumentException("Null name");
/*  66 */     if (versionRange == null)
/*  67 */       versionRange = VersionRange.ALL_VERSIONS;
/*  68 */     this.name = name;
/*  69 */     this.versionRange = versionRange;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  75 */     return this.name;
/*     */   }
/*     */ 
/*     */   public VersionRange getVersionRange()
/*     */   {
/*  80 */     return this.versionRange;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*  86 */     if (obj == this)
/*  87 */       return true;
/*  88 */     if ((obj == null) || (!(obj instanceof RequirePackage)))
/*  89 */       return false;
/*  90 */     RequirePackage other = (RequirePackage)obj;
/*  91 */     if (!getName().equals(other.getName()))
/*  92 */       return false;
/*  93 */     return getVersionRange().equals(other.getVersionRange());
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/*  99 */     return getName().hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 105 */     return "RequirePackage: " + getName() + ":" + getVersionRange();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.structure.spi.classloading.helpers.RequirePackageImpl
 * JD-Core Version:    0.6.0
 */