/*     */ package org.jboss.deployers.spi.management;
/*     */ 
/*     */ import org.jboss.managed.api.ComponentType;
/*     */ 
/*     */ public abstract interface KnownComponentTypes
/*     */ {
/*     */   public static enum MBean
/*     */   {
/* 106 */     Dynamic("MBean", "StatelessSession"), 
/* 107 */     Standard("MBean", "Standard"), 
/* 108 */     Model("MBean", "Model"), 
/* 109 */     Open("MBean", "Open"), 
/* 110 */     Persistent("MBean", "Persistent"), 
/* 111 */     XMBean("MBean", "XMBean");
/*     */ 
/*     */     private final String type;
/*     */     private final String subtype;
/*     */ 
/* 117 */     private MBean(String type, String subtype) { this.type = type;
/* 118 */       this.subtype = subtype;
/*     */     }
/*     */ 
/*     */     public ComponentType getType()
/*     */     {
/* 123 */       return new ComponentType(this.type, this.subtype);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static enum EJB
/*     */   {
/*  82 */     StatelessSession("EJB", "StatelessSession"), 
/*  83 */     StatefulSession("EJB", "StatefulSession"), 
/*  84 */     Entity("EJB", "Entity"), 
/*  85 */     MDB("EJB", "MDB");
/*     */ 
/*     */     private final String type;
/*     */     private final String subtype;
/*     */ 
/*  91 */     private EJB(String type, String subtype) { this.type = type;
/*  92 */       this.subtype = subtype;
/*     */     }
/*     */ 
/*     */     public ComponentType getType()
/*     */     {
/*  97 */       return new ComponentType(this.type, this.subtype);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static enum JMSDestination
/*     */   {
/*  60 */     Queue("JMSDestination", "Queue"), Topic("JMSDestination", "Topic"), 
/*  61 */     DurableTopic("DataSource", "DurableTopic");
/*     */ 
/*     */     private final String type;
/*     */     private final String subtype;
/*     */ 
/*  67 */     private JMSDestination(String type, String subtype) { this.type = type;
/*  68 */       this.subtype = subtype;
/*     */     }
/*     */ 
/*     */     public ComponentType getType()
/*     */     {
/*  73 */       return new ComponentType(this.type, this.subtype);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static enum DataSourceTypes
/*     */   {
/*  39 */     XA("DataSource", "XA"), LocalTx("DataSource", "LocalTx"), NoTx("DataSource", "NoTx");
/*     */ 
/*     */     private final String type;
/*     */     private final String subtype;
/*     */ 
/*  45 */     private DataSourceTypes(String type, String subtype) { this.type = type;
/*  46 */       this.subtype = subtype;
/*     */     }
/*     */ 
/*     */     public ComponentType getType()
/*     */     {
/*  51 */       return new ComponentType(this.type, this.subtype);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.spi.management.KnownComponentTypes
 * JD-Core Version:    0.6.0
 */