/*    */ package org.jboss.deployers.spi.deployer.helpers;
/*    */ 
/*    */ import java.util.Set;
/*    */ import org.jboss.deployers.spi.DeploymentException;
/*    */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*    */ 
/*    */ public abstract class AbstractSimpleRealDeployer<T> extends AbstractRealDeployer
/*    */ {
/*    */   public AbstractSimpleRealDeployer(Class<T> input)
/*    */   {
/* 44 */     if (input == null)
/* 45 */       throw new IllegalArgumentException("Null input");
/* 46 */     setInput(input);
/*    */   }
/*    */ 
/*    */   public Class<? extends T> getInput()
/*    */   {
/* 52 */     Class input = super.getInput();
/* 53 */     if (input == null)
/* 54 */       throw new IllegalStateException("No input for " + this);
/* 55 */     return input;
/*    */   }
/*    */ 
/*    */   public void internalDeploy(DeploymentUnit unit) throws DeploymentException
/*    */   {
/* 60 */     Object deployment = unit.getAttachment(getInput());
/* 61 */     if (deployment != null)
/*    */     {
/* 64 */       unit.getTypes().add(getType());
/* 65 */       deploy(unit, deployment);
/*    */     }
/*    */   }
/*    */ 
/*    */   public void internalUndeploy(DeploymentUnit unit)
/*    */   {
/* 71 */     Object deployment = unit.getAttachment(getInput());
/* 72 */     if (deployment != null)
/* 73 */       undeploy(unit, deployment);
/*    */   }
/*    */ 
/*    */   public abstract void deploy(DeploymentUnit paramDeploymentUnit, T paramT)
/*    */     throws DeploymentException;
/*    */ 
/*    */   public void undeploy(DeploymentUnit unit, T deployment)
/*    */   {
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer
 * JD-Core Version:    0.6.0
 */