/*     */ package org.jboss.deployers.spi.deployer.helpers;
/*     */ 
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.deployer.DeploymentStages;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract class AbstractRealDeployer extends AbstractDeployer
/*     */ {
/*     */   private boolean useUnitName;
/*     */ 
/*     */   public AbstractRealDeployer()
/*     */   {
/*  45 */     setStage(DeploymentStages.REAL);
/*     */   }
/*     */ 
/*     */   public final void deploy(DeploymentUnit unit) throws DeploymentException
/*     */   {
/*  50 */     internalDeploy(unit);
/*     */ 
/*  52 */     if (isControllerContextNameCandidate(unit))
/*     */     {
/*  54 */       addControllerContextName(unit);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected boolean isControllerContextNameCandidate(DeploymentUnit unit)
/*     */   {
/*  66 */     return (this.useUnitName) && (unit.isComponent());
/*     */   }
/*     */ 
/*     */   protected abstract void internalDeploy(DeploymentUnit paramDeploymentUnit)
/*     */     throws DeploymentException;
/*     */ 
/*     */   protected void addControllerContextName(DeploymentUnit unit)
/*     */   {
/*  84 */     unit.addControllerContextName(unit.getName());
/*     */   }
/*     */ 
/*     */   protected void removeControllerContextName(DeploymentUnit unit)
/*     */   {
/*  94 */     unit.removeControllerContextName(unit.getName());
/*     */   }
/*     */ 
/*     */   public final void undeploy(DeploymentUnit unit)
/*     */   {
/*     */     try
/*     */     {
/* 101 */       if (isControllerContextNameCandidate(unit))
/*     */       {
/* 103 */         removeControllerContextName(unit);
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 108 */       if (this.log.isTraceEnabled()) {
/* 109 */         this.log.trace("Exception while removing unit name: " + t);
/*     */       }
/*     */     }
/* 112 */     internalUndeploy(unit);
/*     */   }
/*     */ 
/*     */   protected void internalUndeploy(DeploymentUnit unit)
/*     */   {
/*     */   }
/*     */ 
/*     */   public boolean isUseUnitName()
/*     */   {
/* 132 */     return this.useUnitName;
/*     */   }
/*     */ 
/*     */   public void setUseUnitName(boolean useUnitName)
/*     */   {
/* 142 */     this.useUnitName = useUnitName;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer
 * JD-Core Version:    0.6.0
 */