/*     */ package org.jboss.deployers.spi.deployer.helpers;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.attachments.MutableAttachments;
/*     */ import org.jboss.deployers.spi.deployer.managed.ManagedObjectCreator;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.managed.api.ManagedObject;
/*     */ import org.jboss.managed.api.factory.ManagedObjectFactory;
/*     */ import org.jboss.managed.plugins.factory.ManagedObjectFactoryBuilder;
/*     */ 
/*     */ public abstract class AbstractParsingDeployerWithOutput<T> extends AbstractParsingDeployer
/*     */   implements ManagedObjectCreator
/*     */ {
/*     */   private String name;
/*     */   private String suffix;
/*  52 */   private boolean includeDeploymentFile = false;
/*     */ 
/*  55 */   private boolean buildManagedObject = false;
/*     */ 
/*     */   public AbstractParsingDeployerWithOutput(Class<T> output)
/*     */   {
/*  65 */     if (output == null)
/*  66 */       throw new IllegalArgumentException("Null output");
/*  67 */     setOutput(output);
/*     */   }
/*     */ 
/*     */   public Class<T> getOutput()
/*     */   {
/*  74 */     return super.getOutput();
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  84 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/*  94 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public String getSuffix()
/*     */   {
/* 104 */     return this.suffix;
/*     */   }
/*     */ 
/*     */   public void setSuffix(String suffix)
/*     */   {
/* 114 */     this.suffix = suffix;
/*     */   }
/*     */ 
/*     */   public boolean isIncludeDeploymentFile()
/*     */   {
/* 124 */     return this.includeDeploymentFile;
/*     */   }
/*     */ 
/*     */   public void setIncludeDeploymentFile(boolean includeDeploymentFile)
/*     */   {
/* 134 */     this.includeDeploymentFile = includeDeploymentFile;
/*     */   }
/*     */ 
/*     */   public boolean isBuildManagedObject()
/*     */   {
/* 139 */     return this.buildManagedObject;
/*     */   }
/*     */ 
/*     */   public void setBuildManagedObject(boolean buildManagedObject)
/*     */   {
/* 144 */     this.buildManagedObject = buildManagedObject;
/*     */   }
/*     */ 
/*     */   protected boolean allowsReparse()
/*     */   {
/* 155 */     return false;
/*     */   }
/*     */ 
/*     */   public void deploy(DeploymentUnit unit) throws DeploymentException
/*     */   {
/* 160 */     if (!accepts(unit))
/* 161 */       return;
/* 162 */     createMetaData(unit, this.name, this.suffix);
/*     */   }
/*     */ 
/*     */   protected boolean accepts(DeploymentUnit unit)
/*     */     throws DeploymentException
/*     */   {
/* 174 */     return true;
/*     */   }
/*     */ 
/*     */   protected T getMetaData(DeploymentUnit unit, String key)
/*     */   {
/* 186 */     return unit.getAttachment(key, getOutput());
/*     */   }
/*     */ 
/*     */   protected void createMetaData(DeploymentUnit unit, String name, String suffix)
/*     */     throws DeploymentException
/*     */   {
/* 199 */     createMetaData(unit, name, suffix, getOutput().getName());
/*     */   }
/*     */ 
/*     */   protected void createMetaData(DeploymentUnit unit, String name, String suffix, String key)
/*     */     throws DeploymentException
/*     */   {
/* 215 */     Object result = getMetaData(unit, key);
/* 216 */     if ((result != null) && (!allowsReparse())) {
/* 217 */       return;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 222 */       if (suffix == null)
/* 223 */         result = parse(unit, name, result);
/*     */       else {
/* 225 */         result = parse(unit, name, suffix, result);
/*     */       }
/* 227 */       if (result != null)
/* 228 */         unit.getTypes().add(getType());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 232 */       throw DeploymentException.rethrowAsDeploymentException("Error creating managed object for " + unit.getName(), e);
/*     */     }
/*     */ 
/* 236 */     if (result == null) {
/* 237 */       return;
/*     */     }
/*     */ 
/* 240 */     unit.getTransientManagedObjects().addAttachment(key, result, getOutput());
/*     */   }
/*     */ 
/*     */   protected abstract T parse(DeploymentUnit paramDeploymentUnit, String paramString, T paramT)
/*     */     throws Exception;
/*     */ 
/*     */   protected abstract T parse(DeploymentUnit paramDeploymentUnit, String paramString1, String paramString2, T paramT)
/*     */     throws Exception;
/*     */ 
/*     */   public void build(DeploymentUnit unit, Map<String, ManagedObject> managedObjects)
/*     */     throws DeploymentException
/*     */   {
/* 275 */     if (this.buildManagedObject)
/*     */     {
/* 277 */       Object deployment = unit.getAttachment(getOutput());
/* 278 */       if (deployment != null)
/*     */       {
/* 281 */         if (!(deployment instanceof Serializable))
/*     */         {
/* 284 */           this.log.debug("Skipping ManagedObject since T(" + deployment + ") is not Serializable");
/* 285 */           return;
/*     */         }
/*     */ 
/* 288 */         Serializable instance = (Serializable)deployment;
/* 289 */         ManagedObjectFactory factory = ManagedObjectFactoryBuilder.create();
/* 290 */         ManagedObject mo = factory.initManagedObject(instance, null, null);
/* 291 */         if (mo != null)
/* 292 */           managedObjects.put(mo.getName(), mo);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.spi.deployer.helpers.AbstractParsingDeployerWithOutput
 * JD-Core Version:    0.6.0
 */