/*     */ package org.jboss.deployers.spi.deployer.helpers;
/*     */ 
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import org.jboss.deployers.spi.deployer.Deployer;
/*     */ import org.jboss.deployers.spi.deployer.DeploymentStage;
/*     */ import org.jboss.deployers.spi.deployer.DeploymentStages;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract class AbstractDeployer
/*     */   implements Deployer
/*     */ {
/*  42 */   protected Logger log = Logger.getLogger(getClass());
/*     */ 
/*  45 */   private int relativeOrder = 0;
/*     */ 
/*  48 */   private DeploymentStage stage = DeploymentStages.REAL;
/*     */   private boolean topLevelOnly;
/*     */   private boolean componentsOnly;
/*     */   private boolean wantComponents;
/*     */   private boolean allInputs;
/*     */   private Class<?> input;
/*     */   private Class<?> output;
/*     */   private Set<String> inputs;
/*     */   private Set<String> outputs;
/*     */   private String type;
/*  78 */   private boolean parentFirst = true;
/*     */ 
/*     */   public int getRelativeOrder()
/*     */   {
/*  82 */     return this.relativeOrder;
/*     */   }
/*     */ 
/*     */   public void setRelativeOrder(int relativeOrder)
/*     */   {
/*  87 */     this.relativeOrder = relativeOrder;
/*     */   }
/*     */ 
/*     */   public DeploymentStage getStage()
/*     */   {
/*  92 */     return this.stage;
/*     */   }
/*     */ 
/*     */   public void setStage(DeploymentStage stage)
/*     */   {
/* 103 */     if (stage == null)
/* 104 */       throw new IllegalArgumentException("Null stage");
/* 105 */     this.stage = stage;
/*     */   }
/*     */ 
/*     */   public boolean isAllInputs()
/*     */   {
/* 110 */     return this.allInputs;
/*     */   }
/*     */ 
/*     */   public void setAllInputs(boolean allInputs)
/*     */   {
/* 120 */     this.allInputs = allInputs;
/*     */   }
/*     */ 
/*     */   public boolean isComponentsOnly()
/*     */   {
/* 125 */     return this.componentsOnly;
/*     */   }
/*     */ 
/*     */   public void setComponentsOnly(boolean componentsOnly)
/*     */   {
/* 135 */     this.componentsOnly = componentsOnly;
/* 136 */     setWantComponents(true);
/*     */   }
/*     */ 
/*     */   public boolean isWantComponents()
/*     */   {
/* 141 */     return this.wantComponents;
/*     */   }
/*     */ 
/*     */   public void setWantComponents(boolean wantComponents)
/*     */   {
/* 151 */     this.wantComponents = wantComponents;
/*     */   }
/*     */ 
/*     */   public boolean isTopLevelOnly()
/*     */   {
/* 156 */     return this.topLevelOnly;
/*     */   }
/*     */ 
/*     */   public void setTopLevelOnly(boolean topLevelOnly)
/*     */   {
/* 166 */     this.topLevelOnly = topLevelOnly;
/*     */   }
/*     */ 
/*     */   public Class<?> getInput()
/*     */   {
/* 171 */     return this.input;
/*     */   }
/*     */ 
/*     */   public void setInput(Class<?> input)
/*     */   {
/* 182 */     addInput(input);
/* 183 */     this.input = input;
/*     */   }
/*     */ 
/*     */   public Class<?> getOutput()
/*     */   {
/* 188 */     return this.output;
/*     */   }
/*     */ 
/*     */   public void setOutput(Class<?> output)
/*     */   {
/* 199 */     addOutput(output);
/* 200 */     this.output = output;
/*     */   }
/*     */ 
/*     */   public Set<String> getInputs()
/*     */   {
/* 205 */     return this.inputs;
/*     */   }
/*     */ 
/*     */   public void setInputs(Set<String> inputs)
/*     */   {
/* 215 */     this.inputs = inputs;
/*     */   }
/*     */ 
/*     */   public void setInputs(String[] inputs)
/*     */   {
/* 226 */     if (inputs == null)
/*     */     {
/* 228 */       setInputs((Set)null);
/* 229 */       return;
/*     */     }
/* 231 */     Set temp = new HashSet(inputs.length);
/* 232 */     for (String input : inputs)
/*     */     {
/* 234 */       if (input == null)
/* 235 */         throw new IllegalArgumentException("Null input");
/* 236 */       temp.add(input);
/*     */     }
/* 238 */     setInputs(temp);
/*     */   }
/*     */ 
/*     */   public void setInputs(Class<?>[] inputs)
/*     */   {
/* 249 */     if (inputs == null)
/*     */     {
/* 251 */       setInputs((Set)null);
/* 252 */       return;
/*     */     }
/* 254 */     Set temp = new HashSet(inputs.length);
/* 255 */     for (Class input : inputs)
/*     */     {
/* 257 */       if (input == null)
/* 258 */         throw new IllegalArgumentException("Null input");
/* 259 */       temp.add(input.getName());
/*     */     }
/* 261 */     setInputs(temp);
/*     */   }
/*     */ 
/*     */   public void addInput(String input)
/*     */   {
/* 271 */     if (input == null) {
/* 272 */       throw new IllegalArgumentException("Null input");
/*     */     }
/* 274 */     if (this.inputs == null) {
/* 275 */       this.inputs = new HashSet();
/*     */     }
/* 277 */     this.inputs.add(input);
/*     */   }
/*     */ 
/*     */   public void addInput(Class<?> input)
/*     */   {
/* 287 */     if (input == null) {
/* 288 */       throw new IllegalArgumentException("Null input");
/*     */     }
/* 290 */     addInput(input.getName());
/*     */   }
/*     */ 
/*     */   public Set<String> getOutputs()
/*     */   {
/* 295 */     return this.outputs;
/*     */   }
/*     */ 
/*     */   public void setOutputs(Set<String> outputs)
/*     */   {
/* 305 */     this.outputs = outputs;
/*     */   }
/*     */ 
/*     */   public void setOutputs(String[] outputs)
/*     */   {
/* 316 */     if (outputs == null)
/*     */     {
/* 318 */       setOutputs((Set)null);
/* 319 */       return;
/*     */     }
/* 321 */     Set temp = new HashSet(outputs.length);
/* 322 */     for (String output : outputs)
/*     */     {
/* 324 */       if (output == null)
/* 325 */         throw new IllegalArgumentException("Null output");
/* 326 */       temp.add(output);
/*     */     }
/* 328 */     setOutputs(temp);
/*     */   }
/*     */ 
/*     */   public void setOutputs(Class<?>[] outputs)
/*     */   {
/* 339 */     if (outputs == null)
/*     */     {
/* 341 */       setOutputs((Set)null);
/* 342 */       return;
/*     */     }
/* 344 */     Set temp = new HashSet(outputs.length);
/* 345 */     for (Class output : outputs)
/*     */     {
/* 347 */       if (output == null)
/* 348 */         throw new IllegalArgumentException("Null output");
/* 349 */       temp.add(output.getName());
/*     */     }
/* 351 */     setOutputs(temp);
/*     */   }
/*     */ 
/*     */   public void addOutput(String output)
/*     */   {
/* 361 */     if (output == null) {
/* 362 */       throw new IllegalArgumentException("Null output");
/*     */     }
/* 364 */     if (this.outputs == null) {
/* 365 */       this.outputs = new HashSet();
/*     */     }
/* 367 */     this.outputs.add(output);
/*     */   }
/*     */ 
/*     */   public void addOutput(Class<?> output)
/*     */   {
/* 377 */     if (output == null) {
/* 378 */       throw new IllegalArgumentException("Null output");
/*     */     }
/* 380 */     addOutput(output.getName());
/*     */   }
/*     */ 
/*     */   public String getType()
/*     */   {
/* 390 */     return this.type;
/*     */   }
/*     */ 
/*     */   public void setType(String type)
/*     */   {
/* 395 */     this.type = type;
/*     */   }
/*     */ 
/*     */   public boolean isParentFirst()
/*     */   {
/* 400 */     return this.parentFirst;
/*     */   }
/*     */ 
/*     */   public void setParentFirst(boolean parentFirst)
/*     */   {
/* 410 */     this.parentFirst = parentFirst;
/*     */   }
/*     */ 
/*     */   public void undeploy(DeploymentUnit unit)
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.spi.deployer.helpers.AbstractDeployer
 * JD-Core Version:    0.6.0
 */